/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.crviewer.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BrowseTreeContentProvider
implements ITreeContentProvider,
FileFilter {
    public static final boolean DIRECTORIES_ONLY = true;
    public static final boolean DIRECTORIES_AND_RPT = false;
    private File m_rootDirectory;
    private boolean m_selectionMode;
    private boolean m_isAtRootLevel;

    public BrowseTreeContentProvider(File file, boolean bl) {
        this.m_rootDirectory = file;
        this.m_selectionMode = bl;
        this.m_isAtRootLevel = true;
    }

    @Override
    public boolean accept(File file) {
        Object object = null;
        object = file.isDirectory() ? ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(file.getAbsolutePath())) : ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
        if (object == null || !object.isAccessible()) {
            return false;
        }
        if (this.m_selectionMode) {
            return file.isDirectory();
        }
        return file.isDirectory() || file.isFile() && file.getName().endsWith(".rpt");
    }

    public Object[] getChildren(Object object) {
        if (object == null) {
            return new Object[0];
        }
        try {
            IResource[] iResourceArray;
            IContainer iContainer = null;
            if (object instanceof File) {
                iResourceArray = (IResource[])object;
                if (!iResourceArray.isDirectory()) {
                    return new Object[0];
                }
            } else {
                return new Object[0];
            }
            Object object2 = iResourceArray.getAbsolutePath();
            iContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path((String)object2));
            iResourceArray = iContainer.members(false);
            object2 = new ArrayList(iResourceArray.length);
            for (int i = 0; i < iResourceArray.length; ++i) {
                File file;
                if (iResourceArray[i].getLocation() == null || !this.accept(file = new File(iResourceArray[i].getLocation().makeAbsolute().toOSString()))) continue;
                object2.add(file);
            }
            return object2.toArray(new File[object2.size()]);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    public Object[] getElements(Object object) {
        if (this.m_isAtRootLevel) {
            this.m_isAtRootLevel = false;
            return new Object[]{this.m_rootDirectory};
        }
        return this.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object getParent(Object object) {
        return ((File)object).getParentFile();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }
}

