/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.rad.crviewer.internal;

import com.businessobjects.integration.capabilities.librarycomponents.crystalreports.exceptions.ReportLocationException;
import com.businessobjects.integration.rad.crviewer.JSPViewerController;
import com.businessobjects.integration.rad.crviewer.NLSResourceManager;
import com.businessobjects.integration.rad.crviewer.internal.BrowseDialog;
import com.businessobjects.integration.rad.crviewer.internal.BrowseReportFileValidator;
import com.businessobjects.integration.rad.crviewer.internal.BrowseTreeContentProvider;
import com.businessobjects.integration.rad.crviewer.internal.BrowseTreeLabelProvider;
import com.businessobjects.integration.rad.crviewer.internal.WebSphereViewerLibraryIDEAdaptor;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowseActionHandler
extends SelectionAdapter {
    private Text m_fileNameField;
    private Text m_viewerNameField;

    public BrowseActionHandler(Text text, Text text2) {
        this.m_fileNameField = text2;
        this.m_viewerNameField = text;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        Object object = selectionEvent.getSource();
        if (object instanceof Button) {
            Button button = (Button)object;
            WebSphereViewerLibraryIDEAdaptor webSphereViewerLibraryIDEAdaptor = new WebSphereViewerLibraryIDEAdaptor();
            JSPViewerController jSPViewerController = new JSPViewerController();
            try {
                String string = jSPViewerController.getReportDirectoryCanonicalPath(webSphereViewerLibraryIDEAdaptor);
                BrowseDialog browseDialog = new BrowseDialog(button.getShell(), (ILabelProvider)new BrowseTreeLabelProvider(), new BrowseTreeContentProvider(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), false));
                browseDialog.setInput(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile());
                File file = new File(string);
                if (!file.exists()) {
                    file.mkdirs();
                }
                browseDialog.setInitialSelection(file);
                browseDialog.setTitle(NLSResourceManager.page1_browse_button_tooltip);
                browseDialog.setMessage(NLSResourceManager.page1_browse_button_tooltip);
                browseDialog.setValidator(new BrowseReportFileValidator());
                browseDialog.setBlockOnOpen(true);
                browseDialog.setAllowMultiple(false);
                browseDialog.open();
                if (browseDialog.getFirstResult() != null) {
                    Path path = new Path(browseDialog.getFirstResult() + "");
                    IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                    String string2 = iFile.getFullPath().makeAbsolute().toString();
                    if (this.m_fileNameField != null && string2 != null) {
                        this.m_fileNameField.setText(string2);
                        if (this.m_viewerNameField != null && this.m_viewerNameField.getText().trim().length() == 0) {
                            String string3 = new File(string2).getName();
                            if (string3.endsWith(".rpt")) {
                                string3 = string3.substring(0, string3.lastIndexOf(".rpt"));
                            }
                            this.m_viewerNameField.setText(string3);
                        }
                    }
                }
            }
            catch (ReportLocationException reportLocationException) {
                MessageDialog.openError((Shell)button.getShell(), (String)NLSResourceManager.warning_dialog_title, (String)reportLocationException.getLocalizedMessage());
            }
        }
    }
}

