/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.enterprise.search.page;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.enterprise.search.NLSResourceManager;
import com.businessobjects.integration.enterprise.search.internal.QueryBuilder;
import com.businessobjects.integration.enterprise.search.internal.SearchQuery;
import com.businessobjects.integration.rad.enterprise.objects.ObjectTypeManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfoManager;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionStore;
import com.businessobjects.integration.rad.enterprise.sdkconnection.IConnectionStore;
import com.businessobjects.integration.rad.enterprise.view.EnterpriseView;
import com.businessobjects.integration.rad.enterprise.view.actions.FiltersAction;
import com.businessobjects.integration.rad.enterprise.view.actions.LogOnOffContextAction;
import com.businessobjects.integration.rad.enterprise.view.actions.NewConnectionAction;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.FilterDialog;
import com.businessobjects.integration.rad.enterprise.view.actions.internal.ItemsComparator;
import com.businessobjects.integration.rad.enterprise.view.model.TreeParent;
import com.businessobjects.integration.shared.CommonStrings;
import com.businessobjects.integration.shared.ResourceManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class SearchPage
extends DialogPage
implements ISearchPage,
ModifyListener {
    private static final int NUM_SAVED_QUERIES = 10;
    private Combo serverCombo;
    private Text ownerText;
    private Combo searchStringCombo;
    private Button caseSensitiveBtn;
    private Button titleBtn;
    private Button descriptionBtn;
    private Button keywordsBtn;
    private Button searchOwnerBtn;
    private Button topNsearchBtn;
    private Text topNsearchText;
    private Text objectTypeText;
    private ConnectionInfo connInfo;
    private String searchString;
    private boolean caseSensitive;
    private boolean title;
    private boolean description;
    private boolean keywords;
    private boolean searchOwner;
    private boolean topN;
    private int n;
    private int lastServerSelectionIndex;
    private String owner;
    private Set<String> progIdsToSearch = new HashSet<String>();
    private static List<QueryData> previousSearch = new ArrayList<QueryData>(10);
    private List<ConnectionInfo> connInfoArray;
    private ISearchPageContainer container;
    private SelectionListener selectionListener;

    private void populateUIControls(QueryData queryData) {
        String[] stringArray = this.serverCombo.getItems();
        boolean bl = false;
        ConnectionInfo connectionInfo = queryData.connInfo;
        if (connectionInfo != null) {
            String string = connectionInfo.getDisplayName();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                this.serverCombo.select(i);
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        this.ownerText.setText(queryData.owner);
        this.caseSensitiveBtn.setSelection(queryData.caseSensitive);
        this.titleBtn.setSelection(queryData.title);
        this.descriptionBtn.setSelection(queryData.description);
        this.keywordsBtn.setSelection(queryData.keywords);
        this.searchOwnerBtn.setSelection(queryData.searchOwner);
        this.topNsearchBtn.setSelection(queryData.topN);
        this.progIdsToSearch = queryData.progIdsToSearch;
        this.populateObjectType();
        if (queryData.topN) {
            this.topNsearchText.setText(String.valueOf(queryData.n));
        } else {
            this.topNsearchText.setText("");
        }
        this.updateUIStateAndValidate();
    }

    public SearchPage() {
        this.progIdsToSearch.addAll(ObjectTypeManager.getFilterableProgIds());
        this.progIdsToSearch.add("OTHERS");
        this.connInfoArray = new ArrayList<ConnectionInfo>();
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchPage.this.updateUIStateAndValidate();
            }
        };
    }

    public SearchPage(String string) {
        super(string);
        this.progIdsToSearch.addAll(ObjectTypeManager.getFilterableProgIds());
        this.progIdsToSearch.add("OTHERS");
        this.connInfoArray = new ArrayList<ConnectionInfo>();
        this.selectionListener = new /* invalid duplicate definition of identical inner class */;
    }

    public SearchPage(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
        this.progIdsToSearch.addAll(ObjectTypeManager.getFilterableProgIds());
        this.progIdsToSearch.add("OTHERS");
        this.connInfoArray = new ArrayList<ConnectionInfo>();
        this.selectionListener = new /* invalid duplicate definition of identical inner class */;
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.container = iSearchPageContainer;
    }

    public boolean performAction() {
        Object object;
        boolean bl = this.connInfo.isConnected();
        if (!bl) {
            object = EnterpriseView.getView();
            TreeParent treeParent = null;
            TreeViewer treeViewer = null;
            if (object != null) {
                treeParent = object.getRoot();
                treeViewer = object.getViewer();
            }
            try {
                bl = LogOnOffContextAction.setConnectState((ConnectionInfo)this.connInfo, (boolean)true, (TreeParent)treeParent, (TreeViewer)treeViewer);
            }
            catch (ConnectionException connectionException) {
                LogManager.getInstance().message(10000, "com.businessobjects.integration.enterprise.search", (Exception)((Object)connectionException));
            }
        }
        if (bl) {
            NewSearchUI.activateSearchResultView();
            object = new QueryData();
            ((QueryData)object).connInfo = this.connInfo;
            ((QueryData)object).searchString = this.searchString;
            ((QueryData)object).caseSensitive = this.caseSensitive;
            ((QueryData)object).title = this.title;
            ((QueryData)object).description = this.description;
            ((QueryData)object).keywords = this.keywords;
            ((QueryData)object).searchOwner = this.searchOwner;
            ((QueryData)object).topN = this.topN;
            ((QueryData)object).n = this.n;
            ((QueryData)object).owner = this.owner;
            ((QueryData)object).progIdsToSearch = new TreeSet<String>(this.progIdsToSearch);
            NewSearchUI.runQueryInBackground((ISearchQuery)new SearchQuery(QueryBuilder.buildQueryString(this.searchString, this.caseSensitive, this.title, this.description, this.keywords, this.searchOwner, this.owner, this.topN, this.n, this.progIdsToSearch), this.connInfo));
            if (previousSearch.contains(object)) {
                previousSearch.remove(object);
            }
            previousSearch.add((QueryData)object);
            if (previousSearch.size() > 10) {
                previousSearch.remove(0);
            }
        }
        return bl;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        Label label = new Label(composite2, 0);
        label.setText(NLSResourceManager.server_label);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 5);
        label.setLayoutData((Object)formData);
        this.serverCombo = new Combo(composite2, 8);
        formData = new GridData(256);
        formData.grabExcessHorizontalSpace = true;
        this.serverCombo.setLayoutData((Object)formData);
        this.serverCombo.addSelectionListener(this.selectionListener);
        this.serverCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (SearchPage.this.serverCombo.getSelectionIndex() >= 0 && SearchPage.this.lastServerSelectionIndex != SearchPage.this.serverCombo.getSelectionIndex()) {
                    SearchPage.this.lastServerSelectionIndex = SearchPage.this.serverCombo.getSelectionIndex();
                    SearchPage.this.connInfo = (ConnectionInfo)SearchPage.this.connInfoArray.get(SearchPage.this.serverCombo.getSelectionIndex());
                    SearchPage.this.ownerText.setText(SearchPage.this.connInfo.getUserId());
                }
            }
        });
        Button button = new Button(composite2, 8);
        button.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.NEW_DOT_DOT_DOT));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewConnectionAction newConnectionAction = new NewConnectionAction();
                newConnectionAction.run();
                ConnectionInfo connectionInfo = newConnectionAction.getConnectionInfo();
                if (connectionInfo != null) {
                    SearchPage.this.connInfoArray.add(SearchPage.this.serverCombo.getItemCount(), connectionInfo);
                    String string = connectionInfo.getDisplayName();
                    SearchPage.this.serverCombo.add(string, SearchPage.this.serverCombo.getItemCount());
                    SearchPage.this.serverCombo.select(SearchPage.this.serverCombo.getItemCount() - 1);
                    SearchPage.this.ownerText.setText(connectionInfo.getUserId());
                    if (SearchPage.this.serverCombo.getItemCount() == 1) {
                        SearchPage.this.serverCombo.setEnabled(true);
                    }
                    SearchPage.this.updateUIStateAndValidate();
                }
            }
        });
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0, 10);
        formData2.right = new FormAttachment(100, -5);
        button.setLayoutData((Object)formData2);
        formData2 = new FormData();
        formData2.top = new FormAttachment(0, 10);
        formData2.left = new FormAttachment((Control)label, 5);
        formData2.right = new FormAttachment((Control)button, -5);
        this.serverCombo.setLayoutData((Object)formData2);
        formData2 = new Group(composite2, 0);
        formData2.setLayout((Layout)new FormLayout());
        formData2.setText(NLSResourceManager.query_group);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)this.serverCombo, 5);
        formData3.left = new FormAttachment(0, 5);
        formData3.right = new FormAttachment(100, -5);
        formData2.setLayoutData((Object)formData3);
        formData3 = new Label((Composite)formData2, 0);
        formData3.setText(NLSResourceManager.search_string_prompt);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment(0, 5);
        formData4.left = new FormAttachment(0, 5);
        formData4.right = new FormAttachment(100, -5);
        formData3.setLayoutData((Object)formData4);
        this.searchStringCombo = new Combo((Composite)formData2, 0);
        this.searchStringCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (SearchPage.this.searchStringCombo.getSelectionIndex() >= 0) {
                    QueryData queryData = (QueryData)previousSearch.get(SearchPage.this.searchStringCombo.getSelectionIndex());
                    SearchPage.this.populateUIControls(queryData);
                }
            }
        });
        this.searchStringCombo.addModifyListener((ModifyListener)this);
        this.caseSensitiveBtn = new Button((Composite)formData2, 32);
        this.caseSensitiveBtn.addSelectionListener(this.selectionListener);
        this.caseSensitiveBtn.setText(NLSResourceManager.case_sensitive);
        formData4 = new FormData();
        formData4.top = new FormAttachment((Control)formData3, 5);
        formData4.left = new FormAttachment(0, 5);
        formData4.right = new FormAttachment((Control)this.caseSensitiveBtn, -5);
        this.searchStringCombo.setLayoutData((Object)formData4);
        formData4 = new FormData();
        formData4.top = new FormAttachment((Control)formData3, 5);
        formData4.right = new FormAttachment(100, -5);
        this.caseSensitiveBtn.setLayoutData((Object)formData4);
        formData4 = new Group((Composite)formData2, 0);
        formData4.setLayout((Layout)new FormLayout());
        formData4.setText(NLSResourceManager.search_in);
        this.titleBtn = new Button((Composite)formData4, 32);
        this.titleBtn.setSelection(true);
        this.titleBtn.addSelectionListener(this.selectionListener);
        this.titleBtn.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.TITLE));
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment(0, 5);
        formData5.left = new FormAttachment(0, 5);
        formData5.right = new FormAttachment(100, -5);
        this.titleBtn.setLayoutData((Object)formData5);
        this.descriptionBtn = new Button((Composite)formData4, 32);
        this.descriptionBtn.addSelectionListener(this.selectionListener);
        this.descriptionBtn.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.DESCRIPTION));
        formData5 = new FormData();
        formData5.top = new FormAttachment((Control)this.titleBtn, 5);
        formData5.left = new FormAttachment(0, 5);
        formData5.right = new FormAttachment(100, -5);
        this.descriptionBtn.setLayoutData((Object)formData5);
        this.keywordsBtn = new Button((Composite)formData4, 32);
        this.keywordsBtn.addSelectionListener(this.selectionListener);
        this.keywordsBtn.setText(ResourceManager.getString((String)CommonStrings.COMMON_STRINGS, (String)CommonStrings.KEYWORDS));
        formData5 = new FormData();
        formData5.top = new FormAttachment((Control)this.descriptionBtn, 5);
        formData5.left = new FormAttachment(0, 5);
        formData5.bottom = new FormAttachment(100, -5);
        formData5.right = new FormAttachment(100, -5);
        this.keywordsBtn.setLayoutData((Object)formData5);
        formData5 = new Group((Composite)formData2, 0);
        formData5.setLayout((Layout)new FormLayout());
        formData5.setText(NLSResourceManager.owned_by);
        this.searchOwnerBtn = new Button((Composite)formData5, 32);
        this.searchOwnerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchPage.this.setFocusToTextWidget(SearchPage.this.ownerText);
                SearchPage.this.updateUIStateAndValidate();
            }
        });
        this.searchOwnerBtn.setText(NLSResourceManager.owned_by_prompt);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment(0, 5);
        formData6.left = new FormAttachment(0, 5);
        formData6.right = new FormAttachment(100, -5);
        this.searchOwnerBtn.setLayoutData((Object)formData6);
        this.ownerText = new Text((Composite)formData5, 2048);
        formData6 = new FormData();
        formData6.top = new FormAttachment((Control)this.searchOwnerBtn, 5);
        formData6.left = new FormAttachment(10, 5);
        formData6.right = new FormAttachment(100, -5);
        this.ownerText.setLayoutData((Object)formData6);
        this.ownerText.setEnabled(false);
        this.ownerText.addModifyListener((ModifyListener)this);
        formData6 = new Group((Composite)formData2, 0);
        formData6.setLayout((Layout)new FormLayout());
        formData6.setText(NLSResourceManager.filter_by);
        FormData formData7 = new FormData();
        formData7.left = new FormAttachment(0, 5);
        formData7.bottom = new FormAttachment(100, -10);
        formData7.right = new FormAttachment(100, -5);
        formData6.setLayoutData((Object)formData7);
        formData7 = new Label((Composite)formData6, 0);
        formData7.setText(NLSResourceManager.object_type);
        FormData formData8 = new FormData();
        formData8.top = new FormAttachment(0, 10);
        formData8.left = new FormAttachment(0, 5);
        formData7.setLayoutData((Object)formData8);
        this.objectTypeText = new Text((Composite)formData6, 2048);
        formData8 = new Button((Composite)formData6, 0);
        this.objectTypeText.setEnabled(false);
        ConnectionInfo[] connectionInfoArray = new FormData();
        connectionInfoArray.top = new FormAttachment(0, 10);
        connectionInfoArray.left = new FormAttachment((Control)formData7, 5);
        connectionInfoArray.right = new FormAttachment((Control)formData8, -5);
        this.objectTypeText.setLayoutData((Object)connectionInfoArray);
        this.objectTypeText.setText(NLSResourceManager.all_types);
        formData8.setText(NLSResourceManager.choose);
        connectionInfoArray = new FormData();
        connectionInfoArray.top = new FormAttachment(0, 10);
        connectionInfoArray.right = new FormAttachment(100, -5);
        formData8.setLayoutData((Object)connectionInfoArray);
        formData8.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UIUtilities.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FilterDialog filterDialog = new FilterDialog(UIUtilities.getShell(), SearchPage.this.progIdsToSearch);
                        if (filterDialog.open() == 0) {
                            SearchPage.this.progIdsToSearch = filterDialog.getCheckedElements();
                            SearchPage.this.populateObjectType();
                        }
                    }
                });
            }
        });
        this.topNsearchBtn = new Button((Composite)formData6, 32);
        this.topNsearchText = new Text((Composite)formData6, 2048);
        this.topNsearchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchPage.this.setFocusToTextWidget(SearchPage.this.topNsearchText);
                SearchPage.this.updateUIStateAndValidate();
            }
        });
        this.topNsearchBtn.setText(NLSResourceManager.top_n_prompt);
        connectionInfoArray = new FormData();
        connectionInfoArray.left = new FormAttachment(0, 5);
        connectionInfoArray.top = new FormAttachment((Control)formData8, 5);
        connectionInfoArray.bottom = new FormAttachment(100, -10);
        this.topNsearchBtn.setLayoutData((Object)connectionInfoArray);
        this.topNsearchText.addModifyListener((ModifyListener)this);
        connectionInfoArray = new FormData();
        connectionInfoArray.left = new FormAttachment((Control)this.topNsearchBtn, 5);
        connectionInfoArray.right = new FormAttachment(100, -5);
        connectionInfoArray.top = new FormAttachment((Control)formData8, 5);
        connectionInfoArray.bottom = new FormAttachment(100, -10);
        this.topNsearchText.setLayoutData((Object)connectionInfoArray);
        connectionInfoArray = new FormData();
        connectionInfoArray.top = new FormAttachment((Control)this.searchStringCombo, 5);
        connectionInfoArray.left = new FormAttachment(0, 5);
        connectionInfoArray.right = new FormAttachment(50, -5);
        connectionInfoArray.bottom = new FormAttachment((Control)formData6, -10);
        formData4.setLayoutData((Object)connectionInfoArray);
        connectionInfoArray = new FormData();
        connectionInfoArray.top = new FormAttachment((Control)this.searchStringCombo, 5);
        connectionInfoArray.left = new FormAttachment(50, 5);
        connectionInfoArray.right = new FormAttachment(100, -5);
        connectionInfoArray.bottom = new FormAttachment((Control)formData6, -10);
        formData5.setLayoutData((Object)connectionInfoArray);
        connectionInfoArray = ConnectionInfoManager.getInstance().getConnections((IConnectionStore)ConnectionStore.getInstance());
        if (connectionInfoArray.length == 0) {
            this.serverCombo.setEnabled(false);
        } else {
            for (int i = 0; i < connectionInfoArray.length; ++i) {
                this.connInfoArray.add(this.serverCombo.getItemCount(), connectionInfoArray[i]);
                String string = connectionInfoArray[i].getDisplayName();
                this.serverCombo.add(string, this.serverCombo.getItemCount());
            }
            this.serverCombo.select(0);
            this.ownerText.setText(connectionInfoArray[0].getUserId());
        }
        this.serverCombo.addModifyListener((ModifyListener)this);
        this.searchStringCombo.setFocus();
        IWorkbenchHelpSystem iWorkbenchHelpSystem = UIUtilities.getHelpSystem();
        if (iWorkbenchHelpSystem != null) {
            iWorkbenchHelpSystem.setHelp((Control)composite2, "com.businessobjects.integration.enterprise.search.docroot");
        }
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public void setVisible(boolean bl) {
        this.updateUIStateAndValidate();
        super.setVisible(bl);
        for (QueryData queryData : previousSearch) {
            this.searchStringCombo.add(queryData.searchString);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.updateUIStateAndValidate();
    }

    private void setFocusToTextWidget(final Text text) {
        UIUtilities.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                text.setFocus();
            }
        });
    }

    private void updateUIStateAndValidate() {
        this.searchString = this.searchStringCombo.getText().trim();
        this.caseSensitive = this.caseSensitiveBtn.getSelection();
        this.title = this.titleBtn.getSelection();
        this.description = this.descriptionBtn.getSelection();
        this.keywords = this.keywordsBtn.getSelection();
        this.searchOwner = this.searchOwnerBtn.getSelection();
        this.owner = this.ownerText.getText().trim();
        this.topN = this.topNsearchBtn.getSelection();
        this.topNsearchText.setEnabled(this.topN);
        this.ownerText.setEnabled(this.searchOwner);
        if (this.topN) {
            try {
                this.n = Integer.parseInt(this.topNsearchText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.n = 0;
            }
        }
        if (this.serverCombo.getSelectionIndex() >= 0) {
            this.connInfo = this.connInfoArray.get(this.serverCombo.getSelectionIndex());
        }
        boolean bl = !(this.searchString.length() <= 0 || !this.title && !this.description && !this.keywords || this.searchOwner && this.owner.length() <= 0 || this.topN && this.n <= 0 || this.serverCombo.getSelectionIndex() < 0 || this.progIdsToSearch.isEmpty());
        this.container.setPerformActionEnabled(bl);
    }

    private void populateObjectType() {
        if (this.progIdsToSearch.isEmpty()) {
            this.objectTypeText.setText(NLSResourceManager.no_types);
            this.container.setPerformActionEnabled(false);
        } else {
            this.updateUIStateAndValidate();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.progIdsToSearch.size() == 1 + ObjectTypeManager.getFilterableProgIds().size()) {
            stringBuffer.append(NLSResourceManager.all_types);
        } else {
            TreeSet<String> treeSet = new TreeSet<String>(ItemsComparator.StringItemsComparator);
            for (String string : this.progIdsToSearch) {
                if ("OTHERS".equals(string)) {
                    treeSet.add(FiltersAction.OTHER_NAME);
                    continue;
                }
                treeSet.add(ObjectTypeManager.getNameForProgId((String)string));
            }
            for (String string : treeSet) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(string);
            }
        }
        this.objectTypeText.setText(stringBuffer.toString());
    }

    private static class QueryData {
        private ConnectionInfo connInfo;
        private String searchString;
        private boolean caseSensitive;
        private boolean title;
        private boolean description;
        private boolean keywords;
        private boolean searchOwner;
        private boolean topN;
        private int n;
        private String owner;
        private Set<String> progIdsToSearch;

        private QueryData() {
        }

        public boolean equals(Object object) {
            if (object instanceof QueryData) {
                QueryData queryData = (QueryData)object;
                if (this.connInfo != null && this.searchString != null) {
                    return this.connInfo.equals((Object)queryData.connInfo) && this.searchString.equals(queryData.searchString);
                }
            }
            return false;
        }
    }
}

