/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.enterprise.search.internal;

import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.enterprise.search.NLSResourceManager;
import com.businessobjects.integration.enterprise.search.SearchResult;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionException;
import com.businessobjects.integration.rad.enterprise.sdkconnection.ConnectionInfo;
import com.businessobjects.integration.rad.enterprise.sdkconnection.EnterpriseFunctionAccessor;
import com.businessobjects.integration.rad.enterprise.view.PropertySource;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class SearchQuery
implements ISearchQuery {
    private String query;
    private ConnectionInfo connInfo;
    private SearchResult result = new SearchResult(this);

    public SearchQuery(String string, ConnectionInfo connectionInfo) {
        this.query = string;
        this.connInfo = connectionInfo;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        this.result.removeAll();
        try {
            this.result.setConnInfo(this.connInfo);
            LogManager.getInstance().message(100, "com.businessobjects.integration.enterprise.search", "Query = " + this.query);
            List list = EnterpriseFunctionAccessor.getInstance((int)this.connInfo.getVersion()).query(this.connInfo, this.query);
            LogManager.getInstance().message(100, "com.businessobjects.integration.enterprise.search", "Result Size = " + list.size());
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                Integer n = (Integer)map.get("SI_ID");
                if (n == null) continue;
                this.result.addMatch(new Match((Object)new PropertySource(this.connInfo, n.intValue(), map, null), 1, 0, 0));
            }
        }
        catch (ConnectionException connectionException) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.enterprise.search", (Exception)((Object)connectionException));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return NLSResourceManager.searching_prompt;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    public String getQuery() {
        return this.query;
    }
}

