/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.eclipse.web.properties.operations.update;

import com.businessobjects.crystalreports.integration.eclipse.facets.shared.FacetErrorDialog;
import com.businessobjects.crystalreports.integration.eclipse.facets.shared.FacetUtils;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.shared.UIUtilities;
import com.businessobjects.integration.eclipse.web.properties.IUpdateOperationRunnable;
import com.businessobjects.integration.eclipse.web.properties.IVersionPropertyPage;
import com.businessobjects.integration.eclipse.web.properties.NLSResourceManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class UpdateOperationRunnable
implements IUpdateOperationRunnable {
    private IProject activeProject;
    private String targetVersion;
    private IVersionPropertyPage page;

    public void init(IProject activeProj, String targetVer, IVersionPropertyPage propertyPage) {
        this.activeProject = activeProj;
        this.targetVersion = targetVer;
        this.page = propertyPage;
    }

    public void run() {
        try {
            new ProgressMonitorDialog(UIUtilities.getShell()).run(false, false, new IRunnableWithProgress(){

                private IDataModel getConfigObject(IFacetedProject.Action.Type type, IProjectFacetVersion version, Set<IProjectFacetVersion> facets) throws CoreException {
                    IProjectFacet projectFacet = version.getProjectFacet();
                    IProjectFacetVersion targetFacetVersion = projectFacet.getVersion(UpdateOperationRunnable.this.targetVersion);
                    IDataModel config = (IDataModel)version.getActionDefinition(facets, type).createConfigObject();
                    config.setStringProperty("IFacetDataModelProperties.FACET_ID", projectFacet.getId());
                    config.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", UpdateOperationRunnable.this.targetVersion);
                    config.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)targetFacetVersion);
                    return config;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)UpdateOperationRunnable.this.activeProject);
                        Set facets = facetedProject.getProjectFacets();
                        List installedWebFacets = UpdateOperationRunnable.this.page.getInstalledWebFacets();
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(installedWebFacets.size() * 200));
                        try {
                            for (IProjectFacetVersion version : facets) {
                                IProjectFacet projectFacet = version.getProjectFacet();
                                String facetId = projectFacet.getId();
                                if (!installedWebFacets.contains(facetId)) continue;
                                if (projectFacet.hasVersion(UpdateOperationRunnable.this.targetVersion)) {
                                    IProjectFacetVersion targetFacetVersion = projectFacet.getVersion(UpdateOperationRunnable.this.targetVersion);
                                    if (version.supports(facets, IFacetedProject.Action.Type.VERSION_CHANGE)) {
                                        IDataModel config;
                                        if (UpdateOperationRunnable.this.targetVersion.equals(version.getVersionString())) {
                                            config = this.getConfigObject(IFacetedProject.Action.Type.UNINSTALL, version, facets);
                                            facetedProject.uninstallProjectFacet(version, (Object)config, (IProgressMonitor)progress.newChild(50, 7));
                                            config = this.getConfigObject(IFacetedProject.Action.Type.INSTALL, version, facets);
                                            facetedProject.installProjectFacet(version, (Object)config, (IProgressMonitor)progress.newChild(150, 7));
                                        } else {
                                            config = (IDataModel)version.getActionDefinition(facets, IFacetedProject.Action.Type.VERSION_CHANGE).createConfigObject();
                                            config.setStringProperty("IFacetDataModelProperties.FACET_ID", projectFacet.getId());
                                            config.setStringProperty("IFacetDataModelProperties.FACET_VERSION_STR", UpdateOperationRunnable.this.targetVersion);
                                            config.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)targetFacetVersion);
                                            IFacetedProject.Action versionChangeAction = new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, targetFacetVersion, (Object)config);
                                            facetedProject.modify(Collections.singleton(versionChangeAction), (IProgressMonitor)progress.newChild(200));
                                        }
                                    } else {
                                        final Set failedFiles = FacetUtils.installLibrary((IProject)UpdateOperationRunnable.this.activeProject, (String)facetId, (String)UpdateOperationRunnable.this.targetVersion, null, (String)UpdateOperationRunnable.this.page.getFirstSourcePath(UpdateOperationRunnable.this.activeProject));
                                        if (failedFiles.size() > 0) {
                                            UIUtilities.getDisplay().asyncExec(new Runnable(){

                                                public void run() {
                                                    FacetErrorDialog dialog = new FacetErrorDialog(UIUtilities.getShell(), failedFiles);
                                                    dialog.open();
                                                }
                                            });
                                        }
                                        return;
                                    }
                                    UpdateOperationRunnable.this.page.populateUI();
                                    continue;
                                }
                                String facetName = projectFacet.getLabel();
                                MessageDialog.openError((Shell)UIUtilities.getShell(), (String)NLSResourceManager.library_update_no_version_title, (String)NLS.bind((String)NLSResourceManager.library_update_no_version_message, (Object[])new String[]{UpdateOperationRunnable.this.targetVersion, facetName}));
                                return;
                            }
                        }
                        finally {
                            progress.done();
                        }
                    }
                    catch (CoreException e) {
                        LogManager.getInstance().message(1000, "com.businessobjects.integration.eclipse.web.properties", (Exception)((Object)e));
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            LogManager.getInstance().message(10000, "com.businessobjects.integration.eclipse.web.properties", (Exception)e);
        }
        catch (InterruptedException e) {
            LogManager.getInstance().message(100, "com.businessobjects.integration.eclipse.web.properties", (Exception)e);
        }
    }
}

