/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.integration.eclipse.facets.shared;

import com.businessobjects.integration.capabilities.filesystem.FileSystemManager;
import com.businessobjects.integration.capabilities.librarycomponents.model.ContextParam;
import com.businessobjects.integration.capabilities.librarycomponents.model.Resource;
import com.businessobjects.integration.capabilities.librarycomponents.model.Servlet;
import com.businessobjects.integration.capabilities.librarycomponents.model.Taglib;
import com.businessobjects.integration.capabilities.logging.LogManager;
import com.businessobjects.integration.eclipse.facets.shared.FacetErrorRecord;
import com.businessobjects.sdks.manager.RuntimeLibraryManager;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.TagLibRef;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class FacetUtils {
    private static final int WEB_2_3_ID = 23;
    private static final int WEB_2_4_ID = 24;

    public static Set<FacetErrorRecord> installLibrary(IProject iProject, String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iProject);
        Set<FacetErrorRecord> set = FacetUtils.copyLibraries(iVirtualComponent, string, string2, iProgressMonitor);
        set.addAll(FacetUtils.copyResources(iVirtualComponent, string, string2, iProgressMonitor));
        FacetUtils.configureServlet(iVirtualComponent, string, string2, iProgressMonitor);
        FacetUtils.configureContextParam(iVirtualComponent, string, string2, iProgressMonitor);
        FacetUtils.configureTaglib(iVirtualComponent, string, string2, iProgressMonitor);
        return set;
    }

    public static Set<FacetErrorRecord> uninstallLibrary(IProject iProject, String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)iProject);
        Set<FacetErrorRecord> set = FacetUtils.removeResources(iVirtualComponent, string, string2, iProgressMonitor);
        set.addAll(FacetUtils.removeLibraries(iVirtualComponent, string, string2, iProgressMonitor));
        FacetUtils.deconfigureServlet(iVirtualComponent, string, string2, iProgressMonitor);
        FacetUtils.deconfigureContextParam(iVirtualComponent, string, string2, iProgressMonitor);
        FacetUtils.deconfigureTaglib(iVirtualComponent, string, string2, iProgressMonitor);
        return set;
    }

    public static Set<FacetErrorRecord> changeLibraryVersion(IProject iProject, String string, String string2, String string3, IProgressMonitor iProgressMonitor) throws CoreException {
        Set<FacetErrorRecord> set = FacetUtils.uninstallLibrary(iProject, string, string2, iProgressMonitor);
        set.addAll(FacetUtils.installLibrary(iProject, string, string3, iProgressMonitor));
        return set;
    }

    private static IVirtualFolder getRootFolder(IVirtualComponent iVirtualComponent) {
        return iVirtualComponent.getRootFolder();
    }

    private static IVirtualFolder getWebInfLibFolder(IVirtualComponent iVirtualComponent) {
        return FacetUtils.getRootFolder(iVirtualComponent).getFolder(WebArtifactEdit.WEBLIB);
    }

    private static Set<FacetErrorRecord> copyLibraries(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        HashSet<FacetErrorRecord> hashSet = new HashSet<FacetErrorRecord>();
        iVirtualComponent.create(0, iProgressMonitor);
        IVirtualFolder iVirtualFolder = FacetUtils.getWebInfLibFolder(iVirtualComponent);
        List<String> list = FacetUtils.getLibraryJars(string, string2);
        for (String string3 : list) {
            File file = new File(string3);
            IFile iFile = iVirtualFolder.getFile(file.getName()).getUnderlyingFile();
            boolean bl = iFile.exists();
            try {
                FileSystemManager.copy((File)file, (File)iFile.getLocation().toFile(), (boolean)true);
            }
            catch (IOException iOException) {
                if (bl) {
                    hashSet.add(FacetErrorRecord.createUpdateError(iFile.getFullPath().toString()));
                    continue;
                }
                hashSet.add(FacetErrorRecord.createAddError(iFile.getFullPath().toString()));
            }
        }
        iVirtualFolder.getUnderlyingFolder().refreshLocal(1, iProgressMonitor);
        return hashSet;
    }

    private static Set<FacetErrorRecord> copyResources(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        HashSet<FacetErrorRecord> hashSet = new HashSet<FacetErrorRecord>();
        List list = RuntimeLibraryManager.getInstance().getResources(string, string2);
        Iterator iterator = list.iterator();
        IVirtualFolder iVirtualFolder = FacetUtils.getRootFolder(iVirtualComponent);
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            File file = new File(resource.getSource());
            File file2 = new File(iVirtualFolder.getUnderlyingFolder().getLocation().toFile(), resource.getTarget());
            if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            if (file.isFile()) {
                try {
                    FileSystemManager.copy((File)file, (File)file2, (boolean)true);
                }
                catch (IOException iOException) {
                    if (file.exists()) {
                        hashSet.add(FacetErrorRecord.createUpdateError(file.getAbsolutePath()));
                        continue;
                    }
                    hashSet.add(FacetErrorRecord.createAddError(file.getAbsolutePath()));
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            List list2 = FileSystemManager.copyDirectory((File)file, (File)file2, (boolean)true, (String[])new String[0], (boolean)true);
            for (String string3 : list2) {
                hashSet.add(FacetErrorRecord.createAddError(string3));
            }
        }
        iVirtualFolder.getUnderlyingFolder().refreshLocal(2, iProgressMonitor);
        return hashSet;
    }

    private static Set<FacetErrorRecord> removeResources(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        HashSet<FacetErrorRecord> hashSet = new HashSet<FacetErrorRecord>();
        List list = RuntimeLibraryManager.getInstance().getResources(string, string2);
        Iterator iterator = list.iterator();
        IVirtualFolder iVirtualFolder = FacetUtils.getRootFolder(iVirtualComponent);
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            IVirtualFolder iVirtualFolder2 = iVirtualFolder.getFolder(resource.getTarget());
            if (iVirtualFolder2.exists()) {
                try {
                    iVirtualFolder2.getUnderlyingFolder().delete(1, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    hashSet.add(FacetErrorRecord.createDeleteError(resource.getTarget()));
                }
                continue;
            }
            IVirtualFile iVirtualFile = iVirtualFolder.getFile(resource.getTarget());
            if (!iVirtualFile.exists()) continue;
            try {
                iVirtualFile.delete(1, iProgressMonitor);
            }
            catch (CoreException coreException) {
                hashSet.add(FacetErrorRecord.createDeleteError(resource.getTarget()));
            }
        }
        iVirtualFolder.getUnderlyingFolder().refreshLocal(2, iProgressMonitor);
        return hashSet;
    }

    private static Set<FacetErrorRecord> removeLibraries(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) throws CoreException {
        HashSet<FacetErrorRecord> hashSet = new HashSet<FacetErrorRecord>();
        IVirtualFolder iVirtualFolder = iVirtualComponent.getRootFolder();
        IVirtualFolder iVirtualFolder2 = iVirtualFolder.getFolder(WebArtifactEdit.WEBLIB);
        List list = RuntimeLibraryManager.getInstance().getBusinessObjectsLibraries(string, string2);
        for (String string3 : list) {
            File file = new File(string3);
            IFile iFile = iVirtualFolder2.getFile(file.getName()).getUnderlyingFile();
            LogManager.getInstance().message(100, "com.businessobjects.integration.eclipse.enterprise.facet", "Removing file " + iFile.getLocation().toOSString());
            try {
                iFile.delete(true, iProgressMonitor);
            }
            catch (CoreException coreException) {
                LogManager.getInstance().message(100, "com.businessobjects.integration.eclipse.enterprise.facet", (Exception)((Object)coreException));
                hashSet.add(FacetErrorRecord.createDeleteError(iFile.getFullPath().toString()));
            }
        }
        iVirtualFolder2.getUnderlyingFolder().refreshLocal(1, iProgressMonitor);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureServlet(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) {
        FacetUtils.deconfigureServlet(iVirtualComponent, string, string2, iProgressMonitor);
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)iVirtualComponent);
        try {
            WebApp webApp = (WebApp)webArtifactEdit.getDeploymentDescriptorRoot();
            List list = RuntimeLibraryManager.getInstance().getServlets(string, string2);
            for (Servlet servlet : list) {
                ServletType servletType = WebapplicationFactory.eINSTANCE.createServletType();
                servletType.setClassName(servlet.getClassname());
                org.eclipse.jst.j2ee.webapplication.Servlet servlet2 = WebapplicationFactory.eINSTANCE.createServlet();
                servlet2.setServletName(servlet.getName());
                servlet2.setWebType((WebType)servletType);
                servlet2.setDescription(servlet.getDescription());
                servlet2.setLoadOnStartup(servlet.getLoadOnStartup());
                servlet2.setWebApp(webApp);
                webApp.getServlets().add((Object)servlet2);
                ServletMapping servletMapping = WebapplicationFactory.eINSTANCE.createServletMapping();
                servletMapping.setServlet(servlet2);
                servletMapping.setUrlPattern(servlet.getMapping());
                servletMapping.setWebApp(webApp);
                webApp.getServletMappings().add((Object)servletMapping);
            }
            webArtifactEdit.saveIfNecessary(iProgressMonitor);
        }
        finally {
            webArtifactEdit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureContextParam(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) {
        FacetUtils.deconfigureContextParam(iVirtualComponent, string, string2, iProgressMonitor);
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)iVirtualComponent);
        try {
            WebApp webApp = (WebApp)webArtifactEdit.getDeploymentDescriptorRoot();
            List list = RuntimeLibraryManager.getInstance().getContextParams(string, string2);
            for (ContextParam contextParam : list) {
                org.eclipse.jst.j2ee.webapplication.ContextParam contextParam2;
                if (FacetUtils.isWebApp23(webApp)) {
                    contextParam2 = WebapplicationFactory.eINSTANCE.createContextParam();
                    contextParam2.setParamName(contextParam.getName());
                    contextParam2.setParamValue(contextParam.getValue());
                    webApp.getContexts().add((Object)contextParam2);
                    continue;
                }
                if (!FacetUtils.isWebApp24(webApp)) continue;
                contextParam2 = CommonFactory.eINSTANCE.createParamValue();
                contextParam2.setName(contextParam.getName());
                contextParam2.setValue(contextParam.getValue());
                webApp.getContextParams().add((Object)contextParam2);
            }
            webArtifactEdit.saveIfNecessary(iProgressMonitor);
        }
        finally {
            webArtifactEdit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureTaglib(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) {
        FacetUtils.deconfigureTaglib(iVirtualComponent, string, string2, iProgressMonitor);
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)iVirtualComponent);
        try {
            WebApp webApp = (WebApp)webArtifactEdit.getDeploymentDescriptorRoot();
            List list = RuntimeLibraryManager.getInstance().getTaglibs(string, string2);
            for (Taglib taglib : list) {
                TagLibRef tagLibRef = WebapplicationFactory.eINSTANCE.createTagLibRef();
                tagLibRef.setTaglibLocation(taglib.getLocation());
                tagLibRef.setTaglibURI(taglib.getUri());
                tagLibRef.setWebApp(webApp);
                webApp.getTagLibs().add((Object)taglib);
            }
            webArtifactEdit.saveIfNecessary(iProgressMonitor);
        }
        finally {
            webArtifactEdit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deconfigureServlet(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) {
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)iVirtualComponent);
        try {
            WebApp webApp = (WebApp)webArtifactEdit.getDeploymentDescriptorRoot();
            List list = RuntimeLibraryManager.getInstance().getServlets(string, string2);
            for (Servlet servlet : list) {
                org.eclipse.jst.j2ee.webapplication.Servlet servlet2 = webApp.getServletNamed(servlet.getName());
                ServletMapping servletMapping = webApp.getServletMapping(servlet2);
                webApp.getServlets().remove((Object)servlet2);
                webApp.getServletMappings().remove((Object)servletMapping);
            }
            webArtifactEdit.saveIfNecessary(iProgressMonitor);
        }
        finally {
            webArtifactEdit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deconfigureContextParam(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) {
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)iVirtualComponent);
        try {
            WebApp webApp = (WebApp)webArtifactEdit.getDeploymentDescriptorRoot();
            List list = RuntimeLibraryManager.getInstance().getContextParams(string, string2);
            for (ContextParam contextParam : list) {
                Object object;
                Iterator iterator;
                if (FacetUtils.isWebApp23(webApp)) {
                    iterator = webApp.getContexts().iterator();
                    while (iterator.hasNext()) {
                        org.eclipse.jst.j2ee.webapplication.ContextParam contextParam2;
                        object = iterator.next();
                        if (!(object instanceof org.eclipse.jst.j2ee.webapplication.ContextParam) || !(contextParam2 = (org.eclipse.jst.j2ee.webapplication.ContextParam)object).getParamName().equals(contextParam.getName())) continue;
                        iterator.remove();
                    }
                    continue;
                }
                if (!FacetUtils.isWebApp24(webApp)) continue;
                iterator = webApp.getContextParams().iterator();
                while (iterator.hasNext()) {
                    object = (ParamValue)iterator.next();
                    if (!object.getName().equals(contextParam.getName())) continue;
                    iterator.remove();
                }
            }
            webArtifactEdit.saveIfNecessary(iProgressMonitor);
        }
        finally {
            webArtifactEdit.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deconfigureTaglib(IVirtualComponent iVirtualComponent, String string, String string2, IProgressMonitor iProgressMonitor) {
        WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)iVirtualComponent);
        try {
            WebApp webApp = (WebApp)webArtifactEdit.getDeploymentDescriptorRoot();
            List list = RuntimeLibraryManager.getInstance().getTaglibs(string, string2);
            for (Taglib taglib : list) {
                Iterator iterator = webApp.getTagLibs().iterator();
                while (iterator.hasNext()) {
                    TagLibRef tagLibRef = (TagLibRef)iterator.next();
                    if (!tagLibRef.getTaglibURI().equals(taglib.getUri())) continue;
                    iterator.remove();
                }
            }
            webArtifactEdit.saveIfNecessary(iProgressMonitor);
        }
        finally {
            webArtifactEdit.dispose();
        }
    }

    private static List<String> getLibraryJars(String string, String string2) {
        List list = RuntimeLibraryManager.getInstance().getBusinessObjectsLibraries(string, string2);
        list.addAll(RuntimeLibraryManager.getInstance().getExternalLibraries(string, string2));
        return list;
    }

    private static boolean isWebApp23(WebApp webApp) {
        return webApp.getVersionID() == 23;
    }

    private static boolean isWebApp24(WebApp webApp) {
        return webApp.getVersionID() == 24;
    }
}

