/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WrappingFileOutputStream
extends OutputStream {
    private static String className = "com.ibm.ws.ffdc.WrappingFileOutputStream";
    private static Logger logger = Logger.getLogger(className);
    private String ivMainFileName = null;
    private File ivMainFile = null;
    private String ivDirectory = null;
    private String ivNamePrefix = null;
    private String ivNameSuffix = null;
    private String ivSepChar = "_";
    private int ivMaxBackups;
    private String[] ivBackupFiles = null;
    private String ivPreviousTimeStamp = null;
    private int ivTimeStampCounter = 1;
    private DateFormat ivDateFormatter = new SimpleDateFormat("yy.M.d_H.mm.ss");
    private long ivMaxFileSize;
    private long ivCurFileSize = 0L;
    private FileOutputStream ivFileStream = null;

    public WrappingFileOutputStream(String fileName, int rollover, int maxBackups) throws IOException, WsException {
        this.ivMainFile = new File(fileName);
        this.ivMainFileName = fileName;
        int index = this.ivMainFileName.lastIndexOf(File.separator);
        if (index == -1) {
            throw new WsException(fileName + " does not contain a path separator character");
        }
        this.ivDirectory = this.ivMainFileName.substring(0, index);
        String fName = this.ivMainFileName.substring(index + 1, this.ivMainFileName.length());
        if (fName == null || fName.equals("")) {
            throw new WsException(fileName + " is not a proper fully qualified file name");
        }
        index = fName.lastIndexOf(46);
        if (index == -1) {
            this.ivNamePrefix = fName;
            this.ivNameSuffix = null;
        } else {
            this.ivNamePrefix = fName.substring(0, index);
            this.ivNameSuffix = fName.substring(index, fName.length());
        }
        boolean exists = FFDCHelper.fileExists(this.ivMainFile);
        this.ivCurFileSize = !exists ? 0L : FFDCHelper.getFileLength(this.ivMainFile);
        this.ivMaxFileSize = rollover;
        this.ivMaxBackups = maxBackups;
        if (this.ivMaxBackups > 0) {
            this.ivBackupFiles = this.generateBackupFileList();
        }
        try {
            this.ivFileStream = WrappingFileOutputStream.createFileOutputStream(this.ivMainFileName, true);
            logger.logp(Level.FINEST, className, "<init>", "opened FileOutputStream - " + this.ivMainFileName);
        }
        catch (PrivilegedActionException pae) {
            throw new WsException(this.ivMainFileName + " failed to create", (Throwable)pae);
        }
    }

    public void write(int b) throws IOException {
        this.incrementCount(1);
        this.ivFileStream.write(b);
    }

    public void write(byte[] bytes) throws IOException {
        this.incrementCount(bytes.length);
        this.ivFileStream.write(bytes);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        this.incrementCount(len);
        this.ivFileStream.write(bytes, off, len);
    }

    public void flush() throws IOException {
        this.ivFileStream.flush();
    }

    public void close() throws IOException {
        this.ivFileStream.close();
        logger.logp(Level.FINEST, className, "close", "closing FileOutputStream - " + this.ivMainFileName);
    }

    private void incrementCount(int count) throws IOException {
        this.ivCurFileSize += (long)count;
        if (this.ivCurFileSize >= this.ivMaxFileSize) {
            this.switchFiles();
            this.ivCurFileSize = count;
        }
    }

    private void switchFiles() throws IOException {
        logger.entering(className, "switchFiles");
        this.ivFileStream.flush();
        this.ivFileStream.close();
        String backupFileName = this.createBackupFileName();
        File backup = new File(backupFileName);
        boolean success = FFDCHelper.renameFile(this.ivMainFile, backup);
        if (logger.isLoggable(Level.FINEST)) {
            String mainStr = this.ivMainFile == null ? "null" : this.ivMainFile.getCanonicalPath();
            String backupStr = backup == null ? "null" : backup.getCanonicalPath();
            String successStr = success ? "Succeeded" : "Failed";
            logger.logp(Level.FINEST, className, "switchFiles", "{0} in renaming {1} to {2}", new Object[]{successStr, mainStr, backupStr});
        }
        try {
            this.ivFileStream = WrappingFileOutputStream.createFileOutputStream(this.ivMainFileName, false);
        }
        catch (PrivilegedActionException pae) {
            IOException ex = new IOException(this.ivMainFileName + " failed to create");
            logger.exiting(className, "switchFiles", ex);
            throw ex;
        }
        this.ivCurFileSize = 0L;
        logger.exiting(className, "switchFiles");
    }

    private String createBackupFileName() {
        int lastIndex;
        String oldName;
        Date date = new Date(System.currentTimeMillis());
        String ts = this.ivDateFormatter.format(date);
        if (this.ivPreviousTimeStamp == null) {
            this.ivPreviousTimeStamp = ts;
        } else {
            if (this.ivPreviousTimeStamp.startsWith(ts)) {
                ts = ts + Integer.toHexString(this.ivTimeStampCounter++);
            }
            this.ivPreviousTimeStamp = ts;
        }
        String backupFileName = this.ivDirectory + File.separator + this.ivNamePrefix + this.ivSepChar + ts + this.ivNameSuffix;
        if (this.ivBackupFiles == null) {
            this.ivBackupFiles = new String[]{null};
        }
        if ((oldName = this.ivBackupFiles[lastIndex = this.ivBackupFiles.length - 1]) != null) {
            FFDCHelper.deleteFile(new File(oldName));
        }
        int i = lastIndex;
        int j = lastIndex - 1;
        while (i > 0) {
            this.ivBackupFiles[i] = this.ivBackupFiles[j];
            --i;
            --j;
        }
        this.ivBackupFiles[0] = backupFileName;
        return backupFileName;
    }

    private String[] generateBackupFileList() {
        String[] files = FFDCHelper.listFileNames(new File(this.ivDirectory));
        if (files == null || files.length == 0) {
            return new String[this.ivMaxBackups];
        }
        String dir = this.ivDirectory + File.separator;
        int size = files.length;
        Vector<String> fileNames = new Vector<String>(size);
        Vector<Long> timestamps = new Vector<Long>(size);
        int arrayIndex = 0;
        for (int i = 0; i < size; ++i) {
            long time;
            String fqFileName = dir + files[i];
            File candidate = new File(fqFileName);
            if (!FFDCHelper.isFile(candidate) || (time = this.getFileTimestamp(files[i])) == 0L) continue;
            fileNames.addElement(fqFileName);
            timestamps.addElement(new Long(time));
            ++arrayIndex;
        }
        if (fileNames.isEmpty()) {
            String[] retVal = new String[this.ivMaxBackups];
            for (int i = 0; i < this.ivMaxBackups; ++i) {
                retVal[i] = null;
            }
            return retVal;
        }
        return this.sortAndDeleteFiles(fileNames, timestamps);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getFileTimestamp(String fileName) {
        if (!fileName.startsWith(this.ivNamePrefix)) return 0L;
        fileName = fileName.substring(this.ivNamePrefix.length() + 1);
        if (this.ivNameSuffix != null) {
            if (!fileName.endsWith(this.ivNameSuffix)) return 0L;
            fileName = fileName.substring(0, fileName.length() - this.ivNameSuffix.length());
        }
        try {
            Date date = this.ivDateFormatter.parse(fileName);
            return date.getTime();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    private String[] sortAndDeleteFiles(Vector fileNameVector, Vector timestampsVector) {
        int i;
        int size = fileNameVector.size();
        String[] fileNames = new String[size];
        long[] timestamps = new long[size];
        for (int i2 = 0; i2 < size; ++i2) {
            fileNames[i2] = (String)fileNameVector.elementAt(i2);
            timestamps[i2] = (Long)timestampsVector.elementAt(i2);
        }
        int length = fileNames.length;
        boolean changed = true;
        while (changed) {
            changed = false;
            int i3 = 0;
            for (int j = 1; j < length; ++j) {
                if (timestamps[i3] < timestamps[j]) {
                    long temp = timestamps[i3];
                    String tempS = fileNames[i3];
                    timestamps[i3] = timestamps[j];
                    timestamps[j] = temp;
                    fileNames[i3] = fileNames[j];
                    fileNames[j] = tempS;
                    changed = true;
                }
                ++i3;
            }
        }
        String[] arrayToReturn = new String[this.ivMaxBackups];
        if (length <= this.ivMaxBackups) {
            System.arraycopy(fileNames, 0, arrayToReturn, 0, length);
            for (i = length; i < this.ivMaxBackups; ++i) {
                arrayToReturn[i] = null;
            }
        } else {
            System.arraycopy(fileNames, 0, arrayToReturn, 0, this.ivMaxBackups);
            for (i = this.ivMaxBackups; i < length; ++i) {
                if (fileNames[i] == null) continue;
                FFDCHelper.deleteFile(new File(fileNames[i]));
            }
        }
        return arrayToReturn;
    }

    String[] getBackupFileList() {
        if (this.ivBackupFiles == null || this.ivBackupFiles.length == 0) {
            return null;
        }
        int len = this.ivBackupFiles.length;
        String[] copy = new String[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = this.ivBackupFiles[i];
        }
        return copy;
    }

    public FileChannel getChanel() {
        return this.ivFileStream.getChannel();
    }

    private static FileOutputStream createFileOutputStream(String fileName, boolean append) throws PrivilegedActionException {
        final String tempFileName = fileName;
        final boolean tempAppend = append;
        FileOutputStream fs = (FileOutputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws IOException {
                return new FileOutputStream(tempFileName, tempAppend);
            }
        });
        return fs;
    }
}

