/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.ffdc.Manager;
import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.ffdc.impl.FfdcProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatters
extends com.ibm.ffdc.util.provider.Formatters<FfdcProvider> {
    public Formatters(FfdcProvider provider) {
        super((com.ibm.ffdc.util.provider.FfdcProvider)provider);
    }

    protected <T> Formatter makeFormatter(final Class<T> cl) throws PrivilegedActionException {
        Formatter f = super.makeFormatter(cl);
        if (!this.isIntrospector(f)) {
            return f;
        }
        if (FFDCSelfIntrospectable.class.isAssignableFrom(cl)) {
            Method introspectSelfMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() {
                    try {
                        return cl.getMethod("introspectSelf", new Class[0]);
                    }
                    catch (Exception e) {
                        Manager.Ffdc.log((Throwable)e, (Object)this, this.getClass().getName(), "34", new Object[]{cl == null ? null : cl.getName()});
                        return null;
                    }
                }
            });
            if (introspectSelfMethod == null) {
                return f;
            }
            return new IntrospectSelfFormatter(cl, introspectSelfMethod);
        }
        Method introspectSelfMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() {
                try {
                    Method m = cl.getDeclaredMethod("introspectSelf", new Class[0]);
                    if (!Modifier.isPublic(m.getModifiers())) {
                        return null;
                    }
                    if (String[].class.equals(m.getReturnType())) {
                        return m;
                    }
                    return null;
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (introspectSelfMethod == null) {
            return f;
        }
        return new IntrospectSelfFormatter(cl, introspectSelfMethod);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntrospectSelfFormatter
    implements Formatter {
        private final Class cl;
        private final Method introspectSelfMethod;

        public IntrospectSelfFormatter(Class cl, Method introspectSelfMethod) {
            this.cl = cl;
            this.introspectSelfMethod = introspectSelfMethod;
        }

        public void formatTo(final Object o, IncidentStream is) {
            try {
                String[] lines;
                for (String line : lines = AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                    @Override
                    public String[] run() throws IllegalAccessException, InvocationTargetException {
                        IntrospectSelfFormatter.this.introspectSelfMethod.setAccessible(true);
                        return (String[])IntrospectSelfFormatter.this.introspectSelfMethod.invoke(o, new Object[0]);
                    }
                })) {
                    is.write(null, (Object)line);
                }
            }
            catch (PrivilegedActionException e) {
                Manager.Ffdc.log((Throwable)e, (Object)this, this.getClass().getName(), "formatTo");
                is.write("self introspection failed", (Object)e);
            }
        }

        public String[] getSupportedTypeNames() {
            return new String[]{this.cl.getName()};
        }

        public boolean isSupported(Class<?> clazz) {
            return this.cl.equals(clazz);
        }
    }
}

