/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.impl.Configure;
import com.ibm.ws.ffdc.impl.FFDCExceptionFileFilter;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import java.io.File;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FFDCJanitor {
    private static FFDCJanitor instance = new FFDCJanitor();
    private long timeOfTheDayForCleanup;
    private int daysBetweenCleanups;
    private long timeOfNextCleanup;
    private long maximumFileAge;
    private Object synchronizationGuard = new Object();
    private static final String classname = FFDCJanitor.class.getName();
    private static final Logger logger = Logger.getLogger(classname);
    private boolean configured = false;

    private FFDCJanitor() {
    }

    public static FFDCJanitor getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupIfNeeded() {
        logger.entering(classname, "doCleanupIfNeeded");
        if (!this.configured) {
            logger.exiting(classname, "doCleanupIfNeeded", "not configured - no-op");
            return;
        }
        boolean cleanupNeeded = false;
        long currentTime = System.currentTimeMillis();
        logger.logp(Level.FINE, classname, "doCleanupIfNeeded", "TimeOfNext: " + this.timeOfNextCleanup + "  cur: " + currentTime);
        Object object = this.synchronizationGuard;
        synchronized (object) {
            if (this.timeOfNextCleanup <= currentTime) {
                cleanupNeeded = true;
                this.setNextCleanupTime(currentTime);
            }
        }
        if (cleanupNeeded) {
            cleanupNeeded = false;
            File[] filesToBeDeleted = null;
            FFDCExceptionFileFilter filter = new FFDCExceptionFileFilter();
            filter.setFileSelectionAttributes(null, null, FFDC.getExceptionFileExtension(), FFDC.getExceptionIndexFileNameExtension(), -1L, currentTime - this.maximumFileAge);
            try {
                filesToBeDeleted = FFDCHelper.listFiles(new File(FFDCHelper.getDefaultLoggingDirectory()), filter);
            }
            catch (WsException e) {
                filesToBeDeleted = null;
                logger.logp(Level.WARNING, classname, "doCleanupIfNeeded", "MSG_FFDCJANITOR_FAILED_TO_GET_EXCEPTION_FILES_LIST", e);
            }
            if (filesToBeDeleted != null && filesToBeDeleted.length > 0) {
                logger.logp(Level.FINE, classname, "doCleanupIfNeeded", "Entering loop to delete: " + filesToBeDeleted.length + " files.");
                int deletedCounter = 0;
                for (int i = 0; i < filesToBeDeleted.length; ++i) {
                    logger.logp(Level.FINE, classname, "doCleanupIfNeeded", "Attempting to delete file " + filesToBeDeleted[i].getName());
                    if (FFDCHelper.deleteFile(filesToBeDeleted[i])) {
                        ++deletedCounter;
                        logger.logp(Level.FINE, classname, "doCleanupIfNeeded", "Deleted file " + filesToBeDeleted[i].getName());
                        continue;
                    }
                    if (!filesToBeDeleted[i].exists()) continue;
                    logger.logp(Level.INFO, classname, "doCleanupIfNeeded", "FFDCJANITOR_FAILED_TO_DELETE_FILE", new Object[]{filesToBeDeleted[i].getName()});
                }
                logger.logp(Level.INFO, classname, "doCleanupIfNeeded", "FFDCJANITOR_DELETED_FILES", new Object[]{new Integer(deletedCounter), new Integer(filesToBeDeleted.length)});
            }
        }
        logger.exiting(classname, "doCleanupIfNeeded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeForCleanup(long timeOfDay) {
        this.timeOfTheDayForCleanup = timeOfDay >= 0L && timeOfDay < 86400000L ? timeOfDay : 0L;
        long currentTime = System.currentTimeMillis();
        Object object = this.synchronizationGuard;
        synchronized (object) {
            this.setNextCleanupTime(currentTime);
        }
        this.configured = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, classname, "setTimeForCleanup", "Configured to do cleanup every " + this.daysBetweenCleanups + " day(s), at " + timeOfDay / 3600000L + ":" + (timeOfDay - 3600000L * (timeOfDay / 3600000L)) / 60000L + ", when files reach " + this.maximumFileAge + "ms of age.");
        }
    }

    public void configure(Configure cfg) {
        this.daysBetweenCleanups = cfg.daysBetweenExceptionFilesCleanup;
        this.maximumFileAge = cfg.exceptionFileMaximumAge;
        if (cfg.timeOfTheDayForCleanup > 0L) {
            this.setTimeForCleanup(cfg.timeOfTheDayForCleanup);
        } else if (!this.configured) {
            Random rnd = new Random();
            this.setTimeForCleanup(rnd.nextInt(1440) * 60 * 1000);
        }
    }

    private void setNextCleanupTime(long currentTime) {
        int offset = TimeZone.getDefault().getOffset(currentTime);
        this.timeOfNextCleanup = ((currentTime + (long)offset) / 86400000L + (long)(this.configured ? this.daysBetweenCleanups : 0)) * 86400000L + this.timeOfTheDayForCleanup - (long)offset;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, classname, "setNextCleanupTime", "Next clean up set for " + new Date(this.timeOfNextCleanup).toString());
        }
    }
}

