/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FFDCHelper {
    private static String svServerName = "";
    private static String svDefaultLoggingDirectory;
    private static String svDatabaseDirectory;
    private static final String classname;
    private static Logger logger;
    private static boolean svServer;

    public static boolean isServer() {
        return svServer;
    }

    public static void setServer() {
        svServer = true;
    }

    public static String getServerName() {
        return svServerName;
    }

    public static void setServerName(String serverName) {
        if (serverName != null) {
            svServerName = serverName;
        }
    }

    public static String[] split(String aString, int ch) {
        if (aString == null || aString.equals("")) {
            return new String[0];
        }
        int numComponents = 0;
        int curIndex = 0;
        while (true) {
            curIndex = aString.indexOf(ch, curIndex);
            ++numComponents;
            if (curIndex == -1) break;
            ++curIndex;
        }
        String[] result = new String[numComponents];
        int start = 0;
        int end = aString.indexOf(ch, 0);
        for (int i = 0; i < numComponents; ++i) {
            result[i] = i + 1 == numComponents ? aString.substring(start) : aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(ch, start);
        }
        return result;
    }

    public static String generateFilename(String defaultPrefix) {
        try {
            Date date = new Date(System.currentTimeMillis());
            SimpleDateFormat formatter = new SimpleDateFormat("yy.MM.dd_HH.mm.ss.SSS");
            String ts = formatter.format(date);
            StringBuffer sb = new StringBuffer(64);
            if (FFDC.isZos()) {
                String stoken = FFDC.getzOSServantName();
                sb.append(FFDC.getFullServerName().trim());
                sb.append('_');
                sb.append(FFDC.getzOSjobName().trim());
                sb.append('_');
                sb.append(FFDC.getzOSjobNumber().trim());
                if (stoken != null) {
                    sb.append('_');
                    sb.append(stoken.trim());
                }
            } else {
                sb.append(svServerName);
            }
            sb.append('_');
            sb.append(defaultPrefix);
            sb.append('_');
            sb.append(ts);
            return new String(sb);
        }
        catch (Throwable t) {
            logger.logp(Level.FINEST, classname, "generateOutputFileName", "FFDCHELPER_GENERATE_FILENAME_FAILED", t);
            return null;
        }
    }

    public static synchronized String getDefaultLoggingDirectory() throws WsException {
        if (svDefaultLoggingDirectory == null) {
            String logDir = FFDC.getLogRoot();
            if (logDir == null) {
                throw new WsException("FFDCHelper - unable to obtain the install directory");
            }
            File directory = new File(logDir = logDir.endsWith(File.separator) ? logDir + "ffdc" : logDir + File.separator + "ffdc");
            if (!FFDCHelper.fileExists(directory) && !FFDCHelper.makeDirectories(directory)) {
                throw new WsException("FFDCHelper - Unable to create directory  " + directory.getPath());
            }
            svDefaultLoggingDirectory = directory.getPath();
        }
        return svDefaultLoggingDirectory;
    }

    public static synchronized String getQualifiedDatabaseName(String databaseName) throws WsException {
        if (svDatabaseDirectory == null) {
            String dbDir = FFDCHelper.getSystemProperty("user.install.root");
            if (dbDir == null) {
                throw new WsException("FFDCHelper - unable to obtain the install directory");
            }
            if (!dbDir.endsWith(File.separator)) {
                dbDir = dbDir + File.separator;
            }
            svDatabaseDirectory = dbDir = dbDir + "properties" + File.separator + "logbr" + File.separator + "ffdc" + File.separator + "adv" + File.separator + databaseName;
        }
        return svDatabaseDirectory;
    }

    public static synchronized String getFFDCDBName() throws WsException {
        return FFDCHelper.getQualifiedDatabaseName("ffdcdb.xml");
    }

    public static String getSystemProperty(String propName) {
        final String temp = propName;
        try {
            String prop = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(temp);
                }
            });
            return prop;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "getSystemProperty", "FFDCHELPER_SECURITYEXCEPTION", se);
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resource) throws PrivilegedActionException {
        final String tempResource = resource;
        InputStream stream = (InputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(tempResource);
            }
        });
        return stream;
    }

    public static boolean deleteFile(File fileToDelete) {
        try {
            final File tempFileToDelete = fileToDelete;
            Boolean deleted = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFileToDelete.delete();
                }
            });
            return deleted;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "deleteFile", "FFDCHELPER_SECURITYEXCEPTION", se);
            return false;
        }
    }

    public static boolean fileExists(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean exists = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFileToCheck.exists();
                }
            });
            return exists;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "fileExists", "FFDCHELPER_SECURITYEXCEPTION", se);
            return false;
        }
    }

    public static long getFileLength(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Long size = (Long)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFileToCheck.length();
                }
            });
            return size;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "getFileLength", "FFDCHELPER_SECURITYEXCEPTION", se);
            return 0L;
        }
    }

    public static boolean canWriteFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFileToCheck.canWrite();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "canWriteFile", "FFDCHELPER_SECURITYEXCEPTION", se);
            return false;
        }
    }

    public static boolean createNewFile(File fileToCreate) throws PrivilegedActionException {
        final File tempFileToCreate = fileToCreate;
        Boolean bool = (Boolean)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return tempFileToCreate.createNewFile();
            }
        });
        return bool;
    }

    public static boolean makeDirectories(File dirToMake) {
        final File tempDirToMake = dirToMake;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempDirToMake.mkdirs();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "makeDirectories", "FFDCHELPER_SECURITYEXCEPTION", se);
            return false;
        }
    }

    public static boolean renameFile(File current, File newName) {
        final File tempCurrentFile = current;
        final File tempNewName = newName;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempCurrentFile.renameTo(tempNewName);
                }
            });
            return result;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "renameFile", "FFDCHELPER_SECURITYEXCEPTION", se);
            return false;
        }
    }

    public static boolean isFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean isFile = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFileToCheck.isFile();
                }
            });
            return isFile;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "isFile", "FFDCHELPER_SECURITYEXCEPTION", se);
            return false;
        }
    }

    public static String[] listFileNames(File file) {
        final File tempFile = file;
        try {
            String[] result = (String[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFile.list();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "listFileNames", "FFDCHELPER_SECURITYEXCEPTION", se);
            return new String[0];
        }
    }

    public static boolean isDirectory(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean exists = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFileToCheck.isDirectory();
                }
            });
            return exists;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "isDirectory", "FFDCHELPER_SECURITYEXCEPTION", se);
            return false;
        }
    }

    public static File[] listFiles(File directory, FileFilter filter) {
        final File tempFile = directory;
        final FileFilter tempFilter = filter;
        try {
            File[] result = (File[])AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return tempFile.listFiles(tempFilter);
                }
            });
            return result;
        }
        catch (SecurityException se) {
            logger.logp(Level.FINEST, classname, "listFiles", "FFDCHELPER_SECURITYEXCEPTION", se);
            return new File[0];
        }
    }

    public static DateFormat getBasicDateFormatter() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        return formatter;
    }

    public static String getThreadId() {
        LogRecord logRecord = new LogRecord(Level.FINE, "x");
        return FFDCHelper.getThreadId(logRecord);
    }

    public static String getThreadId(LogRecord logRecord) {
        int length;
        StringBuffer buffer = new StringBuffer(16);
        String tid = Integer.toHexString(logRecord.getThreadID());
        for (int i = length = tid.length(); i < 8; ++i) {
            buffer.append('0');
        }
        buffer.append(tid);
        return buffer.toString();
    }

    static {
        svDatabaseDirectory = null;
        classname = FFDCHelper.class.getName();
        logger = Logger.getLogger(classname, "com.ibm.ws.ffdc.resources.FFDCMessages");
        svServer = false;
    }
}

