/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc.impl;

import com.ibm.etools.analysis.engine.Directive;
import com.ibm.etools.analysis.engine.Incident;
import com.ibm.etools.analysis.engine.Solution;
import com.ibm.etools.analysis.engine.engines.FFDCAnalysisEngine;
import com.ibm.ffdc.util.provider.CapturedDataElements;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.DiagnosticEngine;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.IncidentStream;
import com.ibm.ws.ffdc.impl.CallStack;
import com.ibm.ws.ffdc.impl.Configure;
import com.ibm.ws.ffdc.impl.FFDCHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMAdapter
extends CapturedDataElements {
    private final List<DiagnosticModule> dml;
    private final CallStack cs;
    private final Object callerThis;
    private final String sourceId;
    private static final String thisClass = DMAdapter.class.getName();
    private static Logger LOGGER = Logger.getLogger(thisClass, "com.ibm.ws.ffdc.resources.FFDCMessages");
    private static FFDCAnalysisEngine analysisEngine;
    static boolean isFFDCAnalysisEngineAvailable;

    public DMAdapter(String sourceId, Object reporter, Throwable th, Object[] cde) {
        super(cde);
        LOGGER.entering(thisClass, "constructor", new Object[]{sourceId, reporter, th, cde});
        this.cs = new CallStack(th);
        this.callerThis = reporter;
        this.sourceId = sourceId;
        Configure cfg = FFDC.getConfiguration();
        this.dml = cfg == null ? null : DiagnosticEngine.getDiagnosticModules(cfg.processLevel, reporter, sourceId, this.cs);
    }

    public void formatTo(com.ibm.ffdc.config.IncidentStream is) {
        String[] directives;
        List<DiagnosticModule> dml = this.dml;
        if (dml == null || dml.isEmpty()) {
            is.write("Reporter", this.callerThis);
            super.formatTo(is);
            return;
        }
        IncidentStream incidentStream = (IncidentStream)is;
        FFDCAnalysisEngine analysisEngine = DMAdapter.getAnalysisEngine();
        if (analysisEngine == null) {
            directives = null;
        } else {
            Incident incident = new Incident(null);
            incident.setMessageId(this.cs.getExceptionName());
            incident.setRawData(this.cs.getCallStack());
            Solution[] solutions = analysisEngine.analyzeForSolutions(incident);
            ArrayList<String> lDirectives = new ArrayList<String>(10);
            for (Solution solution : solutions) {
                Directive[] aDirectives;
                incidentStream.writeLine("Solution", solution.getDescription());
                for (Directive d : aDirectives = solution.getDirectives()) {
                    lDirectives.add(d.getDirectiveString());
                }
            }
            directives = lDirectives.toArray(new String[0]);
        }
        for (DiagnosticModule dm : dml) {
            if (this.processDM(incidentStream, dm, directives)) continue;
            return;
        }
    }

    private boolean processDM(IncidentStream is, DiagnosticModule dm, String[] directives) {
        LOGGER.entering(thisClass, "processDM", new Object[]{is, dm, directives});
        return dm.dumpComponentData(directives, this.cs.getThrowable(), is, this.callerThis, this.getCapturedDataElements(), this.sourceId, this.cs);
    }

    private static synchronized FFDCAnalysisEngine getAnalysisEngine() {
        if (analysisEngine == null) {
            if (!isFFDCAnalysisEngineAvailable) {
                return null;
            }
            try {
                String qualifiedName = FFDCHelper.getFFDCDBName();
                analysisEngine = FFDCAnalysisEngine.getInstance((String)qualifiedName);
                LOGGER.logp(Level.INFO, thisClass, "getAnalysisEngine", "FFDCAnalysisEngineUsing", qualifiedName);
            }
            catch (WsException e) {
                isFFDCAnalysisEngineAvailable = false;
                LOGGER.logp(Level.WARNING, thisClass, "getAnalysisEngine", "FFDCAnalysisEngineUsing", e);
            }
        }
        return analysisEngine;
    }

    static {
        isFFDCAnalysisEngineAvailable = true;
    }
}

