/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.impl.CallStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticEngine {
    private static final Hashtable<Integer, DiagnosticModule> globalHashTableOfDM = new Hashtable();

    public static List<DiagnosticModule> getDiagnosticModules(int processLevel, Object callerThis, String sourceId, CallStack cs) {
        switch (processLevel) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
            case 4: {
                DiagnosticModule dm = DiagnosticEngine.getCurrentLevelDiagnosticModules(callerThis, cs, sourceId);
                return dm == null ? null : Collections.singletonList(dm);
            }
            case 5: 
            case 6: 
            case 7: {
                return DiagnosticEngine.getFullStackDMIterator(callerThis, cs, sourceId);
            }
        }
        return null;
    }

    private static DiagnosticModule getCurrentLevelDiagnosticModules(Object callerThis, CallStack cs, String sourceId) {
        String clname = DiagnosticEngine.getReporterClassName(callerThis, cs);
        DiagnosticModule dm = DiagnosticEngine.findDM(clname);
        if (dm == null) {
            dm = DiagnosticEngine.findDM(sourceId);
        }
        return dm;
    }

    private static List<DiagnosticModule> getFullStackDMIterator(Object callerThis, CallStack cs, String sourceId) {
        HashSet<DiagnosticModule> foundDMs = new HashSet<DiagnosticModule>();
        DiagnosticModule dm = DiagnosticEngine.getCurrentLevelDiagnosticModules(callerThis, cs, sourceId);
        List<String> cnames = cs.getClassNames();
        ArrayList<DiagnosticModule> dml = new ArrayList<DiagnosticModule>(cnames.size() + (dm == null ? 0 : 1));
        for (String clname : cnames) {
            dm = DiagnosticEngine.findDM(clname);
            if (dm == null || !foundDMs.add(dm)) continue;
            dml.add(dm);
        }
        return dml;
    }

    private static String getReporterClassName(Object callerThis, CallStack cs) {
        String clname = callerThis != null ? (callerThis instanceof Class ? ((Class)callerThis).getName() : callerThis.getClass().getName()) : cs.getReporterClassName();
        return clname;
    }

    private static DiagnosticModule findDM(String path) {
        String trimName = path;
        while (trimName != null) {
            int pkgKey = trimName.hashCode();
            DiagnosticModule dm = globalHashTableOfDM.get(pkgKey);
            if (dm != null) {
                return dm;
            }
            trimName = DiagnosticEngine.trim(trimName);
        }
        return null;
    }

    private static String trim(String pkgName) {
        int lastDot = pkgName.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return pkgName.substring(0, lastDot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean registerDM(DiagnosticModule dm, String packageName) {
        Hashtable<Integer, DiagnosticModule> hashtable = globalHashTableOfDM;
        synchronized (hashtable) {
            int DMKey = packageName.hashCode();
            if (globalHashTableOfDM.containsKey(DMKey)) {
                return false;
            }
            globalHashTableOfDM.put(DMKey, dm);
        }
        return true;
    }

    static boolean deregisterDM(String packageName) {
        int DMKey = packageName.hashCode();
        return null != globalHashTableOfDM.remove(DMKey);
    }
}

