/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.formatting;

import com.ibm.ffdc.Ffdc;
import com.ibm.ffdc.Manager;
import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentStream;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtilFormatter
implements Formatter {
    protected static final String FAILED_TO_FORMAT_SEE_FFDC = "Failed to format see FFDC";
    protected static final String KEY = "key";
    protected static final String VALUE = "value";
    protected static final String NOTE = "Note";
    protected static final String MODIFIED_WHILE_PRINTING = "this object has been modified while printing";
    protected static final String MAP_DOES_NOT_SUPPORT_OP_ENTRY_SET = "this map does not support op: entrySet()";

    @Override
    public final void formatTo(Object o, IncidentStream is) {
        if (o instanceof Map) {
            this.formatTo(is, (Map)o);
        } else if (o instanceof Collection) {
            this.formatTo(is, (Collection)o);
        } else {
            is.write(null, o.toString());
        }
    }

    private void formatTo(IncidentStream is, Map<?, ?> map) {
        is.write(null, Character.valueOf('{'));
        try {
            for (Map.Entry<?, ?> e : map.entrySet()) {
                is.write(KEY, e.getKey());
                is.write(VALUE, e.getValue());
            }
        }
        catch (ConcurrentModificationException e) {
            is.write(NOTE, MODIFIED_WHILE_PRINTING);
        }
        catch (UnsupportedOperationException e) {
            is.write(NOTE, MAP_DOES_NOT_SUPPORT_OP_ENTRY_SET);
        }
        catch (Exception e) {
            Ffdc ffdc = Manager.Ffdc.getFfdc(e, this, this.getClass().getName(), "61");
            if (ffdc.isLoggable()) {
                ffdc.log(new Object[0]);
            }
            is.write(FAILED_TO_FORMAT_SEE_FFDC, ffdc.toString());
        }
        is.write(null, Character.valueOf('}'));
    }

    private void formatTo(IncidentStream is, Collection<?> collection) {
        is.write(null, Character.valueOf('{'));
        try {
            for (Object o : collection) {
                is.write(null, o);
            }
        }
        catch (ConcurrentModificationException e) {
            is.write(NOTE, MODIFIED_WHILE_PRINTING);
        }
        catch (Exception e) {
            Ffdc ffdc = Manager.Ffdc.getFfdc(e, this, this.getClass().getName(), "77");
            if (ffdc.isLoggable()) {
                ffdc.log(new Object[0]);
            }
            is.write(FAILED_TO_FORMAT_SEE_FFDC, ffdc.toString());
        }
        is.write(null, Character.valueOf('}'));
    }

    @Override
    public String[] getSupportedTypeNames() {
        return new String[]{"java.util.*"};
    }

    @Override
    public boolean isSupported(Class<?> klass) {
        return Collection.class.getPackage().equals(klass.getPackage());
    }
}

