/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.xinclude;

import com.ibm.xml.xml4j.internal.s1.impl.XMLEntityManager;
import com.ibm.xml.xml4j.internal.s1.impl.XMLErrorReporter;
import com.ibm.xml.xml4j.internal.s1.impl.io.ASCIIReader;
import com.ibm.xml.xml4j.internal.s1.impl.io.Latin1Reader;
import com.ibm.xml.xml4j.internal.s1.impl.io.UTF16Reader;
import com.ibm.xml.xml4j.internal.s1.impl.io.UTF8Reader;
import com.ibm.xml.xml4j.internal.s1.util.EncodingMap;
import com.ibm.xml.xml4j.internal.s1.util.HTTPInputSource;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import com.ibm.xml.xml4j.internal.s1.xinclude.XIncludeHandler;
import com.ibm.xml.xml4j.internal.s1.xni.XMLString;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLInputSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Map;

public class XIncludeTextReader {
    private Reader fReader;
    private final XIncludeHandler fHandler;
    private XMLInputSource fSource;
    private XMLErrorReporter fErrorReporter;
    private XMLString fTempString = new XMLString();

    public XIncludeTextReader(XMLInputSource xMLInputSource, XIncludeHandler xIncludeHandler, int n2) throws IOException {
        this.fHandler = xIncludeHandler;
        this.fSource = xMLInputSource;
        this.fTempString = new XMLString(new char[n2 + 1], 0, 0);
    }

    public void setErrorReporter(XMLErrorReporter xMLErrorReporter) {
        this.fErrorReporter = xMLErrorReporter;
    }

    protected Reader getReader(XMLInputSource xMLInputSource) throws IOException {
        Object object2;
        Object object3;
        String string2;
        if (xMLInputSource.getCharacterStream() != null) {
            return xMLInputSource.getCharacterStream();
        }
        InputStream inputStream = null;
        String string3 = xMLInputSource.getEncoding();
        if (string3 == null) {
            string3 = "UTF-8";
        }
        if (xMLInputSource.getByteStream() != null) {
            inputStream = xMLInputSource.getByteStream();
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream, this.fTempString.ch.length);
            }
        } else {
            Object object4;
            Object object5;
            string2 = XMLEntityManager.expandSystemId(xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId(), false);
            object3 = new URL(string2);
            object2 = ((URL)object3).openConnection();
            if (object2 instanceof HttpURLConnection && xMLInputSource instanceof HTTPInputSource) {
                object5 = (HttpURLConnection)object2;
                HTTPInputSource hTTPInputSource = (HTTPInputSource)xMLInputSource;
                object4 = hTTPInputSource.getHTTPRequestProperties();
                while (object4.hasNext()) {
                    Map.Entry entry = (Map.Entry)object4.next();
                    ((URLConnection)object5).setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                boolean bl = hTTPInputSource.getFollowHTTPRedirects();
                if (!bl) {
                    ((HttpURLConnection)object5).setInstanceFollowRedirects(bl);
                }
            }
            inputStream = new BufferedInputStream(((URLConnection)object2).getInputStream());
            object5 = ((URLConnection)object2).getContentType();
            int n2 = object5 != null ? ((String)object5).indexOf(59) : -1;
            object4 = null;
            String string4 = null;
            if (n2 != -1) {
                object4 = ((String)object5).substring(0, n2).trim();
                string4 = ((String)object5).substring(n2 + 1).trim();
                if (string4.startsWith("charset=")) {
                    if ((string4 = string4.substring(8).trim()).charAt(0) == '\"' && string4.charAt(string4.length() - 1) == '\"' || string4.charAt(0) == '\'' && string4.charAt(string4.length() - 1) == '\'') {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                } else {
                    string4 = null;
                }
            } else {
                object4 = ((String)object5).trim();
            }
            String string5 = null;
            if (((String)object4).equals("text/xml")) {
                string5 = string4 != null ? string4 : "US-ASCII";
            } else if (((String)object4).equals("application/xml")) {
                string5 = string4 != null ? string4 : this.getEncodingName(inputStream);
            } else if (((String)object4).endsWith("+xml")) {
                string5 = this.getEncodingName(inputStream);
            }
            if (string5 != null) {
                string3 = string5;
            }
        }
        string3 = string3.toUpperCase(Locale.ENGLISH);
        if ((string3 = this.consumeBOM(inputStream, string3)).equals("UTF-8")) {
            return this.createUTF8Reader(inputStream);
        }
        if (string3.equals("UTF-16BE")) {
            return this.createUTF16Reader(inputStream, true);
        }
        if (string3.equals("UTF-16LE")) {
            return this.createUTF16Reader(inputStream, false);
        }
        string2 = EncodingMap.getIANA2JavaMapping(string3);
        if (string2 == null) {
            object3 = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210");
            object2 = this.fErrorReporter.getLocale();
            throw new IOException(object3.formatMessage((Locale)object2, "EncodingDeclInvalid", new Object[]{string3}));
        }
        if (string2.equals("ASCII")) {
            return this.createASCIIReader(inputStream);
        }
        if (string2.equals("ISO8859_1")) {
            return this.createLatin1Reader(inputStream);
        }
        return new InputStreamReader(inputStream, string2);
    }

    private Reader createUTF8Reader(InputStream inputStream) {
        return new UTF8Reader(inputStream, this.fTempString.ch.length, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createUTF16Reader(InputStream inputStream, boolean bl) {
        return new UTF16Reader(inputStream, this.fTempString.ch.length << 1, bl, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createASCIIReader(InputStream inputStream) {
        return new ASCIIReader(inputStream, this.fTempString.ch.length, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createLatin1Reader(InputStream inputStream) {
        return new Latin1Reader(inputStream, this.fTempString.ch.length);
    }

    protected String getEncodingName(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        String string2 = null;
        inputStream.mark(4);
        int n2 = inputStream.read(byArray, 0, 4);
        inputStream.reset();
        if (n2 == 4) {
            string2 = this.getEncodingName(byArray);
        }
        return string2;
    }

    protected String consumeBOM(InputStream inputStream, String string2) throws IOException {
        byte[] byArray = new byte[3];
        int n2 = 0;
        inputStream.mark(3);
        if (string2.equals("UTF-8")) {
            n2 = inputStream.read(byArray, 0, 3);
            if (n2 == 3) {
                int n3 = byArray[0] & 0xFF;
                int n4 = byArray[1] & 0xFF;
                int n5 = byArray[2] & 0xFF;
                if (n3 != 239 || n4 != 187 || n5 != 191) {
                    inputStream.reset();
                }
            } else {
                inputStream.reset();
            }
        } else if (string2.startsWith("UTF-16")) {
            n2 = inputStream.read(byArray, 0, 2);
            if (n2 == 2) {
                int n6 = byArray[0] & 0xFF;
                int n7 = byArray[1] & 0xFF;
                if (n6 == 254 && n7 == 255) {
                    return "UTF-16BE";
                }
                if (n6 == 255 && n7 == 254) {
                    return "UTF-16LE";
                }
            }
            inputStream.reset();
        }
        return string2;
    }

    protected String getEncodingName(byte[] byArray) {
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return "UTF-16BE";
        }
        if (n2 == 255 && n3 == 254) {
            return "UTF-16LE";
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return "UTF-8";
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return "UTF-16BE";
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return "UTF-16LE";
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return "CP037";
        }
        return null;
    }

    public void parse() throws IOException {
        this.fReader = this.getReader(this.fSource);
        this.fSource = null;
        int n2 = this.fReader.read(this.fTempString.ch, 0, this.fTempString.ch.length - 1);
        this.fHandler.fHasIncludeReportedContent = true;
        while (n2 != -1) {
            for (int i = 0; i < n2; ++i) {
                char c = this.fTempString.ch[i];
                if (this.isValid(c)) continue;
                if (XMLChar.isHighSurrogate(c)) {
                    int n3;
                    if (++i < n2) {
                        n3 = this.fTempString.ch[i];
                    } else {
                        n3 = this.fReader.read();
                        if (n3 != -1) {
                            this.fTempString.ch[n2++] = (char)n3;
                        }
                    }
                    if (XMLChar.isLowSurrogate(n3)) {
                        int n4 = XMLChar.supplemental(c, (char)n3);
                        if (this.isValid(n4)) continue;
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n4, 16)}, (short)2);
                        continue;
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(n3, 16)}, (short)2);
                    continue;
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(c, 16)}, (short)2);
            }
            if (this.fHandler != null && n2 > 0) {
                this.fTempString.offset = 0;
                this.fTempString.length = n2;
                this.fHandler.characters(this.fTempString, this.fHandler.modifyAugmentations(null, true));
            }
            n2 = this.fReader.read(this.fTempString.ch, 0, this.fTempString.ch.length - 1);
        }
    }

    public void setInputSource(XMLInputSource xMLInputSource) {
        this.fSource = xMLInputSource;
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
            this.fReader = null;
        }
    }

    protected boolean isValid(int n2) {
        return XMLChar.isValid(n2);
    }

    protected void setBufferSize(int n2) {
        if (this.fTempString.ch.length != ++n2) {
            this.fTempString.ch = new char[n2];
        }
    }
}

