/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;

public class URI
implements Serializable {
    static final long serialVersionUID = 1601921774685357214L;
    private static final byte[] fgLookupTable = new byte[128];
    private static final int RESERVED_CHARACTERS = 1;
    private static final int MARK_CHARACTERS = 2;
    private static final int SCHEME_CHARACTERS = 4;
    private static final int USERINFO_CHARACTERS = 8;
    private static final int ASCII_ALPHA_CHARACTERS = 16;
    private static final int ASCII_DIGIT_CHARACTERS = 32;
    private static final int ASCII_HEX_CHARACTERS = 64;
    private static final int PATH_CHARACTERS = 128;
    private static final int MASK_ALPHA_NUMERIC = 48;
    private static final int MASK_UNRESERVED_MASK = 50;
    private static final int MASK_URI_CHARACTER = 51;
    private static final int MASK_SCHEME_CHARACTER = 52;
    private static final int MASK_USERINFO_CHARACTER = 58;
    private static final int MASK_PATH_CHARACTER = 178;
    private String m_scheme = null;
    private String m_userinfo = null;
    private String m_host = null;
    private int m_port = -1;
    private String m_regAuthority = null;
    private String m_path = null;
    private String m_queryString = null;
    private String m_fragment = null;
    private static boolean DEBUG;

    public URI() {
    }

    public URI(URI uRI) {
        this.initialize(uRI);
    }

    public URI(String string2) throws MalformedURIException {
        this((URI)null, string2);
    }

    public URI(String string2, boolean bl) throws MalformedURIException {
        this(null, string2, bl);
    }

    public URI(URI uRI, String string2) throws MalformedURIException {
        this.initialize(uRI, string2);
    }

    public URI(URI uRI, String string2, boolean bl) throws MalformedURIException {
        this.initialize(uRI, string2, bl);
    }

    public URI(String string2, String string3) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            throw new MalformedURIException("Cannot construct URI with null/empty scheme!");
        }
        if (string3 == null || string3.trim().length() == 0) {
            throw new MalformedURIException("Cannot construct URI with null/empty scheme-specific part!");
        }
        this.setScheme(string2);
        this.setPath(string3);
    }

    public URI(String string2, String string3, String string4, String string5, String string6) throws MalformedURIException {
        this(string2, null, string3, -1, string4, string5, string6);
    }

    public URI(String string2, String string3, String string4, int n2, String string5, String string6, String string7) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            throw new MalformedURIException("Scheme is required!");
        }
        if (string4 == null) {
            if (string3 != null) {
                throw new MalformedURIException("Userinfo may not be specified if host is not specified!");
            }
            if (n2 != -1) {
                throw new MalformedURIException("Port may not be specified if host is not specified!");
            }
        }
        if (string5 != null) {
            if (string5.indexOf(63) != -1 && string6 != null) {
                throw new MalformedURIException("Query string cannot be specified in path and query string!");
            }
            if (string5.indexOf(35) != -1 && string7 != null) {
                throw new MalformedURIException("Fragment cannot be specified in both the path and fragment!");
            }
        }
        this.setScheme(string2);
        this.setHost(string4);
        this.setPort(n2);
        this.setUserinfo(string3);
        this.setPath(string5);
        this.setQueryString(string6);
        this.setFragment(string7);
    }

    private void initialize(URI uRI) {
        this.m_scheme = uRI.getScheme();
        this.m_userinfo = uRI.getUserinfo();
        this.m_host = uRI.getHost();
        this.m_port = uRI.getPort();
        this.m_regAuthority = uRI.getRegBasedAuthority();
        this.m_path = uRI.getPath();
        this.m_queryString = uRI.getQueryString();
        this.m_fragment = uRI.getFragment();
    }

    private void initialize(URI uRI, String string2, boolean bl) throws MalformedURIException {
        int n2;
        int n3;
        int n4;
        String string3 = string2;
        int n5 = n4 = string3 != null ? string3.length() : 0;
        if (uRI == null && n4 == 0) {
            if (bl) {
                this.m_path = "";
                return;
            }
            throw new MalformedURIException("Cannot initialize URI with empty parameters.");
        }
        if (n4 == 0) {
            this.initialize(uRI);
            return;
        }
        int n6 = 0;
        int n7 = string3.indexOf(58);
        if (n7 != -1) {
            n3 = n7 - 1;
            n2 = string3.lastIndexOf(47, n3);
            int n8 = string3.lastIndexOf(63, n3);
            int n9 = string3.lastIndexOf(35, n3);
            if (n7 == 0 || n2 != -1 || n8 != -1 || n9 != -1) {
                if (n7 == 0 || uRI == null && n9 != 0 && !bl) {
                    throw new MalformedURIException("No scheme found in URI.");
                }
            } else {
                this.initializeScheme(string3);
                n6 = this.m_scheme.length() + 1;
                if (n7 == n4 - 1 || string3.charAt(n7 + 1) == '#') {
                    throw new MalformedURIException("Scheme specific part cannot be empty.");
                }
            }
        } else if (uRI == null && string3.indexOf(35) != 0 && !bl) {
            throw new MalformedURIException("No scheme found in URI.");
        }
        if (n6 + 1 < n4 && string3.charAt(n6) == '/' && string3.charAt(n6 + 1) == '/') {
            n3 = n6 += 2;
            n2 = 0;
            while (n6 < n4 && (n2 = (int)string3.charAt(n6)) != 47 && n2 != 63 && n2 != 35) {
                ++n6;
            }
            if (n6 > n3) {
                if (!this.initializeAuthority(string3.substring(n3, n6))) {
                    n6 = n3 - 2;
                }
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(string3, n6);
        if (uRI != null) {
            this.absolutize(uRI);
        }
    }

    private void initialize(URI uRI, String string2) throws MalformedURIException {
        int n2;
        int n3;
        int n4;
        String string3 = string2;
        int n5 = n4 = string3 != null ? string3.length() : 0;
        if (uRI == null && n4 == 0) {
            throw new MalformedURIException("Cannot initialize URI with empty parameters.");
        }
        if (n4 == 0) {
            this.initialize(uRI);
            return;
        }
        int n6 = 0;
        int n7 = string3.indexOf(58);
        if (n7 != -1) {
            n3 = n7 - 1;
            n2 = string3.lastIndexOf(47, n3);
            int n8 = string3.lastIndexOf(63, n3);
            int n9 = string3.lastIndexOf(35, n3);
            if (n7 == 0 || n2 != -1 || n8 != -1 || n9 != -1) {
                if (n7 == 0 || uRI == null && n9 != 0) {
                    throw new MalformedURIException("No scheme found in URI.");
                }
            } else {
                this.initializeScheme(string3);
                n6 = this.m_scheme.length() + 1;
                if (n7 == n4 - 1 || string3.charAt(n7 + 1) == '#') {
                    throw new MalformedURIException("Scheme specific part cannot be empty.");
                }
            }
        } else if (uRI == null && string3.indexOf(35) != 0) {
            throw new MalformedURIException("No scheme found in URI.");
        }
        if (n6 + 1 < n4 && string3.charAt(n6) == '/' && string3.charAt(n6 + 1) == '/') {
            n3 = n6 += 2;
            n2 = 0;
            while (n6 < n4 && (n2 = (int)string3.charAt(n6)) != 47 && n2 != 63 && n2 != 35) {
                ++n6;
            }
            if (n6 > n3) {
                if (!this.initializeAuthority(string3.substring(n3, n6))) {
                    n6 = n3 - 2;
                }
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(string3, n6);
        if (uRI != null) {
            this.absolutize(uRI);
        }
    }

    public void absolutize(URI uRI) {
        int n2;
        if (this.m_path.length() == 0 && this.m_scheme == null && this.m_host == null && this.m_regAuthority == null) {
            this.m_scheme = uRI.getScheme();
            this.m_userinfo = uRI.getUserinfo();
            this.m_host = uRI.getHost();
            this.m_port = uRI.getPort();
            this.m_regAuthority = uRI.getRegBasedAuthority();
            this.m_path = uRI.getPath();
            if (this.m_queryString == null) {
                this.m_queryString = uRI.getQueryString();
                if (this.m_fragment == null) {
                    this.m_fragment = uRI.getFragment();
                }
            }
            return;
        }
        if (this.m_scheme != null) {
            return;
        }
        this.m_scheme = uRI.getScheme();
        if (this.m_host != null || this.m_regAuthority != null) {
            return;
        }
        this.m_userinfo = uRI.getUserinfo();
        this.m_host = uRI.getHost();
        this.m_port = uRI.getPort();
        this.m_regAuthority = uRI.getRegBasedAuthority();
        if (this.m_path.length() > 0 && this.m_path.startsWith("/")) {
            return;
        }
        String string2 = "";
        String string3 = uRI.getPath();
        if (string3 != null && string3.length() > 0) {
            n2 = string3.lastIndexOf(47);
            if (n2 != -1) {
                string2 = string3.substring(0, n2 + 1);
            }
        } else if (this.m_path.length() > 0) {
            string2 = "/";
        }
        string2 = string2.concat(this.m_path);
        n2 = -1;
        while ((n2 = string2.indexOf("/./")) != -1) {
            string2 = string2.substring(0, n2 + 1).concat(string2.substring(n2 + 3));
        }
        if (string2.endsWith("/.")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        n2 = 1;
        int n3 = -1;
        String string4 = null;
        while ((n2 = string2.indexOf("/../", n2)) > 0) {
            string4 = string2.substring(0, string2.indexOf("/../"));
            n3 = string4.lastIndexOf(47);
            if (n3 != -1) {
                if (!string4.substring(n3).equals("..")) {
                    string2 = string2.substring(0, n3 + 1).concat(string2.substring(n2 + 4));
                    n2 = n3;
                    continue;
                }
                n2 += 4;
                continue;
            }
            n2 += 4;
        }
        if (string2.endsWith("/..") && (n3 = (string4 = string2.substring(0, string2.length() - 3)).lastIndexOf(47)) != -1) {
            string2 = string2.substring(0, n3 + 1);
        }
        this.m_path = string2;
    }

    private void initializeScheme(String string2) throws MalformedURIException {
        int n2;
        int n3 = string2.length();
        String string3 = null;
        char c = '\u0000';
        for (n2 = 0; n2 < n3 && (c = string2.charAt(n2)) != ':' && c != '/' && c != '?' && c != '#'; ++n2) {
        }
        string3 = string2.substring(0, n2);
        if (string3.length() == 0) {
            throw new MalformedURIException("No scheme found in URI.");
        }
        this.setScheme(string3);
    }

    private boolean initializeAuthority(String string2) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = string2.length();
        char c = '\u0000';
        String string3 = null;
        if (string2.indexOf(64, n4) != -1) {
            for (n3 = 0; n3 < n5 && (c = string2.charAt(n3)) != '@'; ++n3) {
            }
            string3 = string2.substring(n4, n3);
            ++n3;
        }
        String string4 = null;
        n4 = n3;
        boolean bl = false;
        if (n3 < n5) {
            if (string2.charAt(n4) == '[') {
                n2 = string2.indexOf(93, n4);
                int n6 = n3 = n2 != -1 ? n2 : n5;
                if (n3 + 1 < n5 && string2.charAt(n3 + 1) == ':') {
                    ++n3;
                    bl = true;
                } else {
                    n3 = n5;
                }
            } else {
                n2 = string2.lastIndexOf(58, n5);
                n3 = n2 > n4 ? n2 : n5;
                bl = n3 != n5;
            }
        }
        string4 = string2.substring(n4, n3);
        n2 = -1;
        if (string4.length() > 0 && bl) {
            n4 = ++n3;
            while (n3 < n5) {
                ++n3;
            }
            String string5 = string2.substring(n4, n3);
            if (string5.length() > 0) {
                try {
                    n2 = Integer.parseInt(string5);
                    if (n2 == -1) {
                        --n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -2;
                }
            }
        }
        if (this.isValidServerBasedAuthority(string4, n2, string3)) {
            this.m_host = string4;
            this.m_port = n2;
            this.m_userinfo = string3;
            return true;
        }
        if (this.isValidRegistryBasedAuthority(string2)) {
            this.m_regAuthority = string2;
            return true;
        }
        return false;
    }

    private boolean isValidServerBasedAuthority(String string2, int n2, String string3) {
        if (!URI.isWellFormedAddress(string2)) {
            return false;
        }
        if (n2 < -1 || n2 > 65535) {
            return false;
        }
        if (string3 != null) {
            int n3 = string3.length();
            char c = '\u0000';
            for (int i = 0; i < n3; ++i) {
                c = string3.charAt(i);
                if (c == '%') {
                    if (i + 2 >= n3 || !URI.isHex(string3.charAt(i + 1)) || !URI.isHex(string3.charAt(i + 2))) {
                        return false;
                    }
                    i += 2;
                    continue;
                }
                if (URI.isUserinfoCharacter(c)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValidRegistryBasedAuthority(String string2) {
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == '%') {
                if (i + 2 >= n2 || !URI.isHex(string2.charAt(i + 1)) || !URI.isHex(string2.charAt(i + 2))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (URI.isPathCharacter(c)) continue;
            return false;
        }
        return true;
    }

    private void initializePath(String string2, int n2) throws MalformedURIException {
        int n3;
        if (string2 == null) {
            throw new MalformedURIException("Cannot initialize path from null string!");
        }
        int n4 = n2;
        int n5 = string2.length();
        char c = '\u0000';
        if (n4 < n5) {
            if (this.getScheme() == null || string2.charAt(n4) == '/') {
                for (n3 = n2; n3 < n5; ++n3) {
                    c = string2.charAt(n3);
                    if (c == '%') {
                        if (n3 + 2 >= n5 || !URI.isHex(string2.charAt(n3 + 1)) || !URI.isHex(string2.charAt(n3 + 2))) {
                            throw new MalformedURIException("Path contains invalid escape sequence!");
                        }
                        n3 += 2;
                        continue;
                    }
                    if (URI.isPathCharacter(c)) continue;
                    if (c != '?' && c != '#') {
                        throw new MalformedURIException("Path contains invalid character: " + c);
                    }
                    break;
                }
            } else {
                while (n3 < n5 && (c = (char)string2.charAt(n3)) != '?' && c != '#') {
                    if (c == '%') {
                        if (n3 + 2 >= n5 || !URI.isHex(string2.charAt(n3 + 1)) || !URI.isHex(string2.charAt(n3 + 2))) {
                            throw new MalformedURIException("Opaque part contains invalid escape sequence!");
                        }
                        n3 += 2;
                    } else if (!URI.isURICharacter(c)) {
                        throw new MalformedURIException("Opaque part contains invalid character: " + c);
                    }
                    ++n3;
                }
            }
        }
        this.m_path = string2.substring(n4, n3);
        if (c == '?') {
            n4 = ++n3;
            while (n3 < n5 && (c = string2.charAt(n3)) != '#') {
                if (c == '%') {
                    if (n3 + 2 >= n5 || !URI.isHex(string2.charAt(n3 + 1)) || !URI.isHex(string2.charAt(n3 + 2))) {
                        throw new MalformedURIException("Query string contains invalid escape sequence!");
                    }
                    n3 += 2;
                } else if (!URI.isURICharacter(c)) {
                    throw new MalformedURIException("Query string contains invalid character: " + c);
                }
                ++n3;
            }
            this.m_queryString = string2.substring(n4, n3);
        }
        if (c == '#') {
            n4 = ++n3;
            while (n3 < n5) {
                c = string2.charAt(n3);
                if (c == '%') {
                    if (n3 + 2 >= n5 || !URI.isHex(string2.charAt(n3 + 1)) || !URI.isHex(string2.charAt(n3 + 2))) {
                        throw new MalformedURIException("Fragment contains invalid escape sequence!");
                    }
                    n3 += 2;
                } else if (!URI.isURICharacter(c)) {
                    throw new MalformedURIException("Fragment contains invalid character: " + c);
                }
                ++n3;
            }
            this.m_fragment = string2.substring(n4, n3);
        }
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_host != null || this.m_regAuthority != null) {
            stringBuffer.append("//");
            if (this.m_host != null) {
                if (this.m_userinfo != null) {
                    stringBuffer.append(this.m_userinfo);
                    stringBuffer.append('@');
                }
                stringBuffer.append(this.m_host);
                if (this.m_port != -1) {
                    stringBuffer.append(':');
                    stringBuffer.append(this.m_port);
                }
            } else {
                stringBuffer.append(this.m_regAuthority);
            }
        }
        if (this.m_path != null) {
            stringBuffer.append(this.m_path);
        }
        if (this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getRegBasedAuthority() {
        return this.m_regAuthority;
    }

    public String getAuthority() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_host != null || this.m_regAuthority != null) {
            stringBuffer.append("//");
            if (this.m_host != null) {
                if (this.m_userinfo != null) {
                    stringBuffer.append(this.m_userinfo);
                    stringBuffer.append('@');
                }
                stringBuffer.append(this.m_host);
                if (this.m_port != -1) {
                    stringBuffer.append(':');
                    stringBuffer.append(this.m_port);
                }
            } else {
                stringBuffer.append(this.m_regAuthority);
            }
        }
        return stringBuffer.toString();
    }

    public String getPath(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(this.m_path);
        if (bl && this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (bl2 && this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getPath() {
        return this.m_path;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setScheme(String string2) throws MalformedURIException {
        if (string2 == null) {
            throw new MalformedURIException("Cannot set scheme from null string!");
        }
        if (!URI.isConformantSchemeName(string2)) {
            throw new MalformedURIException("The scheme is not conformant.");
        }
        this.m_scheme = string2.toLowerCase(Locale.ENGLISH);
    }

    public void setUserinfo(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_userinfo = null;
            return;
        }
        if (this.m_host == null) {
            throw new MalformedURIException("Userinfo cannot be set when host is null!");
        }
        int n2 = string2.length();
        char c = '\u0000';
        for (int i = 0; i < n2; ++i) {
            c = string2.charAt(i);
            if (c == '%') {
                if (i + 2 < n2 && URI.isHex(string2.charAt(i + 1)) && URI.isHex(string2.charAt(i + 2))) continue;
                throw new MalformedURIException("Userinfo contains invalid escape sequence!");
            }
            if (URI.isUserinfoCharacter(c)) continue;
            throw new MalformedURIException("Userinfo contains invalid character:" + c);
        }
        this.m_userinfo = string2;
    }

    public void setHost(String string2) throws MalformedURIException {
        if (string2 == null || string2.length() == 0) {
            if (string2 != null) {
                this.m_regAuthority = null;
            }
            this.m_host = string2;
            this.m_userinfo = null;
            this.m_port = -1;
            return;
        }
        if (!URI.isWellFormedAddress(string2)) {
            throw new MalformedURIException("Host is not a well formed address!");
        }
        this.m_host = string2;
        this.m_regAuthority = null;
    }

    public void setPort(int n2) throws MalformedURIException {
        if (n2 >= 0 && n2 <= 65535) {
            if (this.m_host == null) {
                throw new MalformedURIException("Port cannot be set when host is null!");
            }
        } else if (n2 != -1) {
            throw new MalformedURIException("Invalid port number!");
        }
        this.m_port = n2;
    }

    public void setRegBasedAuthority(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_regAuthority = null;
            return;
        }
        if (string2.length() < 1 || !this.isValidRegistryBasedAuthority(string2) || string2.indexOf(47) != -1) {
            throw new MalformedURIException("Registry based authority is not well formed.");
        }
        this.m_regAuthority = string2;
        this.m_host = null;
        this.m_userinfo = null;
        this.m_port = -1;
    }

    public void setPath(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(string2, 0);
        }
    }

    public void appendPath(String string2) throws MalformedURIException {
        if (string2 == null || string2.trim().length() == 0) {
            return;
        }
        if (!URI.isURIString(string2)) {
            throw new MalformedURIException("Path contains invalid character!");
        }
        this.m_path = this.m_path == null || this.m_path.trim().length() == 0 ? (string2.startsWith("/") ? string2 : "/" + string2) : (this.m_path.endsWith("/") ? (string2.startsWith("/") ? this.m_path.concat(string2.substring(1)) : this.m_path.concat(string2)) : (string2.startsWith("/") ? this.m_path.concat(string2) : this.m_path.concat("/" + string2)));
    }

    public void setQueryString(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Query string can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Query string cannot be set when path is null!");
            }
            if (!URI.isURIString(string2)) {
                throw new MalformedURIException("Query string contains invalid character!");
            }
            this.m_queryString = string2;
        }
    }

    public void setFragment(String string2) throws MalformedURIException {
        if (string2 == null) {
            this.m_fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Fragment can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Fragment cannot be set when path is null!");
            }
            if (!URI.isURIString(string2)) {
                throw new MalformedURIException("Fragment contains invalid character!");
            }
            this.m_fragment = string2;
        }
    }

    public boolean equals(Object object2) {
        if (object2 instanceof URI) {
            URI uRI = (URI)object2;
            if ((this.m_scheme == null && uRI.m_scheme == null || this.m_scheme != null && uRI.m_scheme != null && this.m_scheme.equals(uRI.m_scheme)) && (this.m_userinfo == null && uRI.m_userinfo == null || this.m_userinfo != null && uRI.m_userinfo != null && this.m_userinfo.equals(uRI.m_userinfo)) && (this.m_host == null && uRI.m_host == null || this.m_host != null && uRI.m_host != null && this.m_host.equals(uRI.m_host)) && this.m_port == uRI.m_port && (this.m_path == null && uRI.m_path == null || this.m_path != null && uRI.m_path != null && this.m_path.equals(uRI.m_path)) && (this.m_queryString == null && uRI.m_queryString == null || this.m_queryString != null && uRI.m_queryString != null && this.m_queryString.equals(uRI.m_queryString)) && (this.m_fragment == null && uRI.m_fragment == null || this.m_fragment != null && uRI.m_fragment != null && this.m_fragment.equals(uRI.m_fragment))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_scheme != null) {
            stringBuffer.append(this.m_scheme);
            stringBuffer.append(':');
        }
        stringBuffer.append(this.getSchemeSpecificPart());
        return stringBuffer.toString();
    }

    public boolean isGenericURI() {
        return this.m_host != null;
    }

    public boolean isAbsoluteURI() {
        return this.m_scheme != null;
    }

    public static boolean isConformantSchemeName(String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return false;
        }
        if (!URI.isAlpha(string2.charAt(0))) {
            return false;
        }
        int n2 = string2.length();
        for (int i = 1; i < n2; ++i) {
            char c = string2.charAt(i);
            if (URI.isSchemeCharacter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedAddress(String string2) {
        if (string2 == null) {
            return false;
        }
        int n2 = string2.length();
        if (n2 == 0) {
            return false;
        }
        if (string2.startsWith("[")) {
            return URI.isWellFormedIPv6Reference(string2);
        }
        if (string2.startsWith(".") || string2.startsWith("-") || string2.endsWith("-")) {
            return false;
        }
        int n3 = string2.lastIndexOf(46);
        if (string2.endsWith(".")) {
            n3 = string2.substring(0, n3).lastIndexOf(46);
        }
        if (n3 + 1 < n2 && URI.isDigit(string2.charAt(n3 + 1))) {
            return URI.isWellFormedIPv4Address(string2);
        }
        if (n2 > 255) {
            return false;
        }
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == '.') {
                if (!URI.isAlphanum(string2.charAt(i - 1))) {
                    return false;
                }
                if (i + 1 < n2 && !URI.isAlphanum(string2.charAt(i + 1))) {
                    return false;
                }
                n4 = 0;
                continue;
            }
            if (!URI.isAlphanum(c) && c != '-') {
                return false;
            }
            if (++n4 <= 63) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedIPv4Address(String string2) {
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == '.') {
                if (i > 0 && !URI.isDigit(string2.charAt(i - 1)) || i + 1 < n2 && !URI.isDigit(string2.charAt(i + 1))) {
                    return false;
                }
                n4 = 0;
                if (++n3 <= 3) continue;
                return false;
            }
            if (!URI.isDigit(c)) {
                return false;
            }
            if (++n4 > 3) {
                return false;
            }
            if (n4 != 3) continue;
            char c2 = string2.charAt(i - 2);
            char c3 = string2.charAt(i - 1);
            if (c2 < '2' || c2 == '2' && (c3 < '5' || c3 == '5' && c <= '5')) continue;
            return false;
        }
        return n3 == 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWellFormedIPv6Reference(String string2) {
        int n2 = string2.length();
        int n3 = 1;
        int n4 = n2 - 1;
        if (n2 <= 2) return false;
        if (string2.charAt(0) != '[') return false;
        if (string2.charAt(n4) != ']') {
            return false;
        }
        int[] nArray = new int[1];
        if ((n3 = URI.scanHexSequence(string2, n3, n4, nArray)) == -1) {
            return false;
        }
        if (n3 == n4) {
            if (nArray[0] != 8) return false;
            return true;
        }
        if (n3 + 1 >= n4) return false;
        if (string2.charAt(n3) != ':') return false;
        if (string2.charAt(n3 + 1) == ':') {
            nArray[0] = nArray[0] + 1;
            if (nArray[0] > 8) {
                return false;
            }
            if ((n3 += 2) == n4) {
                return true;
            }
        } else {
            if (nArray[0] != 6) return false;
            if (!URI.isWellFormedIPv4Address(string2.substring(n3 + 1, n4))) return false;
            return true;
        }
        int n5 = nArray[0];
        if ((n3 = URI.scanHexSequence(string2, n3, n4, nArray)) == n4) return true;
        if (n3 == -1) return false;
        if (!URI.isWellFormedIPv4Address(string2.substring(nArray[0] > n5 ? n3 + 1 : n3, n4))) return false;
        return true;
    }

    private static int scanHexSequence(String string2, int n2, int n3, int[] nArray) {
        int n4 = 0;
        int n5 = n2;
        while (n2 < n3) {
            char c = string2.charAt(n2);
            if (c == ':') {
                if (n4 > 0 && (nArray[0] = nArray[0] + 1) > 8) {
                    return -1;
                }
                if (n4 == 0 || n2 + 1 < n3 && string2.charAt(n2 + 1) == ':') {
                    return n2;
                }
                n4 = 0;
            } else {
                if (!URI.isHex(c)) {
                    if (c == '.' && n4 < 4 && n4 > 0 && nArray[0] <= 6) {
                        int n6 = n2 - n4 - 1;
                        return n6 >= n5 ? n6 : n6 + 1;
                    }
                    return -1;
                }
                if (++n4 > 4) {
                    return -1;
                }
            }
            ++n2;
        }
        return n4 > 0 && (nArray[0] = nArray[0] + 1) <= 8 ? n3 : -1;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHex(char c) {
        return c <= 'f' && (fgLookupTable[c] & 0x40) != 0;
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphanum(char c) {
        return c <= 'z' && (fgLookupTable[c] & 0x30) != 0;
    }

    private static boolean isReservedCharacter(char c) {
        return c <= ']' && (fgLookupTable[c] & 1) != 0;
    }

    private static boolean isUnreservedCharacter(char c) {
        return c <= '~' && (fgLookupTable[c] & 0x32) != 0;
    }

    private static boolean isURICharacter(char c) {
        return c <= '~' && (fgLookupTable[c] & 0x33) != 0;
    }

    private static boolean isSchemeCharacter(char c) {
        return c <= 'z' && (fgLookupTable[c] & 0x34) != 0;
    }

    private static boolean isUserinfoCharacter(char c) {
        return c <= 'z' && (fgLookupTable[c] & 0x3A) != 0;
    }

    private static boolean isPathCharacter(char c) {
        return c <= '~' && (fgLookupTable[c] & 0xB2) != 0;
    }

    private static boolean isURIString(String string2) {
        if (string2 == null) {
            return false;
        }
        int n2 = string2.length();
        char c = '\u0000';
        for (int i = 0; i < n2; ++i) {
            c = string2.charAt(i);
            if (c == '%') {
                if (i + 2 >= n2 || !URI.isHex(string2.charAt(i + 1)) || !URI.isHex(string2.charAt(i + 2))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (URI.isURICharacter(c)) continue;
            return false;
        }
        return true;
    }

    static {
        int n2 = 48;
        while (n2 <= 57) {
            int n3 = n2++;
            fgLookupTable[n3] = (byte)(fgLookupTable[n3] | 0x60);
        }
        for (n2 = 65; n2 <= 70; ++n2) {
            int n4 = n2;
            fgLookupTable[n4] = (byte)(fgLookupTable[n4] | 0x50);
            int n5 = n2 + 32;
            fgLookupTable[n5] = (byte)(fgLookupTable[n5] | 0x50);
        }
        for (n2 = 71; n2 <= 90; ++n2) {
            int n6 = n2;
            fgLookupTable[n6] = (byte)(fgLookupTable[n6] | 0x10);
            int n7 = n2 + 32;
            fgLookupTable[n7] = (byte)(fgLookupTable[n7] | 0x10);
        }
        fgLookupTable[59] = (byte)(fgLookupTable[59] | 1);
        fgLookupTable[47] = (byte)(fgLookupTable[47] | 1);
        fgLookupTable[63] = (byte)(fgLookupTable[63] | 1);
        fgLookupTable[58] = (byte)(fgLookupTable[58] | 1);
        fgLookupTable[64] = (byte)(fgLookupTable[64] | 1);
        fgLookupTable[38] = (byte)(fgLookupTable[38] | 1);
        fgLookupTable[61] = (byte)(fgLookupTable[61] | 1);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 1);
        fgLookupTable[36] = (byte)(fgLookupTable[36] | 1);
        fgLookupTable[44] = (byte)(fgLookupTable[44] | 1);
        fgLookupTable[91] = (byte)(fgLookupTable[91] | 1);
        fgLookupTable[93] = (byte)(fgLookupTable[93] | 1);
        fgLookupTable[45] = (byte)(fgLookupTable[45] | 2);
        fgLookupTable[95] = (byte)(fgLookupTable[95] | 2);
        fgLookupTable[46] = (byte)(fgLookupTable[46] | 2);
        fgLookupTable[33] = (byte)(fgLookupTable[33] | 2);
        fgLookupTable[126] = (byte)(fgLookupTable[126] | 2);
        fgLookupTable[42] = (byte)(fgLookupTable[42] | 2);
        fgLookupTable[39] = (byte)(fgLookupTable[39] | 2);
        fgLookupTable[40] = (byte)(fgLookupTable[40] | 2);
        fgLookupTable[41] = (byte)(fgLookupTable[41] | 2);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 4);
        fgLookupTable[45] = (byte)(fgLookupTable[45] | 4);
        fgLookupTable[46] = (byte)(fgLookupTable[46] | 4);
        fgLookupTable[59] = (byte)(fgLookupTable[59] | 8);
        fgLookupTable[58] = (byte)(fgLookupTable[58] | 8);
        fgLookupTable[38] = (byte)(fgLookupTable[38] | 8);
        fgLookupTable[61] = (byte)(fgLookupTable[61] | 8);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 8);
        fgLookupTable[36] = (byte)(fgLookupTable[36] | 8);
        fgLookupTable[44] = (byte)(fgLookupTable[44] | 8);
        fgLookupTable[59] = (byte)(fgLookupTable[59] | 0x80);
        fgLookupTable[47] = (byte)(fgLookupTable[47] | 0x80);
        fgLookupTable[58] = (byte)(fgLookupTable[58] | 0x80);
        fgLookupTable[64] = (byte)(fgLookupTable[64] | 0x80);
        fgLookupTable[38] = (byte)(fgLookupTable[38] | 0x80);
        fgLookupTable[61] = (byte)(fgLookupTable[61] | 0x80);
        fgLookupTable[43] = (byte)(fgLookupTable[43] | 0x80);
        fgLookupTable[36] = (byte)(fgLookupTable[36] | 0x80);
        fgLookupTable[44] = (byte)(fgLookupTable[44] | 0x80);
        DEBUG = false;
    }

    public static class MalformedURIException
    extends IOException {
        static final long serialVersionUID = -6695054834342951930L;

        public MalformedURIException() {
        }

        public MalformedURIException(String string2) {
            super(string2);
        }
    }
}

