/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.util;

import com.ibm.xml.xml4j.internal.s1.util.SymbolTable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class SoftReferenceSymbolTable
extends SymbolTable {
    protected SREntry[] fBuckets = null;
    private final ReferenceQueue fReferenceQueue;

    public SoftReferenceSymbolTable(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n2);
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load: " + f2);
        }
        if (n2 == 0) {
            n2 = 1;
        }
        this.fLoadFactor = f2;
        this.fTableSize = n2;
        this.fBuckets = new SREntry[this.fTableSize];
        this.fThreshold = (int)((float)this.fTableSize * f2);
        this.fCount = 0;
        this.fReferenceQueue = new ReferenceQueue();
    }

    public SoftReferenceSymbolTable(int n2) {
        this(n2, 0.75f);
    }

    public SoftReferenceSymbolTable() {
        this(101, 0.75f);
    }

    @Override
    public String addSymbol(String string2) {
        this.clean();
        int n2 = this.hash(string2) % this.fTableSize;
        SREntry sREntry = this.fBuckets[n2];
        while (sREntry != null) {
            SREntryData sREntryData = (SREntryData)sREntry.get();
            if (sREntryData != null && sREntryData.symbol.equals(string2)) {
                return sREntryData.symbol;
            }
            sREntry = sREntry.next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n2 = this.hash(string2) % this.fTableSize;
        }
        string2 = string2.intern();
        this.fBuckets[n2] = sREntry = new SREntry(string2, this.fBuckets[n2], n2, this.fReferenceQueue);
        ++this.fCount;
        return string2;
    }

    @Override
    public String addSymbol(char[] cArray, int n2, int n3) {
        Object object2;
        this.clean();
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        Object object3 = this.fBuckets[n4];
        while (object3 != null) {
            block5: {
                object2 = (SREntryData)((SoftReference)object3).get();
                if (object2 != null && n3 == ((SREntryData)object2).characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (cArray[n2 + i] == ((SREntryData)object2).characters[i]) {
                            continue;
                        }
                        break block5;
                    }
                    return ((SREntryData)object2).symbol;
                }
            }
            object3 = ((SREntry)object3).next;
        }
        if (this.fCount >= this.fThreshold) {
            this.rehash();
            n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        }
        object3 = new String(cArray, n2, n3).intern();
        this.fBuckets[n4] = object2 = new SREntry((String)object3, cArray, n2, n3, this.fBuckets[n4], n4, this.fReferenceQueue);
        ++this.fCount;
        return object3;
    }

    @Override
    protected void rehash() {
        int n2 = this.fBuckets.length;
        SREntry[] sREntryArray = this.fBuckets;
        int n3 = n2 * 2 + 1;
        SREntry[] sREntryArray2 = new SREntry[n3];
        this.fThreshold = (int)((float)n3 * this.fLoadFactor);
        this.fBuckets = sREntryArray2;
        this.fTableSize = this.fBuckets.length;
        int n4 = n2;
        while (n4-- > 0) {
            SREntry sREntry = sREntryArray[n4];
            while (sREntry != null) {
                SREntry sREntry2 = sREntry;
                sREntry = sREntry.next;
                SREntryData sREntryData = (SREntryData)sREntry2.get();
                if (sREntryData != null) {
                    int n5 = this.hash(sREntryData.characters, 0, sREntryData.characters.length) % n3;
                    if (sREntryArray2[n5] != null) {
                        sREntryArray2[n5].prev = sREntry2;
                    }
                    sREntry2.next = sREntryArray2[n5];
                    sREntryArray2[n5] = sREntry2;
                    continue;
                }
                --this.fCount;
            }
        }
    }

    @Override
    public boolean containsSymbol(String string2) {
        int n2 = this.hash(string2) % this.fTableSize;
        int n3 = string2.length();
        SREntry sREntry = this.fBuckets[n2];
        while (sREntry != null) {
            block4: {
                SREntryData sREntryData = (SREntryData)sREntry.get();
                if (sREntryData != null && n3 == sREntryData.characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (string2.charAt(i) == sREntryData.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            sREntry = sREntry.next;
        }
        return false;
    }

    @Override
    public boolean containsSymbol(char[] cArray, int n2, int n3) {
        int n4 = this.hash(cArray, n2, n3) % this.fTableSize;
        SREntry sREntry = this.fBuckets[n4];
        while (sREntry != null) {
            block4: {
                SREntryData sREntryData = (SREntryData)sREntry.get();
                if (sREntryData != null && n3 == sREntryData.characters.length) {
                    for (int i = 0; i < n3; ++i) {
                        if (cArray[n2 + i] == sREntryData.characters[i]) {
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            sREntry = sREntry.next;
        }
        return false;
    }

    private void removeEntry(SREntry sREntry) {
        if (sREntry.next != null) {
            sREntry.next.prev = sREntry.prev;
        }
        if (sREntry.prev != null) {
            sREntry.prev.next = sREntry.next;
        } else {
            this.fBuckets[sREntry.bucket] = sREntry.next;
        }
        --this.fCount;
    }

    private void clean() {
        SREntry sREntry = (SREntry)this.fReferenceQueue.poll();
        while (sREntry != null) {
            this.removeEntry(sREntry);
            sREntry = (SREntry)this.fReferenceQueue.poll();
        }
    }

    protected static final class SREntryData {
        public final String symbol;
        public final char[] characters;

        public SREntryData(String string2) {
            this.symbol = string2;
            this.characters = new char[this.symbol.length()];
            this.symbol.getChars(0, this.characters.length, this.characters, 0);
        }

        public SREntryData(String string2, char[] cArray, int n2, int n3) {
            this.symbol = string2;
            this.characters = new char[n3];
            System.arraycopy(cArray, n2, this.characters, 0, n3);
        }
    }

    protected static final class SREntry
    extends SoftReference {
        public SREntry next;
        public SREntry prev;
        public int bucket;

        public SREntry(String string2, SREntry sREntry, int n2, ReferenceQueue referenceQueue) {
            super(new SREntryData(string2), referenceQueue);
            this.initialize(sREntry, n2);
        }

        public SREntry(String string2, char[] cArray, int n2, int n3, SREntry sREntry, int n4, ReferenceQueue referenceQueue) {
            super(new SREntryData(string2, cArray, n2, n3), referenceQueue);
            this.initialize(sREntry, n4);
        }

        private void initialize(SREntry sREntry, int n2) {
            this.next = sREntry;
            if (sREntry != null) {
                sREntry.prev = this;
            }
            this.prev = null;
            this.bucket = n2;
        }
    }
}

