/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.serialize;

import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.serialize.BaseMarkupSerializer;
import com.ibm.xml.xml4j.internal.s1.serialize.ElementState;
import com.ibm.xml.xml4j.internal.s1.serialize.OutputFormat;
import com.ibm.xml.xml4j.internal.s1.util.NamespaceSupport;
import com.ibm.xml.xml4j.internal.s1.util.SymbolTable;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import com.ibm.xml.xml4j.internal.s1.util.XMLSymbols;
import com.ibm.xml.xml4j.internal.s1.xni.NamespaceContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    protected boolean fNamespacePrefixes = true;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean bl) {
        this.fNamespaces = bl;
        if (this.fNSBinder == null) {
            this.fNSBinder = new NamespaceSupport();
            this.fLocalNSBinder = new NamespaceSupport();
            this.fSymbolTable = new SymbolTable();
        }
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        try {
            String string5;
            Object object2;
            String string6;
            Object object3;
            if (this._printer == null) {
                String string7 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string7);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string3 == null || string3.length() == 0 ? string4 : string3);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            attributes2 = this.extractNamespaces(attributes2);
            if (string4 == null || string4.length() == 0) {
                if (string3 == null) {
                    String string8 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(string8);
                }
                string4 = string2 != null && !string2.equals("") ? ((object3 = this.getPrefix(string2)) != null && ((String)object3).length() > 0 ? (String)object3 + ":" + string3 : string3) : string3;
            }
            this._printer.printText('<');
            this._printer.printText(string4);
            this._printer.indent();
            if (attributes2 != null) {
                for (int i = 0; i < attributes2.getLength(); ++i) {
                    this._printer.printSpace();
                    string6 = attributes2.getQName(i);
                    if (string6 != null && string6.length() == 0) {
                        string6 = attributes2.getLocalName(i);
                        object2 = attributes2.getURI(i);
                        if (!(object2 == null || ((String)object2).length() == 0 || string2 != null && string2.length() != 0 && ((String)object2).equals(string2) || (object3 = this.getPrefix((String)object2)) == null || ((String)object3).length() <= 0)) {
                            string6 = (String)object3 + ":" + string6;
                        }
                    }
                    if ((string5 = attributes2.getValue(i)) == null) {
                        string5 = "";
                    }
                    this._printer.printText(string6);
                    this._printer.printText("=\"");
                    this.printEscaped(string5);
                    this._printer.printText('\"');
                    if (!string6.equals("xml:space")) continue;
                    bl = string5.equals("preserve") ? true : this._format.getPreserveSpace();
                }
            }
            if (this._prefixes != null) {
                object3 = this._prefixes.entrySet().iterator();
                while (object3.hasNext()) {
                    this._printer.printSpace();
                    object2 = (Map.Entry)object3.next();
                    string5 = (String)object2.getKey();
                    string6 = (String)object2.getValue();
                    if (string6.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string5);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string6);
                    this._printer.printText("=\"");
                    this.printEscaped(string5);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string2, string3, string4, bl);
            string6 = string3 == null || string3.length() == 0 ? string4 : string2 + "^" + string3;
            elementState.doCData = this._format.isCDataElement(string6);
            elementState.unescaped = this._format.isNonEscapingElement(string6);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.endElementIO(string2, string3, string4);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string2, String string3, String string4) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    @Override
    public void startElement(String string2, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                String string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(string3);
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string2);
            this._printer.indent();
            if (attributeList != null) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    this._printer.printSpace();
                    String string4 = attributeList.getName(i);
                    String string5 = attributeList.getValue(i);
                    if (string5 != null) {
                        this._printer.printText(string4);
                        this._printer.printText("=\"");
                        this.printEscaped(string5);
                        this._printer.printText('\"');
                    }
                    if (!string4.equals("xml:space")) continue;
                    bl = string5.equals("preserve") ? true : this._format.getPreserveSpace();
                }
            }
            elementState = this.enterElementState(null, null, string2, bl);
            elementState.doCData = this._format.isCDataElement(string2);
            elementState.unescaped = this._format.isNonEscapingElement(string2);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string2) throws SAXException {
        this.endElement(null, null, string2);
    }

    protected void startDocument(String string2) throws IOException {
        String string3 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                String string4 = this._format.getEncoding();
                if (string4 != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(string4);
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string2);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            for (int i = 0; i < 18 + string2.length(); ++i) {
                                this._printer.printText(" ");
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string3 != null && string3.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string3, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string3 != null && string3.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string2);
                    this._printer.printText(" [");
                    this.printText(string3, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    @Override
    protected void serializeElement(Element element2) throws IOException {
        String string2;
        String string3;
        Attr attr2;
        int n2;
        if (this.fNamespaces) {
            this.fLocalNSBinder.reset();
            this.fNSBinder.pushContext();
        }
        String string4 = element2.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string4);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (elementState.inCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
        }
        this.fPreserveSpace = elementState.preserveSpace;
        int n3 = 0;
        NamedNodeMap namedNodeMap = null;
        if (element2.hasAttributes()) {
            namedNodeMap = element2.getAttributes();
            n3 = namedNodeMap.getLength();
        }
        if (!this.fNamespaces) {
            this._printer.printText('<');
            this._printer.printText(string4);
            this._printer.indent();
            for (n2 = 0; n2 < n3; ++n2) {
                attr2 = (Attr)namedNodeMap.item(n2);
                string3 = attr2.getName();
                string2 = attr2.getValue();
                if (string2 == null) {
                    string2 = "";
                }
                this.printAttribute(string3, string2, attr2.getSpecified(), attr2);
            }
        } else {
            String string5;
            boolean bl;
            String string6;
            String string7;
            for (n2 = 0; n2 < n3; ++n2) {
                attr2 = (Attr)namedNodeMap.item(n2);
                string7 = attr2.getNamespaceURI();
                if (string7 == null || !string7.equals(NamespaceContext.XMLNS_URI)) continue;
                string2 = attr2.getNodeValue();
                if (string2 == null) {
                    string2 = XMLSymbols.EMPTY_STRING;
                }
                if (string2.equals(NamespaceContext.XMLNS_URI)) {
                    if (this.fDOMErrorHandler == null) continue;
                    string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CantBindXMLNS", null);
                    this.modifyDOMError(string6, (short)2, null, attr2);
                    bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                    if (bl) continue;
                    throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                }
                string5 = attr2.getPrefix();
                string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                string6 = this.fSymbolTable.addSymbol(attr2.getLocalName());
                if (string5 == XMLSymbols.PREFIX_XMLNS) {
                    if ((string2 = this.fSymbolTable.addSymbol(string2)).length() == 0) continue;
                    this.fNSBinder.declarePrefix(string6, string2);
                    continue;
                }
                string2 = this.fSymbolTable.addSymbol(string2);
                this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, string2);
            }
            string7 = element2.getNamespaceURI();
            string5 = element2.getPrefix();
            if (string7 != null && string5 != null && string7.length() == 0 && string5.length() != 0) {
                string5 = null;
                this._printer.printText('<');
                this._printer.printText(element2.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(string4);
                this._printer.indent();
            }
            if (string7 != null) {
                string7 = this.fSymbolTable.addSymbol(string7);
                String string8 = string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                if (this.fNSBinder.getURI(string5) != string7) {
                    if (this.fNamespacePrefixes) {
                        this.printNamespaceAttr(string5, string7);
                    }
                    this.fLocalNSBinder.declarePrefix(string5, string7);
                    this.fNSBinder.declarePrefix(string5, string7);
                }
            } else if (element2.getLocalName() == null) {
                if (this.fDOMErrorHandler != null) {
                    string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{element2.getNodeName()});
                    this.modifyDOMError(string6, (short)2, null, element2);
                    bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                    if (!bl) {
                        throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                    }
                }
            } else {
                string7 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                if (string7 != null && string7.length() > 0) {
                    if (this.fNamespacePrefixes) {
                        this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    }
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                attr2 = (Attr)namedNodeMap.item(n2);
                string2 = attr2.getValue();
                string3 = attr2.getNodeName();
                string7 = attr2.getNamespaceURI();
                if (string7 != null && string7.length() == 0) {
                    string7 = null;
                    string3 = attr2.getLocalName();
                }
                if (string2 == null) {
                    string2 = XMLSymbols.EMPTY_STRING;
                }
                if (string7 != null) {
                    string5 = attr2.getPrefix();
                    string5 = string5 == null ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                    string6 = this.fSymbolTable.addSymbol(attr2.getLocalName());
                    if (string7 != null && string7.equals(NamespaceContext.XMLNS_URI)) {
                        String string9;
                        string5 = attr2.getPrefix();
                        string5 = string5 == null || string5.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string5);
                        string6 = this.fSymbolTable.addSymbol(attr2.getLocalName());
                        if (string5 == XMLSymbols.PREFIX_XMLNS) {
                            string9 = this.fLocalNSBinder.getURI(string6);
                            if ((string2 = this.fSymbolTable.addSymbol(string2)).length() == 0 || string9 != null) continue;
                            if (this.fNamespacePrefixes) {
                                this.printNamespaceAttr(string6, string2);
                            }
                            this.fLocalNSBinder.declarePrefix(string6, string2);
                            continue;
                        }
                        string7 = this.fNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                        string9 = this.fLocalNSBinder.getURI(XMLSymbols.EMPTY_STRING);
                        string2 = this.fSymbolTable.addSymbol(string2);
                        if (string9 != null || !this.fNamespacePrefixes) continue;
                        this.printNamespaceAttr(XMLSymbols.EMPTY_STRING, string2);
                        continue;
                    }
                    string7 = this.fSymbolTable.addSymbol(string7);
                    String string10 = this.fNSBinder.getURI(string5);
                    if (string5 == XMLSymbols.EMPTY_STRING || string10 != string7) {
                        string3 = attr2.getNodeName();
                        String string11 = this.fNSBinder.getPrefix(string7);
                        if (string11 != null && string11 != XMLSymbols.EMPTY_STRING) {
                            string5 = string11;
                            string3 = string5 + ":" + string6;
                        } else {
                            if (string5 == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(string5) != null) {
                                int n4 = 1;
                                string5 = this.fSymbolTable.addSymbol(PREFIX + n4++);
                                while (this.fLocalNSBinder.getURI(string5) != null) {
                                    string5 = this.fSymbolTable.addSymbol(PREFIX + n4++);
                                }
                                string3 = string5 + ":" + string6;
                            }
                            if (this.fNamespacePrefixes) {
                                this.printNamespaceAttr(string5, string7);
                            }
                            string2 = this.fSymbolTable.addSymbol(string2);
                            this.fLocalNSBinder.declarePrefix(string5, string2);
                            this.fNSBinder.declarePrefix(string5, string7);
                        }
                    }
                    this.printAttribute(string3, string2 == null ? XMLSymbols.EMPTY_STRING : string2, attr2.getSpecified(), attr2);
                    continue;
                }
                if (attr2.getLocalName() == null) {
                    if (this.fDOMErrorHandler != null) {
                        string6 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr2.getNodeName()});
                        this.modifyDOMError(string6, (short)2, null, attr2);
                        boolean bl2 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!bl2) {
                            throw new RuntimeException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SerializationStopped", null));
                        }
                    }
                    this.printAttribute(string3, string2, attr2.getSpecified(), attr2);
                    continue;
                }
                this.printAttribute(string3, string2, attr2.getSpecified(), attr2);
            }
        }
        if (element2.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string4, this.fPreserveSpace);
            elementState.doCData = this._format.isCDataElement(string4);
            elementState.unescaped = this._format.isNonEscapingElement(string4);
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                this.serializeNode(node2);
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, string4);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            elementState.afterElement = true;
            elementState.afterComment = false;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string2, String string3) throws IOException {
        this._printer.printSpace();
        if (string2 == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            this._printer.printText("xmlns:" + string2);
        }
        this._printer.printText("=\"");
        this.printEscaped(string3);
        this._printer.printText('\"');
    }

    private void printAttribute(String string2, String string3, boolean bl, Attr attr2) throws IOException {
        if (bl || (this.features & 0x40) == 0) {
            if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 2) != 0) {
                short s = this.fDOMFilter.acceptNode(attr2);
                switch (s) {
                    case 2: 
                    case 3: {
                        return;
                    }
                }
            }
            this._printer.printSpace();
            this._printer.printText(string2);
            this._printer.printText("=\"");
            this.printEscaped(string3);
            this._printer.printText('\"');
        }
        if (string2.equals("xml:space")) {
            this.fPreserveSpace = string3.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    @Override
    protected String getEntityRef(int n2) {
        switch (n2) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes2) throws SAXException {
        if (attributes2 == null) {
            return null;
        }
        int n2 = attributes2.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes2);
        for (int i = n2 - 1; i >= 0; --i) {
            String string2 = attributesImpl.getQName(i);
            if (!string2.startsWith("xmlns")) continue;
            if (string2.length() == 5) {
                this.startPrefixMapping("", attributes2.getValue(i));
                attributesImpl.removeAttribute(i);
                continue;
            }
            if (string2.charAt(5) != ':') continue;
            this.startPrefixMapping(string2.substring(6), attributes2.getValue(i));
            attributesImpl.removeAttribute(i);
        }
        return attributesImpl;
    }

    @Override
    protected void printEscaped(String string2) throws IOException {
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (!XMLChar.isValid(c)) {
                if (++i < n2) {
                    this.surrogates(c, string2.charAt(i), false);
                    continue;
                }
                this.fatalError("The character '" + (char)c + "' is an invalid XML character");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t') {
                this.printHex(c);
                continue;
            }
            if (c == '<') {
                this._printer.printText("&lt;");
                continue;
            }
            if (c == '&') {
                this._printer.printText("&amp;");
                continue;
            }
            if (c == '\"') {
                this._printer.printText("&quot;");
                continue;
            }
            if (c >= ' ' && this._encodingInfo.isPrintable(c)) {
                this._printer.printText(c);
                continue;
            }
            this.printHex(c);
        }
    }

    protected void printXMLChar(int n2) throws IOException {
        if (n2 == 13) {
            this.printHex(n2);
        } else if (n2 == 60) {
            this._printer.printText("&lt;");
        } else if (n2 == 38) {
            this._printer.printText("&amp;");
        } else if (n2 == 62) {
            this._printer.printText("&gt;");
        } else if (n2 == 10 || n2 == 9 || n2 >= 32 && this._encodingInfo.isPrintable((char)n2)) {
            this._printer.printText((char)n2);
        } else {
            this.printHex(n2);
        }
    }

    @Override
    protected void printText(String string2, boolean bl, boolean bl2) throws IOException {
        int n2 = string2.length();
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (!XMLChar.isValid(c)) {
                    if (++i < n2) {
                        this.surrogates(c, string2.charAt(i), true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (!XMLChar.isValid(c)) {
                    if (++i < n2) {
                        this.surrogates(c, string2.charAt(i), true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        }
    }

    @Override
    protected void printText(char[] cArray, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            while (n3-- > 0) {
                char c;
                if (!XMLChar.isValid(c = cArray[n2++])) {
                    if (n3-- > 0) {
                        this.surrogates(c, cArray[n2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        } else {
            while (n3-- > 0) {
                char c;
                if (!XMLChar.isValid(c = cArray[n2++])) {
                    if (n3-- > 0) {
                        this.surrogates(c, cArray[n2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        }
    }

    @Override
    protected void checkUnboundNamespacePrefixedNode(Node node2) throws IOException {
        if (this.fNamespaces) {
            Node node3 = node2.getFirstChild();
            while (node3 != null) {
                Node node4 = node3.getNextSibling();
                String string2 = node3.getPrefix();
                String string3 = string2 = string2 == null || string2.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string2);
                if (this.fNSBinder.getURI(string2) == null && string2 != null) {
                    this.fatalError("The replacement text of the entity node '" + node2.getNodeName() + "' contains an element node '" + node3.getNodeName() + "' with an undeclared prefix '" + string2 + "'.");
                }
                if (node3.getNodeType() == 1) {
                    NamedNodeMap namedNodeMap = node3.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        String string4 = namedNodeMap.item(i).getPrefix();
                        String string5 = string4 = string4 == null || string4.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(string4);
                        if (this.fNSBinder.getURI(string4) != null || string4 == null) continue;
                        this.fatalError("The replacement text of the entity node '" + node2.getNodeName() + "' contains an element node '" + node3.getNodeName() + "' with an attribute '" + namedNodeMap.item(i).getNodeName() + "' an undeclared prefix '" + string4 + "'.");
                    }
                }
                if (node3.hasChildNodes()) {
                    this.checkUnboundNamespacePrefixedNode(node3);
                }
                node3 = node4;
            }
        }
    }

    @Override
    public boolean reset() {
        super.reset();
        if (this.fNSBinder != null) {
            this.fNSBinder.reset();
            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        }
        return true;
    }
}

