/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.serialize;

import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.serialize.ElementState;
import com.ibm.xml.xml4j.internal.s1.serialize.OutputFormat;
import com.ibm.xml.xml4j.internal.s1.serialize.XMLSerializer;
import com.ibm.xml.xml4j.internal.s1.util.NamespaceSupport;
import com.ibm.xml.xml4j.internal.s1.util.SymbolTable;
import com.ibm.xml.xml4j.internal.s1.util.XML11Char;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.xml.sax.SAXException;

public class XML11Serializer
extends XMLSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;

    public XML11Serializer() {
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputFormat outputFormat) {
        super(outputFormat);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(Writer writer, OutputFormat outputFormat) {
        super(writer, outputFormat);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputStream, outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setVersion("1.1");
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            ElementState elementState = this.content();
            if (elementState.inCData || elementState.doCData) {
                if (!elementState.inCData) {
                    this._printer.printText("<![CDATA[");
                    elementState.inCData = true;
                }
                int n4 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                int n5 = n2 + n3;
                for (int i = n2; i < n5; ++i) {
                    char c = cArray[i];
                    if (c == ']' && i + 2 < n5 && cArray[i + 1] == ']' && cArray[i + 2] == '>') {
                        this._printer.printText("]]]]><![CDATA[>");
                        i += 2;
                        continue;
                    }
                    if (!XML11Char.isXML11Valid(c)) {
                        if (++i < n5) {
                            this.surrogates(c, cArray[i], true);
                            continue;
                        }
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                        continue;
                    }
                    if (this._encodingInfo.isPrintable(c) && XML11Char.isXML11ValidLiteral(c)) {
                        this._printer.printText(c);
                        continue;
                    }
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(c));
                    this._printer.printText(";<![CDATA[");
                }
                this._printer.setNextIndent(n4);
            } else if (elementState.preserveSpace) {
                int n6 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(cArray, n2, n3, true, elementState.unescaped);
                this._printer.setNextIndent(n6);
            } else {
                this.printText(cArray, n2, n3, false, elementState.unescaped);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    protected void printEscaped(String string2) throws IOException {
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (!XML11Char.isXML11Valid(c)) {
                if (++i < n2) {
                    this.surrogates(c, string2.charAt(i), false);
                    continue;
                }
                this.fatalError("The character '" + (char)c + "' is an invalid XML character");
                continue;
            }
            if (c == '\n' || c == '\r' || c == '\t' || c == '\u0085' || c == '\u2028') {
                this.printHex(c);
                continue;
            }
            if (c == '<') {
                this._printer.printText("&lt;");
                continue;
            }
            if (c == '&') {
                this._printer.printText("&amp;");
                continue;
            }
            if (c == '\"') {
                this._printer.printText("&quot;");
                continue;
            }
            if (c >= ' ' && this._encodingInfo.isPrintable(c)) {
                this._printer.printText(c);
                continue;
            }
            this.printHex(c);
        }
    }

    @Override
    protected final void printCDATAText(String string2) throws IOException {
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == ']' && i + 2 < n2 && string2.charAt(i + 1) == ']' && string2.charAt(i + 2) == '>') {
                if (this.fDOMErrorHandler != null) {
                    String string3;
                    if ((this.features & 0x10) == 0 && (this.features & 2) == 0) {
                        string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null);
                        this.modifyDOMError(string3, (short)3, null, this.fCurrentNode);
                        boolean bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!bl) {
                            throw new IOException();
                        }
                    } else {
                        string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null);
                        this.modifyDOMError(string3, (short)1, null, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                i += 2;
                continue;
            }
            if (!XML11Char.isXML11Valid(c)) {
                if (++i < n2) {
                    this.surrogates(c, string2.charAt(i), true);
                    continue;
                }
                this.fatalError("The character '" + c + "' is an invalid XML character");
                continue;
            }
            if (this._encodingInfo.isPrintable(c) && XML11Char.isXML11ValidLiteral(c)) {
                this._printer.printText(c);
                continue;
            }
            this._printer.printText("]]>&#x");
            this._printer.printText(Integer.toHexString(c));
            this._printer.printText(";<![CDATA[");
        }
    }

    @Override
    protected final void printXMLChar(int n2) throws IOException {
        if (n2 == 13 || n2 == 133 || n2 == 8232) {
            this.printHex(n2);
        } else if (n2 == 60) {
            this._printer.printText("&lt;");
        } else if (n2 == 38) {
            this._printer.printText("&amp;");
        } else if (n2 == 62) {
            this._printer.printText("&gt;");
        } else if (this._encodingInfo.isPrintable((char)n2) && XML11Char.isXML11ValidLiteral(n2)) {
            this._printer.printText((char)n2);
        } else {
            this.printHex(n2);
        }
    }

    @Override
    protected final void surrogates(int n2, int n3, boolean bl) throws IOException {
        if (XMLChar.isHighSurrogate(n2)) {
            if (!XMLChar.isLowSurrogate(n3)) {
                this.fatalError("The character '" + (char)n3 + "' is an invalid XML character");
            } else {
                int n4 = XMLChar.supplemental((char)n2, (char)n3);
                if (!XML11Char.isXML11Valid(n4)) {
                    this.fatalError("The character '" + (char)n4 + "' is an invalid XML character");
                } else if (bl && this.content().inCData) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(n4));
                    this._printer.printText(";<![CDATA[");
                } else {
                    this.printHex(n4);
                }
            }
        } else {
            this.fatalError("The character '" + (char)n2 + "' is an invalid XML character");
        }
    }

    @Override
    protected void printText(String string2, boolean bl, boolean bl2) throws IOException {
        int n2 = string2.length();
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (!XML11Char.isXML11Valid(c)) {
                    if (++i < n2) {
                        this.surrogates(c, string2.charAt(i), true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (!XML11Char.isXML11Valid(c)) {
                    if (++i < n2) {
                        this.surrogates(c, string2.charAt(i), true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        }
    }

    @Override
    protected void printText(char[] cArray, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            while (n3-- > 0) {
                char c;
                if (!XML11Char.isXML11Valid(c = cArray[n2++])) {
                    if (n3-- > 0) {
                        this.surrogates(c, cArray[n2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        } else {
            while (n3-- > 0) {
                char c;
                if (!XML11Char.isXML11Valid(c = cArray[n2++])) {
                    if (n3-- > 0) {
                        this.surrogates(c, cArray[n2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + c + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c)) {
                    this._printer.printText(c);
                    continue;
                }
                this.printXMLChar(c);
            }
        }
    }

    @Override
    public boolean reset() {
        super.reset();
        return true;
    }
}

