/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.serialize;

import com.ibm.xml.xml4j.internal.s1.serialize.ObjectFactory;
import com.ibm.xml.xml4j.internal.s1.serialize.OutputFormat;
import com.ibm.xml.xml4j.internal.s1.serialize.SecuritySupport;
import com.ibm.xml.xml4j.internal.s1.serialize.Serializer;
import com.ibm.xml.xml4j.internal.s1.serialize.SerializerFactoryImpl;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class SerializerFactory {
    public static final String FactoriesProperty = "com.ibm.xml.xml4j.internal.s1.serialize.factories";
    private static Hashtable _factories = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSerializerFactory(SerializerFactory serializerFactory) {
        Hashtable hashtable = _factories;
        synchronized (hashtable) {
            String string2 = serializerFactory.getSupportedMethod();
            _factories.put(string2, serializerFactory);
        }
    }

    public static SerializerFactory getSerializerFactory(String string2) {
        return (SerializerFactory)_factories.get(string2);
    }

    protected abstract String getSupportedMethod();

    public abstract Serializer makeSerializer(OutputFormat var1);

    public abstract Serializer makeSerializer(Writer var1, OutputFormat var2);

    public abstract Serializer makeSerializer(OutputStream var1, OutputFormat var2) throws UnsupportedEncodingException;

    static {
        SerializerFactory serializerFactory = new SerializerFactoryImpl("xml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("html");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("xhtml");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        serializerFactory = new SerializerFactoryImpl("text");
        SerializerFactory.registerSerializerFactory(serializerFactory);
        String string2 = SecuritySupport.getSystemProperty(FactoriesProperty);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ;,:");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    serializerFactory = (SerializerFactory)ObjectFactory.newInstance(string3, SerializerFactory.class.getClassLoader(), true);
                    if (!_factories.containsKey(serializerFactory.getSupportedMethod())) continue;
                    _factories.put(serializerFactory.getSupportedMethod(), serializerFactory);
                }
                catch (Exception exception) {}
            }
        }
    }
}

