/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.serialize;

import com.ibm.xml.xml4j.internal.s1.serialize.EncodingInfo;
import com.ibm.xml.xml4j.internal.s1.serialize.Encodings;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLDocument;

public class OutputFormat {
    private String _method;
    private String _version;
    private int _indent = 0;
    private String _encoding = "UTF-8";
    private EncodingInfo _encodingInfo = null;
    private boolean _allowJavaNames = false;
    private String _mediaType;
    private String _doctypeSystem;
    private String _doctypePublic;
    private boolean _omitXmlDeclaration = false;
    private boolean _omitDoctype = false;
    private boolean _omitComments = false;
    private boolean _standalone = false;
    private String[] _cdataElements;
    private String[] _nonEscapingElements;
    private String _lineSeparator = "\n";
    private int _lineWidth = 72;
    private boolean _preserve = false;
    private boolean _preserveEmptyAttributes = false;

    public OutputFormat() {
    }

    public OutputFormat(String string2, String string3, boolean bl) {
        this.setMethod(string2);
        this.setEncoding(string3);
        this.setIndenting(bl);
    }

    public OutputFormat(Document document2) {
        this.setMethod(OutputFormat.whichMethod(document2));
        this.setDoctype(OutputFormat.whichDoctypePublic(document2), OutputFormat.whichDoctypeSystem(document2));
        this.setMediaType(OutputFormat.whichMediaType(this.getMethod()));
    }

    public OutputFormat(Document document2, String string2, boolean bl) {
        this(document2);
        this.setEncoding(string2);
        this.setIndenting(bl);
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String string2) {
        this._method = string2;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string2) {
        this._version = string2;
    }

    public int getIndent() {
        return this._indent;
    }

    public boolean getIndenting() {
        return this._indent > 0;
    }

    public void setIndent(int n2) {
        this._indent = n2 < 0 ? 0 : n2;
    }

    public void setIndenting(boolean bl) {
        if (bl) {
            this._indent = 4;
            this._lineWidth = 72;
        } else {
            this._indent = 0;
            this._lineWidth = 0;
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String string2) {
        this._encoding = string2;
        this._encodingInfo = null;
    }

    public void setEncoding(EncodingInfo encodingInfo) {
        this._encoding = encodingInfo.getIANAName();
        this._encodingInfo = encodingInfo;
    }

    public EncodingInfo getEncodingInfo() throws UnsupportedEncodingException {
        if (this._encodingInfo == null) {
            this._encodingInfo = Encodings.getEncodingInfo(this._encoding, this._allowJavaNames);
        }
        return this._encodingInfo;
    }

    public void setAllowJavaNames(boolean bl) {
        this._allowJavaNames = bl;
    }

    public boolean setAllowJavaNames() {
        return this._allowJavaNames;
    }

    public String getMediaType() {
        return this._mediaType;
    }

    public void setMediaType(String string2) {
        this._mediaType = string2;
    }

    public void setDoctype(String string2, String string3) {
        this._doctypePublic = string2;
        this._doctypeSystem = string3;
    }

    public String getDoctypePublic() {
        return this._doctypePublic;
    }

    public String getDoctypeSystem() {
        return this._doctypeSystem;
    }

    public boolean getOmitComments() {
        return this._omitComments;
    }

    public void setOmitComments(boolean bl) {
        this._omitComments = bl;
    }

    public boolean getOmitDocumentType() {
        return this._omitDoctype;
    }

    public void setOmitDocumentType(boolean bl) {
        this._omitDoctype = bl;
    }

    public boolean getOmitXMLDeclaration() {
        return this._omitXmlDeclaration;
    }

    public void setOmitXMLDeclaration(boolean bl) {
        this._omitXmlDeclaration = bl;
    }

    public boolean getStandalone() {
        return this._standalone;
    }

    public void setStandalone(boolean bl) {
        this._standalone = bl;
    }

    public String[] getCDataElements() {
        return this._cdataElements;
    }

    public boolean isCDataElement(String string2) {
        if (this._cdataElements == null) {
            return false;
        }
        for (int i = 0; i < this._cdataElements.length; ++i) {
            if (!this._cdataElements[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void setCDataElements(String[] stringArray) {
        this._cdataElements = stringArray;
    }

    public String[] getNonEscapingElements() {
        return this._nonEscapingElements;
    }

    public boolean isNonEscapingElement(String string2) {
        if (this._nonEscapingElements == null) {
            return false;
        }
        for (int i = 0; i < this._nonEscapingElements.length; ++i) {
            if (!this._nonEscapingElements[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    public void setNonEscapingElements(String[] stringArray) {
        this._nonEscapingElements = stringArray;
    }

    public String getLineSeparator() {
        return this._lineSeparator;
    }

    public void setLineSeparator(String string2) {
        this._lineSeparator = string2 == null ? "\n" : string2;
    }

    public boolean getPreserveSpace() {
        return this._preserve;
    }

    public void setPreserveSpace(boolean bl) {
        this._preserve = bl;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void setLineWidth(int n2) {
        this._lineWidth = n2 <= 0 ? 0 : n2;
    }

    public boolean getPreserveEmptyAttributes() {
        return this._preserveEmptyAttributes;
    }

    public void setPreserveEmptyAttributes(boolean bl) {
        this._preserveEmptyAttributes = bl;
    }

    public char getLastPrintable() {
        if (this.getEncoding() != null && this.getEncoding().equalsIgnoreCase("ASCII")) {
            return '\u00ff';
        }
        return '\uffff';
    }

    public static String whichMethod(Document document2) {
        if (document2 instanceof HTMLDocument) {
            return "html";
        }
        for (Node node2 = document2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() == 1) {
                if (node2.getNodeName().equalsIgnoreCase("html")) {
                    return "html";
                }
                if (node2.getNodeName().equalsIgnoreCase("root")) {
                    return "fop";
                }
                return "xml";
            }
            if (node2.getNodeType() != 3) continue;
            String string2 = node2.getNodeValue();
            for (int i = 0; i < string2.length(); ++i) {
                if (string2.charAt(i) == ' ' || string2.charAt(i) == '\n' || string2.charAt(i) == '\t' || string2.charAt(i) == '\r') continue;
                return "xml";
            }
        }
        return "xml";
    }

    public static String whichDoctypePublic(Document document2) {
        DocumentType documentType = document2.getDoctype();
        if (documentType != null) {
            try {
                return documentType.getPublicId();
            }
            catch (Error error2) {
                // empty catch block
            }
        }
        if (document2 instanceof HTMLDocument) {
            return "-//W3C//DTD XHTML 1.0 Strict//EN";
        }
        return null;
    }

    public static String whichDoctypeSystem(Document document2) {
        DocumentType documentType = document2.getDoctype();
        if (documentType != null) {
            try {
                return documentType.getSystemId();
            }
            catch (Error error2) {
                // empty catch block
            }
        }
        if (document2 instanceof HTMLDocument) {
            return "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
        }
        return null;
    }

    public static String whichMediaType(String string2) {
        if (string2.equalsIgnoreCase("xml")) {
            return "text/xml";
        }
        if (string2.equalsIgnoreCase("html")) {
            return "text/html";
        }
        if (string2.equalsIgnoreCase("xhtml")) {
            return "text/html";
        }
        if (string2.equalsIgnoreCase("text")) {
            return "text/plain";
        }
        if (string2.equalsIgnoreCase("fop")) {
            return "application/pdf";
        }
        return null;
    }

    public static class Defaults {
        public static final int Indent = 4;
        public static final String Encoding = "UTF-8";
        public static final int LineWidth = 72;
    }

    public static class DTD {
        public static final String HTMLPublicId = "-//W3C//DTD HTML 4.01//EN";
        public static final String HTMLSystemId = "http://www.w3.org/TR/html4/strict.dtd";
        public static final String XHTMLPublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
        public static final String XHTMLSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
    }
}

