/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.serialize;

import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.serialize.BaseMarkupSerializer;
import com.ibm.xml.xml4j.internal.s1.serialize.ElementState;
import com.ibm.xml.xml4j.internal.s1.serialize.HTMLdtd;
import com.ibm.xml.xml4j.internal.s1.serialize.OutputFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HTMLSerializer
extends BaseMarkupSerializer {
    private boolean _xhtml;
    public static final String XHTMLNamespace = "http://www.w3.org/1999/xhtml";
    private String fUserXHTMLNamespace = null;

    protected HTMLSerializer(boolean bl, OutputFormat outputFormat) {
        super(outputFormat);
        this._xhtml = bl;
    }

    public HTMLSerializer() {
        this(false, new OutputFormat("html", "ISO-8859-1", false));
    }

    public HTMLSerializer(OutputFormat outputFormat) {
        this(false, outputFormat != null ? outputFormat : new OutputFormat("html", "ISO-8859-1", false));
    }

    public HTMLSerializer(Writer writer, OutputFormat outputFormat) {
        this(false, outputFormat != null ? outputFormat : new OutputFormat("html", "ISO-8859-1", false));
        this.setOutputCharStream(writer);
    }

    public HTMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        this(false, outputFormat != null ? outputFormat : new OutputFormat("html", "ISO-8859-1", false));
        this.setOutputByteStream(outputStream);
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("html", "ISO-8859-1", false));
    }

    public void setXHTMLNamespace(String string2) {
        this.fUserXHTMLNamespace = string2;
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes2) throws SAXException {
        boolean bl = false;
        try {
            String string5;
            String string6;
            Object object2;
            boolean bl2;
            if (this._printer == null) {
                throw new IllegalStateException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null));
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string3 == null || string3.length() == 0 ? string4 : string3);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                    this._printer.breakLine();
                }
            }
            boolean bl3 = elementState.preserveSpace;
            boolean bl4 = bl2 = string2 != null && string2.length() != 0;
            if (string4 == null || string4.length() == 0) {
                string4 = string3;
                if (bl2 && (object2 = this.getPrefix(string2)) != null && ((String)object2).length() != 0) {
                    string4 = (String)object2 + ":" + string3;
                }
                bl = true;
            }
            String string7 = !bl2 ? string4 : (string2.equals(XHTMLNamespace) || this.fUserXHTMLNamespace != null && this.fUserXHTMLNamespace.equals(string2) ? string3 : null);
            this._printer.printText('<');
            if (this._xhtml) {
                this._printer.printText(string4.toLowerCase(Locale.ENGLISH));
            } else {
                this._printer.printText(string4);
            }
            this._printer.indent();
            if (attributes2 != null) {
                for (int i = 0; i < attributes2.getLength(); ++i) {
                    this._printer.printSpace();
                    string6 = attributes2.getQName(i).toLowerCase(Locale.ENGLISH);
                    string5 = attributes2.getValue(i);
                    if (this._xhtml || bl2) {
                        if (string5 == null) {
                            this._printer.printText(string6);
                            this._printer.printText("=\"\"");
                            continue;
                        }
                        this._printer.printText(string6);
                        this._printer.printText("=\"");
                        this.printEscaped(string5);
                        this._printer.printText('\"');
                        continue;
                    }
                    if (string5 == null) {
                        string5 = "";
                    }
                    if (!this._format.getPreserveEmptyAttributes() && string5.length() == 0) {
                        this._printer.printText(string6);
                        continue;
                    }
                    if (HTMLdtd.isURI(string4, string6)) {
                        this._printer.printText(string6);
                        this._printer.printText("=\"");
                        this._printer.printText(this.escapeURI(string5));
                        this._printer.printText('\"');
                        continue;
                    }
                    if (HTMLdtd.isBoolean(string4, string6)) {
                        this._printer.printText(string6);
                        continue;
                    }
                    this._printer.printText(string6);
                    this._printer.printText("=\"");
                    this.printEscaped(string5);
                    this._printer.printText('\"');
                }
            }
            if (string7 != null && HTMLdtd.isPreserveSpace(string7)) {
                bl3 = true;
            }
            if (bl) {
                object2 = this._prefixes.entrySet().iterator();
                while (object2.hasNext()) {
                    this._printer.printSpace();
                    Map.Entry entry = (Map.Entry)object2.next();
                    string5 = (String)entry.getKey();
                    string6 = (String)entry.getValue();
                    if (string6.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string5);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string6);
                    this._printer.printText("=\"");
                    this.printEscaped(string5);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string2, string3, string4, bl3);
            if (string7 != null && (string7.equalsIgnoreCase("A") || string7.equalsIgnoreCase("TD"))) {
                elementState.empty = false;
                this._printer.printText('>');
            }
            if (string7 != null && (string4.equalsIgnoreCase("SCRIPT") || string4.equalsIgnoreCase("STYLE"))) {
                if (this._xhtml) {
                    elementState.doCData = true;
                } else {
                    elementState.unescaped = true;
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        try {
            this.endElementIO(string2, string3, string4);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string2, String string3, String string4) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        String string5 = elementState.namespaceURI == null || elementState.namespaceURI.length() == 0 ? elementState.rawName : (elementState.namespaceURI.equals(XHTMLNamespace) || this.fUserXHTMLNamespace != null && this.fUserXHTMLNamespace.equals(elementState.namespaceURI) ? elementState.localName : null);
        if (this._xhtml) {
            if (elementState.empty) {
                this._printer.printText(" />");
            } else {
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                this._printer.printText(elementState.rawName.toLowerCase(Locale.ENGLISH));
                this._printer.printText('>');
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (string5 == null || !HTMLdtd.isOnlyOpening(string5)) {
                if (this._indenting && !elementState.preserveSpace && elementState.afterElement) {
                    this._printer.breakLine();
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                }
                this._printer.printText("</");
                this._printer.printText(elementState.rawName);
                this._printer.printText('>');
            }
        }
        elementState = this.leaveElementState();
        if (string5 == null || !string5.equalsIgnoreCase("A") && !string5.equalsIgnoreCase("TD")) {
            elementState.afterElement = true;
        }
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            ElementState elementState = this.content();
            elementState.doCData = false;
            super.characters(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startElement(String string2, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                throw new IllegalStateException(DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null));
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            if (this._xhtml) {
                this._printer.printText(string2.toLowerCase(Locale.ENGLISH));
            } else {
                this._printer.printText(string2);
            }
            this._printer.indent();
            if (attributeList != null) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    this._printer.printSpace();
                    String string3 = attributeList.getName(i).toLowerCase(Locale.ENGLISH);
                    String string4 = attributeList.getValue(i);
                    if (this._xhtml) {
                        if (string4 == null) {
                            this._printer.printText(string3);
                            this._printer.printText("=\"\"");
                            continue;
                        }
                        this._printer.printText(string3);
                        this._printer.printText("=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                        continue;
                    }
                    if (string4 == null) {
                        string4 = "";
                    }
                    if (!this._format.getPreserveEmptyAttributes() && string4.length() == 0) {
                        this._printer.printText(string3);
                        continue;
                    }
                    if (HTMLdtd.isURI(string2, string3)) {
                        this._printer.printText(string3);
                        this._printer.printText("=\"");
                        this._printer.printText(this.escapeURI(string4));
                        this._printer.printText('\"');
                        continue;
                    }
                    if (HTMLdtd.isBoolean(string2, string3)) {
                        this._printer.printText(string3);
                        continue;
                    }
                    this._printer.printText(string3);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
            }
            if (HTMLdtd.isPreserveSpace(string2)) {
                bl = true;
            }
            elementState = this.enterElementState(null, null, string2, bl);
            if (string2.equalsIgnoreCase("A") || string2.equalsIgnoreCase("TD")) {
                elementState.empty = false;
                this._printer.printText('>');
            }
            if (string2.equalsIgnoreCase("SCRIPT") || string2.equalsIgnoreCase("STYLE")) {
                if (this._xhtml) {
                    elementState.doCData = true;
                } else {
                    elementState.unescaped = true;
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endElement(String string2) throws SAXException {
        this.endElement(null, null, string2);
    }

    protected void startDocument(String string2) throws IOException {
        this._printer.leaveDTD();
        if (!this._started) {
            if (this._docTypePublicId == null && this._docTypeSystemId == null) {
                if (this._xhtml) {
                    this._docTypePublicId = "-//W3C//DTD XHTML 1.0 Strict//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd";
                } else {
                    this._docTypePublicId = "-//W3C//DTD HTML 4.01//EN";
                    this._docTypeSystemId = "http://www.w3.org/TR/html4/strict.dtd";
                }
            }
            if (!this._format.getOmitDocumentType()) {
                if (!(this._docTypePublicId == null || this._xhtml && this._docTypeSystemId == null)) {
                    if (this._xhtml) {
                        this._printer.printText("<!DOCTYPE html PUBLIC ");
                    } else {
                        this._printer.printText("<!DOCTYPE HTML PUBLIC ");
                    }
                    this.printDoctypeURL(this._docTypePublicId);
                    if (this._docTypeSystemId != null) {
                        if (this._indenting) {
                            this._printer.breakLine();
                            this._printer.printText("                      ");
                        } else {
                            this._printer.printText(' ');
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    this._printer.printText('>');
                    this._printer.breakLine();
                } else if (this._docTypeSystemId != null) {
                    if (this._xhtml) {
                        this._printer.printText("<!DOCTYPE html SYSTEM ");
                    } else {
                        this._printer.printText("<!DOCTYPE HTML SYSTEM ");
                    }
                    this.printDoctypeURL(this._docTypeSystemId);
                    this._printer.printText('>');
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    @Override
    protected void serializeElement(Element element2) throws IOException {
        String string2 = element2.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(string2);
            }
        } else {
            if (elementState.empty) {
                this._printer.printText('>');
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this._printer.breakLine();
            }
        }
        boolean bl = elementState.preserveSpace;
        this._printer.printText('<');
        if (this._xhtml) {
            this._printer.printText(string2.toLowerCase(Locale.ENGLISH));
        } else {
            this._printer.printText(string2);
        }
        this._printer.indent();
        NamedNodeMap namedNodeMap = element2.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr2 = (Attr)namedNodeMap.item(i);
                String string3 = attr2.getName().toLowerCase(Locale.ENGLISH);
                String string4 = attr2.getValue();
                if (!attr2.getSpecified()) continue;
                this._printer.printSpace();
                if (this._xhtml) {
                    if (string4 == null) {
                        this._printer.printText(string3);
                        this._printer.printText("=\"\"");
                        continue;
                    }
                    this._printer.printText(string3);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    continue;
                }
                if (string4 == null) {
                    string4 = "";
                }
                if (!this._format.getPreserveEmptyAttributes() && string4.length() == 0) {
                    this._printer.printText(string3);
                    continue;
                }
                if (HTMLdtd.isURI(string2, string3)) {
                    this._printer.printText(string3);
                    this._printer.printText("=\"");
                    this._printer.printText(this.escapeURI(string4));
                    this._printer.printText('\"');
                    continue;
                }
                if (HTMLdtd.isBoolean(string2, string3)) {
                    this._printer.printText(string3);
                    continue;
                }
                this._printer.printText(string3);
                this._printer.printText("=\"");
                this.printEscaped(string4);
                this._printer.printText('\"');
            }
        }
        if (HTMLdtd.isPreserveSpace(string2)) {
            bl = true;
        }
        if (element2.hasChildNodes() || !HTMLdtd.isEmptyTag(string2)) {
            elementState = this.enterElementState(null, null, string2, bl);
            if (string2.equalsIgnoreCase("A") || string2.equalsIgnoreCase("TD")) {
                elementState.empty = false;
                this._printer.printText('>');
            }
            if (string2.equalsIgnoreCase("SCRIPT") || string2.equalsIgnoreCase("STYLE")) {
                if (this._xhtml) {
                    elementState.doCData = true;
                } else {
                    elementState.unescaped = true;
                }
            }
            for (Node node2 = element2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                this.serializeNode(node2);
            }
            this.endElementIO(null, null, string2);
        } else {
            this._printer.unindent();
            if (this._xhtml) {
                this._printer.printText(" />");
            } else {
                this._printer.printText('>');
            }
            elementState.afterElement = true;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    @Override
    protected void characters(String string2) throws IOException {
        this.content();
        super.characters(string2);
    }

    @Override
    protected String getEntityRef(int n2) {
        return HTMLdtd.fromChar(n2);
    }

    protected String escapeURI(String string2) {
        int n2 = string2.indexOf("\"");
        if (n2 >= 0) {
            return string2.substring(0, n2);
        }
        return string2;
    }
}

