/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.serialize;

import com.ibm.xml.xml4j.internal.s1.dom.DOMErrorImpl;
import com.ibm.xml.xml4j.internal.s1.dom.DOMLocatorImpl;
import com.ibm.xml.xml4j.internal.s1.dom.DOMMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.serialize.DOMSerializer;
import com.ibm.xml.xml4j.internal.s1.serialize.ElementState;
import com.ibm.xml.xml4j.internal.s1.serialize.EncodingInfo;
import com.ibm.xml.xml4j.internal.s1.serialize.IndentPrinter;
import com.ibm.xml.xml4j.internal.s1.serialize.OutputFormat;
import com.ibm.xml.xml4j.internal.s1.serialize.Printer;
import com.ibm.xml.xml4j.internal.s1.serialize.Serializer;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSSerializerFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public abstract class BaseMarkupSerializer
implements ContentHandler,
DocumentHandler,
LexicalHandler,
DTDHandler,
DeclHandler,
DOMSerializer,
Serializer {
    protected short features = (short)-1;
    protected DOMErrorHandler fDOMErrorHandler;
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    protected LSSerializerFilter fDOMFilter;
    protected EncodingInfo _encodingInfo;
    private ElementState[] _elementStates;
    private int _elementStateCount;
    private Vector _preRoot;
    protected boolean _started;
    private boolean _prepared;
    protected Hashtable _prefixes;
    protected String _docTypePublicId;
    protected String _docTypeSystemId;
    protected OutputFormat _format;
    protected Printer _printer;
    protected boolean _indenting;
    protected final StringBuffer fStrBuffer = new StringBuffer(40);
    private Writer _writer;
    private OutputStream _output;
    protected Node fCurrentNode = null;

    protected BaseMarkupSerializer(OutputFormat outputFormat) {
        this._elementStates = new ElementState[10];
        for (int i = 0; i < this._elementStates.length; ++i) {
            this._elementStates[i] = new ElementState();
        }
        this._format = outputFormat;
    }

    @Override
    public DocumentHandler asDocumentHandler() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public ContentHandler asContentHandler() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public DOMSerializer asDOMSerializer() throws IOException {
        this.prepare();
        return this;
    }

    @Override
    public void setOutputByteStream(OutputStream outputStream) {
        if (outputStream == null) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"output"});
            throw new NullPointerException(string2);
        }
        this._output = outputStream;
        this._writer = null;
        this.reset();
    }

    @Override
    public void setOutputCharStream(Writer writer) {
        if (writer == null) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"writer"});
            throw new NullPointerException(string2);
        }
        this._writer = writer;
        this._output = null;
        this.reset();
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ArgumentIsNull", new Object[]{"format"});
            throw new NullPointerException(string2);
        }
        this._format = outputFormat;
        this.reset();
    }

    public boolean reset() {
        if (this._elementStateCount > 1) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "ResetInMiddle", null);
            throw new IllegalStateException(string2);
        }
        this._prepared = false;
        this.fCurrentNode = null;
        this.fStrBuffer.setLength(0);
        return true;
    }

    protected void prepare() throws IOException {
        if (this._prepared) {
            return;
        }
        if (this._writer == null && this._output == null) {
            String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
            throw new IOException(string2);
        }
        this._encodingInfo = this._format.getEncodingInfo();
        if (this._output != null) {
            this._writer = this._encodingInfo.getWriter(this._output);
        }
        if (this._format.getIndenting()) {
            this._indenting = true;
            this._printer = new IndentPrinter(this._writer, this._format);
        } else {
            this._indenting = false;
            this._printer = new Printer(this._writer, this._format);
        }
        this._elementStateCount = 0;
        ElementState elementState = this._elementStates[0];
        elementState.namespaceURI = null;
        elementState.localName = null;
        elementState.rawName = null;
        elementState.preserveSpace = this._format.getPreserveSpace();
        elementState.empty = true;
        elementState.afterElement = false;
        elementState.afterComment = false;
        elementState.inCData = false;
        elementState.doCData = false;
        elementState.prefixes = null;
        this._docTypePublicId = this._format.getDoctypePublic();
        this._docTypeSystemId = this._format.getDoctypeSystem();
        this._started = false;
        this._prepared = true;
    }

    @Override
    public void serialize(Element element2) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(element2);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    @Override
    public void serialize(DocumentFragment documentFragment) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(documentFragment);
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    @Override
    public void serialize(Document document2) throws IOException {
        this.reset();
        this.prepare();
        this.serializeNode(document2);
        this.serializePreRoot();
        this._printer.flush();
        if (this._printer.getException() != null) {
            throw this._printer.getException();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.prepare();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.toString());
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            ElementState elementState = this.content();
            if (elementState.inCData || elementState.doCData) {
                if (!elementState.inCData) {
                    this._printer.printText("<![CDATA[");
                    elementState.inCData = true;
                }
                int n4 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                int n5 = n2 + n3;
                for (int i = n2; i < n5; ++i) {
                    char c = cArray[i];
                    if (c == ']' && i + 2 < n5 && cArray[i + 1] == ']' && cArray[i + 2] == '>') {
                        this._printer.printText("]]]]><![CDATA[>");
                        i += 2;
                        continue;
                    }
                    if (!XMLChar.isValid(c)) {
                        if (++i < n5) {
                            this.surrogates(c, cArray[i], true);
                            continue;
                        }
                        this.fatalError("The character '" + c + "' is an invalid XML character");
                        continue;
                    }
                    if (c >= ' ' && this._encodingInfo.isPrintable(c) && c != '\u007f' || c == '\n' || c == '\r' || c == '\t') {
                        this._printer.printText(c);
                        continue;
                    }
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(c));
                    this._printer.printText(";<![CDATA[");
                }
                this._printer.setNextIndent(n4);
            } else if (elementState.preserveSpace) {
                int n6 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(cArray, n2, n3, true, elementState.unescaped);
                this._printer.setNextIndent(n6);
            } else {
                this.printText(cArray, n2, n3, false, elementState.unescaped);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.content();
            if (this._indenting) {
                this._printer.setThisIndent(0);
                int n4 = n2;
                while (n3-- > 0) {
                    this._printer.printText(cArray[n4]);
                    ++n4;
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public final void processingInstruction(String string2, String string3) throws SAXException {
        try {
            this.processingInstructionIO(string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstructionIO(String string2, String string3) throws IOException {
        ElementState elementState = this.content();
        int n2 = string2.indexOf("?>");
        if (n2 >= 0) {
            this.fStrBuffer.append("<?").append(string2.substring(0, n2));
        } else {
            this.fStrBuffer.append("<?").append(string2);
        }
        if (string3 != null) {
            this.fStrBuffer.append(' ');
            n2 = string3.indexOf("?>");
            if (n2 >= 0) {
                this.fStrBuffer.append(string3.substring(0, n2));
            } else {
                this.fStrBuffer.append(string3);
            }
        }
        this.fStrBuffer.append("?>");
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                elementState.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        try {
            this.comment(new String(cArray, n2, n3));
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void comment(String string2) throws IOException {
        if (this._format.getOmitComments()) {
            return;
        }
        ElementState elementState = this.content();
        int n2 = string2.indexOf("-->");
        if (n2 >= 0) {
            this.fStrBuffer.append("<!--").append(string2.substring(0, n2)).append("-->");
        } else {
            this.fStrBuffer.append("<!--").append(string2).append("-->");
        }
        if (this.isDocumentState()) {
            if (this._preRoot == null) {
                this._preRoot = new Vector();
            }
            this._preRoot.addElement(this.fStrBuffer.toString());
        } else {
            if (this._indenting && !elementState.preserveSpace) {
                this._printer.breakLine();
            }
            this._printer.indent();
            this.printText(this.fStrBuffer.toString(), true, true);
            this._printer.unindent();
            if (this._indenting) {
                elementState.afterElement = true;
            }
        }
        this.fStrBuffer.setLength(0);
        elementState.afterComment = true;
        elementState.afterElement = false;
    }

    @Override
    public void startCDATA() {
        ElementState elementState = this.getElementState();
        elementState.doCData = true;
    }

    @Override
    public void endCDATA() {
        ElementState elementState = this.getElementState();
        elementState.doCData = false;
    }

    public void startNonEscaping() {
        ElementState elementState = this.getElementState();
        elementState.unescaped = true;
    }

    public void endNonEscaping() {
        ElementState elementState = this.getElementState();
        elementState.unescaped = false;
    }

    public void startPreserving() {
        ElementState elementState = this.getElementState();
        elementState.preserveSpace = true;
    }

    public void endPreserving() {
        ElementState elementState = this.getElementState();
        elementState.preserveSpace = false;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.serializePreRoot();
            this._printer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startEntity(String string2) {
    }

    @Override
    public void endEntity(String string2) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
        try {
            this.endCDATA();
            this.content();
            this._printer.printText('&');
            this._printer.printText(string2);
            this._printer.printText(';');
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
        if (this._prefixes == null) {
            this._prefixes = new Hashtable();
        }
        this._prefixes.put(string3, string2 == null ? "" : string2);
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
    }

    @Override
    public final void startDTD(String string2, String string3, String string4) throws SAXException {
        try {
            this._printer.enterDTD();
            this._docTypePublicId = string3;
            this._docTypeSystemId = string4;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void elementDecl(String string2, String string3) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ELEMENT ");
            this._printer.printText(string2);
            this._printer.printText(' ');
            this._printer.printText(string3);
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void attributeDecl(String string2, String string3, String string4, String string5, String string6) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ATTLIST ");
            this._printer.printText(string2);
            this._printer.printText(' ');
            this._printer.printText(string3);
            this._printer.printText(' ');
            this._printer.printText(string4);
            if (string5 != null) {
                this._printer.printText(' ');
                this._printer.printText(string5);
            }
            if (string6 != null) {
                this._printer.printText(" \"");
                this.printEscaped(string6);
                this._printer.printText('\"');
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void internalEntityDecl(String string2, String string3) throws SAXException {
        try {
            this._printer.enterDTD();
            this._printer.printText("<!ENTITY ");
            this._printer.printText(string2);
            this._printer.printText(" \"");
            this.printEscaped(string3);
            this._printer.printText("\">");
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void externalEntityDecl(String string2, String string3, String string4) throws SAXException {
        try {
            this._printer.enterDTD();
            this.unparsedEntityDecl(string2, string3, string4, null);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void unparsedEntityDecl(String string2, String string3, String string4, String string5) throws SAXException {
        try {
            this._printer.enterDTD();
            if (string3 == null) {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(string2);
                this._printer.printText(" SYSTEM ");
                this.printDoctypeURL(string4);
            } else {
                this._printer.printText("<!ENTITY ");
                this._printer.printText(string2);
                this._printer.printText(" PUBLIC ");
                this.printDoctypeURL(string3);
                this._printer.printText(' ');
                this.printDoctypeURL(string4);
            }
            if (string5 != null) {
                this._printer.printText(" NDATA ");
                this._printer.printText(string5);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    public void notationDecl(String string2, String string3, String string4) throws SAXException {
        try {
            this._printer.enterDTD();
            if (string3 != null) {
                this._printer.printText("<!NOTATION ");
                this._printer.printText(string2);
                this._printer.printText(" PUBLIC ");
                this.printDoctypeURL(string3);
                if (string4 != null) {
                    this._printer.printText(' ');
                    this.printDoctypeURL(string4);
                }
            } else {
                this._printer.printText("<!NOTATION ");
                this._printer.printText(string2);
                this._printer.printText(" SYSTEM ");
                this.printDoctypeURL(string4);
            }
            this._printer.printText('>');
            if (this._indenting) {
                this._printer.breakLine();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    protected void serializeNode(Node node2) throws IOException {
        this.fCurrentNode = node2;
        block3 : switch (node2.getNodeType()) {
            case 3: {
                String string2 = node2.getNodeValue();
                if (string2 == null) break;
                if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 4) != 0) {
                    short s = this.fDOMFilter.acceptNode(node2);
                    switch (s) {
                        case 2: 
                        case 3: {
                            break block3;
                        }
                    }
                    this.characters(string2);
                    break;
                }
                if (this._indenting && !this.getElementState().preserveSpace && string2.replace('\n', ' ').trim().length() == 0) break;
                this.characters(string2);
                break;
            }
            case 4: {
                String string3 = node2.getNodeValue();
                if ((this.features & 8) != 0) {
                    if (string3 == null) break;
                    if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 8) != 0) {
                        short s = this.fDOMFilter.acceptNode(node2);
                        switch (s) {
                            case 2: 
                            case 3: {
                                return;
                            }
                        }
                    }
                    this.startCDATA();
                    this.characters(string3);
                    this.endCDATA();
                    break;
                }
                this.characters(string3);
                break;
            }
            case 8: {
                String string4;
                if (this._format.getOmitComments() || (string4 = node2.getNodeValue()) == null) break;
                if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 0x80) != 0) {
                    short s = this.fDOMFilter.acceptNode(node2);
                    switch (s) {
                        case 2: 
                        case 3: {
                            return;
                        }
                    }
                }
                this.comment(string4);
                break;
            }
            case 5: {
                this.endCDATA();
                this.content();
                if ((this.features & 4) != 0 || node2.getFirstChild() == null) {
                    if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 0x10) != 0) {
                        short s = this.fDOMFilter.acceptNode(node2);
                        switch (s) {
                            case 2: {
                                return;
                            }
                            case 3: {
                                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                                    this.serializeNode(node3);
                                }
                                return;
                            }
                        }
                    }
                    this.checkUnboundNamespacePrefixedNode(node2);
                    this._printer.printText("&");
                    this._printer.printText(node2.getNodeName());
                    this._printer.printText(";");
                    break;
                }
                for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    this.serializeNode(node4);
                }
                break;
            }
            case 7: {
                if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 0x40) != 0) {
                    short s = this.fDOMFilter.acceptNode(node2);
                    switch (s) {
                        case 2: 
                        case 3: {
                            return;
                        }
                    }
                }
                this.processingInstructionIO(node2.getNodeName(), node2.getNodeValue());
                break;
            }
            case 1: {
                if (this.fDOMFilter != null && (this.fDOMFilter.getWhatToShow() & 1) != 0) {
                    short s = this.fDOMFilter.acceptNode(node2);
                    switch (s) {
                        case 2: {
                            return;
                        }
                        case 3: {
                            for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                                this.serializeNode(node5);
                            }
                            return;
                        }
                    }
                }
                this.serializeElement((Element)node2);
                break;
            }
            case 9: {
                Node node6 = ((Document)node2).getDoctype();
                if (node6 != null) {
                    try {
                        this._printer.enterDTD();
                        this._docTypePublicId = node6.getPublicId();
                        this._docTypeSystemId = node6.getSystemId();
                        String string5 = node6.getInternalSubset();
                        if (string5 != null && string5.length() > 0) {
                            this._printer.printText(string5);
                        }
                        this.endDTD();
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        Method method;
                        Class<?> clazz = node6.getClass();
                        String string6 = null;
                        String string7 = null;
                        try {
                            method = clazz.getMethod("getPublicId", null);
                            if (method.getReturnType().equals(String.class)) {
                                string6 = (String)method.invoke((Object)node6, (Object[])null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            method = clazz.getMethod("getSystemId", null);
                            if (method.getReturnType().equals(String.class)) {
                                string7 = (String)method.invoke((Object)node6, (Object[])null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this._printer.enterDTD();
                        this._docTypePublicId = string6;
                        this._docTypeSystemId = string7;
                        this.endDTD();
                    }
                }
            }
            case 11: {
                Node node6;
                for (node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                    this.serializeNode(node6);
                }
                break;
            }
        }
    }

    protected ElementState content() throws IOException {
        ElementState elementState = this.getElementState();
        if (!this.isDocumentState()) {
            if (elementState.inCData && !elementState.doCData) {
                this._printer.printText("]]>");
                elementState.inCData = false;
            }
            if (elementState.empty) {
                this._printer.printText('>');
                elementState.empty = false;
            }
            elementState.afterElement = false;
            elementState.afterComment = false;
        }
        return elementState;
    }

    protected void characters(String string2) throws IOException {
        ElementState elementState = this.content();
        if (elementState.inCData || elementState.doCData) {
            if (!elementState.inCData) {
                this._printer.printText("<![CDATA[");
                elementState.inCData = true;
            }
            int n2 = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printCDATAText(string2);
            this._printer.setNextIndent(n2);
        } else if (elementState.preserveSpace) {
            int n3 = this._printer.getNextIndent();
            this._printer.setNextIndent(0);
            this.printText(string2, true, elementState.unescaped);
            this._printer.setNextIndent(n3);
        } else {
            this.printText(string2, false, elementState.unescaped);
        }
    }

    protected abstract String getEntityRef(int var1);

    protected abstract void serializeElement(Element var1) throws IOException;

    protected void serializePreRoot() throws IOException {
        if (this._preRoot != null) {
            for (int i = 0; i < this._preRoot.size(); ++i) {
                this.printText((String)this._preRoot.elementAt(i), true, true);
                if (!this._indenting) continue;
                this._printer.breakLine();
            }
            this._preRoot.removeAllElements();
        }
    }

    protected void printCDATAText(String string2) throws IOException {
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c == ']' && i + 2 < n2 && string2.charAt(i + 1) == ']' && string2.charAt(i + 2) == '>') {
                if (this.fDOMErrorHandler != null) {
                    String string3;
                    if ((this.features & 0x10) == 0) {
                        string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null);
                        if ((this.features & 2) != 0) {
                            this.modifyDOMError(string3, (short)3, "wf-invalid-character", this.fCurrentNode);
                            this.fDOMErrorHandler.handleError(this.fDOMError);
                            throw new LSException(82, string3);
                        }
                        this.modifyDOMError(string3, (short)2, "cdata-section-not-splitted", this.fCurrentNode);
                        if (!this.fDOMErrorHandler.handleError(this.fDOMError)) {
                            throw new LSException(82, string3);
                        }
                    } else {
                        string3 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null);
                        this.modifyDOMError(string3, (short)1, null, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                i += 2;
                continue;
            }
            if (!XMLChar.isValid(c)) {
                if (++i < n2) {
                    this.surrogates(c, string2.charAt(i), true);
                    continue;
                }
                this.fatalError("The character '" + c + "' is an invalid XML character");
                continue;
            }
            if (c >= ' ' && this._encodingInfo.isPrintable(c) && c != '\u007f' || c == '\n' || c == '\r' || c == '\t') {
                this._printer.printText(c);
                continue;
            }
            this._printer.printText("]]>&#x");
            this._printer.printText(Integer.toHexString(c));
            this._printer.printText(";<![CDATA[");
        }
    }

    protected void surrogates(int n2, int n3, boolean bl) throws IOException {
        if (XMLChar.isHighSurrogate(n2)) {
            if (!XMLChar.isLowSurrogate(n3)) {
                this.fatalError("The character '" + (char)n3 + "' is an invalid XML character");
            } else {
                int n4 = XMLChar.supplemental((char)n2, (char)n3);
                if (!XMLChar.isValid(n4)) {
                    this.fatalError("The character '" + (char)n4 + "' is an invalid XML character");
                } else if (bl && this.content().inCData) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(n4));
                    this._printer.printText(";<![CDATA[");
                } else {
                    this.printHex(n4);
                }
            }
        } else {
            this.fatalError("The character '" + (char)n2 + "' is an invalid XML character");
        }
    }

    protected void printText(char[] cArray, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            while (n3-- > 0) {
                char c = cArray[n2];
                ++n2;
                if (c == '\n' || c == '\r' || bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printEscaped(c);
            }
        } else {
            while (n3-- > 0) {
                char c = cArray[n2];
                ++n2;
                if (c == ' ' || c == '\f' || c == '\t' || c == '\n' || c == '\r') {
                    this._printer.printSpace();
                    continue;
                }
                if (bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printEscaped(c);
            }
        }
    }

    protected void printText(String string2, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '\n' || c == '\r' || bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printEscaped(c);
            }
        } else {
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == ' ' || c == '\f' || c == '\t' || c == '\n' || c == '\r') {
                    this._printer.printSpace();
                    continue;
                }
                if (bl2) {
                    this._printer.printText(c);
                    continue;
                }
                this.printEscaped(c);
            }
        }
    }

    protected void printDoctypeURL(String string2) throws IOException {
        this._printer.printText('\"');
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '\"' || string2.charAt(i) < ' ' || string2.charAt(i) > '\u007f') {
                this._printer.printText('%');
                this._printer.printText(Integer.toHexString(string2.charAt(i)));
                continue;
            }
            this._printer.printText(string2.charAt(i));
        }
        this._printer.printText('\"');
    }

    protected void printEscaped(int n2) throws IOException {
        String string2 = this.getEntityRef(n2);
        if (string2 != null) {
            this._printer.printText('&');
            this._printer.printText(string2);
            this._printer.printText(';');
        } else if (n2 >= 32 && this._encodingInfo.isPrintable((char)n2) && n2 != 127 || n2 == 10 || n2 == 13 || n2 == 9) {
            if (n2 < 65536) {
                this._printer.printText((char)n2);
            } else {
                this._printer.printText((char)((n2 - 65536 >> 10) + 55296));
                this._printer.printText((char)((n2 - 65536 & 0x3FF) + 56320));
            }
        } else {
            this.printHex(n2);
        }
    }

    final void printHex(int n2) throws IOException {
        this._printer.printText("&#x");
        this._printer.printText(Integer.toHexString(n2));
        this._printer.printText(';');
    }

    protected void printEscaped(String string2) throws IOException {
        for (int i = 0; i < string2.length(); ++i) {
            char c;
            int n2 = string2.charAt(i);
            if ((n2 & 0xFC00) == 55296 && i + 1 < string2.length() && ((c = string2.charAt(i + 1)) & 0xFC00) == 56320) {
                n2 = 65536 + (n2 - 55296 << 10) + c - 56320;
                ++i;
            }
            this.printEscaped(n2);
        }
    }

    protected ElementState getElementState() {
        return this._elementStates[this._elementStateCount];
    }

    protected ElementState enterElementState(String string2, String string3, String string4, boolean bl) {
        if (this._elementStateCount + 1 == this._elementStates.length) {
            int n2;
            ElementState[] elementStateArray = new ElementState[this._elementStates.length + 10];
            for (n2 = 0; n2 < this._elementStates.length; ++n2) {
                elementStateArray[n2] = this._elementStates[n2];
            }
            for (n2 = this._elementStates.length; n2 < elementStateArray.length; ++n2) {
                elementStateArray[n2] = new ElementState();
            }
            this._elementStates = elementStateArray;
        }
        ++this._elementStateCount;
        ElementState elementState = this._elementStates[this._elementStateCount];
        elementState.namespaceURI = string2;
        elementState.localName = string3;
        elementState.rawName = string4;
        elementState.preserveSpace = bl;
        elementState.empty = true;
        elementState.afterElement = false;
        elementState.afterComment = false;
        elementState.inCData = false;
        elementState.doCData = false;
        elementState.unescaped = false;
        elementState.prefixes = this._prefixes;
        this._prefixes = null;
        return elementState;
    }

    protected ElementState leaveElementState() {
        if (this._elementStateCount > 0) {
            this._prefixes = null;
            --this._elementStateCount;
            return this._elementStates[this._elementStateCount];
        }
        String string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "Internal", null);
        throw new IllegalStateException(string2);
    }

    protected boolean isDocumentState() {
        return this._elementStateCount == 0;
    }

    final void clearDocumentState() {
        this._elementStateCount = 0;
    }

    protected String getPrefix(String string2) {
        String string3;
        if (this._prefixes != null && (string3 = (String)this._prefixes.get(string2)) != null) {
            return string3;
        }
        if (this._elementStateCount == 0) {
            return null;
        }
        for (int i = this._elementStateCount; i > 0; --i) {
            if (this._elementStates[i].prefixes == null || (string3 = (String)this._elementStates[i].prefixes.get(string2)) == null) continue;
            return string3;
        }
        return null;
    }

    protected DOMError modifyDOMError(String string2, short s, String string3, Node node2) {
        this.fDOMError.reset();
        this.fDOMError.fMessage = string2;
        this.fDOMError.fType = string3;
        this.fDOMError.fSeverity = s;
        this.fDOMError.fLocator = new DOMLocatorImpl(-1, -1, -1, node2, null);
        return this.fDOMError;
    }

    protected void fatalError(String string2) throws IOException {
        if (this.fDOMErrorHandler == null) {
            throw new IOException(string2);
        }
        this.modifyDOMError(string2, (short)3, null, this.fCurrentNode);
        this.fDOMErrorHandler.handleError(this.fDOMError);
    }

    protected void checkUnboundNamespacePrefixedNode(Node node2) throws IOException {
    }
}

