/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver.readers;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogEntry;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogException;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.CatalogReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

public class TextCatalogReader
implements CatalogReader {
    protected InputStream catfile = null;
    protected int[] stack = new int[3];
    protected Stack tokenStack = new Stack();
    protected int top = -1;
    protected boolean caseSensitive = false;

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void readCatalog(Catalog catalog, String string2) throws MalformedURLException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file:///" + string2);
        }
        URLConnection uRLConnection = uRL.openConnection();
        try {
            this.readCatalog(catalog, uRLConnection.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            catalog.getCatalogManager().debug.message(1, "Failed to load catalog, file not found", uRL.toString());
        }
    }

    @Override
    public void readCatalog(Catalog catalog, InputStream inputStream) throws MalformedURLException, IOException {
        this.catfile = inputStream;
        if (this.catfile == null) {
            return;
        }
        Vector<String> vector = null;
        while (true) {
            String string2;
            if ((string2 = this.nextToken()) == null) {
                if (vector != null) {
                    catalog.unknownEntry(vector);
                    vector = null;
                }
                this.catfile.close();
                this.catfile = null;
                return;
            }
            String string3 = null;
            string3 = this.caseSensitive ? string2 : string2.toUpperCase(Locale.ENGLISH);
            try {
                int n2 = CatalogEntry.getEntryType(string3);
                int n3 = CatalogEntry.getEntryArgCount(n2);
                Vector<String> vector2 = new Vector<String>();
                if (vector != null) {
                    catalog.unknownEntry(vector);
                    vector = null;
                }
                for (int i = 0; i < n3; ++i) {
                    vector2.addElement(this.nextToken());
                }
                catalog.addEntry(new CatalogEntry(string3, vector2));
                continue;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 3) {
                    if (vector == null) {
                        vector = new Vector<String>();
                    }
                    vector.addElement(string2);
                    continue;
                }
                if (catalogException.getExceptionType() != 2) continue;
                catalog.getCatalogManager().debug.message(1, "Invalid catalog entry", string2);
                vector = null;
                continue;
            }
            break;
        }
    }

    protected void finalize() {
        if (this.catfile != null) {
            try {
                this.catfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.catfile = null;
    }

    protected String nextToken() throws IOException {
        int n2;
        int n3;
        String string2 = "";
        if (!this.tokenStack.empty()) {
            return (String)this.tokenStack.pop();
        }
        block0: while (true) {
            n3 = this.catfile.read();
            while (n3 <= 32) {
                n3 = this.catfile.read();
                if (n3 >= 0) continue;
                return null;
            }
            n2 = this.catfile.read();
            if (n2 < 0) {
                return null;
            }
            if (n3 != 45 || n2 != 45) break;
            n3 = 32;
            n2 = this.nextChar();
            while (true) {
                if (n3 == 45 && n2 == 45) continue block0;
                n3 = n2;
                n2 = this.nextChar();
            }
            break;
        }
        this.stack[++this.top] = n2;
        this.stack[++this.top] = n3;
        n3 = this.nextChar();
        if (n3 == 34 || n3 == 39) {
            int n4 = n3;
            while ((n3 = this.nextChar()) != n4) {
                char[] cArray = new char[]{(char)n3};
                String string3 = new String(cArray);
                string2 = string2.concat(string3);
            }
            return string2;
        }
        while (n3 > 32) {
            n2 = this.nextChar();
            if (n3 == 45 && n2 == 45) {
                this.stack[++this.top] = n3;
                this.stack[++this.top] = n2;
                return string2;
            }
            char[] cArray = new char[]{(char)n3};
            String string4 = new String(cArray);
            string2 = string2.concat(string4);
            n3 = n2;
        }
        return string2;
    }

    protected int nextChar() throws IOException {
        if (this.top < 0) {
            return this.catfile.read();
        }
        return this.stack[this.top--];
    }
}

