/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogEntry;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogException;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.SAXCatalogReader;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.TR9401CatalogReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;

public class Resolver
extends Catalog {
    public static final int URISUFFIX = CatalogEntry.addEntryType("URISUFFIX", 2);
    public static final int SYSTEMSUFFIX = CatalogEntry.addEntryType("SYSTEMSUFFIX", 2);
    public static final int RESOLVER = CatalogEntry.addEntryType("RESOLVER", 1);
    public static final int SYSTEMREVERSE = CatalogEntry.addEntryType("SYSTEMREVERSE", 1);

    @Override
    public void setupReaders() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        SAXCatalogReader sAXCatalogReader = new SAXCatalogReader(sAXParserFactory);
        sAXCatalogReader.setCatalogParser(null, "XMLCatalog", "org.apache.xml.resolver.readers.XCatalogReader");
        sAXCatalogReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.ExtendedXMLCatalogReader");
        this.addReader("application/xml", sAXCatalogReader);
        TR9401CatalogReader tR9401CatalogReader = new TR9401CatalogReader();
        this.addReader("text/plain", tR9401CatalogReader);
    }

    @Override
    public void addEntry(CatalogEntry catalogEntry) {
        int n2 = catalogEntry.getEntryType();
        if (n2 == URISUFFIX) {
            String string2 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string3 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string3);
            this.catalogManager.debug.message(4, "URISUFFIX", string2, string3);
        } else if (n2 == SYSTEMSUFFIX) {
            String string4 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string5 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string5);
            this.catalogManager.debug.message(4, "SYSTEMSUFFIX", string4, string5);
        }
        super.addEntry(catalogEntry);
    }

    @Override
    public String resolveURI(String string2) throws MalformedURLException, IOException {
        String string3 = super.resolveURI(string2);
        if (string3 != null) {
            return string3;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == RESOLVER) {
                string3 = this.resolveExternalSystem(string2, catalogEntry.getEntryArg(0));
                if (string3 == null) continue;
                return string3;
            }
            if (catalogEntry.getEntryType() != URISUFFIX) continue;
            String string4 = catalogEntry.getEntryArg(0);
            String string5 = catalogEntry.getEntryArg(1);
            if (string4.length() > string2.length() || !string2.substring(string2.length() - string4.length()).equals(string4)) continue;
            return string5;
        }
        return this.resolveSubordinateCatalogs(Catalog.URI, null, null, string2);
    }

    @Override
    public String resolveSystem(String string2) throws MalformedURLException, IOException {
        String string3 = super.resolveSystem(string2);
        if (string3 != null) {
            return string3;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == RESOLVER) {
                string3 = this.resolveExternalSystem(string2, catalogEntry.getEntryArg(0));
                if (string3 == null) continue;
                return string3;
            }
            if (catalogEntry.getEntryType() != SYSTEMSUFFIX) continue;
            String string4 = catalogEntry.getEntryArg(0);
            String string5 = catalogEntry.getEntryArg(1);
            if (string4.length() > string2.length() || !string2.substring(string2.length() - string4.length()).equals(string4)) continue;
            return string5;
        }
        return this.resolveSubordinateCatalogs(Catalog.SYSTEM, null, null, string2);
    }

    @Override
    public String resolvePublic(String string2, String string3) throws MalformedURLException, IOException {
        String string4 = super.resolvePublic(string2, string3);
        if (string4 != null) {
            return string4;
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != RESOLVER) continue;
            if (string3 != null && (string4 = this.resolveExternalSystem(string3, catalogEntry.getEntryArg(0))) != null) {
                return string4;
            }
            string4 = this.resolveExternalPublic(string2, catalogEntry.getEntryArg(0));
            if (string4 == null) continue;
            return string4;
        }
        return this.resolveSubordinateCatalogs(Catalog.PUBLIC, null, string2, string3);
    }

    protected String resolveExternalSystem(String string2, String string3) throws MalformedURLException, IOException {
        Resolver resolver2 = this.queryResolver(string3, "i2l", string2, null);
        if (resolver2 != null) {
            return resolver2.resolveSystem(string2);
        }
        return null;
    }

    protected String resolveExternalPublic(String string2, String string3) throws MalformedURLException, IOException {
        Resolver resolver2 = this.queryResolver(string3, "fpi2l", string2, null);
        if (resolver2 != null) {
            return resolver2.resolvePublic(string2, null);
        }
        return null;
    }

    protected Resolver queryResolver(String string2, String string3, String string4, String string5) {
        Object var5_5 = null;
        String string6 = string2 + "?command=" + string3 + "&format=tr9401&uri=" + string4 + "&uri2=" + string5;
        Object var7_7 = null;
        try {
            URL uRL = new URL(string6);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            Resolver resolver2 = (Resolver)this.newCatalog();
            String string7 = uRLConnection.getContentType();
            if (string7.indexOf(";") > 0) {
                string7 = string7.substring(0, string7.indexOf(";"));
            }
            resolver2.parseCatalog(string7, uRLConnection.getInputStream());
            return resolver2;
        }
        catch (CatalogException catalogException) {
            if (catalogException.getExceptionType() == 6) {
                this.catalogManager.debug.message(1, "Unparseable catalog: " + string6);
            } else if (catalogException.getExceptionType() == 5) {
                this.catalogManager.debug.message(1, "Unknown catalog format: " + string6);
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            this.catalogManager.debug.message(1, "Malformed resolver URL: " + string6);
            return null;
        }
        catch (IOException iOException) {
            this.catalogManager.debug.message(1, "I/O Exception opening resolver: " + string6);
            return null;
        }
    }

    private Vector appendVector(Vector vector, Vector vector2) {
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(vector2.elementAt(i));
            }
        }
        return vector;
    }

    public Vector resolveAllSystemReverse(String string2) throws MalformedURLException, IOException {
        Vector vector;
        Vector vector2 = new Vector();
        if (string2 != null) {
            vector = this.resolveLocalSystemReverse(string2);
            vector2 = this.appendVector(vector2, vector);
        }
        vector = this.resolveAllSubordinateCatalogs(SYSTEMREVERSE, null, null, string2);
        return this.appendVector(vector2, vector);
    }

    public String resolveSystemReverse(String string2) throws MalformedURLException, IOException {
        Vector vector = this.resolveAllSystemReverse(string2);
        if (vector != null && vector.size() > 0) {
            return (String)vector.elementAt(0);
        }
        return null;
    }

    public Vector resolveAllSystem(String string2) throws MalformedURLException, IOException {
        Vector vector;
        Vector vector2 = new Vector();
        if (string2 != null) {
            vector = this.resolveAllLocalSystem(string2);
            vector2 = this.appendVector(vector2, vector);
        }
        if ((vector2 = this.appendVector(vector2, vector = this.resolveAllSubordinateCatalogs(SYSTEM, null, null, string2))).size() > 0) {
            return vector2;
        }
        return null;
    }

    private Vector resolveAllLocalSystem(String string2) {
        Vector<String> vector = new Vector<String>();
        String string3 = System.getProperty("os.name");
        boolean bl = string3.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != SYSTEM || !catalogEntry.getEntryArg(0).equals(string2) && (!bl || !catalogEntry.getEntryArg(0).equalsIgnoreCase(string2))) continue;
            vector.addElement(catalogEntry.getEntryArg(1));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private Vector resolveLocalSystemReverse(String string2) {
        Vector<String> vector = new Vector<String>();
        String string3 = System.getProperty("os.name");
        boolean bl = string3.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != SYSTEM || !catalogEntry.getEntryArg(1).equals(string2) && (!bl || !catalogEntry.getEntryArg(1).equalsIgnoreCase(string2))) continue;
            vector.addElement(catalogEntry.getEntryArg(0));
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    private synchronized Vector resolveAllSubordinateCatalogs(int n2, String string2, String string3, String string4) throws MalformedURLException, IOException {
        Vector vector = new Vector();
        for (int i = 0; i < this.catalogs.size(); ++i) {
            Object object2;
            Resolver resolver2 = null;
            try {
                resolver2 = (Resolver)this.catalogs.elementAt(i);
            }
            catch (ClassCastException classCastException) {
                object2 = (String)this.catalogs.elementAt(i);
                resolver2 = (Resolver)this.newCatalog();
                try {
                    resolver2.parseCatalog((String)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    this.catalogManager.debug.message(1, "Malformed Catalog URL", (String)object2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, file not found", (String)object2);
                }
                catch (IOException iOException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", (String)object2);
                }
                this.catalogs.setElementAt(resolver2, i);
            }
            String string5 = null;
            if (n2 == DOCTYPE) {
                string5 = resolver2.resolveDoctype(string2, string3, string4);
                if (string5 == null) continue;
                vector.addElement(string5);
                return vector;
            }
            if (n2 == DOCUMENT) {
                string5 = resolver2.resolveDocument();
                if (string5 == null) continue;
                vector.addElement(string5);
                return vector;
            }
            if (n2 == ENTITY) {
                string5 = resolver2.resolveEntity(string2, string3, string4);
                if (string5 == null) continue;
                vector.addElement(string5);
                return vector;
            }
            if (n2 == NOTATION) {
                string5 = resolver2.resolveNotation(string2, string3, string4);
                if (string5 == null) continue;
                vector.addElement(string5);
                return vector;
            }
            if (n2 == PUBLIC) {
                string5 = resolver2.resolvePublic(string3, string4);
                if (string5 == null) continue;
                vector.addElement(string5);
                return vector;
            }
            if (n2 == SYSTEM) {
                object2 = resolver2.resolveAllSystem(string4);
                vector = this.appendVector(vector, (Vector)object2);
                break;
            }
            if (n2 != SYSTEMREVERSE) continue;
            object2 = resolver2.resolveAllSystemReverse(string4);
            vector = this.appendVector(vector, (Vector)object2);
        }
        if (vector != null) {
            return vector;
        }
        return null;
    }
}

