/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver;

import com.ibm.xml.xml4j.internal.s1.resolver.Catalog;
import com.ibm.xml.xml4j.internal.s1.resolver.helpers.BootstrapResolver;
import com.ibm.xml.xml4j.internal.s1.resolver.helpers.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class CatalogManager {
    private static String pFiles = "xml.catalog.files";
    private static String pVerbosity = "xml.catalog.verbosity";
    private static String pPrefer = "xml.catalog.prefer";
    private static String pStatic = "xml.catalog.staticCatalog";
    private static String pAllowPI = "xml.catalog.allowPI";
    private static String pClassname = "xml.catalog.className";
    private static String pIgnoreMissing = "xml.catalog.ignoreMissing";
    private static CatalogManager staticManager = new CatalogManager();
    private BootstrapResolver bResolver = new BootstrapResolver();
    private boolean ignoreMissingProperties = System.getProperty(pIgnoreMissing) != null || System.getProperty(pFiles) != null;
    private ResourceBundle resources;
    private String propertyFile = "CatalogManager.properties";
    private URL propertyFileURI = null;
    private String defaultCatalogFiles = "./xcatalog";
    private String catalogFiles = null;
    private boolean fromPropertiesFile = false;
    private int defaultVerbosity = 1;
    private Integer verbosity = null;
    private boolean defaultPreferPublic = true;
    private Boolean preferPublic = null;
    private boolean defaultUseStaticCatalog = true;
    private Boolean useStaticCatalog = null;
    private static Catalog staticCatalog = null;
    private boolean defaultOasisXMLCatalogPI = true;
    private Boolean oasisXMLCatalogPI = null;
    private boolean defaultRelativeCatalogs = true;
    private Boolean relativeCatalogs = null;
    private String catalogClassName = null;
    public Debug debug = null;

    public CatalogManager() {
        this.debug = new Debug();
    }

    public CatalogManager(String string2) {
        this.propertyFile = string2;
        this.debug = new Debug();
    }

    public void setBootstrapResolver(BootstrapResolver bootstrapResolver) {
        this.bResolver = bootstrapResolver;
    }

    public BootstrapResolver getBootstrapResolver() {
        return this.bResolver;
    }

    private synchronized void readProperties() {
        Object object2;
        block9: {
            try {
                this.propertyFileURI = CatalogManager.class.getResource("/" + this.propertyFile);
                object2 = CatalogManager.class.getResourceAsStream("/" + this.propertyFile);
                if (object2 == null) {
                    if (!this.ignoreMissingProperties) {
                        System.err.println("Cannot find " + this.propertyFile);
                        this.ignoreMissingProperties = true;
                    }
                    return;
                }
                this.resources = new PropertyResourceBundle((InputStream)object2);
            }
            catch (MissingResourceException missingResourceException) {
                if (!this.ignoreMissingProperties) {
                    System.err.println("Cannot read " + this.propertyFile);
                }
            }
            catch (IOException iOException) {
                if (this.ignoreMissingProperties) break block9;
                System.err.println("Failure trying to read " + this.propertyFile);
            }
        }
        if (this.verbosity == null) {
            try {
                object2 = this.resources.getString("verbosity");
                int n2 = Integer.parseInt(((String)object2).trim());
                this.debug.setDebug(n2);
                this.verbosity = new Integer(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static CatalogManager getStaticManager() {
        return staticManager;
    }

    public boolean getIgnoreMissingProperties() {
        return this.ignoreMissingProperties;
    }

    public void setIgnoreMissingProperties(boolean bl) {
        this.ignoreMissingProperties = bl;
    }

    public void ignoreMissingProperties(boolean bl) {
        this.setIgnoreMissingProperties(bl);
    }

    private int queryVerbosity() {
        String string2 = System.getProperty(pVerbosity);
        if (string2 == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultVerbosity;
            }
            try {
                string2 = this.resources.getString("verbosity");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultVerbosity;
            }
        }
        try {
            int n2 = Integer.parseInt(string2.trim());
            return n2;
        }
        catch (Exception exception) {
            System.err.println("Cannot parse verbosity: \"" + string2 + "\"");
            return this.defaultVerbosity;
        }
    }

    public int getVerbosity() {
        if (this.verbosity == null) {
            this.verbosity = new Integer(this.queryVerbosity());
        }
        return this.verbosity;
    }

    public void setVerbosity(int n2) {
        this.verbosity = new Integer(n2);
        this.debug.setDebug(n2);
    }

    public int verbosity() {
        return this.getVerbosity();
    }

    private boolean queryRelativeCatalogs() {
        if (this.resources == null) {
            this.readProperties();
        }
        if (this.resources == null) {
            return this.defaultRelativeCatalogs;
        }
        try {
            String string2 = this.resources.getString("relative-catalogs");
            return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("1");
        }
        catch (MissingResourceException missingResourceException) {
            return this.defaultRelativeCatalogs;
        }
    }

    public boolean getRelativeCatalogs() {
        if (this.relativeCatalogs == null) {
            this.relativeCatalogs = this.queryRelativeCatalogs() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.relativeCatalogs;
    }

    public void setRelativeCatalogs(boolean bl) {
        this.relativeCatalogs = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean relativeCatalogs() {
        return this.getRelativeCatalogs();
    }

    private String queryCatalogFiles() {
        String string2 = System.getProperty(pFiles);
        this.fromPropertiesFile = false;
        if (string2 == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources != null) {
                try {
                    string2 = this.resources.getString("catalogs");
                    this.fromPropertiesFile = true;
                }
                catch (MissingResourceException missingResourceException) {
                    System.err.println(this.propertyFile + ": catalogs not found.");
                    string2 = null;
                }
            }
        }
        if (string2 == null) {
            string2 = this.defaultCatalogFiles;
        }
        return string2;
    }

    public Vector getCatalogFiles() {
        if (this.catalogFiles == null) {
            this.catalogFiles = this.queryCatalogFiles();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.catalogFiles, ";");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            URL uRL = null;
            if (this.fromPropertiesFile && !this.relativeCatalogs()) {
                try {
                    uRL = new URL(this.propertyFileURI, string2);
                    string2 = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            vector.add(string2);
        }
        return vector;
    }

    public void setCatalogFiles(String string2) {
        this.catalogFiles = string2;
        this.fromPropertiesFile = false;
    }

    public Vector catalogFiles() {
        return this.getCatalogFiles();
    }

    private boolean queryPreferPublic() {
        String string2 = System.getProperty(pPrefer);
        if (string2 == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultPreferPublic;
            }
            try {
                string2 = this.resources.getString("prefer");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultPreferPublic;
            }
        }
        if (string2 == null) {
            return this.defaultPreferPublic;
        }
        return string2.equalsIgnoreCase("public");
    }

    public boolean getPreferPublic() {
        if (this.preferPublic == null) {
            this.preferPublic = this.queryPreferPublic() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.preferPublic;
    }

    public void setPreferPublic(boolean bl) {
        this.preferPublic = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean preferPublic() {
        return this.getPreferPublic();
    }

    private boolean queryUseStaticCatalog() {
        String string2 = System.getProperty(pStatic);
        if (this.useStaticCatalog == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultUseStaticCatalog;
            }
            try {
                string2 = this.resources.getString("static-catalog");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultUseStaticCatalog;
            }
        }
        if (string2 == null) {
            return this.defaultUseStaticCatalog;
        }
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("1");
    }

    public boolean getUseStaticCatalog() {
        if (this.useStaticCatalog == null) {
            this.useStaticCatalog = this.queryUseStaticCatalog() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.useStaticCatalog;
    }

    public void setUseStaticCatalog(boolean bl) {
        this.useStaticCatalog = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean staticCatalog() {
        return this.getUseStaticCatalog();
    }

    public Catalog getPrivateCatalog() {
        Catalog catalog = staticCatalog;
        if (this.useStaticCatalog == null) {
            Boolean bl = this.useStaticCatalog = this.getUseStaticCatalog() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (catalog == null || !this.useStaticCatalog.booleanValue()) {
            try {
                String string2 = this.getCatalogClassName();
                if (string2 == null) {
                    catalog = new Catalog();
                } else {
                    try {
                        catalog = (Catalog)Class.forName(string2).newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.debug.message(1, "Catalog class named '" + string2 + "' could not be found. Using default.");
                        catalog = new Catalog();
                    }
                    catch (ClassCastException classCastException) {
                        this.debug.message(1, "Class named '" + string2 + "' is not a Catalog. Using default.");
                        catalog = new Catalog();
                    }
                }
                catalog.setCatalogManager(this);
                catalog.setupReaders();
                catalog.loadSystemCatalogs();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.useStaticCatalog.booleanValue()) {
                staticCatalog = catalog;
            }
        }
        return catalog;
    }

    public Catalog getCatalog() {
        Catalog catalog = staticCatalog;
        if (this.useStaticCatalog == null) {
            Boolean bl = this.useStaticCatalog = this.getUseStaticCatalog() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (catalog == null || !this.useStaticCatalog.booleanValue()) {
            catalog = this.getPrivateCatalog();
            if (this.useStaticCatalog.booleanValue()) {
                staticCatalog = catalog;
            }
        }
        return catalog;
    }

    public boolean queryAllowOasisXMLCatalogPI() {
        String string2 = System.getProperty(pAllowPI);
        if (string2 == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultOasisXMLCatalogPI;
            }
            try {
                string2 = this.resources.getString("allow-oasis-xml-catalog-pi");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultOasisXMLCatalogPI;
            }
        }
        if (string2 == null) {
            return this.defaultOasisXMLCatalogPI;
        }
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("1");
    }

    public boolean getAllowOasisXMLCatalogPI() {
        if (this.oasisXMLCatalogPI == null) {
            this.oasisXMLCatalogPI = this.queryAllowOasisXMLCatalogPI() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.oasisXMLCatalogPI;
    }

    public void setAllowOasisXMLCatalogPI(boolean bl) {
        this.oasisXMLCatalogPI = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean allowOasisXMLCatalogPI() {
        return this.getAllowOasisXMLCatalogPI();
    }

    public String queryCatalogClassName() {
        String string2 = System.getProperty(pClassname);
        if (string2 == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return null;
            }
            try {
                return this.resources.getString("catalog-class-name");
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        return string2;
    }

    public String getCatalogClassName() {
        if (this.catalogClassName == null) {
            this.catalogClassName = this.queryCatalogClassName();
        }
        return this.catalogClassName;
    }

    public void setCatalogClassName(String string2) {
        this.catalogClassName = string2;
    }

    public String catalogClassName() {
        return this.getCatalogClassName();
    }
}

