/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.resolver;

import com.ibm.xml.xml4j.internal.s1.resolver.CatalogEntry;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogException;
import com.ibm.xml.xml4j.internal.s1.resolver.CatalogManager;
import com.ibm.xml.xml4j.internal.s1.resolver.helpers.PublicId;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.CatalogReader;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.SAXCatalogReader;
import com.ibm.xml.xml4j.internal.s1.resolver.readers.TR9401CatalogReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;

public class Catalog {
    public static final int BASE = CatalogEntry.addEntryType("BASE", 1);
    public static final int CATALOG = CatalogEntry.addEntryType("CATALOG", 1);
    public static final int DOCUMENT = CatalogEntry.addEntryType("DOCUMENT", 1);
    public static final int OVERRIDE = CatalogEntry.addEntryType("OVERRIDE", 1);
    public static final int SGMLDECL = CatalogEntry.addEntryType("SGMLDECL", 1);
    public static final int DELEGATE_PUBLIC = CatalogEntry.addEntryType("DELEGATE_PUBLIC", 2);
    public static final int DELEGATE_SYSTEM = CatalogEntry.addEntryType("DELEGATE_SYSTEM", 2);
    public static final int DELEGATE_URI = CatalogEntry.addEntryType("DELEGATE_URI", 2);
    public static final int DOCTYPE = CatalogEntry.addEntryType("DOCTYPE", 2);
    public static final int DTDDECL = CatalogEntry.addEntryType("DTDDECL", 2);
    public static final int ENTITY = CatalogEntry.addEntryType("ENTITY", 2);
    public static final int LINKTYPE = CatalogEntry.addEntryType("LINKTYPE", 2);
    public static final int NOTATION = CatalogEntry.addEntryType("NOTATION", 2);
    public static final int PUBLIC = CatalogEntry.addEntryType("PUBLIC", 2);
    public static final int SYSTEM = CatalogEntry.addEntryType("SYSTEM", 2);
    public static final int URI = CatalogEntry.addEntryType("URI", 2);
    public static final int REWRITE_SYSTEM = CatalogEntry.addEntryType("REWRITE_SYSTEM", 2);
    public static final int REWRITE_URI = CatalogEntry.addEntryType("REWRITE_URI", 2);
    protected URL base;
    protected URL catalogCwd;
    protected Vector catalogEntries = new Vector();
    protected boolean default_override = true;
    protected CatalogManager catalogManager = CatalogManager.getStaticManager();
    protected Vector catalogFiles = new Vector();
    protected Vector localCatalogFiles = new Vector();
    protected Vector catalogs = new Vector();
    protected Vector localDelegate = new Vector();
    protected Hashtable readerMap = new Hashtable();
    protected Vector readerArr = new Vector();

    public Catalog() {
    }

    public Catalog(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public void setCatalogManager(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public void setupReaders() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        SAXCatalogReader sAXCatalogReader = new SAXCatalogReader(sAXParserFactory);
        sAXCatalogReader.setCatalogParser(null, "XMLCatalog", "org.apache.xml.resolver.readers.XCatalogReader");
        sAXCatalogReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.OASISXMLCatalogReader");
        this.addReader("application/xml", sAXCatalogReader);
        TR9401CatalogReader tR9401CatalogReader = new TR9401CatalogReader();
        this.addReader("text/plain", tR9401CatalogReader);
    }

    public void addReader(String string2, CatalogReader catalogReader) {
        if (this.readerMap.containsKey(string2)) {
            Integer n2 = (Integer)this.readerMap.get(string2);
            this.readerArr.set(n2, catalogReader);
        } else {
            this.readerArr.add(catalogReader);
            Integer n3 = new Integer(this.readerArr.size() - 1);
            this.readerMap.put(string2, n3);
        }
    }

    protected void copyReaders(Catalog catalog) {
        Object object2;
        Vector<String> vector = new Vector<String>(this.readerMap.size());
        for (int i = 0; i < this.readerMap.size(); ++i) {
            vector.add(null);
        }
        Enumeration enumeration = this.readerMap.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            object2 = (Integer)this.readerMap.get(string2);
            vector.set((Integer)object2, string2);
        }
        for (int i = 0; i < vector.size(); ++i) {
            object2 = (String)vector.get(i);
            Integer n2 = (Integer)this.readerMap.get(object2);
            catalog.addReader((String)object2, (CatalogReader)this.readerArr.get(n2));
        }
    }

    protected Catalog newCatalog() {
        String string2 = this.getClass().getName();
        try {
            Catalog catalog = (Catalog)Class.forName(string2).newInstance();
            catalog.setCatalogManager(this.catalogManager);
            this.copyReaders(catalog);
            return catalog;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.catalogManager.debug.message(1, "Class Not Found Exception: " + string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.catalogManager.debug.message(1, "Illegal Access Exception: " + string2);
        }
        catch (InstantiationException instantiationException) {
            this.catalogManager.debug.message(1, "Instantiation Exception: " + string2);
        }
        catch (ClassCastException classCastException) {
            this.catalogManager.debug.message(1, "Class Cast Exception: " + string2);
        }
        catch (Exception exception) {
            this.catalogManager.debug.message(1, "Other Exception: " + string2);
        }
        Catalog catalog = new Catalog();
        catalog.setCatalogManager(this.catalogManager);
        this.copyReaders(catalog);
        return catalog;
    }

    public String getCurrentBase() {
        return this.base.toString();
    }

    public String getDefaultOverride() {
        if (this.default_override) {
            return "yes";
        }
        return "no";
    }

    public void loadSystemCatalogs() throws MalformedURLException, IOException {
        Vector vector = this.catalogManager.getCatalogFiles();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.catalogFiles.addElement(vector.elementAt(i));
            }
        }
        if (this.catalogFiles.size() > 0) {
            String string2 = (String)this.catalogFiles.lastElement();
            this.catalogFiles.removeElement(string2);
            this.parseCatalog(string2);
        }
    }

    public synchronized void parseCatalog(String string2) throws MalformedURLException, IOException {
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse catalog: " + string2);
        this.catalogFiles.addElement(string2);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(String string2, InputStream inputStream) throws IOException, CatalogException {
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse " + string2 + " catalog on input stream");
        CatalogReader catalogReader = null;
        if (this.readerMap.containsKey(string2)) {
            int n2 = (Integer)this.readerMap.get(string2);
            catalogReader = (CatalogReader)this.readerArr.get(n2);
        }
        if (catalogReader == null) {
            String string3 = "No CatalogReader for MIME type: " + string2;
            this.catalogManager.debug.message(2, string3);
            throw new CatalogException(6, string3);
        }
        catalogReader.readCatalog(this, inputStream);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(URL uRL) throws IOException {
        this.catalogCwd = uRL;
        this.base = uRL;
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse catalog: " + uRL.toString());
        DataInputStream dataInputStream = null;
        boolean bl = false;
        for (int i = 0; !bl && i < this.readerArr.size(); ++i) {
            CatalogReader catalogReader = (CatalogReader)this.readerArr.get(i);
            try {
                dataInputStream = new DataInputStream(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                break;
            }
            try {
                catalogReader.readCatalog(this, dataInputStream);
                bl = true;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 7) break;
            }
            try {
                dataInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            this.parsePendingCatalogs();
        }
    }

    protected synchronized void parsePendingCatalogs() throws MalformedURLException, IOException {
        Enumeration<Object> enumeration;
        Object object2;
        if (!this.localCatalogFiles.isEmpty()) {
            object2 = new Vector();
            enumeration = this.localCatalogFiles.elements();
            while (enumeration.hasMoreElements()) {
                ((Vector)object2).addElement(enumeration.nextElement());
            }
            for (int i = 0; i < this.catalogFiles.size(); ++i) {
                String string2 = (String)this.catalogFiles.elementAt(i);
                ((Vector)object2).addElement(string2);
            }
            this.catalogFiles = object2;
            this.localCatalogFiles.clear();
        }
        if (this.catalogFiles.isEmpty() && !this.localDelegate.isEmpty()) {
            object2 = this.localDelegate.elements();
            while (object2.hasMoreElements()) {
                this.catalogEntries.addElement(object2.nextElement());
            }
            this.localDelegate.clear();
        }
        while (!this.catalogFiles.isEmpty()) {
            object2 = (String)this.catalogFiles.elementAt(0);
            try {
                this.catalogFiles.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (this.catalogEntries.size() == 0 && this.catalogs.size() == 0) {
                try {
                    this.parseCatalogFile((String)object2);
                }
                catch (CatalogException catalogException) {
                    System.out.println("FIXME: " + catalogException.toString());
                }
            } else {
                this.catalogs.addElement(object2);
            }
            if (!this.localCatalogFiles.isEmpty()) {
                enumeration = new Vector();
                Enumeration enumeration2 = this.localCatalogFiles.elements();
                while (enumeration2.hasMoreElements()) {
                    ((Vector)((Object)enumeration)).addElement(enumeration2.nextElement());
                }
                for (int i = 0; i < this.catalogFiles.size(); ++i) {
                    object2 = (String)this.catalogFiles.elementAt(i);
                    ((Vector)((Object)enumeration)).addElement(object2);
                }
                this.catalogFiles = enumeration;
                this.localCatalogFiles.clear();
            }
            if (this.localDelegate.isEmpty()) continue;
            enumeration = this.localDelegate.elements();
            while (enumeration.hasMoreElements()) {
                this.catalogEntries.addElement(enumeration.nextElement());
            }
            this.localDelegate.clear();
        }
        this.catalogFiles.clear();
    }

    protected synchronized void parseCatalogFile(String string2) throws MalformedURLException, IOException, CatalogException {
        Object object2;
        try {
            object2 = this.fixSlashes(System.getProperty("user.dir"));
            this.catalogCwd = new URL("file:" + (String)object2 + "/basename");
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = this.fixSlashes(System.getProperty("user.dir"));
            this.catalogManager.debug.message(1, "Malformed URL on cwd", string3);
            this.catalogCwd = null;
        }
        try {
            this.base = new URL(this.catalogCwd, this.fixSlashes(string2));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                this.base = new URL("file:" + this.fixSlashes(string2));
            }
            catch (MalformedURLException malformedURLException2) {
                this.catalogManager.debug.message(1, "Malformed URL on catalog filename", this.fixSlashes(string2));
                this.base = null;
            }
        }
        this.catalogManager.debug.message(2, "Loading catalog", string2);
        this.catalogManager.debug.message(4, "Default BASE", this.base.toString());
        string2 = this.base.toString();
        object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; !bl && i < this.readerArr.size(); ++i) {
            CatalogReader catalogReader = (CatalogReader)this.readerArr.get(i);
            try {
                bl2 = false;
                object2 = new DataInputStream(this.base.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl2 = true;
                break;
            }
            try {
                catalogReader.readCatalog(this, (InputStream)object2);
                bl = true;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 7) break;
            }
            try {
                ((FilterInputStream)object2).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) {
            if (bl2) {
                this.catalogManager.debug.message(3, "Catalog does not exist", string2);
            } else {
                this.catalogManager.debug.message(1, "Failed to parse catalog", string2);
            }
        }
    }

    public void addEntry(CatalogEntry catalogEntry) {
        int n2 = catalogEntry.getEntryType();
        if (n2 == BASE) {
            String string2 = catalogEntry.getEntryArg(0);
            URL uRL = null;
            this.catalogManager.debug.message(5, "BASE CUR", this.base.toString());
            this.catalogManager.debug.message(4, "BASE STR", string2);
            try {
                string2 = this.fixSlashes(string2);
                uRL = new URL(this.base, string2);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL("file:" + string2);
                }
                catch (MalformedURLException malformedURLException2) {
                    this.catalogManager.debug.message(1, "Malformed URL on base", string2);
                    uRL = null;
                }
            }
            if (uRL != null) {
                this.base = uRL;
            }
            this.catalogManager.debug.message(5, "BASE NEW", this.base.toString());
        } else if (n2 == CATALOG) {
            String string3 = this.makeAbsolute(catalogEntry.getEntryArg(0));
            this.catalogManager.debug.message(4, "CATALOG", string3);
            this.localCatalogFiles.addElement(string3);
        } else if (n2 == PUBLIC) {
            String string4 = PublicId.normalize(catalogEntry.getEntryArg(0));
            String string5 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string4);
            catalogEntry.setEntryArg(1, string5);
            this.catalogManager.debug.message(4, "PUBLIC", string4, string5);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == SYSTEM) {
            String string6 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string7 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string7);
            this.catalogManager.debug.message(4, "SYSTEM", string6, string7);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == URI) {
            String string8 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string9 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string9);
            this.catalogManager.debug.message(4, "URI", string8, string9);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DOCUMENT) {
            String string10 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(0)));
            catalogEntry.setEntryArg(0, string10);
            this.catalogManager.debug.message(4, "DOCUMENT", string10);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == OVERRIDE) {
            this.catalogManager.debug.message(4, "OVERRIDE", catalogEntry.getEntryArg(0));
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == SGMLDECL) {
            String string11 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(0)));
            catalogEntry.setEntryArg(0, string11);
            this.catalogManager.debug.message(4, "SGMLDECL", string11);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DELEGATE_PUBLIC) {
            String string12 = PublicId.normalize(catalogEntry.getEntryArg(0));
            String string13 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string12);
            catalogEntry.setEntryArg(1, string13);
            this.catalogManager.debug.message(4, "DELEGATE_PUBLIC", string12, string13);
            this.addDelegate(catalogEntry);
        } else if (n2 == DELEGATE_SYSTEM) {
            String string14 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string15 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string14);
            catalogEntry.setEntryArg(1, string15);
            this.catalogManager.debug.message(4, "DELEGATE_SYSTEM", string14, string15);
            this.addDelegate(catalogEntry);
        } else if (n2 == DELEGATE_URI) {
            String string16 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string17 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string16);
            catalogEntry.setEntryArg(1, string17);
            this.catalogManager.debug.message(4, "DELEGATE_URI", string16, string17);
            this.addDelegate(catalogEntry);
        } else if (n2 == REWRITE_SYSTEM) {
            String string18 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string19 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string18);
            catalogEntry.setEntryArg(1, string19);
            this.catalogManager.debug.message(4, "REWRITE_SYSTEM", string18, string19);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == REWRITE_URI) {
            String string20 = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string21 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string20);
            catalogEntry.setEntryArg(1, string21);
            this.catalogManager.debug.message(4, "REWRITE_URI", string20, string21);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DOCTYPE) {
            String string22 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string22);
            this.catalogManager.debug.message(4, "DOCTYPE", catalogEntry.getEntryArg(0), string22);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DTDDECL) {
            String string23 = PublicId.normalize(catalogEntry.getEntryArg(0));
            catalogEntry.setEntryArg(0, string23);
            String string24 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string24);
            this.catalogManager.debug.message(4, "DTDDECL", string23, string24);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == ENTITY) {
            String string25 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string25);
            this.catalogManager.debug.message(4, "ENTITY", catalogEntry.getEntryArg(0), string25);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == LINKTYPE) {
            String string26 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string26);
            this.catalogManager.debug.message(4, "LINKTYPE", catalogEntry.getEntryArg(0), string26);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == NOTATION) {
            String string27 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string27);
            this.catalogManager.debug.message(4, "NOTATION", catalogEntry.getEntryArg(0), string27);
            this.catalogEntries.addElement(catalogEntry);
        } else {
            this.catalogEntries.addElement(catalogEntry);
        }
    }

    public void unknownEntry(Vector vector) {
        if (vector != null && vector.size() > 0) {
            String string2 = (String)vector.elementAt(0);
            this.catalogManager.debug.message(2, "Unrecognized token parsing catalog", string2);
        }
    }

    public void parseAllCatalogs() throws MalformedURLException, IOException {
        Object object2;
        for (int i = 0; i < this.catalogs.size(); ++i) {
            object2 = null;
            try {
                object2 = (Catalog)this.catalogs.elementAt(i);
                continue;
            }
            catch (ClassCastException classCastException) {
                String string2 = (String)this.catalogs.elementAt(i);
                object2 = this.newCatalog();
                ((Catalog)object2).parseCatalog(string2);
                this.catalogs.setElementAt(object2, i);
                ((Catalog)object2).parseAllCatalogs();
            }
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object2).getEntryType() != DELEGATE_PUBLIC && ((CatalogEntry)object2).getEntryType() != DELEGATE_SYSTEM && ((CatalogEntry)object2).getEntryType() != DELEGATE_URI) continue;
            Catalog catalog = this.newCatalog();
            catalog.parseCatalog(((CatalogEntry)object2).getEntryArg(1));
        }
    }

    public String resolveDoctype(String string2, String string3, String string4) throws MalformedURLException, IOException {
        String string5 = null;
        this.catalogManager.debug.message(3, "resolveDoctype(" + string2 + "," + string3 + "," + string4 + ")");
        string4 = this.normalizeURI(string4);
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
        }
        if (string4 != null && string4.startsWith("urn:publicid:")) {
            string4 = PublicId.decodeURN(string4);
            if (string3 != null && !string3.equals(string4)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string4 = null;
            } else {
                string3 = string4;
                string4 = null;
            }
        }
        if (string4 != null && (string5 = this.resolveLocalSystem(string4)) != null) {
            return string5;
        }
        if (string3 != null && (string5 = this.resolveLocalPublic(DOCTYPE, string2, string3, string4)) != null) {
            return string5;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != DOCTYPE || !catalogEntry.getEntryArg(0).equals(string2) || !bl && string4 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(DOCTYPE, string2, string3, string4);
    }

    public String resolveDocument() throws MalformedURLException, IOException {
        this.catalogManager.debug.message(3, "resolveDocument");
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != DOCUMENT) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(DOCUMENT, null, null, null);
    }

    public String resolveEntity(String string2, String string3, String string4) throws MalformedURLException, IOException {
        String string5 = null;
        this.catalogManager.debug.message(3, "resolveEntity(" + string2 + "," + string3 + "," + string4 + ")");
        string4 = this.normalizeURI(string4);
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
        }
        if (string4 != null && string4.startsWith("urn:publicid:")) {
            string4 = PublicId.decodeURN(string4);
            if (string3 != null && !string3.equals(string4)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string4 = null;
            } else {
                string3 = string4;
                string4 = null;
            }
        }
        if (string4 != null && (string5 = this.resolveLocalSystem(string4)) != null) {
            return string5;
        }
        if (string3 != null && (string5 = this.resolveLocalPublic(ENTITY, string2, string3, string4)) != null) {
            return string5;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != ENTITY || !catalogEntry.getEntryArg(0).equals(string2) || !bl && string4 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(ENTITY, string2, string3, string4);
    }

    public String resolveNotation(String string2, String string3, String string4) throws MalformedURLException, IOException {
        String string5 = null;
        this.catalogManager.debug.message(3, "resolveNotation(" + string2 + "," + string3 + "," + string4 + ")");
        string4 = this.normalizeURI(string4);
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
        }
        if (string4 != null && string4.startsWith("urn:publicid:")) {
            string4 = PublicId.decodeURN(string4);
            if (string3 != null && !string3.equals(string4)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string4 = null;
            } else {
                string3 = string4;
                string4 = null;
            }
        }
        if (string4 != null && (string5 = this.resolveLocalSystem(string4)) != null) {
            return string5;
        }
        if (string3 != null && (string5 = this.resolveLocalPublic(NOTATION, string2, string3, string4)) != null) {
            return string5;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != NOTATION || !catalogEntry.getEntryArg(0).equals(string2) || !bl && string4 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(NOTATION, string2, string3, string4);
    }

    public String resolvePublic(String string2, String string3) throws MalformedURLException, IOException {
        String string4;
        this.catalogManager.debug.message(3, "resolvePublic(" + string2 + "," + string3 + ")");
        string3 = this.normalizeURI(string3);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
        }
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
            if (string2 != null && !string2.equals(string3)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string3 = null;
            } else {
                string2 = string3;
                string3 = null;
            }
        }
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        string4 = this.resolveLocalPublic(PUBLIC, null, string2, string3);
        if (string4 != null) {
            return string4;
        }
        return this.resolveSubordinateCatalogs(PUBLIC, null, string2, string3);
    }

    protected synchronized String resolveLocalPublic(int n2, String string2, String string3, String string4) throws MalformedURLException, IOException {
        Object object2;
        Object object3;
        Object object4;
        String string5;
        string3 = PublicId.normalize(string3);
        if (string4 != null && (string5 = this.resolveLocalSystem(string4)) != null) {
            return string5;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object4).getEntryType() == OVERRIDE) {
                bl = ((CatalogEntry)object4).getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (((CatalogEntry)object4).getEntryType() != PUBLIC || !((CatalogEntry)object4).getEntryArg(0).equals(string3) || !bl && string4 != null) continue;
            return ((CatalogEntry)object4).getEntryArg(1);
        }
        bl = this.default_override;
        enumeration = this.catalogEntries.elements();
        object4 = new Vector();
        while (enumeration.hasMoreElements()) {
            object3 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object3).getEntryType() == OVERRIDE) {
                bl = ((CatalogEntry)object3).getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (((CatalogEntry)object3).getEntryType() != DELEGATE_PUBLIC || !bl && string4 != null || ((String)(object2 = ((CatalogEntry)object3).getEntryArg(0))).length() > string3.length() || !((String)object2).equals(string3.substring(0, ((String)object2).length()))) continue;
            ((Vector)object4).addElement(((CatalogEntry)object3).getEntryArg(1));
        }
        if (((Vector)object4).size() > 0) {
            object3 = ((Vector)object4).elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    this.catalogManager.debug.message(2, "\t" + (String)object2);
                }
            }
            object2 = this.newCatalog();
            object3 = ((Vector)object4).elements();
            while (object3.hasMoreElements()) {
                String string6 = (String)object3.nextElement();
                ((Catalog)object2).parseCatalog(string6);
            }
            return ((Catalog)object2).resolvePublic(string3, null);
        }
        return null;
    }

    public String resolveSystem(String string2) throws MalformedURLException, IOException {
        String string3;
        this.catalogManager.debug.message(3, "resolveSystem(" + string2 + ")");
        string2 = this.normalizeURI(string2);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
            return this.resolvePublic(string2, null);
        }
        if (string2 != null && (string3 = this.resolveLocalSystem(string2)) != null) {
            return string3;
        }
        return this.resolveSubordinateCatalogs(SYSTEM, null, null, string2);
    }

    protected String resolveLocalSystem(String string2) throws MalformedURLException, IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string3 = System.getProperty("os.name");
        boolean bl = string3.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object5).getEntryType() != SYSTEM || !((CatalogEntry)object5).getEntryArg(0).equals(string2) && (!bl || !((CatalogEntry)object5).getEntryArg(0).equalsIgnoreCase(string2))) continue;
            return ((CatalogEntry)object5).getEntryArg(1);
        }
        enumeration = this.catalogEntries.elements();
        object5 = null;
        String string4 = null;
        while (enumeration.hasMoreElements()) {
            object4 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object4).getEntryType() == REWRITE_SYSTEM && ((String)(object3 = ((CatalogEntry)object4).getEntryArg(0))).length() <= string2.length() && ((String)object3).equals(string2.substring(0, ((String)object3).length())) && (object5 == null || ((String)object3).length() > ((String)object5).length())) {
                object5 = object3;
                string4 = ((CatalogEntry)object4).getEntryArg(1);
            }
            if (string4 == null) continue;
            return string4 + string2.substring(((String)object5).length());
        }
        enumeration = this.catalogEntries.elements();
        object4 = new Vector();
        while (enumeration.hasMoreElements()) {
            object3 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object3).getEntryType() != DELEGATE_SYSTEM || ((String)(object2 = ((CatalogEntry)object3).getEntryArg(0))).length() > string2.length() || !((String)object2).equals(string2.substring(0, ((String)object2).length()))) continue;
            ((Vector)object4).addElement(((CatalogEntry)object3).getEntryArg(1));
        }
        if (((Vector)object4).size() > 0) {
            object3 = ((Vector)object4).elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    this.catalogManager.debug.message(2, "\t" + (String)object2);
                }
            }
            object2 = this.newCatalog();
            object3 = ((Vector)object4).elements();
            while (object3.hasMoreElements()) {
                String string5 = (String)object3.nextElement();
                ((Catalog)object2).parseCatalog(string5);
            }
            return ((Catalog)object2).resolveSystem(string2);
        }
        return null;
    }

    public String resolveURI(String string2) throws MalformedURLException, IOException {
        String string3;
        this.catalogManager.debug.message(3, "resolveURI(" + string2 + ")");
        string2 = this.normalizeURI(string2);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
            return this.resolvePublic(string2, null);
        }
        if (string2 != null && (string3 = this.resolveLocalURI(string2)) != null) {
            return string3;
        }
        return this.resolveSubordinateCatalogs(URI, null, null, string2);
    }

    protected String resolveLocalURI(String string2) throws MalformedURLException, IOException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object5).getEntryType() != URI || !((CatalogEntry)object5).getEntryArg(0).equals(string2)) continue;
            return ((CatalogEntry)object5).getEntryArg(1);
        }
        enumeration = this.catalogEntries.elements();
        object5 = null;
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            object4 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object4).getEntryType() == REWRITE_URI && ((String)(object3 = ((CatalogEntry)object4).getEntryArg(0))).length() <= string2.length() && ((String)object3).equals(string2.substring(0, ((String)object3).length())) && (object5 == null || ((String)object3).length() > ((String)object5).length())) {
                object5 = object3;
                string3 = ((CatalogEntry)object4).getEntryArg(1);
            }
            if (string3 == null) continue;
            return string3 + string2.substring(((String)object5).length());
        }
        enumeration = this.catalogEntries.elements();
        object4 = new Vector();
        while (enumeration.hasMoreElements()) {
            object3 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object3).getEntryType() != DELEGATE_URI || ((String)(object2 = ((CatalogEntry)object3).getEntryArg(0))).length() > string2.length() || !((String)object2).equals(string2.substring(0, ((String)object2).length()))) continue;
            ((Vector)object4).addElement(((CatalogEntry)object3).getEntryArg(1));
        }
        if (((Vector)object4).size() > 0) {
            object3 = ((Vector)object4).elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    this.catalogManager.debug.message(2, "\t" + (String)object2);
                }
            }
            object2 = this.newCatalog();
            object3 = ((Vector)object4).elements();
            while (object3.hasMoreElements()) {
                String string4 = (String)object3.nextElement();
                ((Catalog)object2).parseCatalog(string4);
            }
            return ((Catalog)object2).resolveURI(string2);
        }
        return null;
    }

    protected synchronized String resolveSubordinateCatalogs(int n2, String string2, String string3, String string4) throws MalformedURLException, IOException {
        for (int i = 0; i < this.catalogs.size(); ++i) {
            Catalog catalog = null;
            try {
                catalog = (Catalog)this.catalogs.elementAt(i);
            }
            catch (ClassCastException classCastException) {
                String string5 = (String)this.catalogs.elementAt(i);
                catalog = this.newCatalog();
                try {
                    catalog.parseCatalog(string5);
                }
                catch (MalformedURLException malformedURLException) {
                    this.catalogManager.debug.message(1, "Malformed Catalog URL", string5);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, file not found", string5);
                }
                catch (IOException iOException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", string5);
                }
                this.catalogs.setElementAt(catalog, i);
            }
            String string6 = null;
            if (n2 == DOCTYPE) {
                string6 = catalog.resolveDoctype(string2, string3, string4);
            } else if (n2 == DOCUMENT) {
                string6 = catalog.resolveDocument();
            } else if (n2 == ENTITY) {
                string6 = catalog.resolveEntity(string2, string3, string4);
            } else if (n2 == NOTATION) {
                string6 = catalog.resolveNotation(string2, string3, string4);
            } else if (n2 == PUBLIC) {
                string6 = catalog.resolvePublic(string3, string4);
            } else if (n2 == SYSTEM) {
                string6 = catalog.resolveSystem(string4);
            } else if (n2 == URI) {
                string6 = catalog.resolveURI(string4);
            }
            if (string6 == null) continue;
            return string6;
        }
        return null;
    }

    protected String fixSlashes(String string2) {
        return string2.replace('\\', '/');
    }

    protected String makeAbsolute(String string2) {
        URL uRL = null;
        string2 = this.fixSlashes(string2);
        try {
            uRL = new URL(this.base, string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.catalogManager.debug.message(1, "Malformed URL on system identifier", string2);
        }
        if (uRL != null) {
            return uRL.toString();
        }
        return string2;
    }

    protected String normalizeURI(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.length();
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (c > ' ' && c <= '\u007f' && c != '\"' && c != '<' && c != '>' && c != '\\' && c != '^' && c != '`' && c != '{' && c != '|' && c != '}' && c != '\u007f') continue;
            return this.normalizeURI(string2, i);
        }
        return string2;
    }

    private String normalizeURI(String string2, int n2) {
        byte[] byArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(string2.charAt(i));
        }
        try {
            byArray = string2.substring(n2).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.catalogManager.debug.message(1, "UTF-8 is an unsupported encoding!?");
            return string2;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = byArray[i] & 0xFF;
            if (n3 <= 32 || n3 > 127 || n3 == 34 || n3 == 60 || n3 == 62 || n3 == 92 || n3 == 94 || n3 == 96 || n3 == 123 || n3 == 124 || n3 == 125 || n3 == 127) {
                this.writeEncodedByte(n3, stringBuffer);
                continue;
            }
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    protected String encodedByte(int n2) {
        StringBuffer stringBuffer = new StringBuffer(3);
        this.writeEncodedByte(n2, stringBuffer);
        return stringBuffer.toString();
    }

    private void writeEncodedByte(int n2, StringBuffer stringBuffer) {
        String string2 = Integer.toHexString(n2).toUpperCase(Locale.ENGLISH);
        if (string2.length() < 2) {
            stringBuffer.append("%0");
            stringBuffer.append(string2);
        } else {
            stringBuffer.append('%');
            stringBuffer.append(string2);
        }
    }

    protected void addDelegate(CatalogEntry catalogEntry) {
        int n2 = 0;
        String string2 = catalogEntry.getEntryArg(0);
        Enumeration enumeration = this.localDelegate.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry2 = (CatalogEntry)enumeration.nextElement();
            String string3 = catalogEntry2.getEntryArg(0);
            if (string3.equals(string2)) {
                return;
            }
            if (string3.length() > string2.length()) {
                ++n2;
            }
            if (string3.length() >= string2.length()) continue;
            break;
        }
        if (this.localDelegate.size() == 0) {
            this.localDelegate.addElement(catalogEntry);
        } else {
            this.localDelegate.insertElementAt(catalogEntry, n2);
        }
    }
}

