/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.jaxp.validation;

import com.ibm.xml.xml4j.internal.s1.dom.NodeImpl;
import com.ibm.xml.xml4j.internal.s1.impl.XMLErrorReporter;
import com.ibm.xml.xml4j.internal.s1.impl.validation.EntityState;
import com.ibm.xml.xml4j.internal.s1.impl.validation.ValidationManager;
import com.ibm.xml.xml4j.internal.s1.impl.xs.XMLSchemaValidator;
import com.ibm.xml.xml4j.internal.s1.impl.xs.util.SimpleLocator;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.DOMDocumentHandler;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.DOMResultAugmentor;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.DOMResultBuilder;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.JAXPValidationMessageFormatter;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.Util;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.ValidatorHelper;
import com.ibm.xml.xml4j.internal.s1.jaxp.validation.XMLSchemaValidatorComponentManager;
import com.ibm.xml.xml4j.internal.s1.util.NamespaceSupport;
import com.ibm.xml.xml4j.internal.s1.util.SymbolTable;
import com.ibm.xml.xml4j.internal.s1.util.XMLAttributesImpl;
import com.ibm.xml.xml4j.internal.s1.util.XMLSymbols;
import com.ibm.xml.xml4j.internal.s1.xni.NamespaceContext;
import com.ibm.xml.xml4j.internal.s1.xni.QName;
import com.ibm.xml.xml4j.internal.s1.xni.XMLString;
import com.ibm.xml.xml4j.internal.s1.xni.XNIException;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLParseException;
import java.io.IOException;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

final class DOMValidatorHelper
implements ValidatorHelper,
EntityState {
    private static final int CHUNK_SIZE = 1024;
    private static final int CHUNK_MASK = 1023;
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private final XMLErrorReporter fErrorReporter;
    private final NamespaceSupport fNamespaceContext;
    private final DOMNamespaceContext fDOMNamespaceContext = new DOMNamespaceContext();
    private final XMLSchemaValidator fSchemaValidator;
    private final SymbolTable fSymbolTable;
    private final ValidationManager fValidationManager;
    private final XMLSchemaValidatorComponentManager fComponentManager;
    private final SimpleLocator fXMLLocator = new SimpleLocator(null, null, -1, -1, -1);
    private DOMDocumentHandler fDOMValidatorHandler;
    private final DOMResultAugmentor fDOMResultAugmentor = new DOMResultAugmentor(this);
    private final DOMResultBuilder fDOMResultBuilder = new DOMResultBuilder();
    private NamedNodeMap fEntities = null;
    private final char[] fCharBuffer = new char[1024];
    private Node fRoot;
    private Node fCurrentElement;
    final QName fElementQName = new QName();
    final QName fAttributeQName = new QName();
    final XMLAttributesImpl fAttributes = new XMLAttributesImpl();
    final XMLString fTempString = new XMLString();

    public DOMValidatorHelper(XMLSchemaValidatorComponentManager xMLSchemaValidatorComponentManager) {
        this.fComponentManager = xMLSchemaValidatorComponentManager;
        this.fErrorReporter = (XMLErrorReporter)this.fComponentManager.getProperty(ERROR_REPORTER);
        this.fNamespaceContext = (NamespaceSupport)this.fComponentManager.getProperty(NAMESPACE_CONTEXT);
        this.fSchemaValidator = (XMLSchemaValidator)this.fComponentManager.getProperty(SCHEMA_VALIDATOR);
        this.fSymbolTable = (SymbolTable)this.fComponentManager.getProperty(SYMBOL_TABLE);
        this.fValidationManager = (ValidationManager)this.fComponentManager.getProperty(VALIDATION_MANAGER);
    }

    @Override
    public void validate(Source source, Result result2) throws SAXException, IOException {
        if (result2 instanceof DOMResult || result2 == null) {
            Node node2;
            DOMSource dOMSource = (DOMSource)source;
            DOMResult dOMResult = (DOMResult)result2;
            this.fRoot = node2 = dOMSource.getNode();
            if (node2 != null) {
                this.fComponentManager.reset();
                this.fValidationManager.setEntityState(this);
                this.fDOMNamespaceContext.reset();
                String string2 = dOMSource.getSystemId();
                this.fXMLLocator.setLiteralSystemId(string2);
                this.fXMLLocator.setExpandedSystemId(string2);
                this.fErrorReporter.setDocumentLocator(this.fXMLLocator);
                try {
                    this.setupEntityMap(node2.getNodeType() == 9 ? (Document)node2 : node2.getOwnerDocument());
                    this.setupDOMResultHandler(dOMSource, dOMResult);
                    this.fSchemaValidator.startDocument(this.fXMLLocator, null, this.fDOMNamespaceContext, null);
                    this.validate(node2);
                    this.fSchemaValidator.endDocument(null);
                }
                catch (XMLParseException xMLParseException) {
                    throw Util.toSAXParseException(xMLParseException);
                }
                catch (XNIException xNIException) {
                    throw Util.toSAXException(xNIException);
                }
                finally {
                    this.fRoot = null;
                    this.fCurrentElement = null;
                    this.fEntities = null;
                    if (this.fDOMValidatorHandler != null) {
                        this.fDOMValidatorHandler.setDOMResult(null);
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fComponentManager.getLocale(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result2.getClass().getName()}));
    }

    @Override
    public boolean isEntityDeclared(String string2) {
        return false;
    }

    @Override
    public boolean isEntityUnparsed(String string2) {
        Entity entity2;
        if (this.fEntities != null && (entity2 = (Entity)this.fEntities.getNamedItem(string2)) != null) {
            return entity2.getNotationName() != null;
        }
        return false;
    }

    private void validate(Node node2) {
        Node node3 = node2;
        boolean bl = this.useIsSameNode(node3);
        while (node2 != null) {
            this.beginNode(node2);
            Node node4 = node2.getFirstChild();
            while (node4 == null) {
                this.finishNode(node2);
                if (node3 == node2) break;
                node4 = node2.getNextSibling();
                if (node4 != null || (node2 = node2.getParentNode()) != null && !(bl ? node3.isSameNode(node2) : node3 == node2)) continue;
                if (node2 != null) {
                    this.finishNode(node2);
                }
                node4 = null;
                break;
            }
            node2 = node4;
        }
    }

    private void beginNode(Node node2) {
        switch (node2.getNodeType()) {
            case 1: {
                this.fCurrentElement = node2;
                this.fNamespaceContext.pushContext();
                this.fillQName(this.fElementQName, node2);
                this.processAttributes(node2.getAttributes());
                this.fSchemaValidator.startElement(this.fElementQName, this.fAttributes, null);
                break;
            }
            case 3: {
                if (this.fDOMValidatorHandler != null) {
                    this.fDOMValidatorHandler.setIgnoringCharacters(true);
                    this.sendCharactersToValidator(node2.getNodeValue());
                    this.fDOMValidatorHandler.setIgnoringCharacters(false);
                    this.fDOMValidatorHandler.characters((Text)node2);
                    break;
                }
                this.sendCharactersToValidator(node2.getNodeValue());
                break;
            }
            case 4: {
                if (this.fDOMValidatorHandler != null) {
                    this.fDOMValidatorHandler.setIgnoringCharacters(true);
                    this.fSchemaValidator.startCDATA(null);
                    this.sendCharactersToValidator(node2.getNodeValue());
                    this.fSchemaValidator.endCDATA(null);
                    this.fDOMValidatorHandler.setIgnoringCharacters(false);
                    this.fDOMValidatorHandler.cdata((CDATASection)node2);
                    break;
                }
                this.fSchemaValidator.startCDATA(null);
                this.sendCharactersToValidator(node2.getNodeValue());
                this.fSchemaValidator.endCDATA(null);
                break;
            }
            case 7: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.processingInstruction((ProcessingInstruction)node2);
                break;
            }
            case 8: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.comment((Comment)node2);
                break;
            }
            case 10: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.doctypeDecl((DocumentType)node2);
                break;
            }
        }
    }

    private void finishNode(Node node2) {
        if (node2.getNodeType() == 1) {
            this.fCurrentElement = node2;
            this.fillQName(this.fElementQName, node2);
            this.fSchemaValidator.endElement(this.fElementQName, null);
            this.fNamespaceContext.popContext();
        }
    }

    private void setupEntityMap(Document document2) {
        DocumentType documentType;
        if (document2 != null && (documentType = document2.getDoctype()) != null) {
            this.fEntities = documentType.getEntities();
            return;
        }
        this.fEntities = null;
    }

    private void setupDOMResultHandler(DOMSource dOMSource, DOMResult dOMResult) throws SAXException {
        if (dOMResult == null) {
            this.fDOMValidatorHandler = null;
            this.fSchemaValidator.setDocumentHandler(null);
            return;
        }
        Node node2 = dOMResult.getNode();
        if (dOMSource.getNode() == node2) {
            this.fDOMValidatorHandler = this.fDOMResultAugmentor;
            this.fDOMResultAugmentor.setDOMResult(dOMResult);
            this.fSchemaValidator.setDocumentHandler(this.fDOMResultAugmentor);
            return;
        }
        if (dOMResult.getNode() == null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                dOMResult.setNode(documentBuilder.newDocument());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
        }
        this.fDOMValidatorHandler = this.fDOMResultBuilder;
        this.fDOMResultBuilder.setDOMResult(dOMResult);
        this.fSchemaValidator.setDocumentHandler(this.fDOMResultBuilder);
    }

    private void fillQName(QName qName, Node node2) {
        String string2 = node2.getPrefix();
        String string3 = node2.getLocalName();
        String string4 = node2.getNodeName();
        String string5 = node2.getNamespaceURI();
        qName.prefix = string2 != null ? this.fSymbolTable.addSymbol(string2) : XMLSymbols.EMPTY_STRING;
        qName.localpart = string3 != null ? this.fSymbolTable.addSymbol(string3) : XMLSymbols.EMPTY_STRING;
        qName.rawname = string4 != null ? this.fSymbolTable.addSymbol(string4) : XMLSymbols.EMPTY_STRING;
        qName.uri = string5 != null && string5.length() > 0 ? this.fSymbolTable.addSymbol(string5) : null;
    }

    private void processAttributes(NamedNodeMap namedNodeMap) {
        int n2 = namedNodeMap.getLength();
        this.fAttributes.removeAllAttributes();
        for (int i = 0; i < n2; ++i) {
            Attr attr2 = (Attr)namedNodeMap.item(i);
            String string2 = attr2.getValue();
            if (string2 == null) {
                string2 = XMLSymbols.EMPTY_STRING;
            }
            this.fillQName(this.fAttributeQName, attr2);
            this.fAttributes.addAttributeNS(this.fAttributeQName, XMLSymbols.fCDATASymbol, string2);
            this.fAttributes.setSpecified(i, attr2.getSpecified());
            if (this.fAttributeQName.uri != NamespaceContext.XMLNS_URI) continue;
            if (this.fAttributeQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                this.fNamespaceContext.declarePrefix(this.fAttributeQName.localpart, string2.length() != 0 ? this.fSymbolTable.addSymbol(string2) : null);
                continue;
            }
            this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, string2.length() != 0 ? this.fSymbolTable.addSymbol(string2) : null);
        }
    }

    private void sendCharactersToValidator(String string2) {
        if (string2 != null) {
            int n2 = string2.length();
            int n3 = n2 & 0x3FF;
            if (n3 > 0) {
                string2.getChars(0, n3, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, n3);
                this.fSchemaValidator.characters(this.fTempString, null);
            }
            int n4 = n3;
            while (n4 < n2) {
                string2.getChars(n4, n4 += 1024, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, 1024);
                this.fSchemaValidator.characters(this.fTempString, null);
            }
        }
    }

    private boolean useIsSameNode(Node node2) {
        if (node2 instanceof NodeImpl) {
            return false;
        }
        Document document2 = node2.getNodeType() == 9 ? (Document)node2 : node2.getOwnerDocument();
        return document2 != null && document2.getImplementation().hasFeature("Core", "3.0");
    }

    Node getCurrentElement() {
        return this.fCurrentElement;
    }

    final class DOMNamespaceContext
    implements NamespaceContext {
        protected String[] fNamespace = new String[32];
        protected int fNamespaceSize = 0;
        protected boolean fDOMContextBuilt = false;

        DOMNamespaceContext() {
        }

        @Override
        public void pushContext() {
            DOMValidatorHelper.this.fNamespaceContext.pushContext();
        }

        @Override
        public void popContext() {
            DOMValidatorHelper.this.fNamespaceContext.popContext();
        }

        @Override
        public boolean declarePrefix(String string2, String string3) {
            return DOMValidatorHelper.this.fNamespaceContext.declarePrefix(string2, string3);
        }

        @Override
        public String getURI(String string2) {
            String string3 = DOMValidatorHelper.this.fNamespaceContext.getURI(string2);
            if (string3 == null) {
                if (!this.fDOMContextBuilt) {
                    this.fillNamespaceContext();
                    this.fDOMContextBuilt = true;
                }
                if (this.fNamespaceSize > 0 && !DOMValidatorHelper.this.fNamespaceContext.containsPrefix(string2)) {
                    string3 = this.getURI0(string2);
                }
            }
            return string3;
        }

        @Override
        public String getPrefix(String string2) {
            return DOMValidatorHelper.this.fNamespaceContext.getPrefix(string2);
        }

        @Override
        public int getDeclaredPrefixCount() {
            return DOMValidatorHelper.this.fNamespaceContext.getDeclaredPrefixCount();
        }

        @Override
        public String getDeclaredPrefixAt(int n2) {
            return DOMValidatorHelper.this.fNamespaceContext.getDeclaredPrefixAt(n2);
        }

        @Override
        public Enumeration getAllPrefixes() {
            return DOMValidatorHelper.this.fNamespaceContext.getAllPrefixes();
        }

        @Override
        public void reset() {
            this.fDOMContextBuilt = false;
            this.fNamespaceSize = 0;
        }

        private void fillNamespaceContext() {
            if (DOMValidatorHelper.this.fRoot != null) {
                for (Node node2 = DOMValidatorHelper.this.fRoot.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                    if (1 != node2.getNodeType()) continue;
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    int n2 = namedNodeMap.getLength();
                    for (int i = 0; i < n2; ++i) {
                        Attr attr2 = (Attr)namedNodeMap.item(i);
                        String string2 = attr2.getValue();
                        if (string2 == null) {
                            string2 = XMLSymbols.EMPTY_STRING;
                        }
                        DOMValidatorHelper.this.fillQName(DOMValidatorHelper.this.fAttributeQName, attr2);
                        if (DOMValidatorHelper.this.fAttributeQName.uri != NamespaceContext.XMLNS_URI) continue;
                        if (DOMValidatorHelper.this.fAttributeQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                            this.declarePrefix0(DOMValidatorHelper.this.fAttributeQName.localpart, string2.length() != 0 ? DOMValidatorHelper.this.fSymbolTable.addSymbol(string2) : null);
                            continue;
                        }
                        this.declarePrefix0(XMLSymbols.EMPTY_STRING, string2.length() != 0 ? DOMValidatorHelper.this.fSymbolTable.addSymbol(string2) : null);
                    }
                }
            }
        }

        private void declarePrefix0(String string2, String string3) {
            if (this.fNamespaceSize == this.fNamespace.length) {
                String[] stringArray = new String[this.fNamespaceSize * 2];
                System.arraycopy(this.fNamespace, 0, stringArray, 0, this.fNamespaceSize);
                this.fNamespace = stringArray;
            }
            this.fNamespace[this.fNamespaceSize++] = string2;
            this.fNamespace[this.fNamespaceSize++] = string3;
        }

        private String getURI0(String string2) {
            for (int i = 0; i < this.fNamespaceSize; i += 2) {
                if (this.fNamespace[i] != string2) continue;
                return this.fNamespace[i + 1];
            }
            return null;
        }
    }
}

