/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.jaxp.datatype;

import com.ibm.xml.jaxp.datatype.XMLGregorianCalendar2;
import com.ibm.xml.xml4j.internal.s1.jaxp.datatype.DateTimeUtil;
import com.ibm.xml.xml4j.internal.s1.jaxp.datatype.DurationImpl;
import com.ibm.xml.xml4j.internal.s1.jaxp.datatype.SerializedXMLGregorianCalendar;
import com.ibm.xml.xml4j.internal.s1.util.DatatypeMessageFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

final class XMLGregorianCalendarImpl
extends XMLGregorianCalendar2
implements Serializable {
    private static final long serialVersionUID = 3905403108073447394L;
    private static final int DIGITS_IN_ONE_BILLION = 10;
    private static final int MAX_INT_I = 1000000000;
    private static final BigInteger MAX_INT_B = BigInteger.valueOf(1000000000L);
    private static final BigInteger MAX_INT_B_NEGATIVE = BigInteger.valueOf(-1000000000L);
    private static final int NOT_REPRESENTABLE_IN_MILLISECONDS = -1;
    private static final Date PURE_GREGORIAN_CALENDAR_CHANGE = new Date(Long.MIN_VALUE);
    private BigInteger eon;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;
    private int hour = Integer.MIN_VALUE;
    private int minute = Integer.MIN_VALUE;
    private int second = Integer.MIN_VALUE;
    private int millisecond = Integer.MIN_VALUE;
    private BigDecimal fracSeconds;
    private int timezone = Integer.MIN_VALUE;
    private XMLGregorianCalendarSnapshot initialValues;
    private static final int YEAR = 2000;
    private static final int MONTH = 1;
    private static final int DAY = 1;
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigInteger I_ZERO = BigInteger.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigInteger I_ONE = BigInteger.ONE;
    private static final BigInteger THIRTEEN = BigInteger.valueOf(13L);

    public XMLGregorianCalendarImpl() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLGregorianCalendarImpl(String string2) {
        int n2;
        if (string2 == null) {
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "CannotBeNull", new Object[]{"String"}));
        }
        int n3 = string2.length();
        if (n3 <= 3) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string2}));
        if (string2.charAt(0) == '-' && string2.charAt(1) == '-') {
            if (string2.charAt(2) == '-') {
                if (n3 < 5) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gDay"}));
                this.setDay0(DateTimeUtil.parseInt(string2, 3, 5));
                if (n3 > 5) {
                    this.parseTimeZone(string2, 5, n3);
                }
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gDay"}));
            }
            this.setMonth0(DateTimeUtil.parseInt(string2, 2, 4));
            if (n3 == 4) {
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonth"}));
            }
            if (string2.charAt(4) == '+' || string2.charAt(4) == 'Z') {
                this.parseTimeZone(string2, 4, n3);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonth"}));
            }
            if (string2.charAt(4) != '-' || n3 < 6) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonth/gMonthDay"}));
            int n4 = 5;
            if (string2.charAt(n4) == '-') {
                ++n4;
                if (n3 == 6) {
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonth"}));
                }
                if (string2.charAt(n4) == '-' || string2.charAt(n4) == '+' || string2.charAt(n4) == 'Z') {
                    this.parseTimeZone(string2, n4, n3);
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonth"}));
                }
            }
            if (n4 + 2 > n3) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonth/gMonthDay"}));
            int n5 = DateTimeUtil.parseInt(string2, n4, n4 + 2);
            int n6 = n4 - 1;
            if (n4 + 2 == n3 || string2.charAt(n4 + 2) != ':') {
                this.setDay0(n5);
                if (n4 + 2 == n3) {
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonthDay"}));
                }
                n6 = n4 + 2;
            }
            this.parseTimeZone(string2, n6, n3);
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gMonth"}));
        }
        if (string2.charAt(2) == ':') {
            this.parseTime(string2, 0, n3);
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "time"}));
        }
        int n7 = DateTimeUtil.indexOf(string2, 1, n3, '-');
        if (n7 != -1) {
            this.setYearAfterCheck(string2, n7);
            if (n7 + 2 >= n3) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gYear"}));
            n2 = DateTimeUtil.parseInt(string2, ++n7, n7 + 2);
            if (n7 + 2 == n3) {
                this.setMonth0(n2);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gYearMonth"}));
            }
            if (string2.charAt(n7 + 2) == ':') {
                this.parseTimeZone(string2, n7 - 1, n3);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gYearMonth"}));
            }
            if (string2.charAt(n7 + 2) != '-' && string2.charAt(n7 + 2) != '+' && string2.charAt(n7 + 2) != 'Z') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gYear/gYearMonth/date/datetime"}));
            }
        } else {
            n7 = DateTimeUtil.indexOf(string2, 1, n3, '+');
            if (n7 == -1) {
                n7 = DateTimeUtil.indexOf(string2, 1, n3, 'Z');
            }
            this.setYearAfterCheck(string2, n7 != -1 ? n7 : n3);
            if (n7 != -1) {
                this.parseTimeZone(string2, n7, n3);
            }
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "gYear"}));
        }
        this.setMonth0(n2);
        if ((n7 += 2) >= n3) return;
        if (string2.charAt(n7) == '-' && n7 + 2 < n3) {
            n2 = DateTimeUtil.parseInt(string2, ++n7, n7 + 2);
            if (n7 + 2 < n3) {
                if (string2.charAt(n7 + 2) == ':') {
                    this.parseTimeZone(string2, n7 - 1, n3);
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string2}));
                }
                if (string2.charAt(n7 + 2) == 'T') {
                    this.setDay0(n2);
                    this.parseTime(string2, n7 + 3, n3);
                    if (this.isValid()) return;
                    throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "datetime"}));
                }
                if (string2.charAt(n7 + 2) != '-' && string2.charAt(n7 + 2) != '+' && string2.charAt(n7 + 2) != 'Z') throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string2}));
                this.setDay0(n2);
                this.parseTimeZone(string2, n7 + 2, n3);
                if (this.isValid()) return;
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "datetime"}));
            }
            this.setDay0(n2);
            if (this.isValid()) return;
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidDateTimeValue", new Object[]{string2, "date"}));
        }
        if ((string2.charAt(n7) != '+' || n7 + 6 != n3) && (string2.charAt(n7) != 'Z' || n7 + 1 != n3)) throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string2}));
        this.parseTimeZone(string2, n7, n3);
        if (this.isValid()) return;
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidLexicalValue", new Object[]{string2}));
    }

    private void setYearAfterCheck(String string2, int n2) {
        int n3 = string2.charAt(0) == '-' ? 1 : 0;
        int n4 = n2 - n3;
        if (string2.charAt(n3) == '0' && n4 > 4) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "NoLeadingZeros", new Object[]{string2}));
        }
        if (n4 < 4) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidYearSyntax", new Object[]{string2}));
        }
        if (n4 < 10) {
            int n5 = DateTimeUtil.parseInt(string2, n3, n2);
            this.setYear0(n3 == 0 ? n5 : -n5);
        } else {
            try {
                this.setYear0(new BigInteger(string2.substring(0, n2)));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.getMessage());
            }
        }
    }

    public XMLGregorianCalendarImpl(GregorianCalendar gregorianCalendar) {
        this.setYear0(gregorianCalendar.get(0) == 0 ? -gregorianCalendar.get(1) : gregorianCalendar.get(1));
        this.setMonth0(gregorianCalendar.get(2) + 1);
        this.setDay0(gregorianCalendar.get(5));
        this.setHour0(gregorianCalendar.get(9) == 0 ? gregorianCalendar.get(10) : 12 + gregorianCalendar.get(10));
        this.setMinute0(gregorianCalendar.get(12));
        this.setSecond0(gregorianCalendar.get(13));
        this.setMillisecond0(gregorianCalendar.get(14));
        this.setTimezone0((gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 60000);
    }

    public XMLGregorianCalendarImpl(BigInteger bigInteger, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7) {
        this.setYear0(bigInteger);
        this.setMonth0(n2);
        this.setDay0(n3);
        this.setHour0(n4);
        this.setMinute0(n5);
        this.setSecond0(n6);
        this.setFractionalSecond0(bigDecimal);
        this.setTimezone0(n7);
    }

    public XMLGregorianCalendarImpl(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setYear0(n2);
        this.setMonth0(n3);
        this.setDay0(n4);
        this.setHour0(n5);
        this.setMinute0(n6);
        this.setSecond0(n7);
        if (n8 == Integer.MIN_VALUE) {
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
        } else {
            if (n8 < 0 || n8 > 1000) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"millisecond", "0", "1000", String.valueOf(this.millisecond)}));
            }
            this.millisecond = n8 + 196608;
            this.fracSeconds = null;
        }
        this.setTimezone0(n9);
    }

    public XMLGregorianCalendarImpl(int n2, int n3, int n4, int n5, int n6, int n7, BigDecimal bigDecimal, int n8) {
        this.setYear0(n2);
        this.setMonth0(n3);
        this.setDay0(n4);
        this.setHour0(n5);
        this.setMinute0(n6);
        this.setSecond0(n7);
        this.setFractionalSecond0(bigDecimal);
        this.setTimezone0(n8);
    }

    private void saveInitialValues() {
        if (this.initialValues == null) {
            this.initialValues = new XMLGregorianCalendarSnapshot(this);
        }
    }

    private void parseTime(String string2, int n2, int n3) throws RuntimeException {
        int n4 = n2 + 2;
        this.setHour0(DateTimeUtil.parseInt(string2, n2, n4));
        if (n4 >= n3) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string2}));
        }
        if (string2.charAt(n4++) != ':') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string2}));
        }
        n2 = n4;
        this.setMinute0(DateTimeUtil.parseInt(string2, n2, n4 += 2));
        if (n4 >= n3) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string2}));
        }
        if (string2.charAt(n4++) != ':') {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string2}));
        }
        int n5 = this.findUTCSign(string2, n2, n3);
        n2 = n4;
        n4 = n5 < 0 ? n3 : n5;
        int n6 = DateTimeUtil.indexOf(string2, n2, n4, '.');
        this.setSecond0(DateTimeUtil.parseInt(string2, n2, n6 != -1 ? n6 : n4));
        if (n6 != -1) {
            try {
                int n7 = n4 - n6;
                if (n7 > 1 && n7 <= 4) {
                    int n8 = DateTimeUtil.parseInt(string2, n6 + 1, n4);
                    if (n7 == 2) {
                        n8 *= 100;
                    } else if (n7 == 3) {
                        n8 = (n8 << 3) + (n8 << 1);
                    }
                    this.millisecond = n8 + (n7 - 1 << 16);
                } else {
                    this.millisecond = -1;
                    this.fracSeconds = new BigDecimal(string2.substring(n6, n4));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeValue", new Object[]{string2}));
            }
        }
        if (n5 > 0) {
            this.getTimeZone(string2, n5, n3);
        }
    }

    private void parseTimeZone(String string2, int n2, int n3) throws RuntimeException {
        if (n2 < n3) {
            int n4 = this.findUTCSign(string2, n2, n3);
            if (n4 < 0) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string2}));
            }
            this.getTimeZone(string2, n4, n3);
        }
    }

    private int findUTCSign(String string2, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            char c = string2.charAt(i);
            if (c != 'Z' && c != '+' && c != '-') continue;
            return i;
        }
        return -1;
    }

    private void getTimeZone(String string2, int n2, int n3) throws RuntimeException {
        int n4;
        int n5;
        if (string2.charAt(n2) == 'Z') {
            if (n3 > ++n2) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string2}));
            }
            this.setTimezone0(0);
            return;
        }
        if (n2 <= n3 - 6) {
            int n6 = string2.charAt(n2) == '-' ? -1 : 1;
            int n7 = ++n2 + 2;
            n5 = n6 * DateTimeUtil.parseInt(string2, n2, n7);
            if (string2.charAt(n7++) != ':') {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string2}));
            }
            n4 = n6 * DateTimeUtil.parseInt(string2, n7, n7 + 2);
            if (n7 + 2 != n3) {
                throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string2}));
            }
        } else {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidTimeZoneValue", new Object[]{string2}));
        }
        this.setTimezone0(n5 * 60 + n4);
    }

    @Override
    public void clear() {
        this.saveInitialValues();
        this.eon = null;
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.millisecond = Integer.MIN_VALUE;
        this.fracSeconds = null;
        this.timezone = Integer.MIN_VALUE;
    }

    @Override
    public void reset() {
        if (this.initialValues != null) {
            this.eon = this.initialValues.eon;
            this.year = this.initialValues.year;
            this.month = this.initialValues.month;
            this.day = this.initialValues.day;
            this.hour = this.initialValues.hour;
            this.minute = this.initialValues.minute;
            this.second = this.initialValues.second;
            this.millisecond = this.initialValues.millisecond;
            this.fracSeconds = this.initialValues.fracSeconds;
            this.timezone = this.initialValues.timezone;
        }
    }

    @Override
    public void setYear(BigInteger bigInteger) {
        this.saveInitialValues();
        this.setYear0(bigInteger);
    }

    private void setYear0(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
            return;
        }
        if (bigInteger.compareTo(MAX_INT_B) >= 0 || bigInteger.compareTo(MAX_INT_B_NEGATIVE) <= 0) {
            BigInteger bigInteger2 = bigInteger.remainder(MAX_INT_B);
            this.eon = bigInteger.subtract(bigInteger2);
            this.year = bigInteger2.intValue();
        } else {
            this.eon = null;
            this.year = bigInteger.intValue();
        }
    }

    @Override
    public void setYear(int n2) {
        this.saveInitialValues();
        this.setYear0(n2);
    }

    private void setYear0(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.year = n2;
            this.eon = null;
            return;
        }
        if (n2 < 1000000000 && n2 > -1000000000) {
            this.eon = null;
            this.year = n2;
        } else {
            this.setYear0(BigInteger.valueOf(n2));
        }
    }

    private int maxDaysInMonthFor(BigInteger bigInteger, int n2) {
        if (n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) {
            return 30;
        }
        if (n2 == 2) {
            if (XMLGregorianCalendarImpl.isLeapYear(bigInteger)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static final boolean isLeapYear(BigInteger bigInteger) {
        return bigInteger.mod(BigInteger.valueOf(4L)).equals(BigInteger.ZERO) && (!bigInteger.mod(BigInteger.valueOf(100L)).equals(BigInteger.ZERO) || bigInteger.mod(BigInteger.valueOf(400L)).equals(BigInteger.ZERO));
    }

    private int maxDaysInMonthFor(int n2, int n3) {
        if (n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11) {
            return 30;
        }
        if (n3 == 2) {
            if (XMLGregorianCalendarImpl.isLeapYear(n2)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private static final boolean isLeapYear(int n2) {
        return n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0);
    }

    @Override
    public void setMonth(int n2) {
        this.saveInitialValues();
        this.setMonth0(n2);
    }

    private void setMonth0(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.month = n2;
            return;
        }
        if (n2 <= 0 || n2 > 12) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"month", "1", "12", String.valueOf(n2)}));
        }
        this.month = n2;
    }

    @Override
    public void setDay(int n2) {
        this.saveInitialValues();
        this.setDay0(n2);
    }

    private void setDay0(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.day = n2;
            return;
        }
        if (n2 < 1 || n2 > 31) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"day", "1", "31", String.valueOf(n2)}));
        }
        this.day = n2;
    }

    @Override
    public void setTimezone(int n2) {
        this.saveInitialValues();
        this.setTimezone0(n2);
    }

    private void setTimezone0(int n2) {
        if (n2 < -840 && n2 != Integer.MIN_VALUE || n2 > 840) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"offset", "-840", "840", String.valueOf(n2)}));
        }
        this.timezone = n2;
    }

    @Override
    public void setHour(int n2) {
        this.saveInitialValues();
        this.setHour0(n2);
    }

    private void setHour0(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.hour = n2;
            return;
        }
        if (n2 < 0 || n2 > 24) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"hour", "0", "24", String.valueOf(n2)}));
        }
        this.hour = n2;
    }

    @Override
    public void setMinute(int n2) {
        this.saveInitialValues();
        this.setMinute0(n2);
    }

    private void setMinute0(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.minute = n2;
            return;
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"minute", "0", "59", String.valueOf(n2)}));
        }
        this.minute = n2;
    }

    @Override
    public void setSecond(int n2) {
        this.saveInitialValues();
        this.setSecond0(n2);
    }

    private void setSecond0(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.second = n2;
            return;
        }
        if (n2 < 0 || n2 > 60) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"second", "0", "60", String.valueOf(n2)}));
        }
        this.second = n2;
    }

    @Override
    public void setMillisecond(int n2) {
        this.saveInitialValues();
        this.setMillisecond0(n2);
    }

    private void setMillisecond0(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
            return;
        }
        if (n2 < 0 || n2 > 999) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"millisecond", "0", "1000", String.valueOf(n2)}));
        }
        this.millisecond = n2 + 196608;
        this.fracSeconds = null;
    }

    @Override
    public void setFractionalSecond(BigDecimal bigDecimal) {
        this.saveInitialValues();
        this.setFractionalSecond0(bigDecimal);
    }

    private void setFractionalSecond0(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
            return;
        }
        if (bigDecimal.compareTo(ZERO) < 0 || bigDecimal.compareTo(ONE) > 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "InvalidValueSet", new Object[]{"fractional", "0.0", "1.0", bigDecimal}));
        }
        int n2 = bigDecimal.scale();
        if (n2 > 0 && n2 <= 3) {
            int n3 = bigDecimal.unscaledValue().intValue();
            if (n2 == 1) {
                n3 *= 100;
            } else if (n2 == 2) {
                n3 = (n3 << 3) + (n3 << 1);
            }
            this.millisecond = n3 + (n2 << 16);
        } else {
            this.millisecond = -1;
        }
        this.fracSeconds = bigDecimal;
    }

    @Override
    public BigInteger getEon() {
        return this.eon;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public BigInteger getEonAndYear() {
        return this.getEonAndYear0(this.year);
    }

    private BigInteger getEonAndYear0(int n2) {
        if (n2 != Integer.MIN_VALUE) {
            if (this.eon != null) {
                if (n2 != 0) {
                    return this.eon.add(BigInteger.valueOf(n2));
                }
                return this.eon;
            }
            return BigInteger.valueOf(n2);
        }
        return null;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public int getTimezone() {
        return this.timezone;
    }

    @Override
    public int getHour() {
        return this.hour;
    }

    @Override
    public int getMinute() {
        return this.minute;
    }

    @Override
    public int getSecond() {
        return this.second;
    }

    @Override
    public int getMillisecond() {
        if (this.millisecond != Integer.MIN_VALUE) {
            if (this.millisecond != -1) {
                return this.millisecond & 0xFFFF;
            }
            return super.getMillisecond();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public BigDecimal getFractionalSecond() {
        if (this.fracSeconds != null) {
            return this.fracSeconds;
        }
        if (this.millisecond != Integer.MIN_VALUE) {
            int n2 = this.millisecond >> 16;
            int n3 = this.millisecond & 0xFFFF;
            if (n2 == 1) {
                n3 /= 100;
            } else if (n2 == 2) {
                n3 /= 10;
            }
            this.fracSeconds = BigDecimal.valueOf(n3, n2);
        }
        return this.fracSeconds;
    }

    @Override
    public int compare(XMLGregorianCalendar xMLGregorianCalendar) {
        QName qName = null;
        QName qName2 = null;
        try {
            qName = xMLGregorianCalendar.getXMLSchemaType();
            qName2 = this.getXMLSchemaType();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (!(qName == qName2 || qName != null && qName2 != null && qName.equals(qName2))) {
            return 2;
        }
        XMLGregorianCalendar xMLGregorianCalendar2 = this.normalize();
        XMLGregorianCalendar xMLGregorianCalendar3 = xMLGregorianCalendar.normalize();
        if (xMLGregorianCalendar2.getTimezone() == xMLGregorianCalendar3.getTimezone()) {
            return this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar3);
        }
        if (xMLGregorianCalendar2.getTimezone() == 0) {
            XMLGregorianCalendar xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar3.clone();
            xMLGregorianCalendar4.setTimezone(840);
            int n2 = this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar4.normalize());
            if (n2 == -1) {
                return n2;
            }
            xMLGregorianCalendar4 = (XMLGregorianCalendar)xMLGregorianCalendar3.clone();
            xMLGregorianCalendar4.setTimezone(-840);
            int n3 = this.compareOrder(xMLGregorianCalendar2, xMLGregorianCalendar4.normalize());
            if (n3 == 1) {
                return n3;
            }
            return 2;
        }
        if (xMLGregorianCalendar3.getTimezone() == 0) {
            XMLGregorianCalendar xMLGregorianCalendar5 = (XMLGregorianCalendar)xMLGregorianCalendar2.clone();
            xMLGregorianCalendar5.setTimezone(-840);
            int n4 = this.compareOrder(xMLGregorianCalendar5.normalize(), xMLGregorianCalendar3);
            if (n4 == -1) {
                return n4;
            }
            xMLGregorianCalendar5 = (XMLGregorianCalendar)xMLGregorianCalendar2.clone();
            xMLGregorianCalendar5.setTimezone(840);
            int n5 = this.compareOrder(xMLGregorianCalendar5.normalize(), xMLGregorianCalendar3);
            if (n5 == 1) {
                return n5;
            }
            return 2;
        }
        return 2;
    }

    private int compareOrder(XMLGregorianCalendar xMLGregorianCalendar, XMLGregorianCalendar xMLGregorianCalendar2) {
        BigDecimal bigDecimal;
        int n2;
        BigInteger bigInteger;
        BigInteger bigInteger2 = xMLGregorianCalendar.getEonAndYear();
        if (bigInteger2 != (bigInteger = xMLGregorianCalendar2.getEonAndYear())) {
            if (bigInteger2 == null || bigInteger == null) {
                return 2;
            }
            n2 = bigInteger2.compareTo(bigInteger);
            if (n2 != 0) {
                if (n2 == 1) {
                    return 1;
                }
                return -1;
            }
        }
        if ((n2 = this.checkValue(xMLGregorianCalendar.getMonth(), xMLGregorianCalendar2.getMonth())) != 0) {
            return n2;
        }
        n2 = this.checkValue(xMLGregorianCalendar.getDay(), xMLGregorianCalendar2.getDay());
        if (n2 != 0) {
            return n2;
        }
        n2 = this.checkValue(xMLGregorianCalendar.getHour(), xMLGregorianCalendar2.getHour());
        if (n2 != 0) {
            return n2;
        }
        n2 = this.checkValue(xMLGregorianCalendar.getMinute(), xMLGregorianCalendar2.getMinute());
        if (n2 != 0) {
            return n2;
        }
        n2 = this.checkValue(xMLGregorianCalendar.getSecond(), xMLGregorianCalendar2.getSecond());
        if (n2 != 0) {
            return n2;
        }
        BigDecimal bigDecimal2 = xMLGregorianCalendar.getFractionalSecond();
        if (bigDecimal2 == (bigDecimal = xMLGregorianCalendar2.getFractionalSecond())) {
            return 0;
        }
        n2 = (bigDecimal2 == null ? ZERO : bigDecimal2).compareTo(bigDecimal == null ? ZERO : bigDecimal);
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 1) {
            return 1;
        }
        return -1;
    }

    private int checkValue(int n2, int n3) {
        if (n2 == n3) {
            return 0;
        }
        if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
            return 2;
        }
        if (n2 < n3) {
            return -1;
        }
        return 1;
    }

    @Override
    public XMLGregorianCalendar normalize() {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl = this;
        if (this.timezone != Integer.MIN_VALUE && this.timezone != 0) {
            xMLGregorianCalendarImpl = (XMLGregorianCalendarImpl)this.clone();
            xMLGregorianCalendarImpl.add(new DurationImpl(this.timezone > 0 ? -1 : 1, I_ZERO, I_ZERO, I_ZERO, I_ZERO, this.timezone > 0 ? BigInteger.valueOf(this.timezone) : BigInteger.valueOf(-this.timezone), ZERO));
            xMLGregorianCalendarImpl.timezone = 0;
            xMLGregorianCalendarImpl.initialValues = null;
        }
        return xMLGregorianCalendarImpl;
    }

    @Override
    public String toXMLFormat() {
        QName qName = this.getXMLSchemaType();
        StringBuilder stringBuilder = new StringBuilder();
        if (qName == DatatypeConstants.DATETIME) {
            this.writeYear(stringBuilder, this.year);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.month);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.day);
            stringBuilder.append('T');
            this.writeIntTwoDigits(stringBuilder, this.hour);
            stringBuilder.append(':');
            this.writeIntTwoDigits(stringBuilder, this.minute);
            stringBuilder.append(':');
            this.writeIntTwoDigits(stringBuilder, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeMilliseconds(stringBuilder);
                } else {
                    stringBuilder.append(this.toString(this.fracSeconds).substring(1));
                }
            }
        } else if (qName == DatatypeConstants.DATE) {
            this.writeYear(stringBuilder, this.year);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.month);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.day);
        } else if (qName == DatatypeConstants.TIME) {
            this.writeIntTwoDigits(stringBuilder, this.hour);
            stringBuilder.append(':');
            this.writeIntTwoDigits(stringBuilder, this.minute);
            stringBuilder.append(':');
            this.writeIntTwoDigits(stringBuilder, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeMilliseconds(stringBuilder);
                } else {
                    stringBuilder.append(this.toString(this.fracSeconds).substring(1));
                }
            }
        } else if (qName == DatatypeConstants.GYEAR) {
            this.writeYear(stringBuilder, this.year);
        } else if (qName == DatatypeConstants.GMONTH) {
            stringBuilder.append("--");
            this.writeIntTwoDigits(stringBuilder, this.month);
            stringBuilder.append("--");
        } else if (qName == DatatypeConstants.GDAY) {
            stringBuilder.append("---");
            this.writeIntTwoDigits(stringBuilder, this.day);
        } else if (qName == DatatypeConstants.GYEARMONTH) {
            this.writeYear(stringBuilder, this.year);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.month);
        } else if (qName == DatatypeConstants.GMONTHDAY) {
            stringBuilder.append("--");
            this.writeIntTwoDigits(stringBuilder, this.month);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.day);
        }
        return this.getTimezoneString(stringBuilder);
    }

    private void writeYear(StringBuilder stringBuilder, int n2) {
        if (this.eon == null) {
            int n3 = n2;
            if (n3 < 0) {
                stringBuilder.append('-');
                n3 = -n2;
            }
            if (n3 < 10000) {
                this.writeIntFourDigits(stringBuilder, n3);
            } else {
                stringBuilder.append(Integer.toString(n3));
            }
        } else {
            stringBuilder.append(this.getEonAndYear0(n2).toString());
        }
    }

    private void writeIntTwoDigits(StringBuilder stringBuilder, int n2) {
        int n3 = n2 / 10;
        int n4 = n2 - (n3 << 3) - (n3 << 1);
        stringBuilder.append((char)(n3 + 48));
        stringBuilder.append((char)(n4 + 48));
    }

    private void writeIntFourDigits(StringBuilder stringBuilder, int n2) {
        int n3 = n2 / 10;
        int n4 = n2 - (n3 << 3) - (n3 << 1);
        n2 = n3;
        n3 = n2 / 10;
        int n5 = n2 - (n3 << 3) - (n3 << 1);
        n2 = n3;
        n3 = n2 / 10;
        int n6 = n2 - (n3 << 3) - (n3 << 1);
        stringBuilder.append((char)(n3 + 48));
        stringBuilder.append((char)(n6 + 48));
        stringBuilder.append((char)(n5 + 48));
        stringBuilder.append((char)(n4 + 48));
    }

    private void writeMilliseconds(StringBuilder stringBuilder) {
        int n2 = this.millisecond >> 16;
        int n3 = this.millisecond & 0xFFFF;
        stringBuilder.append('.');
        int n4 = n3 / 10;
        int n5 = n3 - (n4 << 3) - (n4 << 1);
        n3 = n4;
        n4 = n3 / 10;
        int n6 = n3 - (n4 << 3) - (n4 << 1);
        stringBuilder.append((char)(n4 + 48));
        if (n2 > 1) {
            stringBuilder.append((char)(n6 + 48));
            if (n2 > 2) {
                stringBuilder.append((char)(n5 + 48));
            }
        }
    }

    private String getTimezoneString(StringBuilder stringBuilder) {
        if (this.timezone != Integer.MIN_VALUE) {
            if (this.timezone != 0) {
                int n2 = this.timezone < 0 ? -1 : 1;
                int n3 = this.timezone / 60 * n2;
                int n4 = this.timezone % 60 * n2;
                stringBuilder.append(n2 == -1 ? (char)'-' : '+');
                this.writeIntTwoDigits(stringBuilder, n3);
                stringBuilder.append(':');
                this.writeIntTwoDigits(stringBuilder, n4);
                return stringBuilder.toString();
            }
            stringBuilder.append('Z');
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    @Override
    public QName getXMLSchemaType() {
        boolean bl;
        boolean bl2 = this.hour != Integer.MIN_VALUE;
        boolean bl3 = this.minute != Integer.MIN_VALUE;
        boolean bl4 = bl = this.second != Integer.MIN_VALUE;
        if (bl2 && bl3 && bl) {
            if (this.year != Integer.MIN_VALUE && this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE) {
                return DatatypeConstants.DATETIME;
            }
            if (this.year == Integer.MIN_VALUE && this.month == Integer.MIN_VALUE && this.day == Integer.MIN_VALUE) {
                return DatatypeConstants.TIME;
            }
        } else if (!(bl2 || bl3 || bl)) {
            boolean bl5;
            boolean bl6 = this.year != Integer.MIN_VALUE;
            boolean bl7 = this.month != Integer.MIN_VALUE;
            boolean bl8 = bl5 = this.day != Integer.MIN_VALUE;
            if (bl6) {
                if (bl7 && bl5) {
                    return DatatypeConstants.DATE;
                }
                if (bl7 && !bl5) {
                    return DatatypeConstants.GYEARMONTH;
                }
                if (!bl7 && !bl5) {
                    return DatatypeConstants.GYEAR;
                }
            } else {
                if (bl7) {
                    if (bl5) {
                        return DatatypeConstants.GMONTHDAY;
                    }
                    return DatatypeConstants.GMONTH;
                }
                if (bl5) {
                    return DatatypeConstants.GDAY;
                }
            }
        }
        throw new IllegalStateException(DatatypeMessageFormatter.formatMessage(null, "InvalidFieldsSet", new Object[]{this.year != Integer.MIN_VALUE ? String.valueOf(this.year) : "FIELD_UNDEFINED", this.month != Integer.MIN_VALUE ? String.valueOf(this.month) : "FIELD_UNDEFINED", this.day != Integer.MIN_VALUE ? String.valueOf(this.day) : "FIELD_UNDEFINED", this.hour != Integer.MIN_VALUE ? String.valueOf(this.hour) : "FIELD_UNDEFINED", this.minute != Integer.MIN_VALUE ? String.valueOf(this.minute) : "FIELD_UNDEFINED", this.second != Integer.MIN_VALUE ? String.valueOf(this.second) : "FIELD_UNDEFINED", this.millisecond != Integer.MIN_VALUE ? this.getFractionalSecond().toString() : "FIELD_UNDEFINED", this.timezone != Integer.MIN_VALUE ? String.valueOf(this.timezone) : "FIELD_UNDEFINED"}));
    }

    @Override
    public boolean isValid() {
        if (this.month != Integer.MIN_VALUE && this.day != Integer.MIN_VALUE && (this.year != Integer.MIN_VALUE ? this.day > this.maxDaysInMonthFor(this.year, this.month) : this.day > this.maxDaysInMonthFor(2000, this.month))) {
            return false;
        }
        if (this.hour == 24 && (this.minute != 0 || this.second != 0 || this.millisecond != Integer.MIN_VALUE && (this.millisecond != -1 && (this.millisecond & 0xFFFF) != 0 || this.fracSeconds != null && this.fracSeconds.compareTo(ZERO) != 0))) {
            return false;
        }
        if (this.eon == null && this.year == 0) {
            return false;
        }
        return this.millisecond == Integer.MIN_VALUE || this.second != Integer.MIN_VALUE;
    }

    @Override
    public void add(Duration duration2) {
        this.saveInitialValues();
        boolean[] blArray = new boolean[]{this.eon == null, this.year == Integer.MIN_VALUE, this.month == Integer.MIN_VALUE, this.day == Integer.MIN_VALUE, this.hour == Integer.MIN_VALUE, this.minute == Integer.MIN_VALUE, this.second == Integer.MIN_VALUE, this.millisecond == Integer.MIN_VALUE};
        int n2 = duration2.getSign();
        BigInteger bigInteger = (BigInteger)duration2.getField(DatatypeConstants.MONTHS);
        BigInteger bigInteger2 = BigInteger.valueOf(this.month != Integer.MIN_VALUE ? (long)this.month : 1L).add(bigInteger != null ? (n2 == -1 ? bigInteger.negate() : bigInteger) : I_ZERO);
        this.month = DateTimeUtil.modulo(bigInteger2, I_ONE, THIRTEEN).intValue();
        BigInteger bigInteger3 = DateTimeUtil.fQuotient(bigInteger2, I_ONE, THIRTEEN);
        BigInteger bigInteger4 = this.getEonAndYear();
        BigInteger bigInteger5 = (BigInteger)duration2.getField(DatatypeConstants.YEARS);
        this.setYear0((bigInteger4 != null ? bigInteger4 : I_ZERO).add(bigInteger5 != null ? (n2 == -1 ? bigInteger5.negate() : bigInteger5) : I_ZERO).add(bigInteger3));
        BigDecimal bigDecimal = duration2.isSet(DatatypeConstants.SECONDS) ? (n2 == -1 ? ((BigDecimal)duration2.getField(DatatypeConstants.SECONDS)).negate() : (BigDecimal)duration2.getField(DatatypeConstants.SECONDS)) : ZERO;
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, 2);
        int n3 = (this.second != Integer.MIN_VALUE ? this.second : 0) + bigDecimal2.intValue();
        if (this.getFractionalSecond() != null) {
            this.millisecond = -1;
        }
        BigDecimal bigDecimal3 = this.fracSeconds != null ? (n2 > 0 ? this.fracSeconds.subtract(bigDecimal.subtract(bigDecimal2)) : this.fracSeconds.add(bigDecimal.subtract(bigDecimal2))) : (this.fracSeconds = bigDecimal.subtract(bigDecimal2));
        if (this.fracSeconds != null) {
            this.millisecond = -1;
        }
        int n4 = DateTimeUtil.fQuotient(n3, 60);
        this.second = DateTimeUtil.mod(n3, 60, n4);
        n3 = (this.minute != Integer.MIN_VALUE ? this.minute : 0) + n2 * duration2.getMinutes() + n4;
        n4 = DateTimeUtil.fQuotient(n3, 60);
        this.minute = DateTimeUtil.mod(n3, 60, n4);
        n3 = (this.hour != Integer.MIN_VALUE ? this.hour : 0) + n2 * duration2.getHours() + n4;
        n4 = DateTimeUtil.fQuotient(n3, 24);
        this.hour = DateTimeUtil.mod(n3, 24, n4);
        this.day = (this.day != Integer.MIN_VALUE ? this.day : 1) + n2 * duration2.getDays() + n4;
        while (true) {
            int n5 = this.eon != null ? this.maxDaysInMonthFor(this.eon.add(this.year != Integer.MIN_VALUE ? BigInteger.valueOf(this.year) : BigInteger.valueOf(2000L)), this.month != Integer.MIN_VALUE ? this.month : 1) : (n3 = DateTimeUtil.maxDayInMonthFor(this.year != Integer.MIN_VALUE ? this.year : 2000, this.month != Integer.MIN_VALUE ? this.month : 1));
            if (this.month < 1) {
                this.month += 12;
                BigInteger bigInteger6 = this.getEonAndYear();
                if (bigInteger6 != null) {
                    this.setYear0(bigInteger6.subtract(I_ONE));
                    continue;
                }
                this.setYear0(-1);
                continue;
            }
            if (this.month > 12) {
                this.month -= 12;
                BigInteger bigInteger7 = this.getEonAndYear();
                if (bigInteger7 != null) {
                    this.setYear0(bigInteger7.add(I_ONE));
                    continue;
                }
                this.setYear0(1);
                continue;
            }
            if (this.day < 1) {
                this.day += this.eon != null ? this.maxDaysInMonthFor(this.eon.add(this.year != Integer.MIN_VALUE ? BigInteger.valueOf(this.year) : BigInteger.valueOf(2000L)), (this.month != Integer.MIN_VALUE ? this.month : 1) - 1) : DateTimeUtil.maxDayInMonthFor(this.year != Integer.MIN_VALUE ? this.year : 2000, (this.month != Integer.MIN_VALUE ? this.month : 1) - 1);
                n4 = -1;
            } else if (this.day > n3) {
                this.day -= n3;
                n4 = 1;
            } else {
                if (this.hour < 0) {
                    this.hour += 24;
                    --this.day;
                    continue;
                }
                if (this.hour > 24) {
                    this.hour -= 24;
                    ++this.day;
                    continue;
                }
                if (this.minute < 0) {
                    this.minute += 60;
                    --this.hour;
                    continue;
                }
                if (this.minute > 60) {
                    this.minute -= 60;
                    ++this.hour;
                    continue;
                }
                if (this.second < 0) {
                    this.second += 60;
                    --this.minute;
                    continue;
                }
                if (this.second > 60) {
                    this.second -= 60;
                    ++this.minute;
                    continue;
                }
                if (this.fracSeconds.compareTo(ZERO) == -1) {
                    this.fracSeconds = this.fracSeconds.add(ONE);
                    --this.second;
                    continue;
                }
                if (this.fracSeconds.compareTo(ONE) != 1) break;
                this.fracSeconds = this.fracSeconds.subtract(ONE);
                ++this.second;
                continue;
            }
            n3 = this.month + n4;
            this.month = DateTimeUtil.modulo(n3, 1, 13);
            int n6 = DateTimeUtil.fQuotient(n3, 1, 13);
            this.setYear0(this.year + n6);
        }
        if (blArray[0] && blArray[1]) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
        }
        if (blArray[2]) {
            this.month = Integer.MIN_VALUE;
        }
        if (blArray[3]) {
            this.day = Integer.MIN_VALUE;
        }
        if (blArray[4]) {
            this.hour = Integer.MIN_VALUE;
        }
        if (blArray[5]) {
            this.minute = Integer.MIN_VALUE;
        }
        if (blArray[6] && blArray[7]) {
            this.second = Integer.MIN_VALUE;
            this.millisecond = Integer.MIN_VALUE;
            this.fracSeconds = null;
        }
    }

    @Override
    public GregorianCalendar toGregorianCalendar() {
        return this.toGregorianCalendar(null, null, null);
    }

    @Override
    public GregorianCalendar toGregorianCalendar(TimeZone timeZone, Locale locale, XMLGregorianCalendar xMLGregorianCalendar) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl;
        boolean bl2 = bl = xMLGregorianCalendar != null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone != null ? timeZone : this.getTimeZone(bl ? xMLGregorianCalendar.getTimezone() : Integer.MIN_VALUE), locale != null ? locale : Locale.getDefault());
        gregorianCalendar.clear();
        gregorianCalendar.setGregorianChange(PURE_GREGORIAN_CALENDAR_CHANGE);
        if (this.year != Integer.MIN_VALUE) {
            if (this.eon == null) {
                gregorianCalendar.set(0, this.year < 0 ? 0 : 1);
                gregorianCalendar.set(1, Math.abs(this.year));
            } else {
                BigInteger bigInteger = this.getEonAndYear();
                gregorianCalendar.set(0, bigInteger.signum() == -1 ? 0 : 1);
                gregorianCalendar.set(1, bigInteger.abs().intValue());
            }
        } else if (bl && (n8 = xMLGregorianCalendar.getYear()) != Integer.MIN_VALUE) {
            if (xMLGregorianCalendar.getEon() == null) {
                gregorianCalendar.set(0, n8 < 0 ? 0 : 1);
                gregorianCalendar.set(1, Math.abs(n8));
            } else {
                BigInteger bigInteger = xMLGregorianCalendar.getEonAndYear();
                gregorianCalendar.set(0, bigInteger.signum() == -1 ? 0 : 1);
                gregorianCalendar.set(1, bigInteger.abs().intValue());
            }
        }
        if (this.month != Integer.MIN_VALUE) {
            gregorianCalendar.set(2, this.month - 1);
        } else if (bl && (n7 = xMLGregorianCalendar.getMonth()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(2, n7 - 1);
        }
        if (this.day != Integer.MIN_VALUE) {
            gregorianCalendar.set(5, this.day);
        } else if (bl && (n6 = xMLGregorianCalendar.getDay()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(5, n6);
        }
        if (this.hour != Integer.MIN_VALUE) {
            gregorianCalendar.set(11, this.hour);
        } else if (bl && (n5 = xMLGregorianCalendar.getHour()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(11, n5);
        }
        if (this.minute != Integer.MIN_VALUE) {
            gregorianCalendar.set(12, this.minute);
        } else if (bl && (n4 = xMLGregorianCalendar.getMinute()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(12, n4);
        }
        if (this.second != Integer.MIN_VALUE) {
            gregorianCalendar.set(13, this.second);
        } else if (bl && (n3 = xMLGregorianCalendar.getSecond()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(13, n3);
        }
        if (this.millisecond != Integer.MIN_VALUE) {
            gregorianCalendar.set(14, this.getMillisecond());
        } else if (bl && (n2 = xMLGregorianCalendar.getMillisecond()) != Integer.MIN_VALUE) {
            gregorianCalendar.set(14, n2);
        }
        return gregorianCalendar;
    }

    @Override
    public TimeZone getTimeZone(int n2) {
        int n3;
        int n4 = n3 = this.timezone != Integer.MIN_VALUE ? this.timezone : n2;
        if (n3 == Integer.MIN_VALUE) {
            return TimeZone.getDefault();
        }
        int n5 = n3 >= 0 ? n3 : -n3;
        int n6 = n5 / 60;
        int n7 = n5 % 60;
        StringBuilder stringBuilder = new StringBuilder(9);
        stringBuilder.append("GMT");
        stringBuilder.append(n3 >= 0 ? (char)'+' : '-');
        if (n6 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n6);
        stringBuilder.append(':');
        if (n7 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n7);
        return TimeZone.getTimeZone(stringBuilder.toString());
    }

    @Override
    public Object clone() {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl = new XMLGregorianCalendarImpl();
        xMLGregorianCalendarImpl.eon = this.eon;
        xMLGregorianCalendarImpl.year = this.year;
        xMLGregorianCalendarImpl.month = this.month;
        xMLGregorianCalendarImpl.day = this.day;
        xMLGregorianCalendarImpl.hour = this.hour;
        xMLGregorianCalendarImpl.minute = this.minute;
        xMLGregorianCalendarImpl.second = this.second;
        xMLGregorianCalendarImpl.millisecond = this.millisecond;
        xMLGregorianCalendarImpl.fracSeconds = this.fracSeconds;
        xMLGregorianCalendarImpl.timezone = this.timezone;
        xMLGregorianCalendarImpl.initialValues = this.initialValues;
        return xMLGregorianCalendarImpl;
    }

    private String toString(BigDecimal bigDecimal) {
        StringBuilder stringBuilder;
        String string2 = bigDecimal.unscaledValue().toString();
        int n2 = bigDecimal.scale();
        if (n2 == 0) {
            return string2;
        }
        int n3 = string2.length() - n2;
        if (n3 == 0) {
            return "0." + string2;
        }
        if (n3 > 0) {
            stringBuilder = new StringBuilder(string2);
            stringBuilder.insert(n3, '.');
        } else {
            stringBuilder = new StringBuilder(3 - n3 + string2.length());
            stringBuilder.append("0.");
            for (int i = 0; i < -n3; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private Object writeReplace() throws IOException {
        return new SerializedXMLGregorianCalendar(this.toXMLFormat());
    }

    @Override
    public boolean isFractionalSecondInMilliseconds() {
        return this.millisecond != Integer.MIN_VALUE && this.millisecond != -1;
    }

    @Override
    public int getFractionalSecondScale() {
        if (this.fracSeconds != null) {
            return this.fracSeconds.scale();
        }
        if (this.millisecond != Integer.MIN_VALUE) {
            return this.millisecond >> 16;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarDateTime(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setTime(0, 0, 0);
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarDate(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarTime(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.TIME) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarGYear(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GYEAR) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarGMonth(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GMONTH) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarGDay(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMonth(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GDAY) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarGYearMonth(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setDay(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GYEARMONTH) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public XMLGregorianCalendar2 asXMLGregorianCalendarGMonthDay(boolean bl) {
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl;
        QName qName = this.getXMLSchemaType();
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl = bl ? this : (XMLGregorianCalendarImpl)this.clone();
        if (qName == DatatypeConstants.DATETIME) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setHour(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMinute(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setSecond(Integer.MIN_VALUE);
            xMLGregorianCalendarImpl.setMillisecond(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.DATE) {
            xMLGregorianCalendarImpl.setYear(Integer.MIN_VALUE);
            return xMLGregorianCalendarImpl;
        }
        if (qName == DatatypeConstants.GMONTHDAY) {
            return xMLGregorianCalendarImpl;
        }
        throw new IllegalStateException();
    }

    @Override
    public String toFOFormat() {
        QName qName = this.getXMLSchemaType();
        StringBuilder stringBuilder = new StringBuilder();
        if (qName == DatatypeConstants.DATETIME) {
            if (this.hour != 24) {
                this.writeYear(stringBuilder, this.year);
                stringBuilder.append('-');
                this.writeIntTwoDigits(stringBuilder, this.month);
                stringBuilder.append('-');
                this.writeIntTwoDigits(stringBuilder, this.day);
                stringBuilder.append('T');
                this.writeIntTwoDigits(stringBuilder, this.hour);
                stringBuilder.append(':');
            } else {
                this.writeDateOfFollowingDay(stringBuilder);
                stringBuilder.append("T00:");
            }
            this.writeIntTwoDigits(stringBuilder, this.minute);
            stringBuilder.append(':');
            this.writeIntTwoDigits(stringBuilder, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeFOMilliseconds(stringBuilder);
                } else {
                    this.writeFOFractionalSeconds(stringBuilder);
                }
            }
        } else if (qName == DatatypeConstants.DATE) {
            this.writeYear(stringBuilder, this.year);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.month);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.day);
        } else if (qName == DatatypeConstants.TIME) {
            if (this.hour != 24) {
                this.writeIntTwoDigits(stringBuilder, this.hour);
                stringBuilder.append(':');
            } else {
                stringBuilder.append("00:");
            }
            this.writeIntTwoDigits(stringBuilder, this.minute);
            stringBuilder.append(':');
            this.writeIntTwoDigits(stringBuilder, this.second);
            if (this.millisecond != Integer.MIN_VALUE) {
                if (this.millisecond != -1) {
                    this.writeFOMilliseconds(stringBuilder);
                } else {
                    this.writeFOFractionalSeconds(stringBuilder);
                }
            }
        } else if (qName == DatatypeConstants.GYEAR) {
            this.writeYear(stringBuilder, this.year);
        } else if (qName == DatatypeConstants.GMONTH) {
            stringBuilder.append("--");
            this.writeIntTwoDigits(stringBuilder, this.month);
        } else if (qName == DatatypeConstants.GDAY) {
            stringBuilder.append("---");
            this.writeIntTwoDigits(stringBuilder, this.day);
        } else if (qName == DatatypeConstants.GYEARMONTH) {
            this.writeYear(stringBuilder, this.year);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.month);
        } else if (qName == DatatypeConstants.GMONTHDAY) {
            stringBuilder.append("--");
            this.writeIntTwoDigits(stringBuilder, this.month);
            stringBuilder.append('-');
            this.writeIntTwoDigits(stringBuilder, this.day);
        }
        return this.getTimezoneString(stringBuilder);
    }

    private void writeDateOfFollowingDay(StringBuilder stringBuilder) {
        int n2 = this.year;
        int n3 = this.month;
        int n4 = this.day;
        if (++n4 > this.maxDaysInMonthFor(n2, n3)) {
            n4 = 1;
            if (++n3 > 12) {
                n3 = 1;
                if (++n2 == 0 && this.eon == null) {
                    n2 = 1;
                }
            }
        }
        this.writeYear(stringBuilder, n2);
        stringBuilder.append('-');
        this.writeIntTwoDigits(stringBuilder, n3);
        stringBuilder.append('-');
        this.writeIntTwoDigits(stringBuilder, n4);
    }

    private void writeFOMilliseconds(StringBuilder stringBuilder) {
        int n2 = this.millisecond & 0xFFFF;
        if (n2 != 0) {
            stringBuilder.append('.');
            int n3 = n2 / 10;
            int n4 = n2 - (n3 << 3) - (n3 << 1);
            n2 = n3;
            n3 = n2 / 10;
            int n5 = n2 - (n3 << 3) - (n3 << 1);
            stringBuilder.append((char)(n3 + 48));
            if (n5 != 0 || n4 != 0) {
                stringBuilder.append((char)(n5 + 48));
                if (n4 != 0) {
                    stringBuilder.append((char)(n4 + 48));
                }
            }
        }
    }

    private void writeFOFractionalSeconds(StringBuilder stringBuilder) {
        if (ZERO.compareTo(this.fracSeconds) != 0) {
            stringBuilder.append(this.fracSeconds.stripTrailingZeros().toPlainString().substring(1));
        }
    }

    private static final class XMLGregorianCalendarSnapshot {
        public final BigInteger eon;
        public final int year;
        public final int month;
        public final int day;
        public final int hour;
        public final int minute;
        public final int second;
        public final int millisecond;
        public final BigDecimal fracSeconds;
        public final int timezone;

        public XMLGregorianCalendarSnapshot(XMLGregorianCalendarImpl xMLGregorianCalendarImpl) {
            this.eon = xMLGregorianCalendarImpl.eon;
            this.year = xMLGregorianCalendarImpl.year;
            this.month = xMLGregorianCalendarImpl.month;
            this.day = xMLGregorianCalendarImpl.day;
            this.hour = xMLGregorianCalendarImpl.hour;
            this.minute = xMLGregorianCalendarImpl.minute;
            this.second = xMLGregorianCalendarImpl.second;
            this.millisecond = xMLGregorianCalendarImpl.millisecond;
            this.fracSeconds = xMLGregorianCalendarImpl.fracSeconds;
            this.timezone = xMLGregorianCalendarImpl.timezone;
        }
    }
}

