/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.jaxp.datatype;

import com.ibm.xml.jaxp.datatype.Duration2;
import com.ibm.xml.xml4j.internal.s1.jaxp.datatype.AbstractDurationImpl;
import com.ibm.xml.xml4j.internal.s1.jaxp.datatype.SerializedDuration;
import com.ibm.xml.xml4j.internal.s1.util.DatatypeMessageFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.Duration;

final class LightweightDurationImpl
extends AbstractDurationImpl
implements Serializable {
    private static final long serialVersionUID = -1423382419642387690L;
    private final int sign;
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;

    private static int getSign(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!(n2 != Integer.MIN_VALUE && n2 != 0 || n3 != Integer.MIN_VALUE && n3 != 0 || n4 != Integer.MIN_VALUE && n4 != 0 || n5 != Integer.MIN_VALUE && n5 != 0 || n6 != Integer.MIN_VALUE && n6 != 0 || n7 != Integer.MIN_VALUE && n7 != 0)) {
            return 0;
        }
        return bl ? 1 : -1;
    }

    public LightweightDurationImpl(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(LightweightDurationImpl.getSign(bl, n2, n3, n4, n5, n6, n7), n2, n3, n4, n5, n6, n7);
    }

    public LightweightDurationImpl(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.sign = LightweightDurationImpl.getSign(bl, n2, n3, n4, n5, n6, n7);
        this.years = n2;
        this.months = n3;
        this.days = n4;
        this.hours = n5;
        this.minutes = n6;
        this.seconds = n7;
    }

    public LightweightDurationImpl(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.sign = n2;
        if (n3 != Integer.MIN_VALUE && n3 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "YearsCannotBeNegative", new Object[]{Integer.toString(n3)}));
        }
        this.years = n3;
        if (n4 != Integer.MIN_VALUE && n4 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MonthsCannotBeNegative", new Object[]{Integer.toString(n4)}));
        }
        this.months = n4;
        if (n5 != Integer.MIN_VALUE && n5 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "DaysCannotBeNegative", new Object[]{Integer.toString(n5)}));
        }
        this.days = n5;
        if (n6 != Integer.MIN_VALUE && n6 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "HoursCannotBeNegative", new Object[]{Integer.toString(n6)}));
        }
        this.hours = n6;
        if (n7 != Integer.MIN_VALUE && n7 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "MinutesCannotBeNegative", new Object[]{Integer.toString(n7)}));
        }
        this.minutes = n7;
        if (n8 != Integer.MIN_VALUE && n8 < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "SecondsCannotBeNegative", new Object[]{Integer.toString(n8)}));
        }
        this.seconds = n8;
    }

    @Override
    BigInteger getYearsField() {
        return this.years != Integer.MIN_VALUE ? BigInteger.valueOf(this.years) : null;
    }

    @Override
    BigInteger getMonthsField() {
        return this.months != Integer.MIN_VALUE ? BigInteger.valueOf(this.months) : null;
    }

    @Override
    BigInteger getDaysField() {
        return this.days != Integer.MIN_VALUE ? BigInteger.valueOf(this.days) : null;
    }

    @Override
    BigInteger getHoursField() {
        return this.hours != Integer.MIN_VALUE ? BigInteger.valueOf(this.hours) : null;
    }

    @Override
    BigInteger getMinutesField() {
        return this.minutes != Integer.MIN_VALUE ? BigInteger.valueOf(this.minutes) : null;
    }

    @Override
    BigDecimal getSecondsField() {
        return this.seconds != Integer.MIN_VALUE ? BigDecimal.valueOf(this.seconds) : null;
    }

    @Override
    public int getYears() {
        return this.years != Integer.MIN_VALUE ? this.years : 0;
    }

    @Override
    public int getMonths() {
        return this.months != Integer.MIN_VALUE ? this.months : 0;
    }

    @Override
    public int getDays() {
        return this.days != Integer.MIN_VALUE ? this.days : 0;
    }

    @Override
    public int getHours() {
        return this.hours != Integer.MIN_VALUE ? this.hours : 0;
    }

    @Override
    public int getMinutes() {
        return this.minutes != Integer.MIN_VALUE ? this.minutes : 0;
    }

    @Override
    public int getSeconds() {
        return this.seconds != Integer.MIN_VALUE ? this.seconds : 0;
    }

    @Override
    public int getSign() {
        return this.sign;
    }

    @Override
    boolean isYearsSet() {
        return this.years != Integer.MIN_VALUE;
    }

    @Override
    boolean isMonthsSet() {
        return this.months != Integer.MIN_VALUE;
    }

    @Override
    boolean isDaysSet() {
        return this.days != Integer.MIN_VALUE;
    }

    @Override
    boolean isHoursSet() {
        return this.hours != Integer.MIN_VALUE;
    }

    @Override
    boolean isMinutesSet() {
        return this.minutes != Integer.MIN_VALUE;
    }

    @Override
    boolean isSecondsSet() {
        return this.seconds != Integer.MIN_VALUE;
    }

    @Override
    public Duration multiply(int n2) {
        int n3;
        int n4 = Math.abs(n2);
        int n5 = n3 = n4 != 0 ? Integer.MAX_VALUE / n4 : Integer.MAX_VALUE;
        if (!(this.years != Integer.MIN_VALUE && this.years > n3 || this.months != Integer.MIN_VALUE && this.months > n3 || this.days != Integer.MIN_VALUE && this.days > n3 || this.hours != Integer.MIN_VALUE && this.hours > n3 || this.minutes != Integer.MIN_VALUE && this.minutes > n3 || this.seconds != Integer.MIN_VALUE && this.seconds > n3)) {
            int n6 = n2 > 0 ? 1 : (n2 < 0 ? -1 : 0);
            return new LightweightDurationImpl(this.sign * n6, this.years != Integer.MIN_VALUE ? this.years * n4 : Integer.MIN_VALUE, this.months != Integer.MIN_VALUE ? this.months * n4 : Integer.MIN_VALUE, this.days != Integer.MIN_VALUE ? this.days * n4 : Integer.MIN_VALUE, this.hours != Integer.MIN_VALUE ? this.hours * n4 : Integer.MIN_VALUE, this.minutes != Integer.MIN_VALUE ? this.minutes * n4 : Integer.MIN_VALUE, this.seconds != Integer.MIN_VALUE ? this.seconds * n4 : Integer.MIN_VALUE);
        }
        return super.multiply(n2);
    }

    @Override
    public Duration negate() {
        return new LightweightDurationImpl(-this.sign, this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    @Override
    public Duration normalizeWith(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, this.sign * this.getYears());
        calendar2.add(2, this.sign * this.getMonths());
        calendar2.add(5, this.sign * this.getDays());
        long l = calendar2.getTime().getTime() - calendar.getTime().getTime();
        int n2 = (int)(l / 86400000L);
        int n3 = 1;
        if (!(n2 != 0 || this.hours != Integer.MIN_VALUE && this.hours != 0 || this.minutes != Integer.MIN_VALUE && this.minutes != 0 || this.seconds != Integer.MIN_VALUE && this.seconds != 0)) {
            n3 = 0;
        } else if (n2 < 0) {
            n3 = -1;
        }
        return new LightweightDurationImpl(n3, Integer.MIN_VALUE, Integer.MIN_VALUE, Math.abs(n2), this.hours, this.minutes, this.seconds);
    }

    @Override
    public String toString() {
        char[] cArray = new char[16];
        int n2 = 0;
        if (this.sign == -1) {
            cArray[n2++] = 45;
        }
        cArray[n2++] = 80;
        if (this.years != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n2 += LightweightDurationImpl.getCharLength(this.years)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n2, this.years);
            cArray[n2++] = 89;
        }
        if (this.months != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n2 += LightweightDurationImpl.getCharLength(this.months)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n2, this.months);
            cArray[n2++] = 77;
        }
        if (this.days != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n2 += LightweightDurationImpl.getCharLength(this.days)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n2, this.days);
            cArray[n2++] = 68;
        }
        if (this.hours != Integer.MIN_VALUE || this.minutes != Integer.MIN_VALUE || this.seconds != Integer.MIN_VALUE) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, n2 + 1);
            cArray[n2++] = 84;
            if (this.hours != Integer.MIN_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n2 += LightweightDurationImpl.getCharLength(this.hours)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n2, this.hours);
                cArray[n2++] = 72;
            }
            if (this.minutes != Integer.MIN_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n2 += LightweightDurationImpl.getCharLength(this.minutes)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n2, this.minutes);
                cArray[n2++] = 77;
            }
            if (this.seconds != Integer.MIN_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n2 += LightweightDurationImpl.getCharLength(this.seconds)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n2, this.seconds);
                cArray[n2++] = 83;
            }
        }
        return new String(cArray, 0, n2);
    }

    private static void writeIntToBuffer(char[] cArray, int n2, int n3) {
        do {
            int n4 = n3 / 10;
            int n5 = n3 - (n4 << 3) - (n4 << 1);
            n3 = n4;
            cArray[--n2] = (char)(n5 + 48);
        } while (n3 > 0);
    }

    private static void writeLongToBuffer(char[] cArray, int n2, long l) {
        do {
            long l2 = l / 10L;
            long l3 = l - (l2 << 3) - (l2 << 1);
            l = l2;
            cArray[--n2] = (char)(l3 + 48L);
        } while (l > 0L);
    }

    private static int getCharLength(int n2) {
        if (n2 < 10) {
            return 1;
        }
        if (n2 < 100) {
            return 2;
        }
        if (n2 < 1000) {
            return 3;
        }
        if (n2 < 10000) {
            return 4;
        }
        if (n2 < 100000) {
            return 5;
        }
        if (n2 < 1000000) {
            return 6;
        }
        if (n2 < 10000000) {
            return 7;
        }
        if (n2 < 100000000) {
            return 8;
        }
        if (n2 < 1000000000) {
            return 9;
        }
        return 10;
    }

    private static char[] ensureBufferCapacity(char[] cArray, int n2) {
        if (n2 > cArray.length) {
            char[] cArray2 = new char[n2 << 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            return cArray2;
        }
        return cArray;
    }

    @Override
    BigDecimal[] createBigDecimalArray() {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this.years != Integer.MIN_VALUE ? BigDecimal.valueOf(this.years) : ZERO, this.months != Integer.MIN_VALUE ? BigDecimal.valueOf(this.months) : ZERO, this.days != Integer.MIN_VALUE ? BigDecimal.valueOf(this.days) : ZERO, this.hours != Integer.MIN_VALUE ? BigDecimal.valueOf(this.hours) : ZERO, this.minutes != Integer.MIN_VALUE ? BigDecimal.valueOf(this.minutes) : ZERO, this.seconds != Integer.MIN_VALUE ? BigDecimal.valueOf(this.seconds) : ZERO};
        return bigDecimalArray;
    }

    private Object writeReplace() throws IOException {
        return new SerializedDuration(this.toString());
    }

    @Override
    public boolean areFieldsPrimitive() {
        return true;
    }

    @Override
    public boolean hasFractionalSeconds() {
        return false;
    }

    @Override
    public Duration2 asDurationYearMonth() {
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return ZERO_MONTHS;
        }
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return this;
        }
        return new LightweightDurationImpl(this.sign >= 0, this.years, this.months, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public Duration2 asDurationDayTime() {
        if (!(this.isDaysSet() || this.isHoursSet() || this.isMinutesSet() || this.isSecondsSet())) {
            return ZERO_SECONDS;
        }
        if (!this.isYearsSet() && !this.isMonthsSet()) {
            return this;
        }
        return new LightweightDurationImpl(this.sign >= 0, Integer.MIN_VALUE, Integer.MIN_VALUE, this.days, this.hours, this.minutes, this.seconds);
    }

    @Override
    public String toFOFormat() {
        int n2;
        int n3;
        long l;
        int n4;
        int n5;
        if (this.sign == 0) {
            return this.toZeroDurationFOStringFormat();
        }
        if (this.seconds != Integer.MIN_VALUE) {
            n5 = this.seconds % 60;
            n4 = this.seconds / 60;
        } else {
            n5 = 0;
            n4 = 0;
        }
        int n6 = 0;
        int n7 = 0;
        if (this.minutes != Integer.MIN_VALUE) {
            if (this.minutes > Integer.MAX_VALUE - n4) {
                long l2 = (long)this.minutes + (long)n4;
                n6 = (int)(l2 % 60L);
                n7 = (int)(l2 / 60L);
            } else {
                int n8 = this.minutes + n4;
                n6 = n8 % 60;
                n7 = n8 / 60;
            }
        } else if (n4 > 0) {
            n6 = n4 % 60;
            n7 = n4 / 60;
        }
        int n9 = 0;
        int n10 = 0;
        if (this.hours != Integer.MIN_VALUE) {
            if (this.hours > Integer.MAX_VALUE - n7) {
                l = (long)this.hours + (long)n7;
                n9 = (int)(l % 24L);
                n10 = (int)(l / 24L);
            } else {
                int n11 = this.hours + n7;
                n9 = n11 % 24;
                n10 = n11 / 24;
            }
        } else if (n7 > 0) {
            n9 = n7 % 24;
            n10 = n7 / 24;
        }
        l = 0L;
        l = this.days != Integer.MIN_VALUE ? (long)this.days + (long)n10 : (long)n10;
        if (this.months != Integer.MIN_VALUE) {
            n3 = this.months % 12;
            n2 = this.months / 12;
        } else {
            n3 = 0;
            n2 = 0;
        }
        long l3 = this.years != Integer.MIN_VALUE ? (long)this.years + (long)n2 : (long)n2;
        char[] cArray = new char[16];
        int n12 = 0;
        if (this.sign == -1) {
            cArray[n12++] = 45;
        }
        cArray[n12++] = 80;
        if (l3 > 0L) {
            if (l3 <= Integer.MAX_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += LightweightDurationImpl.getCharLength((int)l3)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n12, (int)l3);
            } else {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += 10) + 1);
                LightweightDurationImpl.writeLongToBuffer(cArray, n12, l3);
            }
            cArray[n12++] = 89;
        }
        if (n3 > 0) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += LightweightDurationImpl.getCharLength(n3)) + 1);
            LightweightDurationImpl.writeIntToBuffer(cArray, n12, n3);
            cArray[n12++] = 77;
        }
        if (l > 0L) {
            if (l <= Integer.MAX_VALUE) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += LightweightDurationImpl.getCharLength((int)l)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n12, (int)l);
            } else {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += 10) + 1);
                LightweightDurationImpl.writeLongToBuffer(cArray, n12, l);
            }
            cArray[n12++] = 68;
        }
        if (n9 > 0 || n6 > 0 || n5 > 0) {
            cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, n12 + 1);
            cArray[n12++] = 84;
            if (n9 > 0) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += LightweightDurationImpl.getCharLength(n9)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n12, n9);
                cArray[n12++] = 72;
            }
            if (n6 > 0) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += LightweightDurationImpl.getCharLength(n6)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n12, n6);
                cArray[n12++] = 77;
            }
            if (n5 > 0) {
                cArray = LightweightDurationImpl.ensureBufferCapacity(cArray, (n12 += LightweightDurationImpl.getCharLength(n5)) + 1);
                LightweightDurationImpl.writeIntToBuffer(cArray, n12, n5);
                cArray[n12++] = 83;
            }
        }
        return new String(cArray, 0, n12);
    }
}

