/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.xs.models;

import com.ibm.xml.xml4j.internal.s1.impl.XMLErrorReporter;
import com.ibm.xml.xml4j.internal.s1.impl.dtd.models.CMNode;
import com.ibm.xml.xml4j.internal.s1.impl.xs.models.XSCMBinOp;
import com.ibm.xml.xml4j.internal.s1.impl.xs.models.XSCMLeaf;
import com.ibm.xml.xml4j.internal.s1.impl.xs.models.XSCMRepeatingLeaf;
import com.ibm.xml.xml4j.internal.s1.impl.xs.models.XSCMUniOp;
import com.ibm.xml.xml4j.internal.s1.util.SecurityManager;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLComponentManager;
import com.ibm.xml.xml4j.internal.s1.xni.parser.XMLConfigurationException;

public class CMNodeFactory {
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final boolean DEBUG = false;
    private static final int MULTIPLICITY = 1;
    private int nodeCount = 0;
    private int maxNodeLimit;
    private XMLErrorReporter fErrorReporter;
    private SecurityManager fSecurityManager = null;

    public void reset(XMLComponentManager xMLComponentManager) {
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        try {
            this.fSecurityManager = (SecurityManager)xMLComponentManager.getProperty(SECURITY_MANAGER);
            if (this.fSecurityManager != null) {
                this.maxNodeLimit = this.fSecurityManager.getMaxOccurNodeLimit() * 1;
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSecurityManager = null;
        }
    }

    public CMNode getCMLeafNode(int n2, Object object2, int n3, int n4) {
        this.nodeCountCheck();
        return new XSCMLeaf(n2, object2, n3, n4);
    }

    public CMNode getCMRepeatingLeafNode(int n2, Object object2, int n3, int n4, int n5, int n6) {
        this.nodeCountCheck();
        return new XSCMRepeatingLeaf(n2, object2, n3, n4, n5, n6);
    }

    public CMNode getCMUniOpNode(int n2, CMNode cMNode) {
        this.nodeCountCheck();
        return new XSCMUniOp(n2, cMNode);
    }

    public CMNode getCMBinOpNode(int n2, CMNode cMNode, CMNode cMNode2) {
        this.nodeCountCheck();
        return new XSCMBinOp(n2, cMNode, cMNode2);
    }

    public void nodeCountCheck() {
        if (this.fSecurityManager != null && this.nodeCount++ > this.maxNodeLimit) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "maxOccurLimit", new Object[]{new Integer(this.maxNodeLimit)}, (short)2);
            this.nodeCount = 0;
        }
    }

    public void resetNodeCount() {
        this.nodeCount = 0;
    }

    public void setProperty(String string2, Object object2) throws XMLConfigurationException {
        if (string2.startsWith("http://apache.org/xml/properties/")) {
            int n2 = string2.length() - "http://apache.org/xml/properties/".length();
            if (n2 == "security-manager".length() && string2.endsWith("security-manager")) {
                this.fSecurityManager = (SecurityManager)object2;
                this.maxNodeLimit = this.fSecurityManager != null ? this.fSecurityManager.getMaxOccurNodeLimit() * 1 : 0;
                return;
            }
            if (n2 == "internal/error-reporter".length() && string2.endsWith("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object2;
                return;
            }
        }
    }
}

