/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.xpath.regex;

import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.BMPattern;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.Match;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.Op;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.ParseException;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.ParserForXMLSchema;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.REUtil;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.RangeToken;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.RegexParser;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.Token;
import java.io.Serializable;
import java.text.CharacterIterator;
import java.util.Locale;

public class RegularExpression
implements Serializable {
    private static final long serialVersionUID = 6242499334195006401L;
    static final boolean DEBUG = false;
    String regex;
    int options;
    int nofparen;
    Token tokentree;
    boolean hasBackReferences = false;
    transient int minlength;
    transient Op operations = null;
    transient int numberOfClosures;
    transient Context context = null;
    transient RangeToken firstChar = null;
    transient String fixedString = null;
    transient int fixedStringOptions;
    transient BMPattern fixedStringTable = null;
    transient boolean fixedStringOnly = false;
    static final int IGNORE_CASE = 2;
    static final int SINGLE_LINE = 4;
    static final int MULTIPLE_LINES = 8;
    static final int EXTENDED_COMMENT = 16;
    static final int USE_UNICODE_CATEGORY = 32;
    static final int UNICODE_WORD_BOUNDARY = 64;
    static final int PROHIBIT_HEAD_CHARACTER_OPTIMIZATION = 128;
    static final int PROHIBIT_FIXED_STRING_OPTIMIZATION = 256;
    static final int XMLSCHEMA_MODE = 512;
    static final int SPECIAL_COMMA = 1024;
    private static final int WT_IGNORE = 0;
    private static final int WT_LETTER = 1;
    private static final int WT_OTHER = 2;
    static final int LINE_FEED = 10;
    static final int CARRIAGE_RETURN = 13;
    static final int LINE_SEPARATOR = 8232;
    static final int PARAGRAPH_SEPARATOR = 8233;

    private synchronized void compile(Token token) {
        if (this.operations != null) {
            return;
        }
        this.numberOfClosures = 0;
        this.operations = this.compile(token, null, false);
    }

    private Op compile(Token token, Op op2, boolean bl) {
        Op op3;
        switch (token.type) {
            case 11: {
                op3 = Op.createDot();
                op3.next = op2;
                break;
            }
            case 0: {
                op3 = Op.createChar(token.getChar());
                op3.next = op2;
                break;
            }
            case 8: {
                op3 = Op.createAnchor(token.getChar());
                op3.next = op2;
                break;
            }
            case 4: 
            case 5: {
                op3 = Op.createRange(token);
                op3.next = op2;
                break;
            }
            case 1: {
                op3 = op2;
                if (!bl) {
                    for (int i = token.size() - 1; i >= 0; --i) {
                        op3 = this.compile(token.getChild(i), op3, false);
                    }
                } else {
                    for (int i = 0; i < token.size(); ++i) {
                        op3 = this.compile(token.getChild(i), op3, true);
                    }
                }
                break;
            }
            case 2: {
                Op.UnionOp unionOp = Op.createUnion(token.size());
                for (int i = 0; i < token.size(); ++i) {
                    unionOp.addElement(this.compile(token.getChild(i), op2, bl));
                }
                op3 = unionOp;
                break;
            }
            case 3: 
            case 9: {
                Token token2 = token.getChild(0);
                int n2 = token.getMin();
                int n3 = token.getMax();
                if (n2 >= 0 && n2 == n3) {
                    op3 = op2;
                    for (int i = 0; i < n2; ++i) {
                        op3 = this.compile(token2, op3, bl);
                    }
                } else {
                    if (n2 > 0 && n3 > 0) {
                        n3 -= n2;
                    }
                    if (n3 > 0) {
                        op3 = op2;
                        for (int i = 0; i < n3; ++i) {
                            Op.ChildOp childOp = Op.createQuestion(token.type == 9);
                            childOp.next = op2;
                            childOp.setChild(this.compile(token2, op3, bl));
                            op3 = childOp;
                        }
                    } else {
                        Op.ChildOp childOp = token.type == 9 ? Op.createNonGreedyClosure() : (token2.getMinLength() == 0 ? Op.createClosure(this.numberOfClosures++) : Op.createClosure(-1));
                        childOp.next = op2;
                        childOp.setChild(this.compile(token2, childOp, bl));
                        op3 = childOp;
                    }
                    if (n2 <= 0) break;
                    for (int i = 0; i < n2; ++i) {
                        op3 = this.compile(token2, op3, bl);
                    }
                }
                break;
            }
            case 7: {
                op3 = op2;
                break;
            }
            case 10: {
                op3 = Op.createString(token.getString());
                op3.next = op2;
                break;
            }
            case 12: {
                op3 = Op.createBackReference(token.getReferenceNumber());
                op3.next = op2;
                break;
            }
            case 6: {
                if (token.getParenNumber() == 0) {
                    op3 = this.compile(token.getChild(0), op2, bl);
                    break;
                }
                if (bl) {
                    op2 = Op.createCapture(token.getParenNumber(), op2);
                    op2 = this.compile(token.getChild(0), op2, bl);
                    op3 = Op.createCapture(-token.getParenNumber(), op2);
                    break;
                }
                op2 = Op.createCapture(-token.getParenNumber(), op2);
                op2 = this.compile(token.getChild(0), op2, bl);
                op3 = Op.createCapture(token.getParenNumber(), op2);
                break;
            }
            case 20: {
                op3 = Op.createLook(20, op2, this.compile(token.getChild(0), null, false));
                break;
            }
            case 21: {
                op3 = Op.createLook(21, op2, this.compile(token.getChild(0), null, false));
                break;
            }
            case 22: {
                op3 = Op.createLook(22, op2, this.compile(token.getChild(0), null, true));
                break;
            }
            case 23: {
                op3 = Op.createLook(23, op2, this.compile(token.getChild(0), null, true));
                break;
            }
            case 24: {
                op3 = Op.createIndependent(op2, this.compile(token.getChild(0), null, bl));
                break;
            }
            case 25: {
                op3 = Op.createModifier(op2, this.compile(token.getChild(0), null, bl), ((Token.ModifierToken)token).getOptions(), ((Token.ModifierToken)token).getOptionsMask());
                break;
            }
            case 26: {
                Token.ConditionToken conditionToken = (Token.ConditionToken)token;
                int n4 = conditionToken.refNumber;
                Op op4 = conditionToken.condition == null ? null : this.compile(conditionToken.condition, null, bl);
                Op op5 = this.compile(conditionToken.yes, op2, bl);
                Op op6 = conditionToken.no == null ? null : this.compile(conditionToken.no, op2, bl);
                op3 = Op.createCondition(op2, n4, op4, op5, op6);
                break;
            }
            default: {
                throw new RuntimeException("Unknown token type: " + token.type);
            }
        }
        return op3;
    }

    public boolean matches(char[] cArray) {
        return this.matches(cArray, 0, cArray.length, (Match)null);
    }

    public boolean matches(char[] cArray, int n2, int n3) {
        return this.matches(cArray, n2, n3, (Match)null);
    }

    public boolean matches(char[] cArray, Match match) {
        return this.matches(cArray, 0, cArray.length, match);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(char[] cArray, int n2, int n3, Match match) {
        int n4;
        int n5;
        Object object2 = this;
        synchronized (object2) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object2 = null;
        Context context2 = this.context;
        synchronized (context2) {
            object2 = this.context.inuse ? new Context() : this.context;
            ((Context)object2).reset(cArray, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(cArray);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object2).match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchCharArray((Context)object2, this.operations, ((Context)object2).start, 1, this.options);
            if (n6 == ((Context)object2).limit) {
                if (((Context)object2).match != null) {
                    ((Context)object2).match.setBeginning(0, ((Context)object2).start);
                    ((Context)object2).match.setEnd(0, n6);
                }
                ((Context)object2).setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(cArray, ((Context)object2).start, ((Context)object2).limit);
            if (n7 >= 0) {
                if (((Context)object2).match != null) {
                    ((Context)object2).match.setBeginning(0, n7);
                    ((Context)object2).match.setEnd(0, n7 + this.fixedString.length());
                }
                ((Context)object2).setInUse(false);
                return true;
            }
            ((Context)object2).setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(cArray, ((Context)object2).start, ((Context)object2).limit)) < 0) {
            ((Context)object2).setInUse(false);
            return false;
        }
        int n8 = ((Context)object2).limit - this.minlength;
        int n9 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = ((Context)object2).start;
                n9 = this.matchCharArray((Context)object2, this.operations, ((Context)object2).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n4 = ((Context)object2).start; n4 <= n8; ++n4) {
                    char c = cArray[n4];
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n9 = this.matchCharArray((Context)object2, this.operations, n4, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                for (n4 = ((Context)object2).start; n4 <= n8; ++n4) {
                    char c;
                    int n10 = cArray[n4];
                    if (!REUtil.isHighSurrogate(n10) || n4 + 1 >= ((Context)object2).limit ? !rangeToken.match(n10) && !rangeToken.match(c = Character.toUpperCase((char)n10)) && !rangeToken.match(Character.toLowerCase(c)) : !rangeToken.match(n10 = REUtil.composeFromSurrogates(n10, cArray[n4 + 1]))) continue;
                    n9 = this.matchCharArray((Context)object2, this.operations, n4, 1, this.options);
                    if (0 > n9) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n4 = ((Context)object2).start; n4 <= n8; ++n4) {
                    int n11 = cArray[n4];
                    if (REUtil.isHighSurrogate(n11) && n4 + 1 < ((Context)object2).limit) {
                        n11 = REUtil.composeFromSurrogates(n11, cArray[n4 + 1]);
                    }
                    if (!rangeToken.match(n11) || 0 > (n9 = this.matchCharArray((Context)object2, this.operations, n4, 1, this.options))) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (n4 = ((Context)object2).start; n4 <= n8 && 0 > (n9 = this.matchCharArray((Context)object2, this.operations, n4, 1, this.options)); ++n4) {
            }
        }
        if (n9 >= 0) {
            if (((Context)object2).match != null) {
                ((Context)object2).match.setBeginning(0, n4);
                ((Context)object2).match.setEnd(0, n9);
            }
            ((Context)object2).setInUse(false);
            return true;
        }
        ((Context)object2).setInUse(false);
        return false;
    }

    private int matchCharArray(Context context2, Op op2, int n2, int n3, int n4) {
        char[] cArray = context2.charTarget;
        while (op2 != null) {
            if (n2 > context2.limit || n2 < context2.start) {
                return -1;
            }
            switch (op2.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op2.getData();
                        if (n3 > 0) {
                            if (n2 >= context2.limit || !RegularExpression.matchIgnoreCase(n5, cArray[n2])) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= context2.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, cArray[n6])) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op2.getData();
                        if (n3 > 0) {
                            if (n2 >= context2.limit || n5 != cArray[n2]) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= context2.limit || n7 < 0 || n5 != cArray[n7]) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op2 = op2.next;
                    break;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context2.limit) {
                            return -1;
                        }
                        n5 = cArray[n2];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, cArray[++n2]);
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context2.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = cArray[n5];
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(cArray[--n5], n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op2 = op2.next;
                    break;
                }
                case 3: 
                case 4: {
                    char c;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context2.limit) {
                            return -1;
                        }
                        n5 = cArray[n2];
                        if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, cArray[++n2]);
                        }
                        RangeToken rangeToken = op2.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n5);
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context2.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = cArray[n5];
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(cArray[--n5], n9);
                        }
                        RangeToken rangeToken = op2.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n9);
                                c = c2;
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op2 = op2.next;
                    break;
                }
                case 5: {
                    int n5 = 0;
                    switch (op2.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context2.start && (n2 <= context2.start || !RegularExpression.isEOLChar(cArray[n2 - 1])) : n2 != context2.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == context2.start || n2 > context2.start && RegularExpression.isEOLChar(cArray[n2 - 1])) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context2.limit && (n2 >= context2.limit || !RegularExpression.isEOLChar(cArray[n2])) : !(n2 == context2.limit || n2 + 1 == context2.limit && RegularExpression.isEOLChar(cArray[n2]) || n2 + 2 == context2.limit && cArray[n2] == '\r' && cArray[n2 + 1] == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == context2.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == context2.limit || n2 + 1 == context2.limit && RegularExpression.isEOLChar(cArray[n2]) || n2 + 2 == context2.limit && cArray[n2] == '\r' && cArray[n2 + 1] == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == context2.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context2.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(cArray, context2.start, context2.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            int n11 = RegularExpression.getPreviousWordType(cArray, context2.start, context2.limit, n2, n4);
                            if (n10 != n11) break;
                            return -1;
                        }
                        case 66: {
                            if (context2.length == 0) {
                                n5 = 1;
                            } else {
                                int n12 = RegularExpression.getWordType(cArray, context2.start, context2.limit, n2, n4);
                                int n6 = n5 = n12 == 0 || n12 == RegularExpression.getPreviousWordType(cArray, context2.start, context2.limit, n2, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context2.length == 0 || n2 == context2.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context2.start, context2.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(cArray, context2.start, context2.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context2.length == 0 || n2 == context2.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(cArray, context2.start, context2.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(cArray, context2.start, context2.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op2 = op2.next;
                    break;
                }
                case 16: {
                    int n14 = op2.getData();
                    if (n14 <= 0 || n14 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n14);
                    }
                    if (context2.match.getBeginning(n14) < 0 || context2.match.getEnd(n14) < 0) {
                        return -1;
                    }
                    int n15 = context2.match.getBeginning(n14);
                    char c = context2.match.getEnd(n14) - n15;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n2, context2.limit, n15, (int)c)) {
                                return -1;
                            }
                            n2 += c;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n2 - c, context2.limit, n15, (int)c)) {
                                return -1;
                            }
                            n2 -= c;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2, context2.limit, n15, (int)c)) {
                            return -1;
                        }
                        n2 += c;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2 - c, context2.limit, n15, (int)c)) {
                            return -1;
                        }
                        n2 -= c;
                    }
                    op2 = op2.next;
                    break;
                }
                case 6: {
                    String string2 = op2.getString();
                    int n16 = string2.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(cArray, n2, context2.limit, string2, n16)) {
                                return -1;
                            }
                            n2 += n16;
                        } else {
                            if (!RegularExpression.regionMatches(cArray, n2 - n16, context2.limit, string2, n16)) {
                                return -1;
                            }
                            n2 -= n16;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2, context2.limit, string2, n16)) {
                            return -1;
                        }
                        n2 += n16;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(cArray, n2 - n16, context2.limit, string2, n16)) {
                            return -1;
                        }
                        n2 -= n16;
                    }
                    op2 = op2.next;
                    break;
                }
                case 7: {
                    int n17 = op2.getData();
                    if (n17 >= 0) {
                        int n18 = context2.offsets[n17];
                        if (n18 < 0 || n18 != n2) {
                            context2.offsets[n17] = n2;
                        } else {
                            context2.offsets[n17] = -1;
                            op2 = op2.next;
                            break;
                        }
                    }
                    int n19 = this.matchCharArray(context2, op2.getChild(), n2, n3, n4);
                    if (n17 >= 0) {
                        context2.offsets[n17] = -1;
                    }
                    if (n19 >= 0) {
                        return n19;
                    }
                    op2 = op2.next;
                    break;
                }
                case 9: {
                    int n20 = this.matchCharArray(context2, op2.getChild(), n2, n3, n4);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op2 = op2.next;
                    break;
                }
                case 8: 
                case 10: {
                    int n21 = this.matchCharArray(context2, op2.next, n2, n3, n4);
                    if (n21 >= 0) {
                        return n21;
                    }
                    op2 = op2.getChild();
                    break;
                }
                case 11: {
                    for (int i = 0; i < op2.size(); ++i) {
                        int n22 = this.matchCharArray(context2, op2.elementAt(i), n2, n3, n4);
                        if (n22 < 0) continue;
                        return n22;
                    }
                    return -1;
                }
                case 15: {
                    int n23 = op2.getData();
                    if (context2.match != null && n23 > 0) {
                        int n24 = context2.match.getBeginning(n23);
                        context2.match.setBeginning(n23, n2);
                        int n7 = this.matchCharArray(context2, op2.next, n2, n3, n4);
                        if (n7 < 0) {
                            context2.match.setBeginning(n23, n24);
                        }
                        return n7;
                    }
                    if (context2.match != null && n23 < 0) {
                        int n25 = -n23;
                        int n8 = context2.match.getEnd(n25);
                        context2.match.setEnd(n25, n2);
                        int n9 = this.matchCharArray(context2, op2.next, n2, n3, n4);
                        if (n9 < 0) {
                            context2.match.setEnd(n25, n8);
                        }
                        return n9;
                    }
                    op2 = op2.next;
                    break;
                }
                case 20: {
                    if (0 > this.matchCharArray(context2, op2.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 21: {
                    if (0 <= this.matchCharArray(context2, op2.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 22: {
                    if (0 > this.matchCharArray(context2, op2.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 23: {
                    if (0 <= this.matchCharArray(context2, op2.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 24: {
                    int n27 = this.matchCharArray(context2, op2.getChild(), n2, n3, n4);
                    if (n27 < 0) {
                        return n27;
                    }
                    n2 = n27;
                    op2 = op2.next;
                    break;
                }
                case 25: {
                    int n28 = n4;
                    n28 |= op2.getData();
                    char c = this.matchCharArray(context2, op2.getChild(), n2, n3, n28 &= ~op2.getData2());
                    if (c < '\u0000') {
                        return c;
                    }
                    n2 = c;
                    op2 = op2.next;
                    break;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op2;
                    char c = '\u0000';
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        c = context2.match.getBeginning(conditionOp.refNumber) >= 0 && context2.match.getEnd(conditionOp.refNumber) >= 0 ? (char)'\u0001' : '\u0000';
                    } else {
                        char c3 = c = 0 <= this.matchCharArray(context2, conditionOp.condition, n2, n3, n4) ? (char)'\u0001' : '\u0000';
                    }
                    if (c != '\u0000') {
                        op2 = conditionOp.yes;
                        break;
                    }
                    if (conditionOp.no != null) {
                        op2 = conditionOp.no;
                        break;
                    }
                    op2 = conditionOp.next;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown operation type: " + op2.type);
                }
            }
        }
        return RegularExpression.isSet(n4, 512) && n2 != context2.limit ? -1 : n2;
    }

    private static final int getPreviousWordType(char[] cArray, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(cArray, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(cArray, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(cArray[n4], n5);
    }

    private static final boolean regionMatches(char[] cArray, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            if (cArray[n2++] == string2.charAt(n5++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            if (cArray[n2++] == cArray[n6++]) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n2++]) == (c3 = string2.charAt(n5++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(char[] cArray, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n2++]) == (c3 = cArray[n6++]) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(String string2) {
        return this.matches(string2, 0, string2.length(), (Match)null);
    }

    public boolean matches(String string2, int n2, int n3) {
        return this.matches(string2, n2, n3, (Match)null);
    }

    public boolean matches(String string2, Match match) {
        return this.matches(string2, 0, string2.length(), match);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(String string2, int n2, int n3, Match match) {
        int n4;
        int n5;
        Object object2 = this;
        synchronized (object2) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object2 = null;
        Context context2 = this.context;
        synchronized (context2) {
            object2 = this.context.inuse ? new Context() : this.context;
            ((Context)object2).reset(string2, n2, n3, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(string2);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object2).match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchString((Context)object2, this.operations, ((Context)object2).start, 1, this.options);
            if (n6 == ((Context)object2).limit) {
                if (((Context)object2).match != null) {
                    ((Context)object2).match.setBeginning(0, ((Context)object2).start);
                    ((Context)object2).match.setEnd(0, n6);
                }
                ((Context)object2).setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(string2, ((Context)object2).start, ((Context)object2).limit);
            if (n7 >= 0) {
                if (((Context)object2).match != null) {
                    ((Context)object2).match.setBeginning(0, n7);
                    ((Context)object2).match.setEnd(0, n7 + this.fixedString.length());
                }
                ((Context)object2).setInUse(false);
                return true;
            }
            ((Context)object2).setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n5 = this.fixedStringTable.matches(string2, ((Context)object2).start, ((Context)object2).limit)) < 0) {
            ((Context)object2).setInUse(false);
            return false;
        }
        int n8 = ((Context)object2).limit - this.minlength;
        int n9 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n4 = ((Context)object2).start;
                n9 = this.matchString((Context)object2, this.operations, ((Context)object2).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n4 = ((Context)object2).start; n4 <= n8; ++n4) {
                    char c = string2.charAt(n4);
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n9 = this.matchString((Context)object2, this.operations, n4, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                for (n4 = ((Context)object2).start; n4 <= n8; ++n4) {
                    char c;
                    int n10 = string2.charAt(n4);
                    if (!REUtil.isHighSurrogate(n10) || n4 + 1 >= ((Context)object2).limit ? !rangeToken.match(n10) && !rangeToken.match(c = Character.toUpperCase((char)n10)) && !rangeToken.match(Character.toLowerCase(c)) : !rangeToken.match(n10 = REUtil.composeFromSurrogates(n10, string2.charAt(n4 + 1)))) continue;
                    n9 = this.matchString((Context)object2, this.operations, n4, 1, this.options);
                    if (0 > n9) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n4 = ((Context)object2).start; n4 <= n8; ++n4) {
                    int n11 = string2.charAt(n4);
                    if (REUtil.isHighSurrogate(n11) && n4 + 1 < ((Context)object2).limit) {
                        n11 = REUtil.composeFromSurrogates(n11, string2.charAt(n4 + 1));
                    }
                    if (!rangeToken.match(n11) || 0 > (n9 = this.matchString((Context)object2, this.operations, n4, 1, this.options))) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (n4 = ((Context)object2).start; n4 <= n8 && 0 > (n9 = this.matchString((Context)object2, this.operations, n4, 1, this.options)); ++n4) {
            }
        }
        if (n9 >= 0) {
            if (((Context)object2).match != null) {
                ((Context)object2).match.setBeginning(0, n4);
                ((Context)object2).match.setEnd(0, n9);
            }
            ((Context)object2).setInUse(false);
            return true;
        }
        ((Context)object2).setInUse(false);
        return false;
    }

    private int matchString(Context context2, Op op2, int n2, int n3, int n4) {
        String string2 = context2.strTarget;
        while (op2 != null) {
            if (n2 > context2.limit || n2 < context2.start) {
                return -1;
            }
            switch (op2.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op2.getData();
                        if (n3 > 0) {
                            if (n2 >= context2.limit || !RegularExpression.matchIgnoreCase(n5, string2.charAt(n2))) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= context2.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, string2.charAt(n6))) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op2.getData();
                        if (n3 > 0) {
                            if (n2 >= context2.limit || n5 != string2.charAt(n2)) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= context2.limit || n7 < 0 || n5 != string2.charAt(n7)) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op2 = op2.next;
                    break;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context2.limit) {
                            return -1;
                        }
                        n5 = string2.charAt(n2);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, string2.charAt(++n2));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context2.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = string2.charAt(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(string2.charAt(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op2 = op2.next;
                    break;
                }
                case 3: 
                case 4: {
                    char c;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context2.limit) {
                            return -1;
                        }
                        n5 = string2.charAt(n2);
                        if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, string2.charAt(++n2));
                        }
                        RangeToken rangeToken = op2.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n5);
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context2.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = string2.charAt(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(string2.charAt(--n5), n9);
                        }
                        RangeToken rangeToken = op2.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n9);
                                c = c2;
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op2 = op2.next;
                    break;
                }
                case 5: {
                    int n5 = 0;
                    switch (op2.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context2.start && (n2 <= context2.start || !RegularExpression.isEOLChar(string2.charAt(n2 - 1))) : n2 != context2.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == context2.start || n2 > context2.start && RegularExpression.isEOLChar(string2.charAt(n2 - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context2.limit && (n2 >= context2.limit || !RegularExpression.isEOLChar(string2.charAt(n2))) : !(n2 == context2.limit || n2 + 1 == context2.limit && RegularExpression.isEOLChar(string2.charAt(n2)) || n2 + 2 == context2.limit && string2.charAt(n2) == '\r' && string2.charAt(n2 + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == context2.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == context2.limit || n2 + 1 == context2.limit && RegularExpression.isEOLChar(string2.charAt(n2)) || n2 + 2 == context2.limit && string2.charAt(n2) == '\r' && string2.charAt(n2 + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == context2.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context2.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(string2, context2.start, context2.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            int n11 = RegularExpression.getPreviousWordType(string2, context2.start, context2.limit, n2, n4);
                            if (n10 != n11) break;
                            return -1;
                        }
                        case 66: {
                            if (context2.length == 0) {
                                n5 = 1;
                            } else {
                                int n12 = RegularExpression.getWordType(string2, context2.start, context2.limit, n2, n4);
                                int n6 = n5 = n12 == 0 || n12 == RegularExpression.getPreviousWordType(string2, context2.start, context2.limit, n2, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context2.length == 0 || n2 == context2.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string2, context2.start, context2.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(string2, context2.start, context2.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context2.length == 0 || n2 == context2.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(string2, context2.start, context2.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(string2, context2.start, context2.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op2 = op2.next;
                    break;
                }
                case 16: {
                    int n14 = op2.getData();
                    if (n14 <= 0 || n14 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n14);
                    }
                    if (context2.match.getBeginning(n14) < 0 || context2.match.getEnd(n14) < 0) {
                        return -1;
                    }
                    int n15 = context2.match.getBeginning(n14);
                    char c = context2.match.getEnd(n14) - n15;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(string2, n2, context2.limit, n15, (int)c)) {
                                return -1;
                            }
                            n2 += c;
                        } else {
                            if (!RegularExpression.regionMatches(string2, n2 - c, context2.limit, n15, (int)c)) {
                                return -1;
                            }
                            n2 -= c;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2, context2.limit, n15, (int)c)) {
                            return -1;
                        }
                        n2 += c;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2 - c, context2.limit, n15, (int)c)) {
                            return -1;
                        }
                        n2 -= c;
                    }
                    op2 = op2.next;
                    break;
                }
                case 6: {
                    String string3 = op2.getString();
                    int n16 = string3.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(string2, n2, context2.limit, string3, n16)) {
                                return -1;
                            }
                            n2 += n16;
                        } else {
                            if (!RegularExpression.regionMatches(string2, n2 - n16, context2.limit, string3, n16)) {
                                return -1;
                            }
                            n2 -= n16;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2, context2.limit, string3, n16)) {
                            return -1;
                        }
                        n2 += n16;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(string2, n2 - n16, context2.limit, string3, n16)) {
                            return -1;
                        }
                        n2 -= n16;
                    }
                    op2 = op2.next;
                    break;
                }
                case 7: {
                    int n17 = op2.getData();
                    if (n17 >= 0) {
                        int n18 = context2.offsets[n17];
                        if (n18 < 0 || n18 != n2) {
                            context2.offsets[n17] = n2;
                        } else {
                            context2.offsets[n17] = -1;
                            op2 = op2.next;
                            break;
                        }
                    }
                    int n19 = this.matchString(context2, op2.getChild(), n2, n3, n4);
                    if (n17 >= 0) {
                        context2.offsets[n17] = -1;
                    }
                    if (n19 >= 0) {
                        return n19;
                    }
                    op2 = op2.next;
                    break;
                }
                case 9: {
                    int n20 = this.matchString(context2, op2.getChild(), n2, n3, n4);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op2 = op2.next;
                    break;
                }
                case 8: 
                case 10: {
                    int n21 = this.matchString(context2, op2.next, n2, n3, n4);
                    if (n21 >= 0) {
                        return n21;
                    }
                    op2 = op2.getChild();
                    break;
                }
                case 11: {
                    for (int i = 0; i < op2.size(); ++i) {
                        int n22 = this.matchString(context2, op2.elementAt(i), n2, n3, n4);
                        if (n22 < 0) continue;
                        return n22;
                    }
                    return -1;
                }
                case 15: {
                    int n23 = op2.getData();
                    if (context2.match != null && n23 > 0) {
                        int n24 = context2.match.getBeginning(n23);
                        context2.match.setBeginning(n23, n2);
                        int n7 = this.matchString(context2, op2.next, n2, n3, n4);
                        if (n7 < 0) {
                            context2.match.setBeginning(n23, n24);
                        }
                        return n7;
                    }
                    if (context2.match != null && n23 < 0) {
                        int n25 = -n23;
                        int n8 = context2.match.getEnd(n25);
                        context2.match.setEnd(n25, n2);
                        int n9 = this.matchString(context2, op2.next, n2, n3, n4);
                        if (n9 < 0) {
                            context2.match.setEnd(n25, n8);
                        }
                        return n9;
                    }
                    op2 = op2.next;
                    break;
                }
                case 20: {
                    if (0 > this.matchString(context2, op2.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 21: {
                    if (0 <= this.matchString(context2, op2.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 22: {
                    if (0 > this.matchString(context2, op2.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 23: {
                    if (0 <= this.matchString(context2, op2.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 24: {
                    int n27 = this.matchString(context2, op2.getChild(), n2, n3, n4);
                    if (n27 < 0) {
                        return n27;
                    }
                    n2 = n27;
                    op2 = op2.next;
                    break;
                }
                case 25: {
                    int n28 = n4;
                    n28 |= op2.getData();
                    char c = this.matchString(context2, op2.getChild(), n2, n3, n28 &= ~op2.getData2());
                    if (c < '\u0000') {
                        return c;
                    }
                    n2 = c;
                    op2 = op2.next;
                    break;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op2;
                    char c = '\u0000';
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        c = context2.match.getBeginning(conditionOp.refNumber) >= 0 && context2.match.getEnd(conditionOp.refNumber) >= 0 ? (char)'\u0001' : '\u0000';
                    } else {
                        char c3 = c = 0 <= this.matchString(context2, conditionOp.condition, n2, n3, n4) ? (char)'\u0001' : '\u0000';
                    }
                    if (c != '\u0000') {
                        op2 = conditionOp.yes;
                        break;
                    }
                    if (conditionOp.no != null) {
                        op2 = conditionOp.no;
                        break;
                    }
                    op2 = conditionOp.next;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown operation type: " + op2.type);
                }
            }
        }
        return RegularExpression.isSet(n4, 512) && n2 != context2.limit ? -1 : n2;
    }

    private static final int getPreviousWordType(String string2, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(string2, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(string2, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(String string2, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(string2.charAt(n4), n5);
    }

    private static final boolean regionMatches(String string2, int n2, int n3, String string3, int n4) {
        if (n3 - n2 < n4) {
            return false;
        }
        return string2.regionMatches(n2, string3, 0, n4);
    }

    private static final boolean regionMatches(String string2, int n2, int n3, int n4, int n5) {
        if (n3 - n2 < n5) {
            return false;
        }
        return string2.regionMatches(n2, string2, n4, n5);
    }

    private static final boolean regionMatchesIgnoreCase(String string2, int n2, int n3, String string3, int n4) {
        return string2.regionMatches(true, n2, string3, 0, n4);
    }

    private static final boolean regionMatchesIgnoreCase(String string2, int n2, int n3, int n4, int n5) {
        if (n3 - n2 < n5) {
            return false;
        }
        return string2.regionMatches(true, n2, string2, n4, n5);
    }

    public boolean matches(CharacterIterator characterIterator) {
        return this.matches(characterIterator, (Match)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(CharacterIterator characterIterator, Match match) {
        int n2;
        int n3;
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        Object object2 = this;
        synchronized (object2) {
            if (this.operations == null) {
                this.prepare();
            }
            if (this.context == null) {
                this.context = new Context();
            }
        }
        object2 = null;
        Context context2 = this.context;
        synchronized (context2) {
            object2 = this.context.inuse ? new Context() : this.context;
            ((Context)object2).reset(characterIterator, n4, n5, this.numberOfClosures);
        }
        if (match != null) {
            match.setNumberOfGroups(this.nofparen);
            match.setSource(characterIterator);
        } else if (this.hasBackReferences) {
            match = new Match();
            match.setNumberOfGroups(this.nofparen);
        }
        ((Context)object2).match = match;
        if (RegularExpression.isSet(this.options, 512)) {
            int n6 = this.matchCharacterIterator((Context)object2, this.operations, ((Context)object2).start, 1, this.options);
            if (n6 == ((Context)object2).limit) {
                if (((Context)object2).match != null) {
                    ((Context)object2).match.setBeginning(0, ((Context)object2).start);
                    ((Context)object2).match.setEnd(0, n6);
                }
                ((Context)object2).setInUse(false);
                return true;
            }
            return false;
        }
        if (this.fixedStringOnly) {
            int n7 = this.fixedStringTable.matches(characterIterator, ((Context)object2).start, ((Context)object2).limit);
            if (n7 >= 0) {
                if (((Context)object2).match != null) {
                    ((Context)object2).match.setBeginning(0, n7);
                    ((Context)object2).match.setEnd(0, n7 + this.fixedString.length());
                }
                ((Context)object2).setInUse(false);
                return true;
            }
            ((Context)object2).setInUse(false);
            return false;
        }
        if (this.fixedString != null && (n3 = this.fixedStringTable.matches(characterIterator, ((Context)object2).start, ((Context)object2).limit)) < 0) {
            ((Context)object2).setInUse(false);
            return false;
        }
        int n8 = ((Context)object2).limit - this.minlength;
        int n9 = -1;
        if (this.operations != null && this.operations.type == 7 && this.operations.getChild().type == 0) {
            if (RegularExpression.isSet(this.options, 4)) {
                n2 = ((Context)object2).start;
                n9 = this.matchCharacterIterator((Context)object2, this.operations, ((Context)object2).start, 1, this.options);
            } else {
                boolean bl = true;
                for (n2 = ((Context)object2).start; n2 <= n8; ++n2) {
                    char c = characterIterator.setIndex(n2);
                    if (RegularExpression.isEOLChar(c)) {
                        bl = true;
                        continue;
                    }
                    if (!bl || 0 > (n9 = this.matchCharacterIterator((Context)object2, this.operations, n2, 1, this.options))) {
                        bl = false;
                        continue;
                    }
                    break;
                }
            }
        } else if (this.firstChar != null) {
            RangeToken rangeToken = this.firstChar;
            if (RegularExpression.isSet(this.options, 2)) {
                rangeToken = this.firstChar.getCaseInsensitiveToken();
                for (n2 = ((Context)object2).start; n2 <= n8; ++n2) {
                    char c;
                    int n10 = characterIterator.setIndex(n2);
                    if (!REUtil.isHighSurrogate(n10) || n2 + 1 >= ((Context)object2).limit ? !rangeToken.match(n10) && !rangeToken.match(c = Character.toUpperCase((char)n10)) && !rangeToken.match(Character.toLowerCase(c)) : !rangeToken.match(n10 = REUtil.composeFromSurrogates(n10, characterIterator.setIndex(n2 + 1)))) continue;
                    n9 = this.matchCharacterIterator((Context)object2, this.operations, n2, 1, this.options);
                    if (0 > n9) {
                        continue;
                    }
                    break;
                }
            } else {
                for (n2 = ((Context)object2).start; n2 <= n8; ++n2) {
                    int n11 = characterIterator.setIndex(n2);
                    if (REUtil.isHighSurrogate(n11) && n2 + 1 < ((Context)object2).limit) {
                        n11 = REUtil.composeFromSurrogates(n11, characterIterator.setIndex(n2 + 1));
                    }
                    if (!rangeToken.match(n11) || 0 > (n9 = this.matchCharacterIterator((Context)object2, this.operations, n2, 1, this.options))) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            for (n2 = ((Context)object2).start; n2 <= n8 && 0 > (n9 = this.matchCharacterIterator((Context)object2, this.operations, n2, 1, this.options)); ++n2) {
            }
        }
        if (n9 >= 0) {
            if (((Context)object2).match != null) {
                ((Context)object2).match.setBeginning(0, n2);
                ((Context)object2).match.setEnd(0, n9);
            }
            ((Context)object2).setInUse(false);
            return true;
        }
        ((Context)object2).setInUse(false);
        return false;
    }

    private int matchCharacterIterator(Context context2, Op op2, int n2, int n3, int n4) {
        CharacterIterator characterIterator = context2.ciTarget;
        while (op2 != null) {
            if (n2 > context2.limit || n2 < context2.start) {
                return -1;
            }
            switch (op2.type) {
                case 1: {
                    int n5;
                    if (RegularExpression.isSet(n4, 2)) {
                        n5 = op2.getData();
                        if (n3 > 0) {
                            if (n2 >= context2.limit || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n2))) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n6 = n2 - 1;
                            if (n6 >= context2.limit || n6 < 0 || !RegularExpression.matchIgnoreCase(n5, characterIterator.setIndex(n6))) {
                                return -1;
                            }
                            n2 = n6;
                        }
                    } else {
                        n5 = op2.getData();
                        if (n3 > 0) {
                            if (n2 >= context2.limit || n5 != characterIterator.setIndex(n2)) {
                                return -1;
                            }
                            ++n2;
                        } else {
                            int n7 = n2 - 1;
                            if (n7 >= context2.limit || n7 < 0 || n5 != characterIterator.setIndex(n7)) {
                                return -1;
                            }
                            n2 = n7;
                        }
                    }
                    op2 = op2.next;
                    break;
                }
                case 0: {
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context2.limit) {
                            return -1;
                        }
                        n5 = characterIterator.setIndex(n2);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                                ++n2;
                            }
                        } else {
                            if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                                n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n2));
                            }
                            if (RegularExpression.isEOLChar(n5)) {
                                return -1;
                            }
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context2.limit || n5 < 0) {
                            return -1;
                        }
                        int n8 = characterIterator.setIndex(n5);
                        if (RegularExpression.isSet(n4, 4)) {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                // empty if block
                            }
                        } else {
                            if (REUtil.isLowSurrogate(n8) && n5 - 1 >= 0) {
                                n8 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n8);
                            }
                            if (!RegularExpression.isEOLChar(n8)) {
                                return -1;
                            }
                        }
                        n2 = --n5;
                    }
                    op2 = op2.next;
                    break;
                }
                case 3: 
                case 4: {
                    char c;
                    int n5;
                    if (n3 > 0) {
                        if (n2 >= context2.limit) {
                            return -1;
                        }
                        n5 = characterIterator.setIndex(n2);
                        if (REUtil.isHighSurrogate(n5) && n2 + 1 < context2.limit) {
                            n5 = REUtil.composeFromSurrogates(n5, characterIterator.setIndex(++n2));
                        }
                        RangeToken rangeToken = op2.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n5)) {
                                if (n5 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n5);
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c2))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n5)) {
                            return -1;
                        }
                        ++n2;
                    } else {
                        n5 = n2 - 1;
                        if (n5 >= context2.limit || n5 < 0) {
                            return -1;
                        }
                        int n9 = characterIterator.setIndex(n5);
                        if (REUtil.isLowSurrogate(n9) && n5 - 1 >= 0) {
                            n9 = REUtil.composeFromSurrogates(characterIterator.setIndex(--n5), n9);
                        }
                        RangeToken rangeToken = op2.getToken();
                        if (RegularExpression.isSet(n4, 2)) {
                            if (!(rangeToken = rangeToken.getCaseInsensitiveToken()).match(n9)) {
                                if (n9 >= 65536) {
                                    return -1;
                                }
                                char c2 = Character.toUpperCase((char)n9);
                                c = c2;
                                if (!rangeToken.match(c2) && !rangeToken.match(Character.toLowerCase(c))) {
                                    return -1;
                                }
                            }
                        } else if (!rangeToken.match(n9)) {
                            return -1;
                        }
                        n2 = n5;
                    }
                    op2 = op2.next;
                    break;
                }
                case 5: {
                    int n5 = 0;
                    switch (op2.getData()) {
                        case 94: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context2.start && (n2 <= context2.start || !RegularExpression.isEOLChar(characterIterator.setIndex(n2 - 1))) : n2 != context2.start)) break;
                            return -1;
                        }
                        case 64: {
                            if (n2 == context2.start || n2 > context2.start && RegularExpression.isEOLChar(characterIterator.setIndex(n2 - 1))) break;
                            return -1;
                        }
                        case 36: {
                            if (!(RegularExpression.isSet(n4, 8) ? n2 != context2.limit && (n2 >= context2.limit || !RegularExpression.isEOLChar(characterIterator.setIndex(n2))) : !(n2 == context2.limit || n2 + 1 == context2.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n2)) || n2 + 2 == context2.limit && characterIterator.setIndex(n2) == '\r' && characterIterator.setIndex(n2 + 1) == '\n'))) break;
                            return -1;
                        }
                        case 65: {
                            if (n2 == context2.start) break;
                            return -1;
                        }
                        case 90: {
                            if (n2 == context2.limit || n2 + 1 == context2.limit && RegularExpression.isEOLChar(characterIterator.setIndex(n2)) || n2 + 2 == context2.limit && characterIterator.setIndex(n2) == '\r' && characterIterator.setIndex(n2 + 1) == '\n') break;
                            return -1;
                        }
                        case 122: {
                            if (n2 == context2.limit) break;
                            return -1;
                        }
                        case 98: {
                            if (context2.length == 0) {
                                return -1;
                            }
                            int n10 = RegularExpression.getWordType(characterIterator, context2.start, context2.limit, n2, n4);
                            if (n10 == 0) {
                                return -1;
                            }
                            int n11 = RegularExpression.getPreviousWordType(characterIterator, context2.start, context2.limit, n2, n4);
                            if (n10 != n11) break;
                            return -1;
                        }
                        case 66: {
                            if (context2.length == 0) {
                                n5 = 1;
                            } else {
                                int n12 = RegularExpression.getWordType(characterIterator, context2.start, context2.limit, n2, n4);
                                int n6 = n5 = n12 == 0 || n12 == RegularExpression.getPreviousWordType(characterIterator, context2.start, context2.limit, n2, n4) ? 1 : 0;
                            }
                            if (n5 != 0) break;
                            return -1;
                        }
                        case 60: {
                            if (context2.length == 0 || n2 == context2.limit) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context2.start, context2.limit, n2, n4) == 1 && RegularExpression.getPreviousWordType(characterIterator, context2.start, context2.limit, n2, n4) == 2) break;
                            return -1;
                        }
                        case 62: {
                            if (context2.length == 0 || n2 == context2.start) {
                                return -1;
                            }
                            if (RegularExpression.getWordType(characterIterator, context2.start, context2.limit, n2, n4) == 2 && RegularExpression.getPreviousWordType(characterIterator, context2.start, context2.limit, n2, n4) == 1) break;
                            return -1;
                        }
                    }
                    op2 = op2.next;
                    break;
                }
                case 16: {
                    int n14 = op2.getData();
                    if (n14 <= 0 || n14 >= this.nofparen) {
                        throw new RuntimeException("Internal Error: Reference number must be more than zero: " + n14);
                    }
                    if (context2.match.getBeginning(n14) < 0 || context2.match.getEnd(n14) < 0) {
                        return -1;
                    }
                    int n15 = context2.match.getBeginning(n14);
                    char c = context2.match.getEnd(n14) - n15;
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n2, context2.limit, n15, (int)c)) {
                                return -1;
                            }
                            n2 += c;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n2 - c, context2.limit, n15, (int)c)) {
                                return -1;
                            }
                            n2 -= c;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2, context2.limit, n15, (int)c)) {
                            return -1;
                        }
                        n2 += c;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2 - c, context2.limit, n15, (int)c)) {
                            return -1;
                        }
                        n2 -= c;
                    }
                    op2 = op2.next;
                    break;
                }
                case 6: {
                    String string2 = op2.getString();
                    int n16 = string2.length();
                    if (!RegularExpression.isSet(n4, 2)) {
                        if (n3 > 0) {
                            if (!RegularExpression.regionMatches(characterIterator, n2, context2.limit, string2, n16)) {
                                return -1;
                            }
                            n2 += n16;
                        } else {
                            if (!RegularExpression.regionMatches(characterIterator, n2 - n16, context2.limit, string2, n16)) {
                                return -1;
                            }
                            n2 -= n16;
                        }
                    } else if (n3 > 0) {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2, context2.limit, string2, n16)) {
                            return -1;
                        }
                        n2 += n16;
                    } else {
                        if (!RegularExpression.regionMatchesIgnoreCase(characterIterator, n2 - n16, context2.limit, string2, n16)) {
                            return -1;
                        }
                        n2 -= n16;
                    }
                    op2 = op2.next;
                    break;
                }
                case 7: {
                    int n17 = op2.getData();
                    if (n17 >= 0) {
                        int n18 = context2.offsets[n17];
                        if (n18 < 0 || n18 != n2) {
                            context2.offsets[n17] = n2;
                        } else {
                            context2.offsets[n17] = -1;
                            op2 = op2.next;
                            break;
                        }
                    }
                    int n19 = this.matchCharacterIterator(context2, op2.getChild(), n2, n3, n4);
                    if (n17 >= 0) {
                        context2.offsets[n17] = -1;
                    }
                    if (n19 >= 0) {
                        return n19;
                    }
                    op2 = op2.next;
                    break;
                }
                case 9: {
                    int n20 = this.matchCharacterIterator(context2, op2.getChild(), n2, n3, n4);
                    if (n20 >= 0) {
                        return n20;
                    }
                    op2 = op2.next;
                    break;
                }
                case 8: 
                case 10: {
                    int n21 = this.matchCharacterIterator(context2, op2.next, n2, n3, n4);
                    if (n21 >= 0) {
                        return n21;
                    }
                    op2 = op2.getChild();
                    break;
                }
                case 11: {
                    for (int i = 0; i < op2.size(); ++i) {
                        int n22 = this.matchCharacterIterator(context2, op2.elementAt(i), n2, n3, n4);
                        if (n22 < 0) continue;
                        return n22;
                    }
                    return -1;
                }
                case 15: {
                    int n23 = op2.getData();
                    if (context2.match != null && n23 > 0) {
                        int n24 = context2.match.getBeginning(n23);
                        context2.match.setBeginning(n23, n2);
                        int n7 = this.matchCharacterIterator(context2, op2.next, n2, n3, n4);
                        if (n7 < 0) {
                            context2.match.setBeginning(n23, n24);
                        }
                        return n7;
                    }
                    if (context2.match != null && n23 < 0) {
                        int n25 = -n23;
                        int n8 = context2.match.getEnd(n25);
                        context2.match.setEnd(n25, n2);
                        int n9 = this.matchCharacterIterator(context2, op2.next, n2, n3, n4);
                        if (n9 < 0) {
                            context2.match.setEnd(n25, n8);
                        }
                        return n9;
                    }
                    op2 = op2.next;
                    break;
                }
                case 20: {
                    if (0 > this.matchCharacterIterator(context2, op2.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 21: {
                    if (0 <= this.matchCharacterIterator(context2, op2.getChild(), n2, 1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 22: {
                    if (0 > this.matchCharacterIterator(context2, op2.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 23: {
                    if (0 <= this.matchCharacterIterator(context2, op2.getChild(), n2, -1, n4)) {
                        return -1;
                    }
                    op2 = op2.next;
                    break;
                }
                case 24: {
                    int n27 = this.matchCharacterIterator(context2, op2.getChild(), n2, n3, n4);
                    if (n27 < 0) {
                        return n27;
                    }
                    n2 = n27;
                    op2 = op2.next;
                    break;
                }
                case 25: {
                    int n28 = n4;
                    n28 |= op2.getData();
                    char c = this.matchCharacterIterator(context2, op2.getChild(), n2, n3, n28 &= ~op2.getData2());
                    if (c < '\u0000') {
                        return c;
                    }
                    n2 = c;
                    op2 = op2.next;
                    break;
                }
                case 26: {
                    Op.ConditionOp conditionOp = (Op.ConditionOp)op2;
                    char c = '\u0000';
                    if (conditionOp.refNumber > 0) {
                        if (conditionOp.refNumber >= this.nofparen) {
                            throw new RuntimeException("Internal Error: Reference number must be more than zero: " + conditionOp.refNumber);
                        }
                        c = context2.match.getBeginning(conditionOp.refNumber) >= 0 && context2.match.getEnd(conditionOp.refNumber) >= 0 ? (char)'\u0001' : '\u0000';
                    } else {
                        char c3 = c = 0 <= this.matchCharacterIterator(context2, conditionOp.condition, n2, n3, n4) ? (char)'\u0001' : '\u0000';
                    }
                    if (c != '\u0000') {
                        op2 = conditionOp.yes;
                        break;
                    }
                    if (conditionOp.no != null) {
                        op2 = conditionOp.no;
                        break;
                    }
                    op2 = conditionOp.next;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown operation type: " + op2.type);
                }
            }
        }
        return RegularExpression.isSet(n4, 512) && n2 != context2.limit ? -1 : n2;
    }

    private static final int getPreviousWordType(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        int n6 = RegularExpression.getWordType(characterIterator, n2, n3, --n4, n5);
        while (n6 == 0) {
            n6 = RegularExpression.getWordType(characterIterator, n2, n3, --n4, n5);
        }
        return n6;
    }

    private static final int getWordType(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n4 < n2 || n4 >= n3) {
            return 2;
        }
        return RegularExpression.getWordType0(characterIterator.setIndex(n4), n5);
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            if (characterIterator.setIndex(n2++) == string2.charAt(n5++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatches(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            if (characterIterator.setIndex(n2++) == characterIterator.setIndex(n6++)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n2, int n3, String string2, int n4) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n4) {
            return false;
        }
        int n5 = 0;
        while (n4-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = characterIterator.setIndex(n2++)) == (c3 = string2.charAt(n5++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static final boolean regionMatchesIgnoreCase(CharacterIterator characterIterator, int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            return false;
        }
        if (n3 - n2 < n5) {
            return false;
        }
        int n6 = n4;
        while (n5-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = characterIterator.setIndex(n2++)) == (c3 = characterIterator.setIndex(n6++)) || (c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    void prepare() {
        Object object2;
        int n2;
        this.compile(this.tokentree);
        this.minlength = this.tokentree.getMinLength();
        this.firstChar = null;
        if (!RegularExpression.isSet(this.options, 128) && !RegularExpression.isSet(this.options, 512) && (n2 = this.tokentree.analyzeFirstCharacter((RangeToken)(object2 = Token.createRange()), this.options)) == 1) {
            ((RangeToken)object2).compactRanges();
            this.firstChar = object2;
        }
        if (this.operations != null && (this.operations.type == 6 || this.operations.type == 1) && this.operations.next == null) {
            this.fixedStringOnly = true;
            if (this.operations.type == 6) {
                this.fixedString = this.operations.getString();
            } else if (this.operations.getData() >= 65536) {
                this.fixedString = REUtil.decomposeToSurrogates(this.operations.getData());
            } else {
                object2 = new char[1];
                object2[0] = (char)this.operations.getData();
                this.fixedString = new String((char[])object2);
            }
            this.fixedStringOptions = this.options;
            this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
        } else if (!RegularExpression.isSet(this.options, 256) && !RegularExpression.isSet(this.options, 512)) {
            object2 = new Token.FixedStringContainer();
            this.tokentree.findFixedString((Token.FixedStringContainer)object2, this.options);
            this.fixedString = ((Token.FixedStringContainer)object2).token == null ? null : ((Token.FixedStringContainer)object2).token.getString();
            this.fixedStringOptions = ((Token.FixedStringContainer)object2).options;
            if (this.fixedString != null && this.fixedString.length() < 2) {
                this.fixedString = null;
            }
            if (this.fixedString != null) {
                this.fixedStringTable = new BMPattern(this.fixedString, 256, RegularExpression.isSet(this.fixedStringOptions, 2));
            }
        }
    }

    private static final boolean isSet(int n2, int n3) {
        return (n2 & n3) == n3;
    }

    public RegularExpression(String string2) throws ParseException {
        this(string2, null);
    }

    public RegularExpression(String string2, String string3) throws ParseException {
        this.setPattern(string2, string3);
    }

    public RegularExpression(String string2, String string3, Locale locale) throws ParseException {
        this.setPattern(string2, string3, locale);
    }

    RegularExpression(String string2, Token token, int n2, boolean bl, int n3) {
        this.regex = string2;
        this.tokentree = token;
        this.nofparen = n2;
        this.options = n3;
        this.hasBackReferences = bl;
    }

    public void setPattern(String string2) throws ParseException {
        this.setPattern(string2, Locale.getDefault());
    }

    public void setPattern(String string2, Locale locale) throws ParseException {
        this.setPattern(string2, this.options, locale);
    }

    private void setPattern(String string2, int n2, Locale locale) throws ParseException {
        this.regex = string2;
        this.options = n2;
        RegexParser regexParser = RegularExpression.isSet(this.options, 512) ? new ParserForXMLSchema(locale) : new RegexParser(locale);
        this.tokentree = regexParser.parse(this.regex, this.options);
        this.nofparen = regexParser.parennumber;
        this.hasBackReferences = regexParser.hasBackReferences;
        this.operations = null;
        this.context = null;
    }

    public void setPattern(String string2, String string3) throws ParseException {
        this.setPattern(string2, string3, Locale.getDefault());
    }

    public void setPattern(String string2, String string3, Locale locale) throws ParseException {
        this.setPattern(string2, REUtil.parseOptions(string3), locale);
    }

    public String getPattern() {
        return this.regex;
    }

    public String toString() {
        return this.tokentree.toString(this.options);
    }

    public String getOptions() {
        return REUtil.createOptionString(this.options);
    }

    public boolean equals(Object object2) {
        if (object2 == null) {
            return false;
        }
        if (!(object2 instanceof RegularExpression)) {
            return false;
        }
        RegularExpression regularExpression = (RegularExpression)object2;
        return this.regex.equals(regularExpression.regex) && this.options == regularExpression.options;
    }

    boolean equals(String string2, int n2) {
        return this.regex.equals(string2) && this.options == n2;
    }

    public int hashCode() {
        return (this.regex + "/" + this.getOptions()).hashCode();
    }

    public int getNumberOfGroups() {
        return this.nofparen;
    }

    private static final int getWordType0(char c, int n2) {
        if (!RegularExpression.isSet(n2, 64)) {
            if (RegularExpression.isSet(n2, 32)) {
                return Token.getRange("IsWord", true).match(c) ? 1 : 2;
            }
            return RegularExpression.isWordChar(c) ? 1 : 2;
        }
        switch (Character.getType(c)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 1;
            }
            case 6: 
            case 7: 
            case 16: {
                return 0;
            }
            case 15: {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': {
                        return 2;
                    }
                }
                return 0;
            }
        }
        return 2;
    }

    private static final boolean isEOLChar(int n2) {
        return n2 == 10 || n2 == 13 || n2 == 8232 || n2 == 8233;
    }

    private static final boolean isWordChar(int n2) {
        if (n2 == 95) {
            return true;
        }
        if (n2 < 48) {
            return false;
        }
        if (n2 > 122) {
            return false;
        }
        if (n2 <= 57) {
            return true;
        }
        if (n2 < 65) {
            return false;
        }
        if (n2 <= 90) {
            return true;
        }
        return n2 >= 97;
    }

    private static final boolean matchIgnoreCase(int n2, int n3) {
        char c;
        if (n2 == n3) {
            return true;
        }
        if (n2 > 65535 || n3 > 65535) {
            return false;
        }
        char c2 = Character.toUpperCase((char)n2);
        if (c2 == (c = Character.toUpperCase((char)n3))) {
            return true;
        }
        return Character.toLowerCase(c2) == Character.toLowerCase(c);
    }

    static final class Context {
        CharacterIterator ciTarget;
        String strTarget;
        char[] charTarget;
        int start;
        int limit;
        int length;
        Match match;
        boolean inuse = false;
        int[] offsets;

        Context() {
        }

        private void resetCommon(int n2) {
            this.length = this.limit - this.start;
            this.setInUse(true);
            this.match = null;
            if (this.offsets == null || this.offsets.length != n2) {
                this.offsets = new int[n2];
            }
            for (int i = 0; i < n2; ++i) {
                this.offsets[i] = -1;
            }
        }

        void reset(CharacterIterator characterIterator, int n2, int n3, int n4) {
            this.ciTarget = characterIterator;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(String string2, int n2, int n3, int n4) {
            this.strTarget = string2;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        void reset(char[] cArray, int n2, int n3, int n4) {
            this.charTarget = cArray;
            this.start = n2;
            this.limit = n3;
            this.resetCommon(n4);
        }

        synchronized void setInUse(boolean bl) {
            this.inuse = bl;
        }
    }
}

