/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.xpath.regex;

import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.Match;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.ParseException;
import com.ibm.xml.xml4j.internal.s1.impl.xpath.regex.RegularExpression;
import java.text.CharacterIterator;

public final class REUtil {
    static final int CACHESIZE = 20;
    static final RegularExpression[] regexCache = new RegularExpression[20];

    private REUtil() {
    }

    static final int composeFromSurrogates(int n2, int n3) {
        return 65536 + (n2 - 55296 << 10) + n3 - 56320;
    }

    static final boolean isLowSurrogate(int n2) {
        return (n2 & 0xFC00) == 56320;
    }

    static final boolean isHighSurrogate(int n2) {
        return (n2 & 0xFC00) == 55296;
    }

    static final String decomposeToSurrogates(int n2) {
        char[] cArray = new char[]{(char)(((n2 -= 65536) >> 10) + 55296), (char)((n2 & 0x3FF) + 56320)};
        return new String(cArray);
    }

    static final String substring(CharacterIterator characterIterator, int n2, int n3) {
        char[] cArray = new char[n3 - n2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = characterIterator.setIndex(i + n2);
        }
        return new String(cArray);
    }

    static final int getOptionValue(int n2) {
        int n3 = 0;
        switch (n2) {
            case 105: {
                n3 = 2;
                break;
            }
            case 109: {
                n3 = 8;
                break;
            }
            case 115: {
                n3 = 4;
                break;
            }
            case 120: {
                n3 = 16;
                break;
            }
            case 117: {
                n3 = 32;
                break;
            }
            case 119: {
                n3 = 64;
                break;
            }
            case 70: {
                n3 = 256;
                break;
            }
            case 72: {
                n3 = 128;
                break;
            }
            case 88: {
                n3 = 512;
                break;
            }
            case 44: {
                n3 = 1024;
                break;
            }
        }
        return n3;
    }

    static final int parseOptions(String string2) throws ParseException {
        if (string2 == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            int n3 = REUtil.getOptionValue(string2.charAt(i));
            if (n3 == 0) {
                throw new ParseException("Unknown Option: " + string2.substring(i), -1);
            }
            n2 |= n3;
        }
        return n2;
    }

    static final String createOptionString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(9);
        if ((n2 & 0x100) != 0) {
            stringBuffer.append('F');
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append('H');
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append('X');
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append('i');
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append('m');
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append('s');
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append('u');
        }
        if ((n2 & 0x40) != 0) {
            stringBuffer.append('w');
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append('x');
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append(',');
        }
        return stringBuffer.toString().intern();
    }

    static String stripExtendedComment(String string2) {
        int n2 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            char c;
            char c2;
            if ((c2 = string2.charAt(n3++)) == '\t' || c2 == '\n' || c2 == '\f' || c2 == '\r' || c2 == ' ') {
                if (n4 <= 0) continue;
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == '#') {
                while (n3 < n2 && (c2 = string2.charAt(n3++)) != '\r' && c2 != '\n') {
                }
                continue;
            }
            if (c2 == '\\' && n3 < n2) {
                c = string2.charAt(n3);
                if (c == '#' || c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == ' ') {
                    stringBuffer.append(c);
                    ++n3;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c);
                ++n3;
                continue;
            }
            if (c2 == '[') {
                ++n4;
                stringBuffer.append(c2);
                if (n3 >= n2) continue;
                c = string2.charAt(n3);
                if (c == '[' || c == ']') {
                    stringBuffer.append(c);
                    ++n3;
                    continue;
                }
                if (c != '^' || n3 + 1 >= n2 || (c = string2.charAt(n3 + 1)) != '[' && c != ']') continue;
                stringBuffer.append('^');
                stringBuffer.append(c);
                n3 += 2;
                continue;
            }
            if (n4 > 0 && c2 == ']') {
                --n4;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string2 = null;
        try {
            String string3 = "";
            String string4 = null;
            if (stringArray.length == 0) {
                System.out.println("Error:Usage: java REUtil -i|-m|-s|-u|-w|-X regularExpression String");
                System.exit(0);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0 || stringArray[i].charAt(0) != '-') {
                    if (string2 == null) {
                        string2 = stringArray[i];
                        continue;
                    }
                    if (string4 == null) {
                        string4 = stringArray[i];
                        continue;
                    }
                    System.err.println("Unnecessary: " + stringArray[i]);
                    continue;
                }
                if (stringArray[i].equals("-i")) {
                    string3 = string3 + "i";
                    continue;
                }
                if (stringArray[i].equals("-m")) {
                    string3 = string3 + "m";
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    string3 = string3 + "s";
                    continue;
                }
                if (stringArray[i].equals("-u")) {
                    string3 = string3 + "u";
                    continue;
                }
                if (stringArray[i].equals("-w")) {
                    string3 = string3 + "w";
                    continue;
                }
                if (stringArray[i].equals("-X")) {
                    string3 = string3 + "X";
                    continue;
                }
                System.err.println("Unknown option: " + stringArray[i]);
            }
            RegularExpression regularExpression = new RegularExpression(string2, string3);
            System.out.println("RegularExpression: " + regularExpression);
            Match match = new Match();
            regularExpression.matches(string4, match);
            for (int i = 0; i < match.getNumberOfGroups(); ++i) {
                if (i == 0) {
                    System.out.print("Matched range for the whole pattern: ");
                } else {
                    System.out.print("[" + i + "]: ");
                }
                if (match.getBeginning(i) < 0) {
                    System.out.println("-1");
                    continue;
                }
                System.out.print(match.getBeginning(i) + ", " + match.getEnd(i) + ", ");
                System.out.println("\"" + match.getCapturedText(i) + "\"");
            }
        }
        catch (ParseException parseException) {
            if (string2 == null) {
                parseException.printStackTrace();
            } else {
                System.err.println("com.ibm.xml.xml4j.internal.s1.utils.regex.ParseException: " + parseException.getMessage());
                String string5 = "        ";
                System.err.println(string5 + string2);
                int n2 = parseException.getLocation();
                if (n2 >= 0) {
                    System.err.print(string5);
                    for (int i = 0; i < n2; ++i) {
                        System.err.print("-");
                    }
                    System.err.println("^");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegularExpression createRegex(String string2, String string3) throws ParseException {
        RegularExpression regularExpression = null;
        int n2 = REUtil.parseOptions(string3);
        RegularExpression[] regularExpressionArray = regexCache;
        synchronized (regexCache) {
            int n3;
            for (n3 = 0; n3 < 20; ++n3) {
                RegularExpression regularExpression2 = regexCache[n3];
                if (regularExpression2 == null) {
                    n3 = -1;
                    break;
                }
                if (!regularExpression2.equals(string2, n2)) continue;
                regularExpression = regularExpression2;
                break;
            }
            if (regularExpression != null) {
                if (n3 != 0) {
                    System.arraycopy(regexCache, 0, regexCache, 1, n3);
                    REUtil.regexCache[0] = regularExpression;
                }
            } else {
                regularExpression = new RegularExpression(string2, string3);
                System.arraycopy(regexCache, 0, regexCache, 1, 19);
                REUtil.regexCache[0] = regularExpression;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return regularExpression;
        }
    }

    public static boolean matches(String string2, String string3) throws ParseException {
        return REUtil.createRegex(string2, null).matches(string3);
    }

    public static boolean matches(String string2, String string3, String string4) throws ParseException {
        return REUtil.createRegex(string2, string3).matches(string4);
    }

    public static String quoteMeta(String string2) {
        int n2 = string2.length();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (".*+?{[()|\\^$".indexOf(c) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(i + (n2 - i) * 2);
                    if (i > 0) {
                        stringBuffer.append(string2.substring(0, i));
                    }
                }
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer != null ? stringBuffer.toString() : string2;
    }

    static void dumpString(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            System.out.print(Integer.toHexString(string2.charAt(i)));
            System.out.print(" ");
        }
        System.out.println();
    }
}

