/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.dv.xs;

import com.ibm.xml.xml4j.internal.s1.impl.dv.InvalidDatatypeValueException;
import com.ibm.xml.xml4j.internal.s1.impl.dv.ValidationContext;
import com.ibm.xml.xml4j.internal.s1.impl.dv.xs.AbstractDateTimeDV;
import com.ibm.xml.xml4j.internal.s1.impl.dv.xs.SchemaDateTimeException;
import javax.xml.datatype.XMLGregorianCalendar;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    @Override
    public Object getActualValue(String string2, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return this.parse(string2);
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, "gMonthDay"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String string2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData dateTimeData = new AbstractDateTimeDV.DateTimeData(string2, this);
        int n2 = string2.length();
        dateTimeData.year = 2000;
        if (string2.charAt(0) != '-' || string2.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string2);
        }
        dateTimeData.month = this.parseInt(string2, 2, 4);
        int n3 = 4;
        if (string2.charAt(n3++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + string2);
        }
        dateTimeData.day = this.parseInt(string2, n3, n3 + 2);
        if (7 < n2) {
            if (!this.isNextCharUTCSign(string2, 7, n2)) {
                throw new SchemaDateTimeException("Error in month parsing:" + string2);
            }
            this.getTimeZone(string2, dateTimeData, 7, n2);
        }
        this.validateDateTime(dateTimeData);
        this.saveUnnormalized(dateTimeData);
        if (dateTimeData.utc != 0 && dateTimeData.utc != 90) {
            this.normalize(dateTimeData);
        }
        dateTimeData.position = 1;
        return dateTimeData;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData dateTimeData) {
        StringBuffer stringBuffer = new StringBuffer(8);
        stringBuffer.append('-');
        stringBuffer.append('-');
        this.append(stringBuffer, dateTimeData.month, 2);
        stringBuffer.append('-');
        this.append(stringBuffer, dateTimeData.day, 2);
        this.append(stringBuffer, (char)dateTimeData.utc, 0);
        return stringBuffer.toString();
    }

    @Override
    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData dateTimeData) {
        return this.factory.newXMLGregorianCalendar(Integer.MIN_VALUE, dateTimeData.unNormMonth, dateTimeData.unNormDay, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, dateTimeData.hasTimeZone() ? dateTimeData.timezoneHr * 60 + dateTimeData.timezoneMin : Integer.MIN_VALUE);
    }
}

