/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl.dv.util;

public final class Base64 {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final boolean fDebug = false;
    private static final byte[] base64Alphabet;
    private static final char[] lookUpBase64Alphabet;

    protected static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    protected static boolean isPad(char c) {
        return c == '=';
    }

    protected static boolean isData(char c) {
        return c < '\u0080' && base64Alphabet[c] != -1;
    }

    protected static boolean isBase64(char c) {
        return Base64.isWhiteSpace(c) || Base64.isPad(c) || Base64.isData(c);
    }

    public static String encode(byte[] byArray) {
        byte by2;
        int n2;
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length * 8;
        if (n3 == 0) {
            return "";
        }
        int n4 = n3 % 24;
        int n5 = n3 / 24;
        int n6 = n4 != 0 ? n5 + 1 : n5;
        char[] cArray = null;
        cArray = new char[n6 * 4];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            by5 = byArray[n8++];
            by6 = byArray[n8++];
            by7 = byArray[n8++];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            byte by8 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byte by9 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            cArray[n7++] = lookUpBase64Alphabet[by2];
            cArray[n7++] = lookUpBase64Alphabet[by8 | by3 << 4];
            cArray[n7++] = lookUpBase64Alphabet[by4 << 2 | by9];
            cArray[n7++] = lookUpBase64Alphabet[by7 & 0x3F];
        }
        if (n4 == 8) {
            by5 = byArray[n8];
            by3 = (byte)(by5 & 3);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            cArray[n7++] = lookUpBase64Alphabet[n2];
            cArray[n7++] = lookUpBase64Alphabet[by3 << 4];
            cArray[n7++] = 61;
            cArray[n7++] = 61;
        } else if (n4 == 16) {
            by5 = byArray[n8];
            by6 = byArray[n8 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by2 = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            cArray[n7++] = lookUpBase64Alphabet[n2];
            cArray[n7++] = lookUpBase64Alphabet[by2 | by3 << 4];
            cArray[n7++] = lookUpBase64Alphabet[by4 << 2];
            cArray[n7++] = 61;
        }
        return new String(cArray);
    }

    public static byte[] decode(String string2) {
        int n2;
        if (string2 == null) {
            return null;
        }
        char[] cArray = string2.toCharArray();
        int n3 = Base64.removeWhiteSpace(cArray);
        if (n3 % 4 != 0) {
            return null;
        }
        int n4 = n3 / 4;
        if (n4 == 0) {
            return new byte[0];
        }
        byte[] byArray = null;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        char c = '\u0000';
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        int n5 = 0;
        int n6 = 0;
        byArray = new byte[n4 * 3];
        for (n2 = 0; n2 < n4 - 1; ++n2) {
            if (!(Base64.isData(c = cArray[n6++]) && Base64.isData(c2 = cArray[n6++]) && Base64.isData(c3 = cArray[n6++]) && Base64.isData(c4 = cArray[n6++]))) {
                return null;
            }
            by2 = base64Alphabet[c];
            by3 = base64Alphabet[c2];
            by4 = base64Alphabet[c3];
            by5 = base64Alphabet[c4];
            byArray[n5++] = (byte)(by2 << 2 | by3 >> 4);
            byArray[n5++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
            byArray[n5++] = (byte)(by4 << 6 | by5);
        }
        if (!Base64.isData(c = cArray[n6++]) || !Base64.isData(c2 = cArray[n6++])) {
            return null;
        }
        by2 = base64Alphabet[c];
        by3 = base64Alphabet[c2];
        c3 = cArray[n6++];
        c4 = cArray[n6++];
        if (!Base64.isData(c3) || !Base64.isData(c4)) {
            if (Base64.isPad(c3) && Base64.isPad(c4)) {
                if ((by3 & 0xF) != 0) {
                    return null;
                }
                byte[] byArray2 = new byte[n2 * 3 + 1];
                System.arraycopy(byArray, 0, byArray2, 0, n2 * 3);
                byArray2[n5] = (byte)(by2 << 2 | by3 >> 4);
                return byArray2;
            }
            if (!Base64.isPad(c3) && Base64.isPad(c4)) {
                by4 = base64Alphabet[c3];
                if ((by4 & 3) != 0) {
                    return null;
                }
                byte[] byArray3 = new byte[n2 * 3 + 2];
                System.arraycopy(byArray, 0, byArray3, 0, n2 * 3);
                byArray3[n5++] = (byte)(by2 << 2 | by3 >> 4);
                byArray3[n5] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
                return byArray3;
            }
            return null;
        }
        by4 = base64Alphabet[c3];
        by5 = base64Alphabet[c4];
        byArray[n5++] = (byte)(by2 << 2 | by3 >> 4);
        byArray[n5++] = (byte)((by3 & 0xF) << 4 | by4 >> 2 & 0xF);
        byArray[n5++] = (byte)(by4 << 6 | by5);
        return byArray;
    }

    protected static int removeWhiteSpace(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = cArray.length;
        for (int i = 0; i < n3; ++i) {
            if (Base64.isWhiteSpace(cArray[i])) continue;
            cArray[n2++] = cArray[i];
        }
        return n2;
    }

    static {
        int n2;
        base64Alphabet = new byte[128];
        lookUpBase64Alphabet = new char[64];
        for (n2 = 0; n2 < 128; ++n2) {
            Base64.base64Alphabet[n2] = -1;
        }
        for (n2 = 90; n2 >= 65; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 65);
        }
        for (n2 = 122; n2 >= 97; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 97 + 26);
        }
        for (n2 = 57; n2 >= 48; --n2) {
            Base64.base64Alphabet[n2] = (byte)(n2 - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n2 = 0; n2 <= 25; ++n2) {
            Base64.lookUpBase64Alphabet[n2] = (char)(65 + n2);
        }
        n2 = 26;
        int n3 = 0;
        while (n2 <= 51) {
            Base64.lookUpBase64Alphabet[n2] = (char)(97 + n3);
            ++n2;
            ++n3;
        }
        n2 = 52;
        n3 = 0;
        while (n2 <= 61) {
            Base64.lookUpBase64Alphabet[n2] = (char)(48 + n3);
            ++n2;
            ++n3;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

