/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xml4j.internal.s1.impl;

import com.ibm.xml.xml4j.internal.s1.impl.XMLDTDScannerImpl;
import com.ibm.xml.xml4j.internal.s1.impl.XMLEntityManager;
import com.ibm.xml.xml4j.internal.s1.impl.XMLErrorReporter;
import com.ibm.xml.xml4j.internal.s1.util.SymbolTable;
import com.ibm.xml.xml4j.internal.s1.util.XML11Char;
import com.ibm.xml.xml4j.internal.s1.util.XMLChar;
import com.ibm.xml.xml4j.internal.s1.util.XMLStringBuffer;
import com.ibm.xml.xml4j.internal.s1.xni.XMLString;
import com.ibm.xml.xml4j.internal.s1.xni.XNIException;
import java.io.IOException;

public class XML11DTDScannerImpl
extends XMLDTDScannerImpl {
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();

    public XML11DTDScannerImpl() {
    }

    public XML11DTDScannerImpl(SymbolTable symbolTable, XMLErrorReporter xMLErrorReporter, XMLEntityManager xMLEntityManager) {
        super(symbolTable, xMLErrorReporter, xMLEntityManager);
    }

    @Override
    protected boolean scanPubidLiteral(XMLString xMLString) throws IOException, XNIException {
        int n2 = this.fEntityScanner.scanChar();
        if (n2 != 39 && n2 != 34) {
            this.reportFatalError("QuoteRequiredInPublicID", null);
            return false;
        }
        this.fStringBuffer.clear();
        boolean bl = true;
        boolean bl2 = true;
        while (true) {
            int n3;
            if ((n3 = this.fEntityScanner.scanChar()) == 32 || n3 == 10 || n3 == 13 || n3 == 133 || n3 == 8232) {
                if (bl) continue;
                this.fStringBuffer.append(' ');
                bl = true;
                continue;
            }
            if (n3 == n2) {
                if (bl) {
                    --this.fStringBuffer.length;
                }
                break;
            }
            if (XMLChar.isPubid(n3)) {
                this.fStringBuffer.append((char)n3);
                bl = false;
                continue;
            }
            if (n3 == -1) {
                this.reportFatalError("PublicIDUnterminated", null);
                return false;
            }
            bl2 = false;
            this.reportFatalError("InvalidCharInPublicID", new Object[]{Integer.toHexString(n3)});
        }
        xMLString.setValues(this.fStringBuffer);
        return bl2;
    }

    @Override
    protected void normalizeWhitespace(XMLString xMLString) {
        int n2 = xMLString.offset + xMLString.length;
        for (int i = xMLString.offset; i < n2; ++i) {
            char c = xMLString.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            xMLString.ch[i] = 32;
        }
    }

    @Override
    protected void normalizeWhitespace(XMLString xMLString, int n2) {
        int n3 = xMLString.offset + xMLString.length;
        for (int i = xMLString.offset + n2; i < n3; ++i) {
            char c = xMLString.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            xMLString.ch[i] = 32;
        }
    }

    @Override
    protected int isUnchangedByNormalization(XMLString xMLString) {
        int n2 = xMLString.offset + xMLString.length;
        for (int i = xMLString.offset; i < n2; ++i) {
            char c = xMLString.ch[i];
            if (!XMLChar.isSpace(c)) continue;
            return i - xMLString.offset;
        }
        return -1;
    }

    @Override
    protected boolean isInvalid(int n2) {
        return !XML11Char.isXML11Valid(n2);
    }

    @Override
    protected boolean isInvalidLiteral(int n2) {
        return !XML11Char.isXML11ValidLiteral(n2);
    }

    @Override
    protected boolean isValidNameChar(int n2) {
        return XML11Char.isXML11Name(n2);
    }

    @Override
    protected boolean isValidNameStartChar(int n2) {
        return XML11Char.isXML11NameStart(n2);
    }

    @Override
    protected boolean isValidNCName(int n2) {
        return XML11Char.isXML11NCName(n2);
    }

    @Override
    protected boolean isValidNameStartHighSurrogate(int n2) {
        return XML11Char.isXML11NameHighSurrogate(n2);
    }

    @Override
    protected boolean versionSupported(String string2) {
        return string2.equals("1.1") || string2.equals("1.0");
    }

    @Override
    protected String getVersionNotSupportedKey() {
        return "VersionNotSupported11";
    }
}

