/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.util;

import com.ibm.xml.xlxp.util.BitSet;
import com.ibm.xml.xlxp.util.BitSetImpl;

public final class SparseBitSet
implements BitSet {
    private static final boolean DEBUG = false;
    public final int MIN_SIZE = 1024;
    private int fBitLength;
    private int fMidPoint;
    private SparseBitSet fLowHalf = null;
    private SparseBitSet fHighHalf = null;
    private BitSetImpl fSmallBitSet = null;
    private int fHash = -1;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public SparseBitSet(SparseBitSet sparseBitSet) {
        this.fBitLength = sparseBitSet.fBitLength;
        this.fMidPoint = sparseBitSet.fMidPoint;
        this.fHash = sparseBitSet.fHash;
        if (sparseBitSet.fSmallBitSet != null) {
            this.fSmallBitSet = new BitSetImpl(sparseBitSet.fSmallBitSet);
            return;
        }
        if (sparseBitSet.fLowHalf != null) {
            this.fLowHalf = new SparseBitSet(sparseBitSet.fLowHalf);
        }
        if (sparseBitSet.fHighHalf != null) {
            this.fHighHalf = new SparseBitSet(sparseBitSet.fHighHalf);
        }
    }

    public SparseBitSet(int n2) {
        this.fBitLength = n2;
        this.fMidPoint = n2 / 2;
        if (n2 <= 1024) {
            this.fSmallBitSet = new BitSetImpl(n2);
        }
    }

    public int compareTo(Object object2) {
        if (object2 == null) {
            return 1;
        }
        SparseBitSet sparseBitSet = (SparseBitSet)object2;
        if (this.fSmallBitSet != null) {
            return this.fSmallBitSet.compareTo(sparseBitSet.fSmallBitSet);
        }
        if (this.fHighHalf != null) {
            int n2 = this.fHighHalf.compareTo(sparseBitSet.fHighHalf);
            if (n2 != 0) {
                return n2;
            }
        } else if (sparseBitSet.fHighHalf != null) {
            return -1;
        }
        if (this.fLowHalf != null) {
            return this.fLowHalf.compareTo(sparseBitSet.fLowHalf);
        }
        return sparseBitSet.fLowHalf == null ? 0 : -1;
    }

    public int hashCode() {
        if (this.fHash != -1) {
            return this.fHash;
        }
        if (this.fSmallBitSet != null) {
            this.fHash = this.fSmallBitSet.hashCode();
        } else {
            int n2 = this.fHash = this.fLowHalf != null ? (this.fHash = this.fHash + this.fLowHalf.hashCode()) : 0;
            if (this.fHighHalf != null) {
                this.fHash += this.fHighHalf.hashCode();
            }
        }
        return this.fHash;
    }

    public Object clone() {
        SparseBitSet sparseBitSet = null;
        try {
            sparseBitSet = (SparseBitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        sparseBitSet.fBitLength = this.fBitLength;
        sparseBitSet.fMidPoint = this.fMidPoint;
        sparseBitSet.fHash = this.fHash;
        sparseBitSet.fLowHalf = null;
        sparseBitSet.fHighHalf = null;
        sparseBitSet.fSmallBitSet = null;
        if (this.fSmallBitSet != null) {
            sparseBitSet.fSmallBitSet = (BitSetImpl)this.fSmallBitSet.clone();
        } else {
            if (this.fLowHalf != null) {
                sparseBitSet.fLowHalf = (SparseBitSet)this.fLowHalf.clone();
            }
            if (this.fHighHalf != null) {
                sparseBitSet.fHighHalf = (SparseBitSet)this.fHighHalf.clone();
            }
        }
        return sparseBitSet;
    }

    private void checkIndexValidity(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index value cannot be negative");
        }
        if (n2 > this.fBitLength - 1) {
            throw new IndexOutOfBoundsException("Index value cannot exceed vector length");
        }
    }

    public boolean equals(SparseBitSet sparseBitSet) {
        if (sparseBitSet == null) {
            return false;
        }
        if (this.fHash != -1 && sparseBitSet.fHash != -1 && this.fHash != sparseBitSet.fHash) {
            return false;
        }
        if (this.fSmallBitSet != null) {
            return this.fSmallBitSet.equals(sparseBitSet.fSmallBitSet);
        }
        if (this.fLowHalf != null && !this.fLowHalf.equals(sparseBitSet.fLowHalf)) {
            return false;
        }
        return this.fHighHalf == null || this.fHighHalf.equals(sparseBitSet.fHighHalf);
    }

    public boolean equals(Object object2) {
        return object2 != null && object2 instanceof SparseBitSet && this.equals((SparseBitSet)object2);
    }

    public boolean getBit(int n2) {
        if (this.fSmallBitSet != null) {
            return this.fSmallBitSet.getBit(n2);
        }
        if (n2 < this.fMidPoint) {
            return this.fLowHalf != null && this.fLowHalf.getBit(n2);
        }
        return this.fHighHalf != null && this.fHighHalf.getBit(n2 - this.fMidPoint);
    }

    public void setLength(int n2) {
        this.fBitLength = n2;
        this.fMidPoint = n2 / 2;
        this.fLowHalf = null;
        this.fHighHalf = null;
        this.fHash = -1;
        if (this.fBitLength <= 1024) {
            if (this.fSmallBitSet != null) {
                this.fSmallBitSet.setLength(this.fBitLength);
            } else {
                this.fSmallBitSet = new BitSetImpl(this.fBitLength);
            }
        } else {
            this.fSmallBitSet = null;
        }
    }

    public void setBit(int n2) {
        this.fHash = -1;
        if (this.fSmallBitSet != null) {
            this.fSmallBitSet.setBit(n2);
            return;
        }
        if (n2 < this.fMidPoint) {
            if (this.fLowHalf == null) {
                this.fLowHalf = new SparseBitSet(this.fMidPoint);
            }
            this.fLowHalf.setBit(n2);
            return;
        }
        if (this.fHighHalf == null) {
            this.fHighHalf = new SparseBitSet(this.fBitLength - this.fMidPoint);
        }
        this.fHighHalf.setBit(n2 - this.fMidPoint);
    }

    public void setBits(BitSet bitSet) {
        SparseBitSet sparseBitSet = (SparseBitSet)bitSet;
        this.fHash = -1;
        if (this.fSmallBitSet != null) {
            this.fSmallBitSet.setBits(sparseBitSet.fSmallBitSet);
            return;
        }
        if (sparseBitSet.fLowHalf != null) {
            if (this.fLowHalf == null) {
                this.fLowHalf = new SparseBitSet(sparseBitSet.fLowHalf);
            } else {
                this.fLowHalf.setBits(sparseBitSet.fLowHalf);
            }
        }
        if (sparseBitSet.fHighHalf != null) {
            if (this.fHighHalf == null) {
                this.fHighHalf = new SparseBitSet(sparseBitSet.fHighHalf);
            } else {
                this.fHighHalf.setBits(sparseBitSet.fHighHalf);
            }
        }
    }

    public void copyTo(BitSet bitSet) {
        SparseBitSet sparseBitSet = (SparseBitSet)bitSet;
        sparseBitSet.fHash = -1;
        if (this.fSmallBitSet != null) {
            if (sparseBitSet.fSmallBitSet == null) {
                sparseBitSet.fSmallBitSet = new BitSetImpl(this.fSmallBitSet);
            } else {
                this.fSmallBitSet.copyTo(sparseBitSet.fSmallBitSet);
            }
            sparseBitSet.fLowHalf = null;
            sparseBitSet.fHighHalf = null;
            return;
        }
        sparseBitSet.fSmallBitSet = null;
        if (this.fLowHalf != null) {
            if (sparseBitSet.fLowHalf == null) {
                sparseBitSet.fLowHalf = new SparseBitSet(this.fLowHalf);
            } else {
                this.fLowHalf.copyTo(sparseBitSet.fLowHalf);
            }
        } else {
            sparseBitSet.fLowHalf = null;
        }
        if (this.fHighHalf != null) {
            if (sparseBitSet.fHighHalf == null) {
                sparseBitSet.fHighHalf = new SparseBitSet(this.fHighHalf);
            } else {
                this.fHighHalf.copyTo(sparseBitSet.fHighHalf);
            }
        } else {
            sparseBitSet.fHighHalf = null;
        }
    }

    public boolean intersectsWith(BitSet bitSet) {
        throw new UnsupportedOperationException();
    }

    public int getLength() {
        return this.fBitLength;
    }

    public void clearAll() {
        if (this.fSmallBitSet != null) {
            this.fSmallBitSet.clearAll();
            return;
        }
        this.fLowHalf = null;
        this.fHighHalf = null;
        this.fHash = -1;
    }

    public int toList(int[] nArray) {
        return this.toList(nArray, 0, 0);
    }

    protected int toList(int[] nArray, int n2, int n3) {
        if (this.fSmallBitSet != null) {
            return this.fSmallBitSet.toList(nArray, n2, n3);
        }
        int n4 = this.fLowHalf != null ? this.fLowHalf.toList(nArray, n2, n3) : n2;
        return this.fHighHalf != null ? this.fHighHalf.toList(nArray, n4, n3 + this.fMidPoint) : n4;
    }
}

