/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.util;

import com.ibm.xml.xlxp.util.BitSet;

public final class BitSetImpl
implements BitSet {
    private static final boolean DEBUG = false;
    private int fBitLength;
    private long fBitVector1;
    private int[] fBitVector2;
    private int fBitVector2Length;
    private int fHash = -1;
    public static String staticCopyrightString = "Licensed Materials - Property of IBM\nXLXP - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2007. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public BitSetImpl(BitSet bitSet) {
        BitSetImpl bitSetImpl = (BitSetImpl)bitSet;
        this.setLength(bitSetImpl.fBitLength);
        this.setBits(bitSetImpl);
    }

    public BitSetImpl(int n2) {
        this.setLength(n2);
    }

    public int compareTo(Object object2) {
        BitSetImpl bitSetImpl = (BitSetImpl)object2;
        if (this.fBitLength <= 64) {
            if (this.fBitVector1 < bitSetImpl.fBitVector1) {
                return -1;
            }
            return this.fBitVector1 == bitSetImpl.fBitVector1 ? 0 : 1;
        }
        int n2 = 0;
        while (n2 < this.fBitVector2Length) {
            if (this.fBitVector2[n2] != bitSetImpl.fBitVector2[n2]) {
                return this.fBitVector2[n2] < bitSetImpl.fBitVector2[n2] ? -1 : 1;
            }
            ++n2;
        }
        return 0;
    }

    public int hashCode() {
        if (this.fBitLength <= 64) {
            return (int)this.fBitVector1;
        }
        if (this.fHash == -1) {
            this.fHash = 0;
            int n2 = 0;
            while (n2 < this.fBitVector2Length) {
                this.fHash += this.fBitVector2[n2] * 31;
                ++n2;
            }
        }
        return this.fHash;
    }

    public Object clone() {
        BitSetImpl bitSetImpl = null;
        try {
            bitSetImpl = (BitSetImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        bitSetImpl.fBitVector2 = null;
        bitSetImpl.setLength(this.fBitLength);
        bitSetImpl.setBits(this);
        return bitSetImpl;
    }

    private void checkIndexValidity(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index value cannot be negative");
        }
        if (n2 > this.fBitLength - 1) {
            throw new IndexOutOfBoundsException("Index value cannot exceed vector length");
        }
    }

    public void clearBit(int n2) {
        this.fHash = -1;
        if (this.fBitLength <= 64) {
            long l = 1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
            this.fBitVector1 &= l;
        } else {
            int n3 = n2 / 32;
            int n4 = n2 % 32;
            int n5 = ~(1 << n4);
            int n6 = n3;
            this.fBitVector2[n6] = this.fBitVector2[n6] & n5;
        }
    }

    public boolean containsSet(BitSet bitSet) {
        BitSetImpl bitSetImpl = (BitSetImpl)bitSet;
        if (this.fBitLength == bitSetImpl.fBitLength) {
            if (this.fBitLength <= 64) {
                return (this.fBitVector1 & bitSetImpl.fBitVector1) == bitSetImpl.fBitVector1;
            }
            int n2 = 0;
            while (n2 < this.fBitVector2Length) {
                if ((this.fBitVector2[n2] & bitSetImpl.fBitVector2[n2]) != bitSetImpl.fBitVector2[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean intersectsWith(BitSet bitSet) {
        BitSetImpl bitSetImpl = (BitSetImpl)bitSet;
        if (this.fBitLength == bitSetImpl.fBitLength) {
            if (this.fBitLength <= 64) {
                return (this.fBitVector1 & bitSetImpl.fBitVector1) != 0L;
            }
            int n2 = 0;
            while (n2 < this.fBitVector2Length) {
                if ((this.fBitVector2[n2] & bitSetImpl.fBitVector2[n2]) != 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return false;
    }

    public boolean equals(BitSet bitSet) {
        BitSetImpl bitSetImpl = (BitSetImpl)bitSet;
        if (this.fBitLength == bitSetImpl.fBitLength) {
            if (this.fBitLength <= 64) {
                return this.fBitVector1 == bitSetImpl.fBitVector1;
            }
            if (this.fHash == bitSetImpl.fHash || this.fHash == -1 || bitSetImpl.fHash == -1) {
                int n2 = 0;
                while (n2 < this.fBitVector2Length) {
                    if (this.fBitVector2[n2] != bitSetImpl.fBitVector2[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object2) {
        if (object2 != null && object2 instanceof BitSet) {
            return this.equals((BitSet)object2);
        }
        return false;
    }

    public boolean getBit(int n2) {
        if (this.fBitLength <= 64) {
            long l = this.fBitVector1 >> n2;
            return (l & 1L) != 0L;
        }
        int n3 = n2 / 32;
        int n4 = n2 % 32;
        int n5 = this.fBitVector2[n3] >> n4;
        return (n5 & 1) != 0;
    }

    public boolean isSuperSetOf(BitSet bitSet) {
        BitSetImpl bitSetImpl = (BitSetImpl)bitSet;
        if (this.fBitLength == bitSetImpl.fBitLength) {
            if (this.fBitLength <= 64) {
                return (this.fBitVector1 | bitSetImpl.fBitVector1) == this.fBitVector1;
            }
            int n2 = 0;
            while (n2 < this.fBitVector2Length) {
                if ((this.fBitVector2[n2] | bitSetImpl.fBitVector2[n2]) != this.fBitVector2[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public boolean isZero() {
        if (this.fBitLength <= 64) {
            return this.fBitVector1 == 0L;
        }
        int n2 = 0;
        while (n2 < this.fBitVector2Length) {
            if (this.fBitVector2[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void setBit(int n2) {
        if (this.fBitLength <= 64) {
            long l = 1L << n2;
            this.fBitVector1 |= l;
        } else {
            int n3 = n2 / 32;
            int n4 = n2 % 32;
            int n5 = 1 << n4;
            int n6 = n3;
            this.fBitVector2[n6] = this.fBitVector2[n6] | n5;
            this.fHash = -1;
        }
    }

    public void setBits(BitSet bitSet) {
        BitSetImpl bitSetImpl = (BitSetImpl)bitSet;
        if (this.fBitLength <= 64) {
            this.fBitVector1 |= bitSetImpl.fBitVector1;
        } else {
            int n2 = 0;
            while (n2 < this.fBitVector2Length) {
                int n3 = n2;
                this.fBitVector2[n3] = this.fBitVector2[n3] | bitSetImpl.fBitVector2[n2];
                ++n2;
            }
            this.fHash = -1;
        }
    }

    public boolean getAndSetBit(int n2) {
        if (this.fBitLength <= 64) {
            long l = 1L << n2;
            boolean bl = (this.fBitVector1 & l) != 0L;
            this.fBitVector1 |= l;
            return bl;
        }
        int n3 = n2 / 32;
        int n4 = n2 % 32;
        int n5 = 1 << n4;
        boolean bl = (this.fBitVector2[n3] & n5) != 0;
        int n6 = n3;
        this.fBitVector2[n6] = this.fBitVector2[n6] | n5;
        this.fHash = -1;
        return bl;
    }

    public void setLength(int n2) {
        this.fBitLength = n2;
        if (n2 <= 64) {
            this.fBitVector1 = 0L;
        } else {
            this.fBitVector2Length = n2 / 32 + (n2 % 32 == 0 ? 0 : 1);
            if (this.fBitVector2 == null || this.fBitVector2Length > this.fBitVector2.length) {
                this.fBitVector2 = new int[this.fBitVector2Length];
            } else {
                int n3 = 0;
                while (n3 < this.fBitVector2Length) {
                    this.fBitVector2[n3] = 0;
                    ++n3;
                }
            }
            this.fHash = -1;
        }
    }

    public void clearAll() {
        if (this.fBitLength <= 64) {
            this.fBitVector1 = 0L;
        } else {
            int n2 = 0;
            while (n2 < this.fBitVector2Length) {
                this.fBitVector2[n2] = 0;
                ++n2;
            }
            this.fHash = -1;
        }
    }

    public int getLength() {
        return this.fBitLength;
    }

    public void copyTo(BitSet bitSet) {
        BitSetImpl bitSetImpl = (BitSetImpl)bitSet;
        bitSetImpl.fBitLength = this.fBitLength;
        if (this.fBitLength <= 64) {
            bitSetImpl.fBitVector1 = this.fBitVector1;
        } else {
            if (bitSetImpl.fBitVector2 == null || this.fBitVector2Length > bitSetImpl.fBitVector2.length) {
                bitSetImpl.fBitVector2Length = this.fBitVector2Length;
                bitSetImpl.fBitVector2 = new int[this.fBitVector2Length];
            }
            System.arraycopy(this.fBitVector2, 0, bitSetImpl.fBitVector2, 0, this.fBitVector2Length);
            bitSetImpl.fHash = this.fHash;
        }
    }

    public int toList(int[] nArray) {
        return this.toList(nArray, 0, 0);
    }

    protected int toList(int[] nArray, int n2, int n3) {
        int n4 = 0;
        if (this.fBitLength <= 64) {
            long l = 1L;
            while (n4 < 64) {
                if ((this.fBitVector1 & l) != 0L) {
                    nArray[n2++] = n4 + n3;
                }
                l <<= 1;
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n4 < this.fBitVector2Length) {
                int n6 = this.fBitVector2[n4];
                if (n6 != 0) {
                    int n7 = 1;
                    int n8 = 0;
                    while (n8 < 32) {
                        if ((n6 & n7) != 0) {
                            nArray[n2++] = n5 + n8 + n3;
                        }
                        n7 <<= 1;
                        ++n8;
                    }
                }
                n5 += 32;
                ++n4;
            }
        }
        return n2;
    }
}

