/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.validation.idc;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XMLStringKey {
    private byte[] bytes;
    private int startOffset;
    private int endOffset;
    private int length;
    private DataBuffer firstBuffer;
    private DataBuffer lastBuffer;

    public void fill(XMLString xMLString) {
        this.bytes = xMLString.bytes;
        this.startOffset = xMLString.startOffset;
        this.endOffset = xMLString.endOffset;
        this.length = xMLString.length;
        this.firstBuffer = xMLString.firstBuffer;
        this.lastBuffer = xMLString.lastBuffer;
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof XMLStringKey) {
            XMLStringKey xMLStringKey = (XMLStringKey)object2;
            if (this.length > 0 && this.length == xMLStringKey.length) {
                if (this.bytes != null && xMLStringKey.bytes != null) {
                    int n2 = this.length;
                    if (this.bytes[this.startOffset] != xMLStringKey.bytes[xMLStringKey.startOffset]) {
                        return false;
                    }
                    while (--n2 > 0) {
                        if (this.bytes[this.startOffset + n2] == xMLStringKey.bytes[xMLStringKey.startOffset + n2]) continue;
                        return false;
                    }
                    return true;
                }
                DataBuffer dataBuffer = this.firstBuffer;
                DataBuffer dataBuffer2 = xMLStringKey.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n3 = this.startOffset;
                byte[] byArray2 = dataBuffer2.bytes;
                int n4 = xMLStringKey.startOffset;
                if (byArray[n3] != byArray2[n4]) {
                    return false;
                }
                DataBuffer dataBuffer3 = this.lastBuffer != null ? this.lastBuffer : dataBuffer;
                DataBuffer dataBuffer4 = xMLStringKey.lastBuffer != null ? xMLStringKey.lastBuffer : dataBuffer2;
                int n5 = this.lastBuffer != null ? dataBuffer.endOffset : this.endOffset;
                int n6 = xMLStringKey.lastBuffer != null ? dataBuffer2.endOffset : xMLStringKey.endOffset;
                int n7 = this.length;
                while (--n7 > 0) {
                    if (++n3 == n5) {
                        dataBuffer = dataBuffer.next;
                        byArray = dataBuffer.bytes;
                        n3 = dataBuffer.startOffset;
                        int n8 = n5 = dataBuffer != dataBuffer3 ? dataBuffer.endOffset : this.endOffset;
                    }
                    if (++n4 == n6) {
                        dataBuffer2 = dataBuffer2.next;
                        byArray2 = dataBuffer2.bytes;
                        n4 = dataBuffer2.startOffset;
                        int n9 = n6 = dataBuffer2 != dataBuffer4 ? dataBuffer2.endOffset : xMLStringKey.endOffset;
                    }
                    if (byArray[n3] == byArray2[n4]) continue;
                    return false;
                }
                return true;
            }
            return this.length == xMLStringKey.length;
        }
        return false;
    }

    public int hashCode() {
        if (this.length == 0) {
            return 0;
        }
        int n2 = 0;
        if (this.bytes != null) {
            for (int i = this.startOffset; i < this.endOffset; ++i) {
                n2 = n2 * 31 + (this.bytes[i] & 0xFF);
            }
            return n2;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n3 = this.startOffset;
        DataBuffer dataBuffer2 = this.lastBuffer != null ? this.lastBuffer : dataBuffer;
        int n4 = this.lastBuffer != null ? dataBuffer.endOffset : this.endOffset;
        while (true) {
            for (int i = n3; i < n4; ++i) {
                n2 = n2 * 31 + (byArray[i] & 0xFF);
            }
            if (dataBuffer == dataBuffer2) {
                return n2;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n3 = dataBuffer.startOffset;
            n4 = dataBuffer != dataBuffer2 ? dataBuffer.endOffset : this.endOffset;
        }
    }
}

