/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.validation.idc;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.validation.idc.IDCContext;
import com.ibm.xml.xlxp.internal.s1.validation.idc.IValue;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class IValueContainer {
    private static final int TABLE_SIZE = 101;
    private static final int SIZE_LIMIT = 10;
    private static final double LOAD_FACTOR = 0.75;
    public int idcID;
    public int idcCategory;
    public int keyID;
    public int fieldCount;
    public IValueContainer nextInPool;
    Object[] idcFValues;
    int[] idcFTypes;
    int[][] idcFItemTypes;
    private int fTableCount = 1;
    private boolean fIsUsingTable = false;
    int fLength;
    IValue fIValueList;
    IValue fDiscardedList = null;
    private IValue[] fIValueTable;
    private int[] fIValueTableChainState;
    private int fTableBuckets;
    private final IDCContext fContext;

    public IValueContainer(IDCContext iDCContext) {
        this(iDCContext, 101);
    }

    public IValueContainer(IDCContext iDCContext, int n2) {
        this.fContext = iDCContext;
        this.fTableBuckets = n2;
    }

    public void add(IValue iValue) {
        this.refreshFValueArrays();
        int n2 = iValue.startOffset;
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.idcFValues[n2++] != null) continue;
            if (this.idcCategory == 1) {
                this.fContext.vmContext.generateError(34);
            }
            return;
        }
        if (this.idcCategory != 2) {
            this.addUniqueOrKey(iValue);
        } else {
            this.addKeyRef(iValue);
        }
    }

    public void removeConflictKeys(IValueContainer iValueContainer, boolean bl) {
        int n2 = 0;
        int n3 = this.fIsUsingTable ? this.fIValueTable.length : 1;
        for (int i = 0; i < n3; ++i) {
            if (this.fIsUsingTable && this.fIValueTableChainState[i] != this.fTableCount) continue;
            IValue iValue = this.fIsUsingTable ? this.fIValueTable[i] : this.fIValueList;
            IValue iValue2 = null;
            block1: while (iValue != null) {
                IValue iValue3;
                if (!iValueContainer.fIsUsingTable) {
                    iValue3 = iValueContainer.fIValueList;
                } else {
                    n2 = this.getTableViewBucket(iValue);
                    if (iValueContainer.fIValueTableChainState[n2] != iValueContainer.fTableCount) {
                        iValue2 = iValue;
                        iValue = iValue.next;
                        continue;
                    }
                    iValue3 = iValueContainer.fIValueTable[n2];
                }
                IValue iValue4 = null;
                while (iValue3 != null && iValue != null) {
                    if (this.equals(iValue, iValue3, iValueContainer.idcID, iValueContainer.fieldCount)) {
                        --iValueContainer.fLength;
                        if (iValue4 == null) {
                            if (!iValueContainer.fIsUsingTable) {
                                iValueContainer.fIValueList = iValue3.next;
                                iValue3.next = iValueContainer.fDiscardedList;
                                iValueContainer.fDiscardedList = iValue3;
                                iValue3 = iValueContainer.fIValueList;
                            } else {
                                iValueContainer.fIValueTable[n2] = iValue3.next;
                                iValue3.next = iValueContainer.fDiscardedList;
                                iValueContainer.fDiscardedList = iValue3;
                                iValue3 = iValueContainer.fIValueTable[n2];
                            }
                        } else {
                            iValue4.next = iValue3.next;
                            iValue3.next = iValueContainer.fDiscardedList;
                            iValueContainer.fDiscardedList = iValue3;
                            iValue3 = iValue4.next;
                        }
                        if (bl) continue;
                        --this.fLength;
                        if (iValue2 == null) {
                            if (!this.fIsUsingTable) {
                                this.fIValueList = iValue.next;
                                iValue.next = null;
                                iValue = this.fIValueList;
                                continue block1;
                            }
                            this.fIValueTable[i] = iValue.next;
                            iValue.next = null;
                            iValue = this.fIValueTable[i];
                            continue block1;
                        }
                        iValue2.next = iValue.next;
                        iValue.next = null;
                        iValue = iValue2.next;
                        continue block1;
                    }
                    iValue4 = iValue3;
                    iValue3 = iValue3.next;
                }
                iValue2 = iValue;
                iValue = iValue.next;
            }
        }
        if (!bl) {
            this.removeConflictDiscardKeys(iValueContainer);
            iValueContainer.removeConflictDiscardKeys(this);
        }
    }

    public boolean resolveKeyref(IValueContainer[] iValueContainerArray, int n2, int n3) {
        int n4 = this.fIsUsingTable ? this.fIValueTable.length : 1;
        for (int i = 0; i < n4; ++i) {
            if (this.fIsUsingTable && this.fIValueTableChainState[i] != this.fTableCount) continue;
            IValue iValue = this.fIsUsingTable ? this.fIValueTable[i] : this.fIValueList;
            while (iValue != null) {
                boolean bl = false;
                for (int j = n3; j < n2; ++j) {
                    if (!iValueContainerArray[j].contains(iValue)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
                iValue = iValue.next;
            }
        }
        return true;
    }

    public boolean contains(IValue iValue) {
        this.refreshFValueArrays();
        IValue iValue2 = null;
        if (!this.fIsUsingTable) {
            iValue2 = this.fIValueList;
        } else {
            int n2 = this.getTableViewBucket(iValue);
            if (this.fIValueTableChainState[n2] == this.fTableCount) {
                iValue2 = this.fIValueTable[n2];
            }
        }
        while (iValue2 != null) {
            if (this.equals(iValue2, iValue, iValue.container.idcID, iValue.container.fieldCount)) {
                return true;
            }
            iValue2 = iValue2.next;
        }
        return false;
    }

    public void clear() {
        this.fLength = 0;
        this.fIValueList = null;
        this.fIsUsingTable = false;
        this.fDiscardedList = null;
    }

    private void cleanTable() {
        if (++this.fTableCount < 0) {
            if (this.fIValueTableChainState != null) {
                for (int i = this.fTableBuckets - 1; i >= 0; --i) {
                    this.fIValueTableChainState[i] = 0;
                }
            }
            this.fTableCount = 1;
        }
    }

    private void prepareTable() {
        if (this.fIValueTable == null) {
            this.fIValueTable = new IValue[this.fTableBuckets];
            this.fIValueTableChainState = new int[this.fTableBuckets];
        } else {
            this.cleanTable();
        }
    }

    private void prepareAndPopulateTable() {
        this.prepareTable();
        IValue iValue = this.fIValueList;
        while (iValue != null) {
            IValue iValue2 = iValue;
            iValue = iValue.next;
            int n2 = this.getTableViewBucket(iValue2);
            if (this.fIValueTableChainState[n2] != this.fTableCount) {
                this.fIValueTableChainState[n2] = this.fTableCount;
                iValue2.next = null;
                this.fIValueTable[n2] = iValue2;
                continue;
            }
            iValue2.next = this.fIValueTable[n2];
            this.fIValueTable[n2] = iValue2;
        }
    }

    private void tableRehash() {
        int n2 = this.fTableBuckets;
        IValue[] iValueArray = this.fIValueTable;
        int[] nArray = this.fIValueTableChainState;
        this.fTableBuckets = n2 << 2;
        this.fIValueTable = new IValue[this.fTableBuckets];
        this.fIValueTableChainState = new int[this.fTableBuckets];
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != this.fTableCount) continue;
            IValue iValue = iValueArray[i];
            while (iValue != null) {
                int n3 = this.getTableViewBucket(iValue);
                IValue iValue2 = iValue.next;
                iValue.next = this.fIValueTable[n3];
                this.fIValueTable[n3] = iValue;
                iValue = iValue2;
                this.fIValueTableChainState[n3] = 1;
            }
        }
        this.fTableCount = 1;
    }

    private int getTableViewBucket(IValue iValue) {
        int n2 = iValue.startOffset;
        int n3 = n2 + iValue.container.fieldCount;
        int n4 = iValue.container.idcID;
        int n5 = 0;
        for (int i = n2; i < n3; ++i) {
            n5 ^= this.fContext.idcFValues[n4][i].hashCode();
        }
        return (n5 & Integer.MAX_VALUE) % this.fTableBuckets;
    }

    private void addUniqueOrKey(IValue iValue) {
        if (!this.fIsUsingTable && this.fLength < 10) {
            IValue iValue2 = this.fIValueList;
            while (iValue2 != null) {
                if (this.equals(iValue, iValue2)) {
                    this.fContext.vmContext.generateError(3 == this.idcCategory ? 32 : 31);
                    return;
                }
                iValue2 = iValue2.next;
            }
            ++this.fLength;
            iValue.next = this.fIValueList;
            this.fIValueList = iValue;
        } else {
            if (!this.fIsUsingTable) {
                this.prepareAndPopulateTable();
                this.fIsUsingTable = true;
            } else if ((double)this.fLength >= (double)this.fTableBuckets * 0.75) {
                this.tableRehash();
            }
            int n2 = this.getTableViewBucket(iValue);
            if (this.fIValueTableChainState[n2] != this.fTableCount) {
                ++this.fLength;
                this.fIValueTableChainState[n2] = this.fTableCount;
                iValue.next = null;
                this.fIValueTable[n2] = iValue;
            } else {
                IValue iValue3 = this.fIValueTable[n2];
                while (iValue3 != null) {
                    if (this.equals(iValue, iValue3)) {
                        this.fContext.vmContext.generateError(3 == this.idcCategory ? 32 : 31);
                        return;
                    }
                    iValue3 = iValue3.next;
                }
                ++this.fLength;
                iValue.next = this.fIValueTable[n2];
                this.fIValueTable[n2] = iValue;
            }
        }
    }

    private void addKeyRef(IValue iValue) {
        iValue.next = this.fIValueList;
        this.fIValueList = iValue;
    }

    private void removeConflictDiscardKeys(IValueContainer iValueContainer) {
        if (iValueContainer.fDiscardedList == null) {
            return;
        }
        int n2 = this.fIsUsingTable ? this.fIValueTable.length : 1;
        for (int i = 0; i < n2; ++i) {
            if (this.fIsUsingTable && this.fIValueTableChainState[i] != this.fTableCount) continue;
            IValue iValue = this.fIsUsingTable ? this.fIValueTable[i] : this.fIValueList;
            IValue iValue2 = null;
            block1: while (iValue != null) {
                IValue iValue3 = iValueContainer.fDiscardedList;
                while (iValue3 != null && iValue != null) {
                    if (this.equals(iValue, iValue3, iValueContainer.idcID, iValueContainer.fieldCount)) {
                        --this.fLength;
                        if (iValue2 == null) {
                            if (!this.fIsUsingTable) {
                                this.fIValueList = iValue.next;
                                iValue.next = null;
                                iValue = this.fIValueList;
                                continue block1;
                            }
                            this.fIValueTable[i] = iValue.next;
                            iValue.next = null;
                            iValue = this.fIValueTable[i];
                            continue block1;
                        }
                        iValue2.next = iValue.next;
                        iValue.next = null;
                        iValue = iValue2.next;
                        continue block1;
                    }
                    iValue3 = iValue3.next;
                }
                iValue2 = iValue;
                iValue = iValue.next;
            }
        }
    }

    private final boolean equals(IValue iValue, IValue iValue2) {
        int n2 = iValue.startOffset;
        int n3 = iValue2.startOffset;
        for (int i = 0; i < this.fieldCount; ++i) {
            int n4;
            int n5 = IValueContainer.convertToPrimitiveKind(this.idcFTypes[n2]);
            if (n5 != (n4 = IValueContainer.convertToPrimitiveKind(this.idcFTypes[n3])) || !this.idcFValues[n2].equals(this.idcFValues[n3])) {
                return false;
            }
            if (n5 == 44 || n5 == 43) {
                int[] nArray = this.idcFItemTypes[n2];
                int[] nArray2 = this.idcFItemTypes[n3];
                if (nArray.length != nArray2.length) {
                    return false;
                }
                int n6 = 0;
                while (i < nArray.length) {
                    if (nArray[n6] != nArray2[n6]) {
                        return false;
                    }
                    ++n6;
                }
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    private final boolean equals(IValue iValue, IValue iValue2, int n2, int n3) {
        int n4 = iValue.startOffset;
        int n5 = iValue2.startOffset;
        int[] nArray = this.fContext.idcFTypes[n2];
        Object[] objectArray = this.fContext.idcFValues[n2];
        int[][] nArray2 = this.fContext.idcFItemTypes[n2];
        if (this.fieldCount != n3) {
            return false;
        }
        for (int i = 0; i < this.fieldCount; ++i) {
            int n6;
            int n7 = IValueContainer.convertToPrimitiveKind(this.idcFTypes[n4]);
            if (n7 != (n6 = IValueContainer.convertToPrimitiveKind(nArray[n5])) || !this.idcFValues[n4].equals(objectArray[n5])) {
                return false;
            }
            if (n7 == 44 || n7 == 43) {
                int[] nArray3 = this.idcFItemTypes[n4];
                int[] nArray4 = nArray2[n5];
                if (nArray3.length != nArray4.length) {
                    return false;
                }
                int n8 = 0;
                while (i < nArray3.length) {
                    if (nArray3[n8] != nArray4[n8]) {
                        return false;
                    }
                    ++n8;
                }
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    private static final int convertToPrimitiveKind(int n2) {
        if (n2 <= 20) {
            return n2;
        }
        if (n2 <= 29) {
            return 2;
        }
        if (n2 <= 42) {
            return 4;
        }
        return n2;
    }

    private void refreshFValueArrays() {
        this.idcFValues = this.fContext.idcFValues[this.idcID];
        this.idcFTypes = this.fContext.idcFTypes[this.idcID];
        this.idcFItemTypes = this.fContext.idcFItemTypes[this.idcID];
    }
}

