/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XMLString {
    public static final short FLAGS_NOTWHITESPACE = 1;
    public static final short FLAGS_ALLWHITESPACE = 2;
    public static final short FLAGS_NORMALIZE_EOL = 4;
    public static final short FLAGS_NORMALIZE_EOL11 = 8;
    public static final short FLAGS_NORMALIZE_EOL_MASK = 12;
    public byte[] bytes;
    public int startOffset;
    public int endOffset;
    public int length;
    public short flags;
    public short encodeFlags;
    public int hashcode;
    public DataBuffer firstBuffer;
    public DataBuffer lastBuffer;
    protected char[][] fConvertedChars;
    protected int[] fConvertedCharsOffset;
    protected int[] fMultiByteCharInfo;
    protected final DataBufferReferrer fBufferReferrer = new DataBufferReferrer(){

        public boolean hasReferenceTo(DataBuffer dataBuffer) {
            if (XMLString.this.firstBuffer == dataBuffer) {
                return true;
            }
            if (XMLString.this.bytes != null || XMLString.this.firstBuffer == null) {
                return false;
            }
            if (XMLString.this.lastBuffer != null) {
                DataBuffer dataBuffer2 = XMLString.this.firstBuffer.next;
                while (true) {
                    if (dataBuffer2 == dataBuffer) {
                        return true;
                    }
                    if (dataBuffer2 == XMLString.this.lastBuffer) {
                        return false;
                    }
                    dataBuffer2 = dataBuffer2.next;
                }
            }
            if (XMLString.this.firstBuffer.next == null) {
                return false;
            }
            DataBuffer dataBuffer3 = XMLString.this.firstBuffer.next;
            while (dataBuffer3 != dataBuffer) {
                if (dataBuffer3 == null) {
                    return false;
                }
                dataBuffer3 = dataBuffer3.next;
            }
            return true;
        }

        public void removeReferencesAndUnregister() {
            XMLString.this.unregister();
        }
    };
    protected DataBufferFactory fBufferFactory;

    public XMLString() {
    }

    public XMLString(XMLString xMLString) {
        this();
        this.bytes = xMLString.bytes;
        this.startOffset = xMLString.startOffset;
        this.endOffset = xMLString.endOffset;
        this.length = xMLString.length;
        this.flags = xMLString.flags;
        this.encodeFlags = xMLString.encodeFlags;
        this.hashcode = xMLString.hashcode;
        this.firstBuffer = xMLString.firstBuffer;
        this.lastBuffer = xMLString.lastBuffer;
        this.fBufferFactory = xMLString.fBufferFactory;
        if (this.fBufferFactory != null) {
            this.fBufferFactory.addReferrer(this.fBufferReferrer);
        }
        this.fBufferReferrer.active = this.firstBuffer != null;
    }

    public void clear() {
        if (this.firstBuffer != null) {
            this.bytes = null;
            this.startOffset = 0;
            this.endOffset = 0;
            this.length = 0;
            this.flags = 0;
            this.encodeFlags = 0;
            this.hashcode = 0;
            this.firstBuffer = null;
            this.lastBuffer = null;
            this.fBufferReferrer.active = false;
        }
    }

    public void unregister() {
        this.clear();
        if (this.fBufferFactory != null) {
            this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            this.fBufferFactory = null;
        }
    }

    public final void setValues(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3) {
        if (dataBuffer2 == null) {
            this.setValues(dataBuffer, n2, n3);
        } else {
            this.setStartPos(dataBuffer, n2);
            this.setEndPos(dataBuffer2, n3);
        }
    }

    public final void setValues(DataBuffer dataBuffer, int n2, int n3) {
        if (this.lastBuffer == null && n2 < dataBuffer.endOffset) {
            this.startOffset = n2;
            this.endOffset = n3;
            this.length = n3 - n2;
            this.bytes = dataBuffer.bytes;
            this.flags = 0;
            this.encodeFlags = 0;
            this.hashcode = 0;
            if (this.firstBuffer == dataBuffer) {
                return;
            }
            this.firstBuffer = dataBuffer;
        } else {
            this.setStartPos(dataBuffer, n2);
            this.setEndPos(dataBuffer, n3);
        }
        if (this.fBufferFactory != this.firstBuffer.factory) {
            if (this.fBufferFactory != null) {
                this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            }
            this.fBufferFactory = dataBuffer.factory;
            this.fBufferFactory.addReferrer(this.fBufferReferrer);
        }
        this.fBufferReferrer.active = true;
    }

    public final void setStartPos(DataBuffer dataBuffer, int n2) {
        this.startOffset = n2;
        this.bytes = null;
        this.flags = 0;
        this.encodeFlags = 0;
        this.hashcode = 0;
        this.firstBuffer = dataBuffer;
        this.lastBuffer = null;
        if (this.fBufferFactory != this.firstBuffer.factory) {
            if (this.fBufferFactory != null) {
                this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            }
            this.fBufferFactory = this.firstBuffer.factory;
            this.fBufferFactory.addReferrer(this.fBufferReferrer);
        }
        this.fBufferReferrer.active = true;
    }

    public final void setEndPos(DataBuffer dataBuffer, int n2) {
        while (dataBuffer != this.firstBuffer) {
            if (this.startOffset < this.firstBuffer.endOffset) {
                if (n2 > dataBuffer.startOffset) {
                    this.setEndPosAcrossBuffers(dataBuffer, n2);
                    return;
                }
                dataBuffer = this.fixEndPos(dataBuffer);
                n2 = dataBuffer.endOffset;
                continue;
            }
            this.fixStartPos();
        }
        this.endOffset = n2;
        this.length = n2 - this.startOffset;
        this.bytes = dataBuffer.bytes;
        this.lastBuffer = null;
    }

    public void clearEndPos() {
        this.bytes = null;
        this.lastBuffer = null;
    }

    private final void setEndPosAcrossBuffers(DataBuffer dataBuffer, int n2) {
        this.bytes = null;
        DataBuffer dataBuffer2 = this.firstBuffer;
        this.length = dataBuffer2.endOffset - this.startOffset;
        while ((dataBuffer2 = dataBuffer2.next) != dataBuffer) {
            this.length += dataBuffer2.endOffset - dataBuffer2.startOffset;
        }
        this.length += n2 - dataBuffer2.startOffset;
        this.lastBuffer = dataBuffer2;
        this.endOffset = n2;
    }

    private final void fixStartPos() {
        this.firstBuffer = this.firstBuffer.next;
        this.startOffset = this.firstBuffer.startOffset;
    }

    private final DataBuffer fixEndPos(DataBuffer dataBuffer) {
        DataBuffer dataBuffer2 = this.firstBuffer;
        while (dataBuffer2.next != dataBuffer) {
            dataBuffer2 = dataBuffer2.next;
        }
        return dataBuffer2;
    }

    public void setValues(XMLString xMLString) {
        if (xMLString != null && xMLString.firstBuffer != null) {
            this.bytes = xMLString.bytes;
            this.startOffset = xMLString.startOffset;
            this.endOffset = xMLString.endOffset;
            this.length = xMLString.length;
            this.flags = xMLString.flags;
            this.encodeFlags = xMLString.encodeFlags;
            this.hashcode = xMLString.hashcode;
            this.firstBuffer = xMLString.firstBuffer;
            this.lastBuffer = xMLString.lastBuffer;
            if (this.fBufferFactory != this.firstBuffer.factory) {
                if (this.fBufferFactory != null) {
                    this.fBufferFactory.removeReferrer(this.fBufferReferrer);
                }
                this.fBufferFactory = this.firstBuffer.factory;
                this.fBufferFactory.addReferrer(this.fBufferReferrer);
            }
            this.fBufferReferrer.active = true;
        } else {
            this.clear();
        }
    }

    public final boolean isAllWhitespace() {
        if ((this.flags & 2) != 0) {
            return true;
        }
        if ((this.flags & 1) != 0) {
            return false;
        }
        return this.checkWhitespace();
    }

    private boolean checkWhitespace() {
        boolean bl;
        boolean bl2 = bl = (this.flags & 8) != 0;
        if (this.length > 0) {
            int n2 = this.startOffset;
            if (this.bytes != null) {
                while (n2 < this.endOffset) {
                    byte by2;
                    if ((by2 = this.bytes[n2++]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) continue;
                    if (bl && (by2 & 0xDF) == 194) {
                        if (n2 == this.endOffset) {
                            this.flags = (short)(this.flags | 1);
                            return false;
                        }
                        if ((by2 & 0xFF) == 194 && (this.bytes[n2] & 0xFF) == 133) {
                            ++n2;
                            continue;
                        }
                        if ((by2 & 0xFF) != 226 || (this.bytes[n2] & 0xFF) != 128) continue;
                        if (n2 + 1 < this.endOffset) {
                            if ((this.bytes[n2 + 1] & 0xFF) != 168) continue;
                            n2 += 2;
                            continue;
                        }
                        this.flags = (short)(this.flags | 1);
                        return false;
                    }
                    this.flags = (short)(this.flags | 1);
                    return false;
                }
            } else {
                DataBuffer dataBuffer = this.firstBuffer;
                byte[] byArray = dataBuffer.bytes;
                int n3 = dataBuffer.endOffset;
                while (true) {
                    if (n2 < n3) {
                        byte by3;
                        if ((by3 = byArray[n2++]) == 32 || by3 == 10 || by3 == 9 || by3 == 13) continue;
                        if (bl && (by3 & 0xDF) == 194) {
                            if (n2 == n3) {
                                if (dataBuffer == this.lastBuffer) {
                                    this.flags = (short)(this.flags | 1);
                                    return false;
                                }
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n2 = dataBuffer.startOffset;
                                int n4 = n3 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                            }
                            if ((by3 & 0xFF) == 194 && (byArray[n2] & 0xFF) == 133) {
                                ++n2;
                                continue;
                            }
                            if ((by3 & 0xFF) != 226 || (byArray[n2] & 0xFF) != 128) continue;
                            if (n2 + 1 < n3) {
                                if ((byArray[n2 + 1] & 0xFF) != 168) continue;
                                n2 += 2;
                                continue;
                            }
                            if (dataBuffer != this.lastBuffer && (dataBuffer.next.bytes[dataBuffer.next.startOffset] & 0xFF) == 168) {
                                dataBuffer = dataBuffer.next;
                                byArray = dataBuffer.bytes;
                                n2 = dataBuffer.startOffset + 1;
                                n3 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                                continue;
                            }
                            this.flags = (short)(this.flags | 1);
                            return false;
                        }
                        this.flags = (short)(this.flags | 1);
                        return false;
                    }
                    if (dataBuffer == this.lastBuffer) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n2 = dataBuffer.startOffset;
                    if (dataBuffer == this.lastBuffer) {
                        n3 = this.endOffset;
                        continue;
                    }
                    n3 = dataBuffer.endOffset;
                }
            }
        }
        this.flags = (short)(this.flags | 2);
        return true;
    }

    public final boolean isNormalized() {
        byte by2;
        if (this.length == 0) {
            return true;
        }
        if (this.bytes != null) {
            int n2 = this.startOffset;
            while (n2 < this.endOffset) {
                byte by3 = this.bytes[n2];
                if (by3 < 0 || by3 > 32) {
                    while ((by3 < 0 || by3 > 32) && ++n2 < this.endOffset) {
                        by3 = this.bytes[n2];
                    }
                    if (n2 >= this.endOffset || by3 >= 32 && ++n2 != this.endOffset) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n3 = this.startOffset;
        int n4 = dataBuffer.endOffset;
        while ((by2 = byArray[n3]) < 0 || by2 > 32) {
            while (by2 < 0 || by2 > 32) {
                if (++n3 < n4) {
                    by2 = byArray[n3];
                    continue;
                }
                if (dataBuffer == this.lastBuffer) {
                    return true;
                }
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                by2 = byArray[n3];
            }
            if (by2 < 32) {
                return false;
            }
            if (++n3 != n4) continue;
            if (dataBuffer == this.lastBuffer) {
                return false;
            }
            dataBuffer = dataBuffer.next;
            byArray = dataBuffer.bytes;
            n3 = dataBuffer.startOffset;
            if (dataBuffer == this.lastBuffer) {
                n4 = this.endOffset;
                continue;
            }
            n4 = dataBuffer.endOffset;
        }
        return false;
    }

    public final boolean equalsXMLString(XMLString xMLString) {
        if (xMLString == this) {
            return true;
        }
        if (this.length > 0 && this.length == xMLString.length) {
            if (this.bytes != null && xMLString.bytes != null) {
                int n2 = this.length;
                if (this.bytes[this.startOffset] != xMLString.bytes[xMLString.startOffset]) {
                    return false;
                }
                while (--n2 > 0) {
                    if (this.bytes[this.startOffset + n2] == xMLString.bytes[xMLString.startOffset + n2]) continue;
                    return false;
                }
                return true;
            }
            DataBuffer dataBuffer = this.firstBuffer;
            DataBuffer dataBuffer2 = xMLString.firstBuffer;
            byte[] byArray = dataBuffer.bytes;
            int n3 = this.startOffset;
            byte[] byArray2 = dataBuffer2.bytes;
            int n4 = xMLString.startOffset;
            if (byArray[n3] != byArray2[n4]) {
                return false;
            }
            DataBuffer dataBuffer3 = this.lastBuffer != null ? this.lastBuffer : dataBuffer;
            DataBuffer dataBuffer4 = xMLString.lastBuffer != null ? xMLString.lastBuffer : dataBuffer2;
            int n5 = this.lastBuffer != null ? dataBuffer.endOffset : this.endOffset;
            int n6 = xMLString.lastBuffer != null ? dataBuffer2.endOffset : xMLString.endOffset;
            int n7 = this.length;
            while (--n7 > 0) {
                if (++n3 == n5) {
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n3 = dataBuffer.startOffset;
                    int n8 = n5 = dataBuffer != dataBuffer3 ? dataBuffer.endOffset : this.endOffset;
                }
                if (++n4 == n6) {
                    dataBuffer2 = dataBuffer2.next;
                    byArray2 = dataBuffer2.bytes;
                    n4 = dataBuffer2.startOffset;
                    int n9 = n6 = dataBuffer2 != dataBuffer4 ? dataBuffer2.endOffset : xMLString.endOffset;
                }
                if (byArray[n3] == byArray2[n4]) continue;
                return false;
            }
            return true;
        }
        return this.length == xMLString.length;
    }

    protected final boolean equalsString(String string2) {
        int n2 = this.startOffset;
        if (this.bytes != null) {
            int n3 = string2.length();
            for (int i = 0; i < n3; ++i) {
                char c = string2.charAt(i);
                if (c == this.bytes[n2]) {
                    ++n2;
                    continue;
                }
                if (c < '\u0080') {
                    return false;
                }
                return this.toString().equals(string2);
            }
            return n2 == this.endOffset;
        }
        return this.toString().equals(string2);
    }

    public final boolean equalsString(byte[] byArray, int n2, int n3) {
        if (n2 + this.length == n3) {
            if (this.length > 0) {
                int n4 = this.startOffset;
                if (this.bytes != null) {
                    while (this.bytes[n4++] == byArray[n2] && ++n2 < n3 && this.bytes[n4++] == byArray[n2] && ++n2 < n3 && this.bytes[n4++] == byArray[n2] && ++n2 < n3) {
                    }
                    return n2 == n3;
                }
                DataBuffer dataBuffer = this.firstBuffer;
                while (true) {
                    int n5;
                    byte[] byArray2 = dataBuffer.bytes;
                    int n6 = n5 = dataBuffer != this.lastBuffer ? dataBuffer.endOffset : this.endOffset;
                    while (byArray2[n4] == byArray[n2++] && ++n4 < n5) {
                    }
                    if (n4 != n5) break;
                    if (dataBuffer == this.lastBuffer) {
                        return true;
                    }
                    dataBuffer = dataBuffer.next;
                    n4 = dataBuffer.startOffset;
                }
                return false;
            }
            return n2 == n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int n2 = this.startOffset;
        if (this.bytes != null) {
            while (n2 < this.endOffset) {
                byte by2 = this.bytes[n2];
                if (by2 >= 0) {
                    this.hashcode = this.hashcode * 31 + by2;
                    ++n2;
                    continue;
                }
                if (this.fMultiByteCharInfo == null) {
                    this.fMultiByteCharInfo = ArrayAllocator.newIntArray(2);
                }
                CharConversionError charConversionError = UTF8Support.decodeCharacter(this.bytes, n2, this.endOffset, this.fMultiByteCharInfo);
                assert (charConversionError == null);
                int n3 = this.fMultiByteCharInfo[0];
                if (n3 < 65536) {
                    this.hashcode = this.hashcode * 31 + n3;
                } else {
                    int n4 = n3 - 65536;
                    n3 = 55296 + (n4 >> 10);
                    this.hashcode = this.hashcode * 31 + n3;
                    n3 = 56320 + (n4 & 0x3FF);
                    this.hashcode = this.hashcode * 31 + n3;
                }
                n2 += this.fMultiByteCharInfo[1];
            }
            return this.hashcode;
        } else {
            DataBuffer dataBuffer = this.firstBuffer;
            block1: while (true) {
                int n5;
                byte[] byArray = dataBuffer.bytes;
                int n6 = n5 = dataBuffer == this.lastBuffer ? this.endOffset : dataBuffer.endOffset;
                while (true) {
                    byte by3;
                    if ((by3 = byArray[n2]) >= 0) {
                        this.hashcode = this.hashcode * 31 + by3;
                        if (++n2 != n5) continue;
                        if (dataBuffer == this.lastBuffer) return this.hashcode;
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                        continue block1;
                    }
                    if (this.fMultiByteCharInfo == null) {
                        this.fMultiByteCharInfo = ArrayAllocator.newIntArray(2);
                    }
                    CharConversionError charConversionError = UTF8Support.decodeCharacter(dataBuffer, n2, this.lastBuffer, this.endOffset, this.fMultiByteCharInfo);
                    assert (charConversionError == null);
                    int n7 = this.fMultiByteCharInfo[0];
                    if (n7 < 65536) {
                        this.hashcode = this.hashcode * 31 + n7;
                    } else {
                        int n8 = n7 - 65536;
                        n7 = 55296 + (n8 >> 10);
                        this.hashcode = this.hashcode * 31 + n7;
                        n7 = 56320 + (n8 & 0x3FF);
                        this.hashcode = this.hashcode * 31 + n7;
                    }
                    if ((n2 += this.fMultiByteCharInfo[1]) == n5) {
                        if (dataBuffer == this.lastBuffer) return this.hashcode;
                        dataBuffer = dataBuffer.next;
                        n2 = dataBuffer.startOffset;
                        continue block1;
                    }
                    if (n2 >= n5) break;
                }
                if (dataBuffer == this.lastBuffer) return this.hashcode;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset + (n2 - n5);
                if (dataBuffer == this.lastBuffer && n2 == this.endOffset) return this.hashcode;
            }
        }
    }

    public boolean equals(Object object2) {
        if (object2 == this) {
            return true;
        }
        if (object2 instanceof XMLString) {
            return this.equalsXMLString((XMLString)object2);
        }
        return false;
    }

    public int compare(XMLString xMLString) {
        if (xMLString.length == this.length) {
            return this.compare2(xMLString, this.length, 0);
        }
        if (xMLString.length < this.length) {
            return this.compare2(xMLString, xMLString.length, 1);
        }
        return this.compare2(xMLString, this.length, -1);
    }

    private int compare2(XMLString xMLString, int n2, int n3) {
        if (n2 == 0) {
            return n3;
        }
        if (this.bytes != null && xMLString.bytes != null) {
            return this.compare2Unbuffered(xMLString, n2, n3);
        }
        return this.compare2Buffered(xMLString, n2, n3);
    }

    private int compare2Unbuffered(XMLString xMLString, int n2, int n3) {
        byte[] byArray = this.bytes;
        byte[] byArray2 = xMLString.bytes;
        int n4 = this.startOffset;
        int n5 = xMLString.startOffset;
        int n6 = n4 + n2;
        while (n4 < n6) {
            byte by2;
            byte by3;
            if ((by3 = byArray[n4++]) > (by2 = byArray2[n5++])) {
                return 1;
            }
            if (by3 >= by2) continue;
            return -1;
        }
        return n3;
    }

    private int compare2Buffered(XMLString xMLString, int n2, int n3) {
        DataBuffer dataBuffer = this.firstBuffer;
        byte[] byArray = dataBuffer.bytes;
        int n4 = this.startOffset;
        byte by2 = byArray[n4];
        DataBuffer dataBuffer2 = xMLString.firstBuffer;
        byte[] byArray2 = dataBuffer2.bytes;
        int n5 = xMLString.startOffset;
        byte by3 = byArray2[n5];
        if (by2 > by3) {
            return 1;
        }
        if (by2 < by3) {
            return -1;
        }
        DataBuffer dataBuffer3 = this.lastBuffer;
        int n6 = dataBuffer.endOffset;
        if (dataBuffer3 == null) {
            dataBuffer3 = dataBuffer;
            n6 = this.endOffset;
        }
        DataBuffer dataBuffer4 = xMLString.lastBuffer;
        int n7 = dataBuffer2.endOffset;
        if (dataBuffer4 == null) {
            dataBuffer4 = dataBuffer2;
            n7 = xMLString.endOffset;
        }
        int n8 = 0;
        while (++n8 < n2) {
            if (++n4 == n6) {
                dataBuffer = dataBuffer.next;
                byArray = dataBuffer.bytes;
                n4 = dataBuffer.startOffset;
                n6 = dataBuffer != dataBuffer3 ? dataBuffer.endOffset : this.endOffset;
            }
            by2 = byArray[n4];
            if (++n5 == n7) {
                dataBuffer2 = dataBuffer2.next;
                byArray2 = dataBuffer2.bytes;
                n5 = dataBuffer2.startOffset;
                int n9 = n7 = dataBuffer2 != dataBuffer4 ? dataBuffer2.endOffset : xMLString.endOffset;
            }
            if (by2 > (by3 = byArray2[n5])) {
                return 1;
            }
            if (by2 >= by3) continue;
            return -1;
        }
        return n3;
    }

    public XMLString normalizeLineBreaks(XMLStringBuffer xMLStringBuffer, XMLString xMLString) {
        if (this.firstBuffer != null && (this.flags & 0xC) != 0) {
            return xMLStringBuffer.addXMLString(this, xMLString);
        }
        return this;
    }

    public final CharConversionError getChars(char[][] cArray, int[] nArray) {
        if (this.firstBuffer != null && (this.bytes != null || this.lastBuffer != null)) {
            if ((this.flags & 0xC) != 0) {
                return UTF8Support.normalizeBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray, (this.flags & 8) != 0);
            }
            return UTF8Support.convertBytesToChars(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, cArray, nArray);
        }
        return null;
    }

    public final int lengthAsCharacters(int[] nArray) {
        return UTF8Support.lengthAsCharacters(this.firstBuffer, this.lastBuffer, this.startOffset, this.endOffset, this.flags, nArray);
    }

    public final String toString() {
        if (this.firstBuffer != null && (this.bytes != null || this.lastBuffer != null)) {
            CharConversionError charConversionError = this.convertToChars();
            if (charConversionError == null) {
                return new String(this.fConvertedChars[0], 0, this.fConvertedCharsOffset[0]);
            }
            return null;
        }
        return null;
    }

    protected final CharConversionError convertToChars() {
        if (this.fConvertedChars == null) {
            int n2;
            for (n2 = 16; n2 < this.length; n2 <<= 1) {
            }
            this.fConvertedChars = ArrayAllocator.newCharArray2(1);
            this.fConvertedChars[0] = ArrayAllocator.newCharArray(n2);
            this.fConvertedCharsOffset = ArrayAllocator.newIntArray(1);
        }
        this.fConvertedCharsOffset[0] = 0;
        return this.getChars(this.fConvertedChars, this.fConvertedCharsOffset);
    }
}

