/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class UTF8Support {
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};

    public static CharConversionError convertCharsToBytes(char[] cArray, int n2, int n3, byte[][] byArray, int[] nArray) {
        int n4;
        int n5;
        byte[] byArray2 = byArray[0];
        int n6 = nArray[0];
        int n7 = byArray2.length;
        if (nArray[1] == -1) {
            n5 = n7 - n6;
            int n8 = n3 - n2 <= n5 ? n3 : n2 + n5;
            while (n2 < n8 && (n4 = cArray[n2]) < 128) {
                ++n2;
                byArray2[n6++] = (byte)n4;
            }
            if (n2 == n3) {
                nArray[0] = n6;
                return null;
            }
        } else {
            n4 = nArray[1];
            if (n2 == n3) {
                nArray[0] = n6;
                nArray[1] = n2;
                return CharConversionError.missingSecondHalfOfSurrogatePair();
            }
            nArray[1] = -1;
            if ((n5 = cArray[n2++]) < 56320 || n5 >= 57344) {
                nArray[0] = n6;
                nArray[1] = n2 - 1;
                return CharConversionError.invalidSecondHalfOfSurrogatePair();
            }
            n4 = 65536 + (n4 - 55296 << 10) + (n5 - 56320);
            if (n6 + 4 > n7) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
                n7 <<= 1;
            }
            byArray2[n6] = (byte)(0xF0 | n4 >> 18);
            byArray2[n6 + 1] = (byte)(0x80 | 0x3F & n4 >> 12);
            byArray2[n6 + 2] = (byte)(0x80 | 0x3F & n4 >> 6);
            byArray2[n6 + 3] = (byte)(0x80 | 0x3F & n4);
            n6 += 4;
        }
        while (n2 < n3) {
            if ((n4 = cArray[n2++]) < 128) {
                if (n6 == n7) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n6++] = (byte)n4;
                continue;
            }
            if (n4 < 2048) {
                if (n6 + 2 > n7) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n6] = (byte)(0xC0 | n4 >> 6);
                byArray2[n6 + 1] = (byte)(0x80 | 0x3F & n4);
                n6 += 2;
                continue;
            }
            if (n4 < 55296 || n4 >= 57344) {
                if (n6 + 3 > n7) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n6] = (byte)(0xE0 | n4 >> 12);
                byArray2[n6 + 1] = (byte)(0x80 | 0x3F & n4 >> 6);
                byArray2[n6 + 2] = (byte)(0x80 | 0x3F & n4);
                n6 += 3;
                continue;
            }
            if (n4 < 56320) {
                if (n2 == n3) {
                    nArray[1] = n4;
                    break;
                }
                n5 = cArray[n2];
                if (n5 >= 56320 && n5 < 57344) {
                    ++n2;
                } else {
                    nArray[0] = n6;
                    nArray[1] = n2 - 1;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n4 = 65536 + (n4 - 55296 << 10) + (n5 - 56320);
                if (n6 + 4 > n7) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n7 <<= 1;
                }
                byArray2[n6] = (byte)(0xF0 | n4 >> 18);
                byArray2[n6 + 1] = (byte)(0x80 | 0x3F & n4 >> 12);
                byArray2[n6 + 2] = (byte)(0x80 | 0x3F & n4 >> 6);
                byArray2[n6 + 3] = (byte)(0x80 | 0x3F & n4);
                n6 += 4;
                continue;
            }
            nArray[0] = n6;
            nArray[1] = n2 - 1;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        nArray[0] = n6;
        return null;
    }

    public static CharConversionError convertCharsToBytes(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5, int[] nArray) {
        int n6;
        int n7 = n5 - n4;
        int n8 = n3 - n2 <= n7 ? n3 : n2 + n7;
        while (n2 < n8 && (n6 = cArray[n2]) < 128) {
            ++n2;
            byArray[n4++] = (byte)n6;
        }
        if (n2 == n3) {
            nArray[0] = n2;
            nArray[1] = n4;
            return null;
        }
        while (n2 < n3) {
            n6 = cArray[n2];
            if (n6 < 128) {
                if (n4 == n5) {
                    nArray[0] = n2;
                    nArray[1] = n4;
                    return null;
                }
                ++n2;
                byArray[n4++] = (byte)n6;
                continue;
            }
            if (n6 < 2048) {
                if (n4 + 2 > n5) {
                    nArray[0] = n2;
                    nArray[1] = n4;
                    return null;
                }
                ++n2;
                byArray[n4] = (byte)(0xC0 | n6 >> 6);
                byArray[n4 + 1] = (byte)(0x80 | 0x3F & n6);
                n4 += 2;
                continue;
            }
            if (n6 < 55296 || n6 >= 57344) {
                if (n4 + 3 > n5) {
                    nArray[0] = n2;
                    nArray[1] = n4;
                    return null;
                }
                ++n2;
                byArray[n4] = (byte)(0xE0 | n6 >> 12);
                byArray[n4 + 1] = (byte)(0x80 | 0x3F & n6 >> 6);
                byArray[n4 + 2] = (byte)(0x80 | 0x3F & n6);
                n4 += 3;
                continue;
            }
            if (n6 < 56320) {
                if (++n2 == n3 || n4 + 4 > n5) {
                    nArray[0] = n2 - 1;
                    nArray[1] = n4;
                    return null;
                }
                char c = cArray[n2];
                if (c >= '\udc00' && c < '\ue000') {
                    ++n2;
                } else {
                    nArray[0] = n2 - 1;
                    nArray[1] = n4;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n6 = 65536 + (n6 - 55296 << 10) + (c - 56320);
                byArray[n4] = (byte)(0xF0 | n6 >> 18);
                byArray[n4 + 1] = (byte)(0x80 | 0x3F & n6 >> 12);
                byArray[n4 + 2] = (byte)(0x80 | 0x3F & n6 >> 6);
                byArray[n4 + 3] = (byte)(0x80 | 0x3F & n6);
                n4 += 4;
                continue;
            }
            nArray[0] = n2;
            nArray[1] = n4;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        nArray[0] = n2;
        nArray[1] = n4;
        return null;
    }

    public static int encodeCharacter(int n2, byte[][] byArray, int n3) {
        byte[] byArray2 = byArray[0];
        int n4 = byArray2.length;
        if (n2 < 128) {
            if (n3 == n4) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n3] = (byte)n2;
            return n3 + 1;
        }
        if (n2 < 2048) {
            if (n3 + 2 > n4) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n3] = (byte)(0xC0 | n2 >> 6);
            byArray2[n3 + 1] = (byte)(0x80 | 0x3F & n2);
            return n3 + 2;
        }
        if (n2 < 65536) {
            if (n3 + 3 > n4) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n3] = (byte)(0xE0 | n2 >> 12);
            byArray2[n3 + 1] = (byte)(0x80 | 0x3F & n2 >> 6);
            byArray2[n3 + 2] = (byte)(0x80 | 0x3F & n2);
            return n3 + 3;
        }
        if (n3 + 4 > n4) {
            byArray2 = UTF8Support.resize(byArray2);
            byArray[0] = byArray2;
        }
        byArray2[n3] = (byte)(0xF0 | n2 >> 18);
        byArray2[n3 + 1] = (byte)(0x80 | 0x3F & n2 >> 12);
        byArray2[n3 + 2] = (byte)(0x80 | 0x3F & n2 >> 6);
        byArray2[n3 + 3] = (byte)(0x80 | 0x3F & n2);
        return n3 + 4;
    }

    public static CharConversionError convertBytesToChars(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3, char[][] cArray, int[] nArray) {
        byte[] byArray = dataBuffer.bytes;
        int n4 = n2;
        char[] cArray2 = cArray[0];
        int n5 = nArray[0];
        if (dataBuffer2 == null && n3 - n4 <= cArray2.length - n5) {
            while (n4 < n3 && byArray[n4] >= 0) {
                cArray2[n5++] = (char)byArray[n4++];
            }
            if (n4 == n3) {
                nArray[0] = n5;
                return null;
            }
            n2 = n4;
            nArray[0] = n5;
        }
        return UTF8Support.convertBytesToChars2(dataBuffer, dataBuffer2, n2, n3, cArray, nArray);
    }

    private static CharConversionError convertBytesToChars2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3, char[][] cArray, int[] nArray) {
        int n4;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n5 = n2;
        char[] cArray2 = cArray[0];
        int n6 = nArray[0];
        int n7 = cArray2.length;
        int n8 = n7 - n6;
        int n9 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n4 = n3;
        } else {
            n4 = dataBuffer2 == dataBuffer3 ? n3 : dataBuffer3.endOffset;
        }
        while (true) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14 = n4 - n5 <= (n8 = n7 - n6) ? n4 : n5 + n8;
            while (n5 < n14 && (n9 = byArray[n5]) >= 0) {
                ++n5;
                cArray2[n6++] = (char)n9;
            }
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
                continue;
            }
            if (n6 == n7) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n7 <<= 1;
                continue;
            }
            if (n5 == n14) continue;
            if ((n13 = fgMultiByteLength[(n9 = byArray[n5++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n9, 0, 0, 0);
            }
            int n15 = n9 & fgFirstByteValueMask[n13];
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n12 = byArray[n5++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n9, n12, 0, 0);
            }
            if (n13 == 2) {
                n15 = (n15 << 6) + (0x3F & n12);
                cArray2[n6++] = (char)n15;
                continue;
            }
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n11 = byArray[n5++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n9, n12, n11, 0);
            }
            if (n13 == 3) {
                if ((n15 = (n15 << 12) + ((0x3F & n12) << 6) + (0x3F & n11)) >= 55296 && n15 < 57344) {
                    return UTF8Support.charConversionFailure(1, n9, n12, n11, 0);
                }
                cArray2[n6++] = (char)n15;
                continue;
            }
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n5++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n9, n12, n11, n10);
            }
            int n16 = (n15 << 8) + ((0x30 & n12) << 2);
            if (n16 > 1024 || n16 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n17 = n16 - 64;
            int n18 = 55296 + n17 + ((0xF & n12) << 2) + ((0x30 & n11) >> 4);
            int n19 = 56320 + ((0xF & n11) << 6) + (0x3F & n10);
            cArray2[n6] = (char)n18;
            if (n6 + 1 == n7) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n7 <<= 1;
            }
            cArray2[n6 + 1] = (char)n19;
            n6 += 2;
        }
    }

    public static CharConversionError normalizeBytesToChars(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3, char[][] cArray, int[] nArray, boolean bl) {
        block5: {
            byte[] byArray = dataBuffer.bytes;
            int n4 = n2;
            char[] cArray2 = cArray[0];
            int n5 = nArray[0];
            if (dataBuffer2 == null && n3 - n4 <= cArray2.length - n5) {
                while (n4 < n3) {
                    if (byArray[n4] != 13) {
                        if (byArray[n4] >= 0) {
                            cArray2[n5++] = (char)byArray[n4++];
                            continue;
                        }
                        break block5;
                    }
                    cArray2[n5++] = 10;
                    if (++n4 < n3 && byArray[n4] == 10) {
                        ++n4;
                        continue;
                    }
                    if (!bl || n4 + 1 >= n3 || (byArray[n4] & 0xFF) != 194 || (byArray[n4 + 1] & 0xFF) != 133) continue;
                    n4 += 2;
                }
                nArray[0] = n5;
                return null;
            }
        }
        return UTF8Support.normalizeBytesToChars2(dataBuffer, dataBuffer2, n2, n3, cArray, nArray, bl);
    }

    private static CharConversionError normalizeBytesToChars2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3, char[][] cArray, int[] nArray, boolean bl) {
        int n4;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n5 = n2;
        char[] cArray2 = cArray[0];
        int n6 = nArray[0];
        int n7 = cArray2.length;
        boolean bl2 = false;
        int n8 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n4 = n3;
        } else {
            n4 = dataBuffer2 == dataBuffer3 ? n3 : dataBuffer3.endOffset;
        }
        while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14 = n4 - n5 <= (n13 = n7 - n6) ? n4 : n5 + n13;
            while (n5 < n14) {
                n8 = byArray[n5];
                if (!bl2) {
                    if (n8 < 0) break;
                    ++n5;
                    if (n8 != 13) {
                        cArray2[n6++] = (char)n8;
                        continue;
                    }
                    bl2 = true;
                    cArray2[n6++] = 10;
                    continue;
                }
                bl2 = false;
                if (n8 == 10) {
                    ++n5;
                    continue;
                }
                if (n8 >= 0) {
                    ++n5;
                    if (n8 == 13) {
                        n8 = 10;
                        bl2 = true;
                    }
                    cArray2[n6++] = (char)n8;
                    continue;
                }
                bl2 = bl;
                break;
            }
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
                continue;
            }
            if (n6 == n7) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n7 <<= 1;
                continue;
            }
            if (n5 == n14) continue;
            if ((n12 = fgMultiByteLength[(n8 = byArray[n5++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n8, 0, 0, 0);
            }
            int n15 = n8 & fgFirstByteValueMask[n12];
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n11 = byArray[n5++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n8, n11, 0, 0);
            }
            if (n12 == 2) {
                n15 = (n15 << 6) + (0x3F & n11);
                if (bl && n15 == 133) {
                    if (!bl2) {
                        cArray2[n6++] = 10;
                    }
                } else {
                    cArray2[n6++] = (char)n15;
                }
                bl2 = false;
                continue;
            }
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n5++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n8, n11, n10, 0);
            }
            if (n12 == 3) {
                if ((n15 = (n15 << 12) + ((0x3F & n11) << 6) + (0x3F & n10)) >= 55296 && n15 < 57344) {
                    return UTF8Support.charConversionFailure(1, n8, n11, n10, 0);
                }
                cArray2[n6++] = bl && n15 == 8232 ? 10 : (char)n15;
                bl2 = false;
                continue;
            }
            if (n5 == n4) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n6;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                n5 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n9 = byArray[n5++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n8, n11, n10, n9);
            }
            int n16 = (n15 << 8) + ((0x30 & n11) << 2);
            if (n16 > 1024 || n16 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n17 = n16 - 64;
            int n18 = 55296 + n17 + ((0xF & n11) << 2) + ((0x30 & n10) >> 4);
            int n19 = 56320 + ((0xF & n10) << 6) + (0x3F & n9);
            cArray2[n6] = (char)n18;
            if (n6 + 1 == n7) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n7 <<= 1;
            }
            cArray2[n6 + 1] = (char)n19;
            n6 += 2;
        }
    }

    public static CharConversionError decodeCharacter(byte[] byArray, int n2, int n3, int[] nArray) {
        if (n2 < n3) {
            int n4 = byArray[n2];
            if (n4 >= 0) {
                nArray[0] = n4;
                nArray[1] = 1;
                return null;
            }
            int n5 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
            if (n5 > 0) {
                nArray[1] = n5;
                if (n2 + n5 > n3) {
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                int n6 = n4 & fgFirstByteValueMask[n5];
                int n7 = byArray[n2 + 1] & 0xFF;
                if ((0xC0 & n7) != 128) {
                    return UTF8Support.charConversionFailure(2, n4, n7, 0, 0);
                }
                if (n5 == 2) {
                    nArray[0] = n6 = (n6 << 6) + (0x3F & n7);
                    return null;
                }
                int n8 = byArray[n2 + 2] & 0xFF;
                if ((0xC0 & n8) != 128) {
                    return UTF8Support.charConversionFailure(3, n4, n7, n8, 0);
                }
                if (n5 == 3) {
                    nArray[0] = n6 = (n6 << 12) + ((0x3F & n7) << 6) + (0x3F & n8);
                    return null;
                }
                int n9 = byArray[n2 + 3] & 0xFF;
                if ((0xC0 & n9) != 128) {
                    return UTF8Support.charConversionFailure(4, n4, n7, n8, n9);
                }
                nArray[0] = n6 = (n6 << 18) + ((0x3F & n7) << 12) + ((0x3F & n8) << 6) + (0x3F & n9);
                return null;
            }
            return UTF8Support.charConversionFailure(1, n4, 0, 0, 0);
        }
        return CharConversionError.insufficientInputToDecodeCharacter();
    }

    public static CharConversionError decodeCharacter(DataBuffer dataBuffer, int n2, DataBuffer dataBuffer2, int n3, int[] nArray) {
        int n4;
        byte[] byArray;
        block11: {
            byArray = dataBuffer.bytes;
            n4 = dataBuffer.endOffset;
            nArray[0] = 0;
            nArray[1] = 1;
            while (true) {
                byArray = dataBuffer.bytes;
                if (n2 < n4) break block11;
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? n3 : dataBuffer.endOffset;
            }
            return CharConversionError.insufficientInputToDecodeCharacter();
        }
        int n5 = byArray[n2++];
        if (n5 >= 0) {
            nArray[0] = n5;
            return null;
        }
        int n6 = fgMultiByteLength[(n5 &= 0xFF) >> 3];
        if (n6 > 1) {
            int n7;
            int n8;
            int n9;
            block14: {
                block13: {
                    block12: {
                        nArray[1] = n6;
                        n9 = n5 & fgFirstByteValueMask[n6];
                        while (true) {
                            if (n2 < n4) break block12;
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            byArray = dataBuffer.bytes;
                            n2 = dataBuffer.startOffset;
                            n4 = dataBuffer == dataBuffer2 ? n3 : dataBuffer.endOffset;
                        }
                        return CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    n8 = byArray[n2++] & 0xFF;
                    if ((0xC0 & n8) != 128) {
                        return UTF8Support.charConversionFailure(2, n5, n8, 0, 0);
                    }
                    if (n6 == 2) {
                        nArray[0] = n9 = (n9 << 6) + (0x3F & n8);
                        return null;
                    }
                    while (true) {
                        if (n2 < n4) break block13;
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        byArray = dataBuffer.bytes;
                        n2 = dataBuffer.startOffset;
                        n4 = dataBuffer == dataBuffer2 ? n3 : dataBuffer.endOffset;
                    }
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                n7 = byArray[n2++] & 0xFF;
                if ((0xC0 & n7) != 128) {
                    return UTF8Support.charConversionFailure(3, n5, n8, n7, 0);
                }
                if (n6 == 3) {
                    nArray[0] = n9 = (n9 << 12) + ((0x3F & n8) << 6) + (0x3F & n7);
                    return null;
                }
                while (true) {
                    if (n2 < n4) break block14;
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n2 = dataBuffer.startOffset;
                    n4 = dataBuffer == dataBuffer2 ? n3 : dataBuffer.endOffset;
                }
                return CharConversionError.insufficientInputToDecodeCharacter();
            }
            int n10 = byArray[n2++] & 0xFF;
            if ((0xC0 & n10) != 128) {
                return UTF8Support.charConversionFailure(4, n5, n8, n7, n10);
            }
            nArray[0] = n9 = (n9 << 18) + ((0x3F & n8) << 12) + ((0x3F & n7) << 6) + (0x3F & n10);
            return null;
        }
        return UTF8Support.charConversionFailure(1, n5, 0, 0, 0);
    }

    public static boolean decodeCharacter(ParsedEntity parsedEntity, int[] nArray) {
        int n2;
        int n3;
        byte[] byArray;
        boolean bl;
        block26: {
            bl = false;
            do {
                byArray = parsedEntity.bytes;
                n3 = parsedEntity.offset;
                n2 = parsedEntity.endOffset;
                if (n3 < n2) break block26;
                if (bl) continue;
                parsedEntity.setMark();
                bl = true;
            } while (parsedEntity.loadMore() != 0);
            if (parsedEntity.atEndOfEntity()) {
                parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
            }
            parsedEntity.resetToMark();
            return parsedEntity.error == null;
        }
        int n4 = byArray[n3++];
        if (n4 >= 0) {
            nArray[0] = n4;
            nArray[1] = 1;
            if (bl) {
                parsedEntity.resetToMark();
            }
            return true;
        }
        int n5 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
        if (n5 > 1) {
            int n6;
            int n7;
            int n8;
            block29: {
                block28: {
                    block27: {
                        nArray[1] = n5;
                        n8 = n4 & fgFirstByteValueMask[n5];
                        while (true) {
                            if (n3 < n2) break block27;
                            if (!bl) {
                                parsedEntity.setMark();
                                bl = true;
                            }
                            if (parsedEntity.loadMore() == 0) break;
                            byArray = parsedEntity.bytes;
                            n3 = parsedEntity.offset;
                            n2 = parsedEntity.endOffset;
                        }
                        if (parsedEntity.atEndOfEntity()) {
                            parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                        }
                        parsedEntity.resetToMark();
                        return parsedEntity.error == null;
                    }
                    n7 = byArray[n3++] & 0xFF;
                    if ((0xC0 & n7) != 128) {
                        parsedEntity.error = UTF8Support.charConversionFailure(2, n4, n7, 0, 0);
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        return false;
                    }
                    if (n5 == 2) {
                        nArray[0] = n8 = (n8 << 6) + (0x3F & n7);
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        return true;
                    }
                    while (true) {
                        if (n3 < n2) break block28;
                        if (!bl) {
                            parsedEntity.setMark();
                            bl = true;
                        }
                        if (parsedEntity.loadMore() == 0) break;
                        byArray = parsedEntity.bytes;
                        n3 = parsedEntity.offset;
                        n2 = parsedEntity.endOffset;
                    }
                    if (parsedEntity.atEndOfEntity()) {
                        parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    parsedEntity.resetToMark();
                    return parsedEntity.error == null;
                }
                n6 = byArray[n3++] & 0xFF;
                if ((0xC0 & n6) != 128) {
                    parsedEntity.error = UTF8Support.charConversionFailure(3, n4, n7, n6, 0);
                    if (bl) {
                        parsedEntity.resetToMark();
                    }
                    return false;
                }
                if (n5 == 3) {
                    nArray[0] = n8 = (n8 << 12) + ((0x3F & n7) << 6) + (0x3F & n6);
                    if (bl) {
                        parsedEntity.resetToMark();
                    }
                    return true;
                }
                while (true) {
                    if (n3 < n2) break block29;
                    if (!bl) {
                        parsedEntity.setMark();
                        bl = true;
                    }
                    if (parsedEntity.loadMore() == 0) break;
                    byArray = parsedEntity.bytes;
                    n3 = parsedEntity.offset;
                    n2 = parsedEntity.endOffset;
                }
                if (parsedEntity.atEndOfEntity()) {
                    parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                }
                parsedEntity.resetToMark();
                return parsedEntity.error == null;
            }
            int n9 = byArray[n3++] & 0xFF;
            if ((0xC0 & n9) != 128) {
                parsedEntity.error = UTF8Support.charConversionFailure(4, n4, n7, n6, n9);
                if (bl) {
                    parsedEntity.resetToMark();
                }
                return false;
            }
            nArray[0] = n8 = (n8 << 18) + ((0x3F & n7) << 12) + ((0x3F & n6) << 6) + (0x3F & n9);
            if (bl) {
                parsedEntity.resetToMark();
            }
            return true;
        }
        parsedEntity.error = UTF8Support.charConversionFailure(1, n4, 0, 0, 0);
        if (bl) {
            parsedEntity.resetToMark();
        }
        return false;
    }

    public static int lengthAsCharacters(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3, int n4, int[] nArray) {
        boolean bl;
        DataBuffer dataBuffer3 = dataBuffer;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = (n4 & 8) != 0;
        boolean bl4 = bl = bl3 || (n4 & 4) != 0;
        if (nArray != null) {
            nArray[0] = 0;
        }
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
        }
        while (true) {
            byte[] byArray = dataBuffer3.bytes;
            int n6 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
            block7: while (n2 < n6) {
                int n7;
                ++n5;
                if ((n7 = byArray[n2++]) >= 0) {
                    if (!bl) continue;
                    if (bl2) {
                        bl2 = false;
                        if (n7 != 10) continue;
                        --n5;
                        continue;
                    }
                    if (n7 != 13) continue;
                    bl2 = true;
                    continue;
                }
                switch (fgMultiByteLength[(n7 &= 0xFF) >> 3]) {
                    default: {
                        return -1;
                    }
                    case 1: {
                        continue block7;
                    }
                    case 2: {
                        if (bl2 && bl3 && n7 == 194) {
                            if (n2 < n6) {
                                if ((byArray[n2] & 0xFF) == 133) {
                                    --n5;
                                    bl2 = false;
                                }
                            } else if (dataBuffer3 != dataBuffer2 && (dataBuffer3.next.bytes[dataBuffer3.next.startOffset] & 0xFF) == 133) {
                                --n5;
                                bl2 = false;
                            }
                        }
                        ++n2;
                        continue block7;
                    }
                    case 3: {
                        n2 += 2;
                        continue block7;
                    }
                    case 4: 
                }
                n2 += 3;
                if (nArray == null) continue;
                nArray[0] = nArray[0] + 1;
            }
            if (dataBuffer3 == dataBuffer2) break;
            dataBuffer3 = dataBuffer3.next;
            n2 = dataBuffer3.startOffset + (n2 - n6);
        }
        return n5;
    }

    public static int lengthAsCharacters(char[] cArray, int n2, int n3) {
        int n4 = n2 + n3;
        while (n2 < n4) {
            if (cArray[n2] < '\ud800' || cArray[n2] >= '\udc00') {
                ++n2;
                continue;
            }
            n2 += 2;
            --n3;
        }
        return n3;
    }

    public static boolean equalsString(byte[] byArray, int n2, int n3, String string2) {
        int n4 = string2.length();
        int n5 = 0;
        while (n5 < n4 && n2 < n3) {
            int n6;
            if ((n6 = string2.charAt(n5++)) < 128) {
                if (n6 == byArray[n2++]) continue;
                return false;
            }
            if (n6 < 2048) {
                if (n2 + 1 >= n3) {
                    return false;
                }
                if ((byte)(0xC0 | n6 >> 6) != byArray[n2++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n6) == byArray[n2++]) continue;
                return false;
            }
            if (n6 < 55296 || n6 >= 57344) {
                if (n2 + 2 >= n3) {
                    return false;
                }
                if ((byte)(0xE0 | n6 >> 12) != byArray[n2++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n6 >> 6) != byArray[n2++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n6) == byArray[n2++]) continue;
                return false;
            }
            if (n6 < 56320) {
                char c;
                if (n5 == n4 || n2 + 3 >= n3) {
                    return false;
                }
                if ((c = string2.charAt(n5++)) < '\udc00' || c >= '\ue000') {
                    return false;
                }
                if ((byte)(0xF0 | (n6 = 65536 + (n6 - 55296 << 10) + (c - 56320)) >> 18) != byArray[n2++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n6 >> 12) != byArray[n2++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n6 >> 6) != byArray[n2++]) {
                    return false;
                }
                if ((byte)(0x80 | 0x3F & n6) == byArray[n2++]) continue;
                return false;
            }
            return false;
        }
        return n5 == n4 && n2 == n3;
    }

    public static int hashCode(String string2) {
        int n2 = string2.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 * 31 + string2.charAt(i);
        }
        assert (n3 == string2.hashCode());
        return n3;
    }

    public static int hashCode(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            int n6 = byArray[n5];
            if (n6 >= 0) {
                n4 = n4 * 31 + n6;
                ++n5;
                continue;
            }
            int n7 = fgMultiByteLength[(n6 &= 0xFF) >> 3];
            if (n7 > 0) {
                if (n5 + n7 > n3) {
                    return -1;
                }
                int n8 = n6 & fgFirstByteValueMask[n7];
                int n9 = byArray[n5 + 1] & 0xFF;
                if ((0xC0 & n9) != 128) {
                    return -1;
                }
                if (n7 == 2) {
                    n8 = (n8 << 6) + (0x3F & n9);
                    n4 = n4 * 31 + n8;
                    n5 += 2;
                    continue;
                }
                int n10 = byArray[n5 + 2] & 0xFF;
                if ((0xC0 & n10) != 128) {
                    return -1;
                }
                if (n7 == 3) {
                    n8 = (n8 << 12) + ((0x3F & n9) << 6) + (0x3F & n10);
                    n4 = n4 * 31 + n8;
                    n5 += 3;
                    continue;
                }
                int n11 = byArray[n5 + 3] & 0xFF;
                if ((0xC0 & n11) != 128) {
                    return -1;
                }
                n8 = (n8 << 18) + ((0x3F & n9) << 12) + ((0x3F & n10) << 6) + (0x3F & n11);
                int n12 = n8 - 65536;
                n8 = 55296 + (n12 >> 10);
                n4 = n4 * 31 + n8;
                n8 = 56320 + (n12 & 0x3FF);
                n4 = n4 * 31 + n8;
                n5 += 4;
                continue;
            }
            return -1;
        }
        return n4;
    }

    private UTF8Support() {
    }

    private static byte[] resize(byte[] byArray) {
        return ArrayAllocator.resizeByteArray(byArray, byArray.length << 1);
    }

    private static char[] resize(char[] cArray) {
        return ArrayAllocator.resizeCharArray(cArray, cArray.length << 1);
    }

    private static CharConversionError charConversionFailure(int n2, int n3, int n4, int n5, int n6) {
        return CharConversionError.invalidUTF8CharacterEncoding(n2, n3, n4, n5, n6);
    }
}

