/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.Symbol;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolMap;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolMapHolder;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class SymbolTable {
    private static final String cn = SymbolTable.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(SymbolTable.class);

    public SymbolTable() {
    }

    public SymbolTable(SymbolMapHolder symbolMapHolder) {
        this();
    }

    public void updateSymbolMapHolder() {
    }

    public void reset(boolean bl) {
        boolean bl2 = LoggerUtil.isEntryLoggable(logger);
        if (bl2) {
            logger.entering(cn, "reset", bl);
        }
        SymbolMap.resetMap(bl);
    }

    public String addSymbol(XMLString xMLString) {
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            logger.entering(cn, "addSymbol", xMLString);
        }
        Symbol symbol = SymbolMap.addSymbol(xMLString);
        if (bl) {
            logger.exiting(cn, "addSymbol", symbol.str);
        }
        return symbol.str;
    }

    public String addSymbol(String string2) {
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            logger.entering(cn, "addSymbol", string2);
        }
        Symbol symbol = SymbolMap.addSymbol(string2);
        if (bl) {
            logger.exiting(cn, "addSymbol", symbol.str);
        }
        return symbol.str;
    }

    public String addSymbolSetValues(XMLString xMLString, XMLString xMLString2) {
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            logger.entering(cn, "addSymbolSetValues", xMLString);
        }
        Symbol symbol = SymbolMap.addSymbol(xMLString);
        symbol.setValues(xMLString2);
        if (bl) {
            logger.exiting(cn, "addSymbolSetValues", symbol.str);
        }
        return symbol.str;
    }

    public String addSymbolSetValues(String string2, XMLString xMLString) {
        String string3;
        Symbol symbol;
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            logger.entering(cn, "addSymbolSetValues", string2);
        }
        if ((symbol = SymbolMap.addSymbol(string2)) != null) {
            symbol.setValues(xMLString);
            string3 = symbol.str;
        } else {
            xMLString.clear();
            string3 = null;
        }
        if (bl) {
            logger.exiting(cn, "addSymbolSetValues", string3);
        }
        return string3;
    }

    private static String symbolString(Symbol symbol) {
        return symbol != null ? "\"" + symbol.str + "\"" : "null";
    }

    public Symbol addNameSymbol(QName qName) {
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            logger.entering(cn, "addNameSymbol", qName);
        }
        Symbol symbol = SymbolMap.addSymbol(qName);
        qName.rawName = qName.localName = symbol.str;
        qName.nsURI = "";
        qName.prefix = "";
        if (bl) {
            logger.exiting(cn, "addNameSymbol", SymbolTable.symbolString(symbol));
        }
        return symbol;
    }

    public Symbol getQNameSymbol(QName qName, int n2, int n3) {
        Object[] objectArray;
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            objectArray = new Object[]{qName, Integer.toString(n2), Integer.toString(n3)};
            logger.entering(cn, "getQNameSymbol", objectArray);
        }
        objectArray = SymbolMap.getQNameSymbol(qName, n2, n3);
        if (bl) {
            logger.exiting(cn, "getQNameSymbol", SymbolTable.symbolString((Symbol)objectArray));
        }
        return objectArray;
    }

    public Symbol putQNameSymbol(QName qName, int n2, int n3) {
        Object[] objectArray;
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            objectArray = new Object[]{qName, Integer.toString(n2), Integer.toString(n3)};
            logger.entering(cn, "putQNameSymbol", objectArray);
        }
        objectArray = SymbolMap.putQNameSymbol(qName, n2, n3);
        if (bl) {
            logger.exiting(cn, "putQNameSymbol", SymbolTable.symbolString((Symbol)objectArray));
        }
        return objectArray;
    }

    public Symbol getQNameSymbol(QName qName) {
        boolean bl = LoggerUtil.isEntryLoggable(logger);
        if (bl) {
            logger.entering(cn, "getQNameSymbol", qName);
        }
        Symbol symbol = SymbolMap.getQNameSymbol(qName);
        if (bl) {
            logger.exiting(cn, "getQNameSymbol", SymbolTable.symbolString(symbol));
        }
        return symbol;
    }
}

