/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.ras.LoggerUtil;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.Symbol;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class SymbolMap
implements Cloneable {
    private static final String cn = SymbolMap.class.getName();
    private static final Logger logger = LoggerUtil.getLogger(SymbolMap.class);
    private static final Logger rebalanceLogger = LoggerUtil.getLogger(SymbolMap.class, "Rebalancing");
    private static final Logger sharingLogger = LoggerUtil.getLogger(SymbolMap.class, "Sharing");
    private static final boolean USE_COMPLEX_SECONDARY_HASH = true;
    private static final boolean REBALANCE_BUCKETS = true;
    private static final int PRUNE_IF_NOT_REFERRENCED_LIMIT = 2;
    private static final int INITIAL_ALLOCATION_SIZE = 8192;
    private static final int B_HASHCODE = 0;
    private static final int B_NEXT = 1;
    private static final int B_NSTART = 2;
    private static final int B_NEND = 3;
    private static final int B_SYMINDEX = 4;
    private static final int B_SIZE = 5;
    private static final Comparator<Symbol> fgHitCountReverseComparator = new Comparator<Symbol>(){

        @Override
        public int compare(Symbol symbol, Symbol symbol2) {
            if (symbol.hitCount == symbol2.hitCount) {
                return 0;
            }
            if (symbol.hitCount > symbol2.hitCount) {
                return -1;
            }
            return 1;
        }
    };
    private static final ReentrantReadWriteLock fgRWLock = new ReentrantReadWriteLock();
    private static final Lock fgMutableMapReadLock = fgRWLock.readLock();
    private static final Lock fgMutableMapWriteLock = fgRWLock.writeLock();
    private static int fgInstanceCounter;
    private static SymbolMap fgSharedMap;
    private static SymbolMap fgMutableMap;
    private int id;
    private final DataBuffer fSymbolBuffer;
    private Symbol[] fSymbols;
    private boolean immutable;
    private boolean rebalancing;
    private int[] fTable;
    private int[] fBuckets;
    private int fNextBucketBase;
    private int fMask;
    private int fSymbolCount;
    private int fResetCount;
    private int fNextRebalanceCount;
    private final int fCountHitsResetCount;
    private int fRebalanceCountFreq;
    private boolean fCountHits;

    private static String threadLabel() {
        return "***XLXP[" + Thread.currentThread().getId() + "]*** ";
    }

    private static String mapLabel(SymbolMap symbolMap) {
        return symbolMap != null ? "SymbolMap " + symbolMap.id : "null";
    }

    private SymbolMap() {
        this.fSymbolBuffer = NullDataBufferFactory.createNewBuffer();
        this.id = fgInstanceCounter++;
        this.fCountHitsResetCount = 16;
        this.fNextRebalanceCount = this.fRebalanceCountFreq = 64;
        this.fRebalanceCountFreq <<= 1;
        this.fSymbolCount = 0;
        this.fSymbols = ArrayAllocator.newObjectArray(Symbol.class, 256);
        this.fMask = 511;
        this.fTable = ArrayAllocator.newIntArray(2560);
        this.fBuckets = ArrayAllocator.newIntArray(640);
        this.fNextBucketBase = 5;
        this.fSymbolBuffer.bytes = ArrayAllocator.newByteArray(8192);
        this.fSymbolBuffer.startOffset = 1;
        this.fSymbolBuffer.endOffset = 1;
        this.immutable = true;
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "SymbolMap", SymbolMap.threadLabel() + "Created " + SymbolMap.mapLabel(this));
        }
    }

    private SymbolMap(SymbolMap symbolMap, Symbol[] symbolArray, int n2) {
        byte[] byArray = ArrayAllocator.newByteArray(n2);
        this.fSymbolBuffer = NullDataBufferFactory.createNewBuffer();
        this.id = fgInstanceCounter++;
        this.fCountHitsResetCount = symbolMap.fCountHitsResetCount;
        this.fRebalanceCountFreq = symbolMap.fRebalanceCountFreq;
        this.fNextRebalanceCount = symbolMap.fNextRebalanceCount;
        this.fSymbolCount = symbolMap.fSymbolCount;
        this.fSymbols = symbolArray;
        this.fSymbolBuffer.bytes = byArray;
        this.fSymbolBuffer.startOffset = 1;
        this.fSymbolBuffer.endOffset = 1;
        this.fMask = symbolMap.fMask;
        this.fTable = ArrayAllocator.newIntArray(symbolMap.fTable.length);
        this.fBuckets = ArrayAllocator.newIntArray(symbolMap.fBuckets.length);
        this.fNextBucketBase = 5;
        int n3 = this.fSymbolBuffer.endOffset;
        for (int i = 0; i < this.fSymbolCount; ++i) {
            Symbol symbol = this.fSymbols[i];
            int n4 = n3;
            int n5 = symbol.nameEnd - symbol.nameStart;
            n3 += n5;
            System.arraycopy(symbol.nameBuffer.bytes, symbol.nameStart, byArray, n4, n5);
            this.fSymbols[i] = symbol = new Symbol(symbol, this.fSymbolBuffer, n4, n4 + n5);
            this.addHashedSymbolToBucket(i, symbol.nameStart, symbol.nameEnd, UTF8Support.hashCode(symbol.str));
        }
        this.fSymbolBuffer.endOffset = n3;
        this.rebalancing = symbolMap.rebalancing;
        this.fResetCount = symbolMap.fResetCount;
        this.fCountHits = symbolMap.fCountHits;
        this.immutable = true;
        if (LoggerUtil.isAnyTracingEnabled()) {
            if (logger.isLoggable(Level.FINE)) {
                this.checkSymbols();
            }
            if (rebalanceLogger.isLoggable(Level.FINER)) {
                rebalanceLogger.logp(Level.FINER, cn, "SymbolMap", SymbolMap.threadLabel() + "Created rebalanced " + SymbolMap.mapLabel(this));
            }
            if (logger.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder();
                this.dumpTables(stringBuilder);
                logger.logp(Level.FINEST, cn, "SymbolMap", SymbolMap.threadLabel() + stringBuilder.toString());
            }
        }
    }

    public SymbolMap clone() {
        assert (this.immutable);
        try {
            SymbolMap symbolMap = (SymbolMap)super.clone();
            symbolMap.id = fgInstanceCounter++;
            symbolMap.immutable = false;
            symbolMap.fSymbols = (Symbol[])this.fSymbols.clone();
            symbolMap.fTable = (int[])this.fTable.clone();
            symbolMap.fBuckets = (int[])this.fBuckets.clone();
            if (LoggerUtil.isAnyTracingEnabled()) {
                if (logger.isLoggable(Level.FINE)) {
                    symbolMap.checkSymbols();
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, cn, "clone", SymbolMap.threadLabel() + SymbolMap.mapLabel(symbolMap) + " created to mutate " + SymbolMap.mapLabel(this));
                }
            }
            return symbolMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetMap(boolean bl) {
        if (fgMutableMap != null) {
            fgMutableMapWriteLock.lock();
            try {
                if (fgMutableMap != null && SymbolMap.fgMutableMap.fSymbolCount != SymbolMap.fgSharedMap.fSymbolCount) {
                    SymbolMap.fgMutableMap.immutable = true;
                    fgSharedMap = fgMutableMap;
                    fgMutableMap = null;
                }
            }
            finally {
                fgMutableMapWriteLock.unlock();
            }
        }
        fgSharedMap.reset(bl);
    }

    private void reset(boolean bl) {
        if (LoggerUtil.isFineLoggable(logger)) {
            this.checkSymbols();
        }
        if (!this.rebalancing && ++this.fResetCount == this.fNextRebalanceCount) {
            this.rebalance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebalance() {
        if (!this.fCountHits) {
            for (int i = 0; i < this.fSymbolCount; ++i) {
                this.fSymbols[i].hitCount = 0;
            }
            this.fCountHits = true;
            SymbolMap symbolMap = fgMutableMap;
            if (symbolMap != null) {
                symbolMap.fCountHits = true;
            }
            this.fNextRebalanceCount = this.fResetCount + this.fCountHitsResetCount;
            return;
        }
        this.rebalancing = true;
        this.fCountHits = false;
        SymbolMap symbolMap = fgMutableMap;
        if (symbolMap != null) {
            symbolMap.fCountHits = false;
        }
        if (LoggerUtil.isFinestLoggable(logger)) {
            StringBuilder stringBuilder = new StringBuilder();
            this.dumpTables(stringBuilder);
            logger.logp(Level.FINEST, cn, "rebalance", SymbolMap.threadLabel() + stringBuilder.toString());
        }
        if (this.tablesBalanced()) {
            this.fRebalanceCountFreq <<= 1;
            if (LoggerUtil.isFinestLoggable(rebalanceLogger)) {
                rebalanceLogger.logp(Level.FINEST, cn, "rebalance", SymbolMap.threadLabel() + "No rebalancing of " + SymbolMap.mapLabel(this) + " was needed on pass " + this.fResetCount);
            }
        } else {
            if (LoggerUtil.isFinerLoggable(rebalanceLogger)) {
                rebalanceLogger.logp(Level.FINER, cn, "rebalance", SymbolMap.threadLabel() + "Rebalancing " + SymbolMap.mapLabel(this));
            }
            fgMutableMapWriteLock.lock();
            try {
                if (fgMutableMap != null) {
                    SymbolMap.fgMutableMap.immutable = true;
                    fgSharedMap = fgMutableMap.createBalancedMap();
                    fgMutableMap = null;
                } else {
                    fgSharedMap = fgSharedMap.createBalancedMap();
                }
            }
            finally {
                fgMutableMapWriteLock.unlock();
            }
        }
        this.fNextRebalanceCount += this.fRebalanceCountFreq;
        this.fRebalanceCountFreq <<= 1;
        this.rebalancing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SymbolMap holdMutableMap() {
        fgMutableMapReadLock.lock();
        if (fgMutableMap != null) {
            return fgMutableMap;
        }
        fgMutableMapReadLock.unlock();
        fgMutableMapWriteLock.lock();
        if (fgMutableMap != null) {
            fgMutableMapReadLock.lock();
            fgMutableMapWriteLock.unlock();
            return fgMutableMap;
        }
        try {
            fgMutableMap = fgSharedMap.clone();
        }
        finally {
            fgMutableMapReadLock.lock();
            fgMutableMapWriteLock.unlock();
        }
        if (LoggerUtil.isFinerLoggable(sharingLogger)) {
            sharingLogger.logp(Level.FINER, cn, "getMutableMap", SymbolMap.threadLabel() + "Created mutable " + SymbolMap.mapLabel(fgMutableMap) + " for shared " + SymbolMap.mapLabel(fgSharedMap));
        }
        return fgMutableMap;
    }

    private static void releaseMutableMap() {
        fgMutableMapReadLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol addSymbol(XMLString xMLString) {
        int n2 = xMLString.hashCode();
        Symbol symbol = fgSharedMap.get(xMLString, n2);
        if (symbol != null) {
            return symbol;
        }
        SymbolMap symbolMap = SymbolMap.holdMutableMap();
        try {
            SymbolMap symbolMap2 = symbolMap;
            synchronized (symbolMap2) {
                symbol = symbolMap.get(xMLString, n2);
                if (symbol == null) {
                    symbol = symbolMap.put(xMLString, n2);
                    if (LoggerUtil.isFineLoggable(logger)) {
                        symbolMap.checkSymbols();
                    }
                }
            }
        }
        finally {
            SymbolMap.releaseMutableMap();
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol addSymbol(String string2) {
        int n2 = UTF8Support.hashCode(string2);
        Symbol symbol = fgSharedMap.get(string2, n2);
        if (symbol != null) {
            return symbol;
        }
        SymbolMap symbolMap = SymbolMap.holdMutableMap();
        try {
            SymbolMap symbolMap2 = symbolMap;
            synchronized (symbolMap2) {
                symbol = symbolMap.get(string2, n2);
                if (symbol == null) {
                    symbol = symbolMap.put(string2, n2);
                    if (LoggerUtil.isFineLoggable(logger)) {
                        symbolMap.checkSymbols();
                    }
                }
            }
        }
        finally {
            SymbolMap.releaseMutableMap();
        }
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol getQNameSymbol(QName qName, int n2, int n3) {
        Symbol symbol = fgSharedMap.get(qName, n2);
        if (symbol != null) {
            symbol.setQNameValues(qName, n3);
            return symbol;
        }
        SymbolMap symbolMap = SymbolMap.holdMutableMap();
        try {
            SymbolMap symbolMap2 = symbolMap;
            synchronized (symbolMap2) {
                symbol = symbolMap.get(qName, n2);
            }
        }
        finally {
            SymbolMap.releaseMutableMap();
        }
        if (symbol != null) {
            symbol.setQNameValues(qName, n3);
            return symbol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol putQNameSymbol(QName qName, int n2, int n3) {
        Symbol symbol;
        SymbolMap symbolMap = SymbolMap.holdMutableMap();
        try {
            SymbolMap symbolMap2 = symbolMap;
            synchronized (symbolMap2) {
                symbol = symbolMap.get(qName, n2);
                if (symbol == null) {
                    symbol = symbolMap.put(qName, n2);
                    if (LoggerUtil.isFineLoggable(logger)) {
                        symbolMap.checkSymbols();
                    }
                }
            }
        }
        finally {
            SymbolMap.releaseMutableMap();
        }
        symbol.setQNameValues(qName, n3);
        return symbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Symbol getQNameSymbol(QName qName) {
        block13: {
            int n2;
            Symbol symbol;
            block12: {
                int n3 = qName.hashcode;
                symbol = fgSharedMap.get(qName.bytes, qName.startOffset, qName.endOffset, n3);
                if (symbol != null && symbol.setValuesIfKnownQName(qName)) {
                    return symbol;
                }
                n2 = DocumentScanner.checkQName(qName);
                if (n2 < 0) break block13;
                if (symbol != null) break block12;
                SymbolMap symbolMap = SymbolMap.holdMutableMap();
                try {
                    SymbolMap symbolMap2 = symbolMap;
                    synchronized (symbolMap2) {
                        block11: {
                            symbol = symbolMap.get(qName.bytes, qName.startOffset, qName.endOffset, n3);
                            if (symbol == null) break block11;
                            if (symbol.setValuesIfKnownQName(qName)) {
                                Symbol symbol2 = symbol;
                                return symbol2;
                            }
                            break block12;
                        }
                        symbol = symbolMap.put(qName, n3);
                        if (LoggerUtil.isFineLoggable(logger)) {
                            symbolMap.checkSymbols();
                        }
                    }
                }
                finally {
                    SymbolMap.releaseMutableMap();
                }
            }
            symbol.setQNameValues(qName, n2);
            return symbol;
        }
        return null;
    }

    private Symbol get(byte[] byArray, int n2, int n3, int n4) {
        int[] nArray = this.fTable;
        int n5 = (SymbolMap.hash(n4) & this.fMask) * 5;
        if (nArray[n5 + 2] != 0) {
            int n6;
            int n7;
            byte[] byArray2 = this.fSymbolBuffer.bytes;
            if (nArray[n5 + 0] == n4) {
                int n8 = n2;
                n7 = nArray[n5 + 2];
                n6 = nArray[n5 + 3];
                while (byArray[n8++] == byArray2[n7] && ++n7 < n6) {
                }
                if (n7 == n6 && n8 == n3) {
                    Symbol symbol = this.fSymbols[nArray[n5 + 4]];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                }
            }
            int[] nArray2 = this.fBuckets;
            n7 = nArray[n5 + 1];
            while (n7 != 0) {
                if (nArray2[n7 + 0] == n4) {
                    n6 = n2;
                    int n9 = nArray2[n7 + 2];
                    int n10 = nArray2[n7 + 3];
                    while (byArray[n6++] == byArray2[n9] && ++n9 < n10) {
                    }
                    if (n9 == n10 && n6 == n3) {
                        Symbol symbol = this.fSymbols[nArray2[n7 + 4]];
                        if (this.fCountHits) {
                            ++symbol.hitCount;
                        }
                        return symbol;
                    }
                }
                n7 = nArray2[n7 + 1];
            }
        }
        return null;
    }

    private Symbol get(XMLString xMLString, int n2) {
        int[] nArray = this.fTable;
        int n3 = (SymbolMap.hash(n2) & this.fMask) * 5;
        if (nArray[n3 + 2] != 0) {
            byte[] byArray = this.fSymbolBuffer.bytes;
            if (nArray[n3 + 0] == n2 && xMLString.equalsString(byArray, nArray[n3 + 2], nArray[n3 + 3])) {
                Symbol symbol = this.fSymbols[nArray[n3 + 4]];
                if (this.fCountHits) {
                    ++symbol.hitCount;
                }
                return symbol;
            }
            int[] nArray2 = this.fBuckets;
            int n4 = nArray[n3 + 1];
            while (n4 != 0) {
                if (nArray2[n4 + 0] == n2 && xMLString.equalsString(byArray, nArray2[n4 + 2], nArray2[n4 + 3])) {
                    Symbol symbol = this.fSymbols[nArray2[n4 + 4]];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                }
                n4 = nArray2[n4 + 1];
            }
        }
        return null;
    }

    private Symbol get(String string2, int n2) {
        int[] nArray = this.fTable;
        int n3 = (SymbolMap.hash(n2) & this.fMask) * 5;
        if (nArray[n3 + 2] != 0) {
            if (nArray[n3 + 0] == n2 && this.bucketEquals(string2, nArray[n3 + 2], nArray[n3 + 3])) {
                Symbol symbol = this.fSymbols[nArray[n3 + 4]];
                if (this.fCountHits) {
                    ++symbol.hitCount;
                }
                return symbol;
            }
            int[] nArray2 = this.fBuckets;
            int n4 = nArray[n3 + 1];
            while (n4 != 0) {
                if (nArray2[n4 + 0] == n2 && this.bucketEquals(string2, nArray2[n4 + 2], nArray2[n4 + 3])) {
                    Symbol symbol = this.fSymbols[nArray2[n4 + 4]];
                    if (this.fCountHits) {
                        ++symbol.hitCount;
                    }
                    return symbol;
                }
                n4 = nArray2[n4 + 1];
            }
        }
        return null;
    }

    private Symbol put(XMLString xMLString, int n2) {
        assert (!this.immutable);
        int n3 = this.fSymbolBuffer.endOffset;
        this.appendToSymbolBytes(xMLString);
        return this.put(xMLString.toString().intern(), n2, n3, this.fSymbolBuffer.endOffset);
    }

    private int checkString(String string2) {
        int n2;
        int n3 = string2.length();
        for (n2 = 0; n2 < n3 && string2.charAt(n2) < '\u0080'; ++n2) {
        }
        if (n2 == n3) {
            return n3;
        }
        int n4 = n2;
        while (n2 < n3) {
            char c;
            if ((c = string2.charAt(n2++)) < '\u0080') {
                ++n4;
                continue;
            }
            if (c < '\u0800') {
                n4 += 2;
                continue;
            }
            if (c < '\ud800' || c >= '\ue000') {
                n4 += 3;
                continue;
            }
            if (c < '\udc00') {
                if (n2 == n3) {
                    return -1;
                }
                if ((c = string2.charAt(n2++)) < '\udc00' || c >= '\ue000') {
                    return -1;
                }
                n4 += 4;
                continue;
            }
            return -1;
        }
        return n4;
    }

    private Symbol put(String string2, int n2) {
        assert (!this.immutable);
        int n3 = this.checkString(string2);
        if (n3 >= 0) {
            int n4 = this.fSymbolBuffer.endOffset;
            this.appendToSymbolBytes(string2, n3);
            return this.put(string2.intern(), UTF8Support.hashCode(string2), n4, this.fSymbolBuffer.endOffset);
        }
        return null;
    }

    private static int hash(int n2) {
        n2 ^= n2 >>> 20 ^ n2 >>> 12;
        return n2 ^ n2 >>> 7 ^ n2 >>> 4;
    }

    private boolean bucketEquals(String string2, int n2, int n3) {
        byte[] byArray = this.fSymbolBuffer.bytes;
        int n4 = string2.length();
        int n5 = n2;
        for (int i = 0; i < n4; ++i) {
            int n6 = string2.charAt(i);
            if (n6 == byArray[n5]) {
                ++n5;
                continue;
            }
            if (n6 < 128) {
                return false;
            }
            if (n6 < 2048) {
                if (byArray[n5] != (byte)(0xC0 | n6 >> 6)) {
                    return false;
                }
                if (byArray[++n5] != (byte)(0x80 | 0x3F & n6)) {
                    return false;
                }
                ++n5;
                continue;
            }
            if (n6 < 55296 || n6 >= 57344) {
                if (byArray[n5] != (byte)(0xE0 | n6 >> 12)) {
                    return false;
                }
                if (byArray[++n5] != (byte)(0x80 | 0x3F & n6 >> 6)) {
                    return false;
                }
                if (byArray[++n5] != (byte)(0x80 | 0x3F & n6)) {
                    return false;
                }
                ++n5;
                continue;
            }
            if (n6 < 56320) {
                if (++i == n4) {
                    return false;
                }
                char c = string2.charAt(i);
                if (c < '\udc00' || c >= '\ue000') {
                    return false;
                }
                if (byArray[n5] != (byte)(0xF0 | (n6 = 65536 + (n6 - 55296 << 10) + (c - 56320)) >> 18)) {
                    return false;
                }
                if (byArray[++n5] != (byte)(0x80 | 0x3F & n6 >> 12)) {
                    return false;
                }
                if (byArray[++n5] != (byte)(0x80 | 0x3F & n6 >> 6)) {
                    return false;
                }
                if (byArray[++n5] != (byte)(0x80 | 0x3F & n6)) {
                    return false;
                }
                ++n5;
                continue;
            }
            return false;
        }
        return n5 == n3;
    }

    private int allocateBucket() {
        int n2 = this.fNextBucketBase;
        if (n2 == this.fBuckets.length) {
            this.fBuckets = ArrayAllocator.resizeIntArray(this.fBuckets, n2 << 1);
        }
        this.fNextBucketBase += 5;
        return n2;
    }

    private void addHashedSymbolToBucket(int n2, int n3, int n4, int n5) {
        int n6;
        int[] nArray;
        int n7 = UTF8Support.hashCode(this.fSymbolBuffer.bytes, n3, n4);
        if (n7 != n5) {
            n5 = n7;
        }
        if ((nArray = this.fTable)[(n6 = (SymbolMap.hash(n5) & this.fMask) * 5) + 2] != 0) {
            int n8 = this.allocateBucket();
            if (nArray[n6 + 1] == 0) {
                nArray[n6 + 1] = n8;
                nArray = this.fBuckets;
            } else {
                n6 = nArray[n6 + 1];
                nArray = this.fBuckets;
                while (nArray[n6 + 1] != 0) {
                    n6 = nArray[n6 + 1];
                }
                nArray[n6 + 1] = n8;
            }
            n6 = n8;
        }
        nArray[n6 + 0] = n5;
        nArray[n6 + 1] = 0;
        nArray[n6 + 2] = n3;
        nArray[n6 + 3] = n4;
        nArray[n6 + 4] = n2;
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "addHashedSymbolToBucket", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + " fSymbols[" + n2 + "] added " + (nArray == this.fTable ? "fTable" : "fBuckets") + "[" + n6 + "] for " + this.fSymbols[n2].str + " [" + n5 + "," + n3 + "," + n4 + "]");
        }
    }

    private void rehash() {
        if (LoggerUtil.isFinestLoggable(logger)) {
            StringBuilder stringBuilder = new StringBuilder();
            this.dumpTables(stringBuilder);
            logger.logp(Level.FINEST, cn, "rehash", SymbolMap.threadLabel() + stringBuilder.toString());
        }
        this.fTable = ArrayAllocator.replaceIntArray(this.fTable, this.fTable.length << 1);
        this.fMask = (this.fMask + 1 << 1) - 1;
        this.fNextBucketBase = 5;
        for (int i = 0; i < this.fSymbolCount; ++i) {
            Symbol symbol = this.fSymbols[i];
            this.addHashedSymbolToBucket(i, symbol.nameStart, symbol.nameEnd, UTF8Support.hashCode(symbol.str));
        }
        if (LoggerUtil.isFinestLoggable(logger)) {
            StringBuilder stringBuilder = new StringBuilder();
            this.dumpTables(stringBuilder);
            logger.logp(Level.FINEST, cn, "rehash", SymbolMap.threadLabel() + stringBuilder.toString());
        }
    }

    private Symbol put(String string2, int n2, int n3, int n4) {
        int n5;
        assert (!this.immutable);
        if (LoggerUtil.isFinestLoggable(logger)) {
            for (int i = 1; i < this.fSymbolCount; ++i) {
                if (!this.fSymbols[i].equalsString(string2)) continue;
                logger.logp(Level.FINEST, cn, "put", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + " inserting duplicate symbol " + string2);
                if (string2.length() <= 0) break;
                this.get(this.fSymbolBuffer.bytes, n3, n4, n2);
                break;
            }
        }
        Symbol symbol = new Symbol(string2, this.fSymbolBuffer, n3, n4);
        if ((n5 = this.fSymbolCount++) == this.fSymbols.length) {
            this.fSymbols = ArrayAllocator.resizeObjectArray(Symbol.class, this.fSymbols, this.fSymbols.length << 1);
        }
        this.fSymbols[n5] = symbol;
        if (n5 == this.fMask - (this.fMask >> 2)) {
            this.rehash();
        }
        this.addHashedSymbolToBucket(n5, n3, n4, n2);
        if (LoggerUtil.isFineLoggable(logger)) {
            this.checkSymbols();
        }
        if (LoggerUtil.isFinerLoggable(logger)) {
            logger.logp(Level.FINER, cn, "put", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + ": added new symbol " + string2 + " [" + n2 + "," + n3 + "," + n4 + "]");
        }
        if (LoggerUtil.isFinestLoggable(logger)) {
            StringBuilder stringBuilder = new StringBuilder();
            this.dumpTables(stringBuilder);
            logger.logp(Level.FINEST, cn, "put", SymbolMap.threadLabel() + stringBuilder.toString());
        }
        return symbol;
    }

    private void checkSymbols() {
        for (int i = 0; i < this.fSymbolCount; ++i) {
            Symbol symbol;
            Symbol symbol2 = this.fSymbols[i];
            if (symbol2.nameBuffer != this.fSymbolBuffer) {
                logger.logp(Level.FINE, cn, "checkSymbols", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + " symbol " + symbol2.str + " different buffer");
            }
            try {
                String string2 = new String(symbol2.nameBuffer.bytes, symbol2.nameStart, symbol2.nameEnd - symbol2.nameStart, "UTF8");
                if (!string2.equals(symbol2.str)) {
                    logger.logp(Level.FINE, cn, "checkSymbols", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + " check #0 failed");
                    return;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.logp(Level.FINE, cn, "checkSymbols", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + " UnsupportedEncodingException");
                return;
            }
            int n2 = UTF8Support.hashCode(symbol2.str);
            if (symbol2.nameStart != symbol2.nameEnd && (symbol = this.get(symbol2.nameBuffer.bytes, symbol2.nameStart, symbol2.nameEnd, n2)) != symbol2) {
                symbol = this.get(symbol2.nameBuffer.bytes, symbol2.nameStart, symbol2.nameEnd, n2);
                logger.logp(Level.FINE, cn, "checkSymbols", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + " check #1 failed");
                return;
            }
            symbol = this.get(symbol2.str, n2);
            if (symbol == symbol2) continue;
            symbol = this.get(symbol2.str, n2);
            logger.logp(Level.FINE, cn, "checkSymbols", SymbolMap.threadLabel() + SymbolMap.mapLabel(this) + " check #2 failed");
            return;
        }
    }

    private boolean tablesBalanced() {
        for (int i = 0; i < this.fTable.length; i += 5) {
            if (this.fTable[i + 2] == 0 || this.fTable[i + 1] == 0) continue;
            int n2 = this.fTable[i + 4];
            int n3 = this.fSymbols[n2].hitCount;
            int n4 = this.fTable[i + 1];
            while (n4 != 0) {
                n2 = this.fBuckets[n4 + 4];
                int n5 = this.fSymbols[n2].hitCount;
                if (n3 < n5) {
                    return false;
                }
                n3 = n5;
                n4 = this.fBuckets[n4 + 1];
            }
        }
        return true;
    }

    private SymbolMap createBalancedMap() {
        int n2;
        int n3;
        assert (this.immutable);
        int n4 = 1;
        Symbol[] symbolArray = ArrayAllocator.newObjectArray(Symbol.class, this.fSymbols.length);
        int n5 = 0;
        Serializable serializable = new ArrayList<Symbol>(this.fSymbolCount);
        Symbol symbol = this.fSymbols[0];
        n4 += symbol.nameEnd - symbol.nameStart;
        ((ArrayList)serializable).add(symbol);
        int n6 = this.fSymbols[0].hitCount == 0 ? 0 : 1;
        for (int i = 1; i < this.fSymbolCount; ++i) {
            int n7;
            symbol = this.fSymbols[i];
            n4 += symbol.nameEnd - symbol.nameStart;
            int n8 = symbol.hitCount;
            if (n8 == 0) {
                ((ArrayList)serializable).add(symbol);
                continue;
            }
            if (n6 > 0) {
                n7 = Collections.binarySearch(serializable, symbol, fgHitCountReverseComparator);
                if (n7 < 0) {
                    n7 = -(n7 + 1);
                }
            } else {
                n7 = 0;
            }
            ((ArrayList)serializable).add(n7, symbol);
            ++n6;
        }
        n5 = this.fSymbolCount;
        ((ArrayList)serializable).toArray(symbolArray);
        if (LoggerUtil.isFinestLoggable(rebalanceLogger)) {
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append(SymbolMap.mapLabel(this) + ":\n");
            for (int i = 0; i < n5; ++i) {
                Symbol symbol2 = symbolArray[i];
                if (symbol2.hitCount == 0) break;
                ((StringBuilder)serializable).append("symbol " + symbol2.str + ": " + symbol2.hitCount + " hit(s)\n");
            }
            ((StringBuilder)serializable).append("remaining symbols have 0 hit(s)");
            rebalanceLogger.logp(Level.FINEST, cn, "rebalanceTables", ((StringBuilder)serializable).toString());
        }
        for (n3 = n2 = this.fSymbolBuffer.bytes.length; n3 < n4; n3 <<= 1) {
        }
        if (LoggerUtil.isFinerLoggable(rebalanceLogger)) {
            if (n2 != n3) {
                rebalanceLogger.logp(Level.FINER, cn, "rebalanceTables", SymbolMap.threadLabel() + "rebalanced " + SymbolMap.mapLabel(this) + " symbol bytes array length changed from " + n2 + " to " + n3);
            }
            if (n4 != this.fSymbolBuffer.endOffset) {
                rebalanceLogger.logp(Level.FINER, cn, "rebalanceTables", SymbolMap.threadLabel() + "rebalanced " + SymbolMap.mapLabel(this) + " symbol bytes offset changed from " + this.fSymbolBuffer.endOffset + " to " + n4);
            }
        }
        SymbolMap symbolMap = new SymbolMap(this, symbolArray, n3);
        return symbolMap;
    }

    private void grow(int n2) {
        int n3;
        for (n3 = this.fSymbolBuffer.bytes.length << 1; n3 < n2; n3 <<= 1) {
        }
        byte[] byArray = ArrayAllocator.resizeByteArray(this.fSymbolBuffer.bytes, n3);
        this.fSymbolBuffer.bytes = byArray;
    }

    private void allocate(int n2) {
        if (this.fSymbolBuffer.endOffset + n2 > this.fSymbolBuffer.bytes.length) {
            this.grow(this.fSymbolBuffer.endOffset + n2);
        }
        this.fSymbolBuffer.endOffset += n2;
    }

    private void appendToSymbolBytes(XMLString xMLString) {
        int n2 = this.fSymbolBuffer.endOffset;
        this.allocate(xMLString.length);
        byte[] byArray = this.fSymbolBuffer.bytes;
        if (xMLString.bytes != null) {
            System.arraycopy(xMLString.bytes, xMLString.startOffset, byArray, n2, xMLString.length);
        } else {
            DataBuffer dataBuffer = xMLString.firstBuffer;
            int n3 = dataBuffer.endOffset - xMLString.startOffset;
            System.arraycopy(dataBuffer.bytes, xMLString.startOffset, byArray, n2, n3);
            n2 += n3;
            while ((dataBuffer = dataBuffer.next) != xMLString.lastBuffer) {
                n3 = dataBuffer.endOffset - dataBuffer.startOffset;
                System.arraycopy(dataBuffer.bytes, dataBuffer.startOffset, byArray, n2, n3);
                n2 += n3;
            }
            n3 = xMLString.endOffset - dataBuffer.startOffset;
            System.arraycopy(dataBuffer.bytes, dataBuffer.startOffset, byArray, n2, n3);
        }
    }

    private void appendToSymbolBytes(String string2, int n2) {
        int n3;
        int n4;
        int n5 = this.fSymbolBuffer.endOffset;
        this.allocate(n2);
        byte[] byArray = this.fSymbolBuffer.bytes;
        int n6 = string2.length();
        for (n4 = 0; n4 < n6 && (n3 = string2.charAt(n4)) < 128; ++n4) {
            byArray[n5++] = (byte)n3;
        }
        while (n4 < n6) {
            if ((n3 = string2.charAt(n4++)) < 128) {
                byArray[n5++] = (byte)n3;
                continue;
            }
            if (n3 < 2048) {
                byArray[n5++] = (byte)(0xC0 | n3 >> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n3);
                continue;
            }
            if (n3 < 55296 || n3 >= 57344) {
                byArray[n5++] = (byte)(0xE0 | n3 >> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n3 >> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n3);
                continue;
            }
            char c = string2.charAt(n4);
            ++n4;
            n3 = 65536 + (n3 - 55296 << 10) + (c - 56320);
            byArray[n5++] = (byte)(0xF0 | n3 >> 18);
            byArray[n5++] = (byte)(0x80 | 0x3F & n3 >> 12);
            byArray[n5++] = (byte)(0x80 | 0x3F & n3 >> 6);
            byArray[n5++] = (byte)(0x80 | 0x3F & n3);
        }
    }

    private void dumpTables(StringBuilder stringBuilder) {
        int n2;
        int n3;
        int[] nArray = new int[8];
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int[] nArray2 = new int[1024];
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        stringBuilder.append(SymbolMap.mapLabel(this) + " tables:\n");
        for (n3 = 0; n3 < this.fSymbolCount; ++n3) {
            stringBuilder.append("fSymbols[" + n3 + "] = \"" + this.fSymbols[n3] + "\"\n");
        }
        for (n3 = 0; n3 < this.fTable.length; n3 += 5) {
            if (this.fTable[n3 + 2] != 0) {
                n2 = n3;
                stringBuilder.append("fTable[" + n2 + "]\n");
                int[] nArray3 = this.fTable;
                int n10 = 0;
                while (true) {
                    int n11 = nArray3[n2 + 4];
                    int n12 = this.fSymbols[n11].hitCount;
                    n7 += n12;
                    if (n12 < nArray2.length - 1) {
                        int n13 = n12;
                        nArray2[n13] = nArray2[n13] + 1;
                    } else {
                        int n14 = nArray2.length - 1;
                        nArray2[n14] = nArray2[n14] + 1;
                    }
                    if (n12 > n8) {
                        n8 = n12;
                        n9 = n3;
                    }
                    stringBuilder.append("  [" + nArray3[n2 + 4] + "] \"" + this.fSymbols[nArray3[n2 + 4]].toString() + "\" " + n12 + " hits\n");
                    n2 = nArray3[n2 + 1];
                    if (n2 == 0) break;
                    nArray3 = this.fBuckets;
                    ++n10;
                }
                int n15 = n10;
                nArray[n15] = nArray[n15] + 1;
                if (n10 <= n4) continue;
                n4 = n10;
                n6 = n3;
                continue;
            }
            ++n5;
        }
        stringBuilder.append("maximum collisions of " + n4 + " first seen in bucket " + n6 + "\n");
        stringBuilder.append("  " + n5 + " empty bucket(s)\n");
        for (n3 = 0; n3 <= n4; ++n3) {
            if (nArray[n3] <= 0) continue;
            stringBuilder.append("  " + nArray[n3] + " bucket(s) with " + n3 + " collision(s)\n");
        }
        stringBuilder.append("total hits of " + n7 + ", maximum hits of " + n8 + " first seen in bucket " + n9 + "\n");
        n3 = n8 + 1 < nArray2.length ? n8 + 1 : nArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            if (nArray2[n2] <= 0) continue;
            stringBuilder.append("  " + nArray2[n2] + " bucket(s) with " + n2 + " hit(s)\n");
        }
    }

    static {
        fgSharedMap = new SymbolMap();
        fgMutableMap = null;
    }
}

