/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class Symbol {
    public final String str;
    final DataBuffer nameBuffer;
    final int nameStart;
    final int nameEnd;
    private String prefix;
    private String localName;
    int hitCount;
    int noHitsFoundCount;

    public Symbol(String string2, DataBuffer dataBuffer, int n2, int n3) {
        this.str = string2;
        this.nameBuffer = dataBuffer;
        this.nameStart = n2;
        this.nameEnd = n3;
        this.prefix = null;
        this.localName = this.str;
    }

    Symbol(Symbol symbol, DataBuffer dataBuffer, int n2, int n3) {
        this.str = symbol.str;
        this.nameBuffer = dataBuffer;
        this.nameStart = n2;
        this.nameEnd = n3;
        this.prefix = symbol.prefix;
        this.localName = symbol.localName;
    }

    public String toString() {
        return this.str;
    }

    boolean equalsString(String string2) {
        return this.str.equals(string2);
    }

    void setValues(XMLString xMLString) {
        xMLString.setValues(this.nameBuffer, this.nameStart, this.nameEnd);
    }

    public void setQNameValues(QName qName) {
        qName.rawName = this.str;
        qName.nsURI = "";
        qName.localName = this.localName;
        qName.prefix = this.prefix;
    }

    boolean setValuesIfKnownQName(QName qName) {
        if (this.prefix != null) {
            qName.rawName = this.str;
            qName.nsURI = "";
            qName.localName = this.localName;
            qName.prefix = this.prefix;
            return true;
        }
        return false;
    }

    void setQNameValues(QName qName, int n2) {
        if (n2 == 0) {
            this.prefix = "";
        } else if (this.prefix == null) {
            this.prefix = this.str.substring(0, n2).intern();
            this.localName = this.str.substring(n2 + 1).intern();
        }
        qName.rawName = this.str;
        qName.nsURI = "";
        qName.localName = this.localName;
        qName.prefix = this.prefix;
    }

    public boolean skippedMatchingQName(ParsedEntity parsedEntity, QName qName) {
        return parsedEntity.skippedBytesInRangeForXMLString(this.nameBuffer.bytes, this.nameStart, this.nameEnd, qName);
    }
}

