/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.CharConversionError;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataSource;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.UTF8Support;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import java.security.AccessController;
import java.security.PrivilegedAction;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class ParsedEntity {
    private static final String COPYRIGHT_YEARS = "Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final boolean NO_ENCODE_FLAGS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity.noEncodeFlags");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    public String baseURI;
    public DataBuffer buffer;
    public byte[] bytes;
    public int offset;
    public int endOffset;
    public int startOffset;
    public int id;
    public boolean lineBreaksNormalized;
    public CharConversionError error;
    public boolean isXML10 = true;
    public boolean isInternal;
    public boolean isCoordinatesAware;
    public boolean loadCalled;
    public ParsedEntity parent;
    public boolean isFragment;
    private final ParsedEntityFactory fEntityFactory;
    private final DataBufferReferrer fBufferReferrer;
    private final int[] fIntPointer;
    public DataSource fSource;
    protected DataBuffer fContentLastBuffer;
    private int fContentEndOffset;
    public boolean fEndOfEntity;
    protected Mark fMarks;
    private Mark fFreeMarks;
    private DataBufferFactory fBufferFactory;
    private static final byte[] contentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] normalizedContentMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte OK = 0;
    private static final byte LT = 1;
    private static final byte CR = 2;
    private static final byte WS = 4;
    private static final byte SQ = 8;
    private static final byte DQ = 16;
    private static final byte __ = 32;
    private static final byte MASK = 63;
    private static final byte[] simpleContentMap = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 4, 4, 32, 32, 2, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 0, 0, 16, 0, 0, 0, 32, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    protected static final byte[] attValueMap = new byte[]{8, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};

    public ParsedEntity(ParsedEntityFactory parsedEntityFactory) {
        this.fEntityFactory = parsedEntityFactory;
        this.fIntPointer = ArrayAllocator.newIntArray(2);
        this.fBufferReferrer = new DataBufferReferrer(){

            public boolean hasReferenceTo(DataBuffer dataBuffer) {
                Object object2;
                if (ParsedEntity.this.buffer == dataBuffer) {
                    return true;
                }
                if (ParsedEntity.this.buffer.next != null) {
                    object2 = ParsedEntity.this.buffer.next;
                    while (object2 != null) {
                        if (object2 == dataBuffer) {
                            return true;
                        }
                        object2 = ((DataBuffer)object2).next;
                    }
                }
                if (ParsedEntity.this.fContentLastBuffer == dataBuffer) {
                    return true;
                }
                if (ParsedEntity.this.fMarks != null) {
                    object2 = ParsedEntity.this.fMarks;
                    while (object2 != null) {
                        if (((Mark)object2).markBuffer == dataBuffer) {
                            return true;
                        }
                        object2 = ((Mark)object2).markNext;
                    }
                    return false;
                }
                return false;
            }

            public void removeReferencesAndUnregister() {
                ParsedEntity.this.clear();
            }
        };
    }

    public void setBufferFactory(DataBufferFactory dataBufferFactory) {
        if (dataBufferFactory != this.fBufferFactory) {
            if (this.fBufferFactory != null) {
                this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            }
            dataBufferFactory.addReferrer(this.fBufferReferrer);
            this.fBufferFactory = dataBufferFactory;
        }
    }

    public String toString() {
        XMLString xMLString = new XMLString();
        xMLString.setValues(this.buffer, this.startOffset, this.offset);
        String string2 = xMLString.toString();
        xMLString.setValues(this.buffer, this.offset, this.endOffset);
        string2 = string2 + "<&&&>" + xMLString.toString();
        xMLString.unregister();
        return string2;
    }

    public void clear() {
        this.baseURI = null;
        this.bytes = null;
        this.startOffset = 0;
        this.lineBreaksNormalized = false;
        this.error = null;
        this.isXML10 = true;
        this.isInternal = false;
        this.loadCalled = false;
        this.parent = null;
        if (this.fSource != null) {
            this.fSource.release();
            this.fSource = null;
        }
        this.buffer = null;
        if (this.fMarks != null) {
            if (this.fFreeMarks != null) {
                Mark mark = this.fMarks;
                while (mark.markNext != null) {
                    mark = mark.markNext;
                }
                mark.markNext = this.fFreeMarks;
            }
            this.fFreeMarks = this.fMarks;
            this.fMarks = null;
        }
        this.fContentLastBuffer = null;
        this.fEndOfEntity = false;
        this.fBufferReferrer.active = false;
        if (this.fBufferFactory != null) {
            this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            this.fBufferFactory = null;
        }
    }

    public int loadMore() {
        this.loadCalled = true;
        do {
            if (this.buffer.next == null) {
                if (this.fSource != null) {
                    this.error = this.fSource.load(this);
                    if (this.error != null) {
                        this.fEndOfEntity = true;
                        if (this.fSource != null) {
                            this.fSource.release();
                            this.fSource = null;
                        }
                        return 0;
                    }
                    this.fEndOfEntity = false;
                    continue;
                }
                this.fEndOfEntity = true;
                return 0;
            }
            if (this.buffer != this.fContentLastBuffer) {
                this.advanceBuffer();
                this.offset = this.startOffset;
                this.fEndOfEntity = false;
                continue;
            }
            this.fEndOfEntity = true;
            return 0;
        } while (this.bytes[this.offset] == 0 && !this.fEndOfEntity);
        return this.bytes[this.offset];
    }

    public void setValues(DataBuffer dataBuffer, int n2, int n3, DataSource dataSource) {
        if (this.buffer != null) {
            this.buffer.next = dataBuffer;
        }
        this.buffer = dataBuffer;
        this.bytes = dataBuffer.bytes;
        this.offset = n2;
        this.endOffset = n3;
        this.startOffset = n2;
        this.fSource = dataSource;
        this.fEndOfEntity = false;
        this.fBufferReferrer.active = true;
    }

    public void setContent(XMLString xMLString) {
        this.buffer = xMLString.firstBuffer;
        this.bytes = this.buffer.bytes;
        this.startOffset = this.offset = xMLString.startOffset;
        if (xMLString.bytes != null) {
            this.endOffset = xMLString.endOffset;
            this.fContentLastBuffer = this.buffer;
            this.fContentEndOffset = this.endOffset;
        } else {
            this.fContentLastBuffer = xMLString.lastBuffer;
            this.fContentEndOffset = xMLString.endOffset;
            this.endOffset = this.buffer.endOffset;
        }
        this.fSource = null;
        this.fBufferReferrer.active = true;
    }

    public void release() {
        this.clear();
        this.fEntityFactory.releaseParsedEntity(this);
    }

    private void pushMark(Mark mark) {
        mark.markNext = this.fMarks;
        this.fMarks = mark;
    }

    private Mark popMark() {
        Mark mark = this.fMarks;
        this.fMarks = mark.markNext;
        return mark;
    }

    public void setMark() {
        Mark mark = this.fFreeMarks;
        if (mark != null) {
            this.fFreeMarks = mark.markNext;
            mark.markNext = null;
        } else {
            mark = new Mark();
        }
        mark.markBuffer = this.buffer;
        mark.markOffset = this.offset;
        mark.markStartOffset = this.startOffset;
        mark.markEndOffset = this.endOffset;
        this.pushMark(mark);
    }

    public void clearMark() {
        Mark mark = this.popMark();
        mark.markBuffer = null;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
    }

    public void resetToMark() {
        Mark mark = this.popMark();
        if (this.buffer != mark.markBuffer) {
            this.buffer = mark.markBuffer;
            this.bytes = this.buffer.bytes;
        }
        mark.markBuffer = null;
        this.offset = mark.markOffset;
        this.startOffset = mark.markStartOffset;
        this.endOffset = mark.markEndOffset;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
        this.fEndOfEntity = false;
    }

    public DataBuffer previousBuffer(DataBuffer dataBuffer) {
        Mark mark = this.fMarks;
        while (mark != null) {
            DataBuffer dataBuffer2 = mark.markBuffer;
            if (dataBuffer2 != dataBuffer) {
                while (dataBuffer2.next != null) {
                    if (dataBuffer2.next == dataBuffer) {
                        return dataBuffer2;
                    }
                    dataBuffer2 = dataBuffer2.next;
                }
            }
            mark = mark.markNext;
        }
        return null;
    }

    private void advanceBuffer() {
        this.buffer = this.buffer.next;
        this.bytes = this.buffer.bytes;
        this.startOffset = this.buffer.startOffset;
        this.endOffset = this.buffer == this.fContentLastBuffer ? this.fContentEndOffset : this.buffer.endOffset;
    }

    public int advanceOffset(int n2) {
        this.offset += n2;
        if (this.offset > this.endOffset) {
            n2 = this.offset - this.endOffset;
            this.advanceBuffer();
            this.offset = this.startOffset + n2;
        }
        return this.offset;
    }

    public boolean skippedValidCharacter() {
        if (this.offset < this.endOffset || this.buffer.next != null || this.fSource != null) {
            if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
                boolean bl;
                boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.validChar10(this.fIntPointer[0]) : XMLCharacterProperties.validChar11(this.fIntPointer[0], this.isInternal);
                if (bl) {
                    this.offset += this.fIntPointer[1];
                    if (this.offset > this.endOffset) {
                        int n2 = this.offset - this.endOffset;
                        this.advanceBuffer();
                        this.offset = this.startOffset + n2;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean skippedNameStartCharacter() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            boolean bl;
            boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.nameStartChar10(this.fIntPointer[0]) : XMLCharacterProperties.nameStartChar11(this.fIntPointer[0]);
            if (bl) {
                this.offset += this.fIntPointer[1];
                if (this.offset > this.endOffset) {
                    int n2 = this.offset - this.endOffset;
                    this.advanceBuffer();
                    this.offset = this.startOffset + n2;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean skippedNameCharacter() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            boolean bl;
            boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.nameChar10(this.fIntPointer[0]) : XMLCharacterProperties.nameChar11(this.fIntPointer[0]);
            if (bl) {
                this.offset += this.fIntPointer[1];
                if (this.offset > this.endOffset) {
                    int n2 = this.offset - this.endOffset;
                    this.advanceBuffer();
                    this.offset = this.startOffset + n2;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean skippedXML11EOLCharacter() {
        if ((this.bytes[this.offset] & 0xDF) == 194) {
            return this.skippedXML11EOLCharacterInternal();
        }
        return false;
    }

    private boolean skippedXML11EOLCharacterInternal() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            if (this.fIntPointer[0] == 133 || this.fIntPointer[0] == 8232) {
                this.offset += this.fIntPointer[1];
                if (this.offset > this.endOffset) {
                    int n2 = this.offset - this.endOffset;
                    this.advanceBuffer();
                    this.offset = this.startOffset + n2;
                }
                return true;
            }
            return false;
        }
        assert (false);
        return false;
    }

    public int decodeCharacter() {
        if (UTF8Support.decodeCharacter(this, this.fIntPointer)) {
            return this.fIntPointer[0];
        }
        return -1;
    }

    public boolean loadNextBuffer(int n2) {
        this.offset = n2;
        if (this.offset == this.endOffset) {
            this.loadMore();
        }
        return !this.fEndOfEntity && this.error == null;
    }

    public boolean atEndOfEntity() {
        return this.fEndOfEntity || this.offset == this.endOffset && (this.fEndOfEntity = this.loadMore() == 0);
    }

    public int checkForMarkup() {
        if (this.bytes[this.offset] != 60) {
            return 0;
        }
        return DocumentScanner.markupMap[this.bytes[this.offset + 1] & 0xFF];
    }

    public boolean lookingAt(int n2) {
        return this.bytes[this.offset] == n2;
    }

    public int currentByte() {
        return this.bytes[this.offset] & 0xFF;
    }

    public int peekByte() {
        int n2 = this.bytes[this.offset + 1];
        if (n2 != 0 || this.offset + 1 < this.endOffset) {
            return n2 & 0xFF;
        }
        this.setMark();
        n2 = this.bytes[++this.offset];
        if (n2 == 0 && this.offset == this.endOffset) {
            n2 = this.loadMore();
        }
        this.resetToMark();
        return n2 & 0xFF;
    }

    public void nextByte() {
        if (++this.offset == this.endOffset) {
            this.loadMore();
        }
    }

    public void skipTwoBytes() {
        this.offset += 2;
        if (this.offset >= this.endOffset) {
            int n2 = this.offset - this.endOffset;
            if (this.loadMore() != 0) {
                this.offset = this.startOffset + n2;
            }
        }
    }

    public boolean skippedByte(int n2) {
        if (this.bytes[this.offset] == n2) {
            if (++this.offset == this.endOffset) {
                this.loadMore();
            }
            return true;
        }
        return false;
    }

    public int skippedQuote() {
        byte by2 = this.bytes[this.offset];
        if (by2 == 34 || by2 == 39) {
            if (++this.offset == this.endOffset) {
                this.loadMore();
            }
            return by2;
        }
        return 0;
    }

    public boolean skippedBytes(byte[] byArray) {
        return this.skippedBytesInRange(byArray, 0, byArray.length);
    }

    public boolean skippedBytesMatchingXMLString(XMLString xMLString) {
        if (xMLString.bytes != null) {
            return this.skippedBytesInRange(xMLString.bytes, xMLString.startOffset, xMLString.endOffset);
        }
        return this.skippedBytes2(xMLString.firstBuffer, xMLString.lastBuffer, xMLString.startOffset, xMLString.endOffset);
    }

    public boolean skippedBytesInRangeForXMLString(byte[] byArray, int n2, int n3, XMLString xMLString) {
        if (this.bytes[this.offset] == byArray[n2]) {
            if (this.offset + (n3 - n2) <= this.endOffset) {
                int n4 = this.offset;
                while (++n2 < n3 && this.bytes[++this.offset] == byArray[n2] && ++n2 < n3 && this.bytes[++this.offset] == byArray[n2] && ++n2 < n3 && this.bytes[++this.offset] == byArray[n2]) {
                }
                if (n2 == n3) {
                    if (++this.offset < this.endOffset) {
                        xMLString.setValues(this.buffer, n4, this.offset);
                        return true;
                    }
                    xMLString.setValues(this.buffer, n4, this.offset);
                    this.loadMore();
                    return true;
                }
                this.offset = n4;
                return false;
            }
            xMLString.setStartPos(this.buffer, this.offset);
            if (!this.skippedBytesAcrossBuffers(byArray, n2, n3)) {
                return false;
            }
            xMLString.setEndPos(this.buffer, this.offset);
            return true;
        }
        if (this.offset == this.endOffset && this.loadMore() != 0) {
            return this.skippedBytesInRangeForXMLString(byArray, n2, n3, xMLString);
        }
        return false;
    }

    public boolean skippedBytesInRange(byte[] byArray, int n2, int n3) {
        if (this.bytes[this.offset] == byArray[n2]) {
            if (this.offset + (n3 - n2) <= this.endOffset) {
                int n4 = this.offset;
                while (++n2 < n3 && this.bytes[++this.offset] == byArray[n2] && ++n2 < n3 && this.bytes[++this.offset] == byArray[n2] && ++n2 < n3 && this.bytes[++this.offset] == byArray[n2]) {
                }
                if (n2 == n3) {
                    if (++this.offset < this.endOffset) {
                        return true;
                    }
                    this.loadMore();
                    return true;
                }
                this.offset = n4;
                return false;
            }
            return this.skippedBytesAcrossBuffers(byArray, n2, n3);
        }
        if (this.offset == this.endOffset && this.loadMore() != 0) {
            return this.skippedBytesInRange(byArray, n2, n3);
        }
        return false;
    }

    private boolean skippedBytesAcrossBuffers(byte[] byArray, int n2, int n3) {
        boolean bl = false;
        int n4 = this.offset++;
        int n5 = this.bytes[this.offset];
        int n6 = n2 + 1;
        while (n6 < n3) {
            if (n5 == byArray[n6]) {
                ++n6;
                n5 = this.bytes[++this.offset];
                continue;
            }
            if (n5 != 0 || this.offset < this.endOffset) {
                if (bl) {
                    this.resetToMark();
                } else {
                    this.offset = n4;
                }
                return false;
            }
            if (!bl) {
                this.offset = n4;
                this.setMark();
                bl = true;
            }
            if ((n5 = this.loadMore()) != 0) continue;
            this.resetToMark();
            return false;
        }
        if (bl) {
            this.clearMark();
        }
        if (n5 == 0 && this.offset == this.endOffset) {
            this.loadMore();
        }
        return true;
    }

    private boolean skippedBytes2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3) {
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n4 = dataBuffer3.endOffset;
        if (this.bytes[this.offset] == byArray[n2]) {
            int n5;
            boolean bl;
            block11: {
                bl = false;
                int n6 = this.offset++;
                n5 = this.bytes[this.offset];
                ++n2;
                while (true) {
                    if (n2 == n4) {
                        if (dataBuffer3 == dataBuffer2) break block11;
                        dataBuffer3 = dataBuffer3.next;
                        byArray = dataBuffer3.bytes;
                        n2 = dataBuffer3.startOffset;
                        int n7 = n4 = dataBuffer3 == dataBuffer2 ? n3 : dataBuffer3.endOffset;
                    }
                    if (n5 == byArray[n2]) {
                        ++n2;
                        n5 = this.bytes[++this.offset];
                        continue;
                    }
                    if (n5 != 0 || this.offset < this.endOffset) {
                        if (bl) {
                            this.resetToMark();
                        } else {
                            this.offset = n6;
                        }
                        return false;
                    }
                    if (!bl) {
                        this.offset = n6;
                        this.setMark();
                        bl = true;
                    }
                    if ((n5 = this.loadMore()) == 0) break;
                }
                this.resetToMark();
                return false;
            }
            if (bl) {
                this.clearMark();
            }
            if (n5 == 0 && this.offset == this.endOffset) {
                this.loadMore();
            }
            return true;
        }
        if (this.offset == this.endOffset && this.loadMore() != 0) {
            return this.skippedBytes2(dataBuffer, dataBuffer2, n2, n3);
        }
        return false;
    }

    public boolean skippedSpace() {
        byte by2 = this.bytes[this.offset];
        if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
            if (++this.offset == this.endOffset) {
                this.loadMore();
            }
            return true;
        }
        return !this.isXML10 && (by2 & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal();
    }

    public int skipSpaces() {
        byte by2;
        while (true) {
            if ((by2 = this.bytes[this.offset]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                if (++this.offset != this.endOffset) continue;
                this.loadMore();
                continue;
            }
            if (this.isXML10 || (by2 & 0xDF) != 194 || !this.skippedXML11EOLCharacterInternal()) break;
        }
        return by2;
    }

    public void skipASCIISpaces() {
        byte by2;
        while ((by2 = this.bytes[this.offset]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
            if (++this.offset != this.endOffset) continue;
            this.loadMore();
        }
    }

    public boolean skippedSpaces() {
        int n2 = this.bytes[this.offset];
        if (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13) {
            do {
                if ((n2 = this.bytes[++this.offset]) != 0 || this.offset != this.endOffset) continue;
                n2 = this.loadMore();
            } while (n2 == 32 || n2 == 10 || n2 == 9 || n2 == 13);
            if (!this.isXML10 && (n2 & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
                this.skipSpaces();
            }
            return true;
        }
        if (!this.isXML10 && (n2 & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
            this.skipSpaces();
            return true;
        }
        if (n2 == 0 && this.offset == this.endOffset && !this.fEndOfEntity) {
            this.loadMore();
            return this.skippedSpaces();
        }
        return false;
    }

    public boolean skipToChar(int n2) {
        int n3 = this.bytes[this.offset];
        while (n3 != n2) {
            if ((n3 = this.bytes[++this.offset]) != 0 || this.offset >= this.endOffset && (n3 = this.loadMore()) != 0) continue;
            return false;
        }
        return true;
    }

    public int skipValidXMLBytesUsingMapForXMLString(byte[] byArray, int n2, XMLString xMLString) {
        if (byArray[this.bytes[this.offset] & 0xFF] == n2) {
            while (byArray[this.bytes[++this.offset] & 0xFF] == n2) {
            }
        }
        if (this.bytes[this.offset] >= 32) {
            return byArray[this.bytes[this.offset]];
        }
        if (this.bytes[this.offset] == 0 && (this.offset < this.endOffset || this.loadMore() == 0)) {
            return byArray[0];
        }
        if (!this.lineBreaksNormalized) {
            return this.skipMoreValidXMLBytesUsingMapForXMLString(byArray, n2, xMLString);
        }
        return this.skipMoreValidXMLBytesUsingMap(byArray, n2);
    }

    private int skipMoreValidXMLBytesUsingMapForXMLString(byte[] byArray, int n2, XMLString xMLString) {
        byte by2 = this.bytes[this.offset];
        if (byArray[by2 & 0xFF] == n2) {
            ++this.offset;
        } else if (by2 == 13) {
            xMLString.flags = (short)(xMLString.flags | 4);
            ++this.offset;
        } else {
            if (by2 > 0) {
                return byArray[by2];
            }
            if (!this.isXML10 && (by2 & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
                xMLString.flags = (short)(xMLString.flags | 8);
            } else if (!this.skippedValidCharacter()) {
                return byArray[by2 & 0xFF];
            }
        }
        while (true) {
            if (byArray[this.bytes[this.offset] & 0xFF] == n2) {
                ++this.offset;
                continue;
            }
            by2 = this.bytes[this.offset];
            if (by2 > 0) {
                if (by2 != 13) {
                    return byArray[by2];
                }
                xMLString.flags = (short)(xMLString.flags | 4);
                ++this.offset;
                continue;
            }
            if (by2 < 0) {
                if (!this.isXML10 && (by2 & 0xDF) == 194 && this.skippedXML11EOLCharacterInternal()) {
                    xMLString.flags = (short)(xMLString.flags | 8);
                    continue;
                }
                if (this.skippedValidCharacter()) continue;
                return byArray[by2 & 0xFF];
            }
            if (this.offset < this.endOffset || this.loadMore() == 0) break;
        }
        return byArray[0];
    }

    private int skipMoreValidXMLBytesUsingMap(byte[] byArray, int n2) {
        byte by2 = this.bytes[this.offset];
        if (byArray[by2 & 0xFF] == n2) {
            ++this.offset;
        } else if (by2 == 13) {
            ++this.offset;
        } else {
            if (by2 > 0) {
                return byArray[by2];
            }
            if (!this.skippedValidCharacter()) {
                return byArray[by2 & 0xFF];
            }
        }
        while (true) {
            if (byArray[this.bytes[this.offset] & 0xFF] == n2) {
                ++this.offset;
                continue;
            }
            by2 = this.bytes[this.offset];
            if (by2 > 0) {
                if (by2 != 13) {
                    return byArray[by2];
                }
                ++this.offset;
                continue;
            }
            if (by2 < 0) {
                if (this.skippedValidCharacter()) continue;
                return byArray[by2 & 0xFF];
            }
            if (this.offset < this.endOffset || this.loadMore() == 0) break;
        }
        return byArray[0];
    }

    public int skipBytesWithinBufferUsingMapForXMLString(byte[] byArray, int n2, XMLString xMLString) {
        int n3 = 0;
        while (byArray[this.bytes[this.offset] & 0xFF] == n2) {
            n3 = n3 * 31 + this.bytes[this.offset++];
        }
        xMLString.hashcode = n3;
        return byArray[this.bytes[this.offset] & 0xFF];
    }

    public int skipBytesWithinBufferUsingMap(byte[] byArray, int n2) {
        while (byArray[this.bytes[this.offset] & 0xFF] == n2) {
            ++this.offset;
        }
        return byArray[this.bytes[this.offset] & 0xFF];
    }

    public int skipBytesUsingMap(byte[] byArray, int n2) {
        while (true) {
            if (byArray[this.bytes[this.offset] & 0xFF] == n2) {
                ++this.offset;
                continue;
            }
            if (this.bytes[this.offset] != 0 || this.offset != this.endOffset || this.loadMore() == 0) break;
        }
        return byArray[this.bytes[this.offset] & 0xFF];
    }

    public void startString(XMLString xMLString) {
        xMLString.setStartPos(this.buffer, this.offset);
    }

    public void endString(XMLString xMLString) {
        xMLString.setEndPos(this.buffer, this.offset);
    }

    public void endStringAtMark(XMLString xMLString) {
        Mark mark = this.popMark();
        xMLString.setEndPos(mark.markBuffer, mark.markOffset);
        mark.markBuffer = null;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
    }

    public int scanSimpleContent(XMLString xMLString) {
        if (NO_ENCODE_FLAGS) {
            return this.scanSimpleContentSimply(xMLString);
        }
        return this.scanSimpleContentWithEncodeFlags(xMLString);
    }

    public int scanSimpleContentWithEncodeFlags(XMLString xMLString) {
        byte[] byArray;
        byte[] byArray2 = this.bytes;
        int n2 = this.offset;
        short s = 0;
        int n3 = 16;
        byte by2 = 0;
        int n4 = 63;
        if (!this.lineBreaksNormalized) {
            byArray = contentMap;
        } else {
            byArray = normalizedContentMap;
            n4 = (byte)(n4 & 0xFFFFFFFD);
        }
        block15: while (true) {
            if (simpleContentMap[byArray2[n2] & 0xFF] == 0) {
                ++n2;
                continue;
            }
            by2 = simpleContentMap[byArray2[n2] & 0xFF];
            if ((by2 & n4) == 0) {
                ++n2;
                continue;
            }
            switch (by2) {
                case 1: {
                    if (n2 > this.offset) {
                        xMLString.setValues(this.buffer, this.offset, n2);
                        xMLString.flags = s;
                        xMLString.encodeFlags = (short)n3;
                        this.offset = n2;
                        switch (DocumentScanner.markupMap[byArray2[n2 + 1] & 0xFF]) {
                            case 1: {
                                return 0;
                            }
                            case 2: {
                                return 1;
                            }
                        }
                        return 2;
                    }
                    switch (DocumentScanner.markupMap[byArray2[n2 + 1] & 0xFF]) {
                        case 1: {
                            return 3;
                        }
                        case 2: {
                            return 4;
                        }
                    }
                    return 5;
                }
                case 2: {
                    ++n2;
                    s = (short)(s | 4);
                    n3 = (short)(n3 | 0x48);
                    n4 = (byte)(n4 & 0xFFFFFFF9);
                    byArray = normalizedContentMap;
                    continue block15;
                }
                case 4: {
                    n3 = (short)(n3 | 8);
                    n4 = (byte)(n4 & 0xFFFFFFFB);
                    continue block15;
                }
                case 8: {
                    n3 = (short)(n3 | 2);
                    n4 = (byte)(n4 & 0xFFFFFFF7);
                    continue block15;
                }
                case 16: {
                    n3 = (short)(n3 | 4);
                    n4 = (byte)(n4 & 0xFFFFFFEF);
                    continue block15;
                }
            }
            break;
        }
        if (byArray2[n2] != 0 || n2 < this.endOffset) {
            return -1;
        }
        return this.scanSimpleContentAcrossBuffers(xMLString, s, byArray);
    }

    public int scanSimpleContentSimply(XMLString xMLString) {
        byte by2;
        short s;
        int n2;
        byte[] byArray;
        block27: {
            byArray = this.bytes;
            n2 = this.offset;
            s = 0;
            if (!this.lineBreaksNormalized) {
                while (true) {
                    if (contentMap[byArray[n2] & 0xFF] == 1) {
                        ++n2;
                        continue;
                    }
                    by2 = byArray[n2];
                    if (by2 == 60) {
                        if (n2 > this.offset) {
                            xMLString.setValues(this.buffer, this.offset, n2);
                            xMLString.flags = s;
                            this.offset = n2;
                            switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                                case 1: {
                                    return 0;
                                }
                                case 2: {
                                    return 1;
                                }
                            }
                            return 2;
                        }
                        switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                            case 1: {
                                return 3;
                            }
                            case 2: {
                                return 4;
                            }
                        }
                        return 5;
                    }
                    if (by2 != 13) break;
                    ++n2;
                    s = (short)(s | 4);
                    if (!this.isXML10) {
                        if ((byArray[n2] & 0xFF) != 194 || (byArray[n2 + 1] & 0xFF) != 133) continue;
                        s = (short)(s | 8);
                        n2 += 2;
                        continue;
                    }
                    break block27;
                    break;
                }
                if (byArray[n2] != 0 || n2 < this.endOffset) {
                    return -1;
                }
                return this.scanSimpleContentAcrossBuffers(xMLString, s, contentMap);
            }
        }
        while (normalizedContentMap[byArray[n2] & 0xFF] == 1) {
            ++n2;
        }
        by2 = byArray[n2];
        if (by2 == 60) {
            if (n2 > this.offset) {
                xMLString.setValues(this.buffer, this.offset, n2);
                xMLString.flags = s;
                this.offset = n2;
                switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 2;
            }
            switch (DocumentScanner.markupMap[byArray[n2 + 1] & 0xFF]) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return 5;
        }
        if (byArray[n2] != 0 || n2 < this.endOffset) {
            return -1;
        }
        return this.scanSimpleContentAcrossBuffers(xMLString, s, normalizedContentMap);
    }

    private int scanSimpleContentAcrossBuffers(XMLString xMLString, short s, byte[] byArray) {
        int n2;
        xMLString.setStartPos(this.buffer, this.offset);
        xMLString.flags = s;
        this.setMark();
        if (this.loadMore() != 0 && (n2 = !this.lineBreaksNormalized ? this.skipMoreValidXMLBytesUsingMapForXMLString(byArray, 1, xMLString) : this.skipMoreValidXMLBytesUsingMap(byArray, 1)) == 2) {
            xMLString.setEndPos(this.buffer, this.offset);
            if (xMLString.length > 0) {
                this.clearMark();
                switch (DocumentScanner.markupMap[this.bytes[this.offset + 1] & 0xFF]) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                }
                return 2;
            }
            xMLString.clear();
            this.resetToMark();
            switch (DocumentScanner.markupMap[this.bytes[this.offset + 1] & 0xFF]) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return 5;
        }
        xMLString.clear();
        this.resetToMark();
        return -1;
    }

    public int scanSimpleAttValue(XMLString xMLString, int n2, int n3) {
        int n4 = this.offset;
        int n5 = this.skipBytesWithinBufferUsingMap(attValueMap, 1);
        if (n5 == 2 && this.lookingAt(n2)) {
            if (n4 < this.offset) {
                xMLString.setValues(this.buffer, n4, this.offset);
                return 0;
            }
            return 1;
        }
        this.startString(xMLString);
        xMLString.startOffset = n4;
        return -1;
    }

    public int scanSimpleNamespaceURI(XMLString xMLString, int n2, int n3) {
        int n4 = this.offset;
        int n5 = this.skipBytesWithinBufferUsingMapForXMLString(attValueMap, 1, xMLString);
        if (n5 == 2 && this.lookingAt(n2)) {
            if (n4 < this.offset) {
                int n6 = xMLString.hashcode;
                xMLString.setValues(this.buffer, n4, this.offset);
                xMLString.hashcode = n6;
                return 0;
            }
            return 1;
        }
        this.startString(xMLString);
        xMLString.startOffset = n4;
        return -1;
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private static class Mark {
        DataBuffer markBuffer;
        int markOffset;
        int markStartOffset;
        int markEndOffset;
        Mark markNext;

        private Mark() {
        }
    }
}

