/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class NullDataBufferFactory
implements DataBufferFactory {
    private static final DataBufferFactory fgSingleton = new NullDataBufferFactory();
    private static final byte[] fgNullBytes = ArrayAllocator.newByteArray(1);
    private static final XMLString fgNullXMLString;

    public static DataBuffer createNewBuffer() {
        return fgSingleton.createBuffer();
    }

    public static void setEmptyStringValues(XMLString xMLString) {
        xMLString.setValues(fgNullXMLString);
    }

    private NullDataBufferFactory() {
    }

    public DataBuffer createBuffer() {
        return new DataBuffer(this);
    }

    public DataBuffer createBuffer(int n2) {
        DataBuffer dataBuffer = new DataBuffer(this);
        if (dataBuffer.bytes == null) {
            dataBuffer.bytes = ArrayAllocator.newByteArray(n2);
        } else if (dataBuffer.bytes.length < n2) {
            dataBuffer.bytes = ArrayAllocator.replaceByteArray(dataBuffer.bytes, n2);
        }
        return dataBuffer;
    }

    public void freeBuffer(DataBuffer dataBuffer) {
        dataBuffer.bytes = null;
    }

    public void addReferrer(DataBufferReferrer dataBufferReferrer) {
    }

    public void removeReferrer(DataBufferReferrer dataBufferReferrer) {
    }

    public boolean isReferenced(DataBuffer dataBuffer) {
        return true;
    }

    public void setReclaimLimit(int n2) {
    }

    public void reclaimBuffers(boolean bl) {
    }

    public void reset(boolean bl) {
    }

    public void unregisterReferrers() {
    }

    static {
        DataBuffer dataBuffer = NullDataBufferFactory.createNewBuffer();
        dataBuffer.bytes = fgNullBytes;
        dataBuffer.endOffset = 0;
        dataBuffer.startOffset = 0;
        fgNullXMLString = new XMLString();
        fgNullXMLString.setValues(dataBuffer, 0, 0);
    }
}

