/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.scan.util;

import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class EntityManager {
    private static final boolean ALWAYS_SUPPORT_DTD = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                if (System.getProperty("com.ibm.xml.xlxp.support.dtd.compat.mode", "true").equals("false")) {
                    return Boolean.FALSE;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return Boolean.TRUE;
        }
    });
    private static final int ENTITYSTATE_DOCUMENT_ENTITY = 0;
    private static final int ENTITYSTATE_REF_IN_CONTENT = 1;
    private static final int ENTITYSTATE_REF_IN_LITERAL = 2;
    private static final int ENTITYSTATE_DTD_EXTERNAL_SUBSET = 3;
    private static final int ENTITYSTATE_PE_BETWEEN_MARKUP = 4;
    private static final int ENTITYSTATE_PE_WITHIN_MARKUP = 5;
    private final DocumentScanner fScanner;
    private final SymbolTable fSymbolTable;
    private final EntityDeclPool fDefaultEntityDeclPool;
    private final ParsedEntityFactory fEntityFactory;
    private final EntitySupport fSupport;
    private XMLStringBuffer fStringBuffer;
    private EntityDeclPool fEntityDeclPool;
    private int fEntityDepth;
    private boolean fSupportDTD;
    private boolean fResolveDTDURIs;
    private ParsedEntity fCurrentEntity;
    private int[] fEntityTypeStack;
    private boolean[] fEntityExternalStack;
    private int[] fEntityStateStack;
    private XMLString fReferencePath;
    private boolean fStandalone;
    private boolean fScanInternalGeneralEntities;
    private boolean fScanExternalGeneralEntities;
    private boolean fScanExternalParameterEntities;
    private boolean fHaveExternalSubsetOrPEReferences;
    private boolean fInExternalEntity;
    private boolean fHadExternalEntity;
    private int fActiveReferences;
    private String[] fActiveReferencesStack;
    private int fActivePEReferences;
    private String[] fActivePEReferencesStack;
    private int fEntityState;

    public EntityManager(EntitySupport entitySupport, DocumentScanner documentScanner, SymbolTable symbolTable, ParsedEntityFactory parsedEntityFactory) {
        this.fSupport = entitySupport;
        this.fScanner = documentScanner;
        this.fSymbolTable = symbolTable;
        this.fEntityFactory = parsedEntityFactory;
        this.fScanInternalGeneralEntities = true;
        this.fScanExternalGeneralEntities = true;
        this.fScanExternalParameterEntities = true;
        this.fSupportDTD = true;
        this.fResolveDTDURIs = true;
        this.fEntityDeclPool = this.fDefaultEntityDeclPool = new EntityDeclPool(symbolTable, null);
        this.fActiveReferencesStack = ArrayAllocator.newStringArray(16);
        this.fActivePEReferencesStack = ArrayAllocator.newStringArray(16);
        this.fEntityTypeStack = ArrayAllocator.newIntArray(8);
        this.fEntityExternalStack = ArrayAllocator.newBooleanArray(8);
        this.fEntityStateStack = ArrayAllocator.newIntArray(8);
        this.fEntityState = 0;
    }

    public void reset(boolean bl) {
        while (this.fCurrentEntity != null) {
            ParsedEntity parsedEntity = this.fCurrentEntity;
            this.fCurrentEntity = this.fCurrentEntity.parent;
            if (parsedEntity.parent == null) continue;
            parsedEntity.release();
        }
        this.fStandalone = false;
        this.fEntityDepth = 0;
        this.fHaveExternalSubsetOrPEReferences = false;
        this.fInExternalEntity = false;
        this.fHadExternalEntity = false;
        this.fActiveReferences = 0;
        this.fActivePEReferences = 0;
    }

    public int entityDepth() {
        return this.fEntityDepth;
    }

    private boolean recursiveReferenceInContent(XMLString xMLString, XMLString xMLString2) {
        this.fScanner.setParameter(0, xMLString);
        this.fScanner.setParameter(1, xMLString2);
        return this.reportFatalError(109);
    }

    private boolean undeclaredEntityInContent(XMLString xMLString) {
        this.fScanner.setParameter(0, xMLString);
        if (this.fHaveExternalSubsetOrPEReferences && !this.fStandalone) {
            if (this.fScanner.reportRecoverableError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47)) {
                return this.fScanner.produceEntityReferenceEvent();
            }
            return false;
        }
        return this.fScanner.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47);
    }

    private boolean unparsedEntityInContent(XMLString xMLString) {
        this.fScanner.setParameter(0, xMLString);
        return this.reportFatalError(108);
    }

    private boolean externallyDeclaredEntityInContent(XMLString xMLString) {
        this.fScanner.setParameter(0, xMLString);
        return this.reportFatalError(73);
    }

    private boolean recursiveReferenceInAttValue(XMLString xMLString, XMLString xMLString2) {
        this.fScanner.setParameter(0, xMLString);
        this.fScanner.setParameter(1, xMLString2);
        return this.reportFatalError(109);
    }

    private boolean undeclaredEntity(XMLString xMLString) {
        this.fScanner.setParameter(0, xMLString);
        return this.fScanner.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006#NT-document", 47);
    }

    private boolean externalEntityInAttValue(XMLString xMLString) {
        this.fScanner.setParameter(0, xMLString);
        return this.reportFatalError(106);
    }

    private boolean externallyDeclaredEntityInAttValue(XMLString xMLString) {
        this.fScanner.setParameter(0, xMLString);
        return this.reportFatalError(73);
    }

    private boolean skippedParameterEntity(XMLString xMLString) {
        return true;
    }

    private boolean recursivePEReference(XMLString xMLString, XMLString xMLString2) {
        this.fScanner.setParameter(0, xMLString);
        this.fScanner.setParameter(1, xMLString2);
        return this.reportFatalError(110);
    }

    public void setScanInternalGeneralEntities(boolean bl) {
        this.fScanInternalGeneralEntities = bl;
    }

    public boolean getScanInternalGeneralEntities() {
        return this.fScanInternalGeneralEntities;
    }

    public void setScanExternalGeneralEntities(boolean bl) {
        this.fScanExternalGeneralEntities = bl;
    }

    public boolean getScanExternalGeneralEntities() {
        return this.fScanExternalGeneralEntities;
    }

    public void setScanExternalParameterEntities(boolean bl) {
        this.fScanExternalParameterEntities = bl;
    }

    public boolean getScanExternalParameterEntities() {
        return this.fScanExternalParameterEntities;
    }

    public void setSupportDTD(boolean bl) {
        this.fSupportDTD = bl || ALWAYS_SUPPORT_DTD;
    }

    public void setResolveDTDURIs(boolean bl) {
        this.fResolveDTDURIs = bl;
    }

    public boolean getResolveDTDURIs() {
        return this.fResolveDTDURIs;
    }

    public void setStandalone() {
        this.fStandalone = true;
    }

    public boolean isStandalone() {
        return this.fStandalone;
    }

    public String currentBaseURI() {
        if (this.fCurrentEntity != null) {
            return this.fCurrentEntity.baseURI;
        }
        return null;
    }

    public boolean inExternalEntity() {
        return this.fInExternalEntity;
    }

    public boolean hadExternalEntity() {
        return this.fHadExternalEntity;
    }

    public void setDocumentEntity(ParsedEntity parsedEntity) {
        this.fCurrentEntity = parsedEntity;
        this.fCurrentEntity.parent = null;
        this.fEntityState = 0;
        ++this.fEntityDepth;
        ++this.fActiveReferences;
    }

    public boolean endOfEntity(int n2) {
        if (this.inReferenceInContent()) {
            this.fSymbolTable.addSymbolSetValues(this.currentReferenceName(), this.fScanner.entityName);
        }
        if (this.entityDepth() > n2) {
            this.popEntityState();
            return true;
        }
        return false;
    }

    private void pushEntityState(int n2, String string2, boolean bl) {
        int n3 = this.fEntityDepth - 1;
        if (n3 == this.fEntityTypeStack.length) {
            int n4 = n3 << 1;
            this.fEntityTypeStack = ArrayAllocator.resizeIntArray(this.fEntityTypeStack, n4);
            this.fEntityExternalStack = ArrayAllocator.resizeBooleanArray(this.fEntityExternalStack, n4);
            this.fEntityStateStack = ArrayAllocator.resizeIntArray(this.fEntityStateStack, n4);
        }
        this.fEntityExternalStack[n3] = this.fInExternalEntity;
        this.fEntityStateStack[n3] = this.fEntityState;
        this.fEntityTypeStack[n3] = bl ? 1 : 0;
        this.fEntityState = n2;
        if (bl) {
            if (this.fActivePEReferences == this.fActivePEReferencesStack.length) {
                this.fActivePEReferencesStack = ArrayAllocator.resizeStringArray(this.fActivePEReferencesStack, this.fActivePEReferences << 1);
            }
            this.fActivePEReferencesStack[this.fActivePEReferences++] = string2;
        } else {
            if (this.fActiveReferences == this.fActiveReferencesStack.length) {
                this.fActiveReferencesStack = ArrayAllocator.resizeStringArray(this.fActiveReferencesStack, this.fActiveReferences << 1);
            }
            this.fActiveReferencesStack[this.fActiveReferences++] = string2;
        }
    }

    public void popEntityState() {
        int n2;
        boolean bl;
        boolean bl2 = bl = this.fEntityTypeStack[n2 = --this.fEntityDepth] == 1;
        if (bl) {
            --this.fActivePEReferences;
        } else {
            --this.fActiveReferences;
        }
        ParsedEntity parsedEntity = this.fCurrentEntity;
        this.fCurrentEntity = this.fCurrentEntity.parent;
        this.fInExternalEntity = this.fEntityExternalStack[n2];
        this.fEntityState = this.fEntityStateStack[n2];
        if (n2 > 0) {
            this.fSupport.setEntityContent(this.fCurrentEntity);
            parsedEntity.release();
        }
    }

    public EntityDeclPool.EntityDecl lookupEntity(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        return this.fEntityDeclPool.lookupEntity(string2);
    }

    public EntityDeclPool.EntityDecl lookupPE(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        return this.fEntityDeclPool.lookupPE(string2);
    }

    public boolean entityReferenceInContent(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.isRecursiveReference(string2)) {
            return this.recursiveReferenceInContent(xMLString, this.entityReferencePath(string2));
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupEntity(string2);
        if (entityDecl == null) {
            return this.undeclaredEntityInContent(xMLString);
        }
        int n2 = entityDecl.type;
        if (this.fStandalone && entityDecl.declaredExternally && !this.externallyDeclaredEntityInContent(xMLString)) {
            return false;
        }
        if (n2 == 0) {
            this.fScanner.singleCh = entityDecl.charValue;
            return this.fScanner.producePredefinedEntityEvent();
        }
        if (n2 == 1) {
            if (this.fScanInternalGeneralEntities) {
                if (!this.fSupportDTD) {
                    return this.undeclaredEntity(xMLString);
                }
                this.allocateInternalEntity(entityDecl.content);
                this.pushEntityState(1, string2, false);
                return this.fScanner.produceStartEntityEvent();
            }
            return this.fScanner.produceEntityReferenceEvent();
        }
        if (n2 == 5) {
            return this.unparsedEntityInContent(xMLString);
        }
        if (this.fScanExternalGeneralEntities) {
            if (!this.fSupportDTD) {
                return this.undeclaredEntity(xMLString);
            }
            this.allocateExternalEntity(entityDecl.publicID, entityDecl.systemID, entityDecl.baseURI);
            this.pushEntityState(1, string2, false);
            this.fInExternalEntity = true;
            this.fHadExternalEntity = true;
            return this.fScanner.scanTextDecl() && this.fScanner.produceStartEntityEvent();
        }
        return this.fScanner.produceEntityReferenceEvent();
    }

    public boolean entityReferenceInAttValue(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.isRecursiveReference(string2)) {
            return this.recursiveReferenceInAttValue(xMLString, this.entityReferencePath(string2));
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupEntity(string2);
        if (entityDecl == null) {
            return this.undeclaredEntity(xMLString);
        }
        int n2 = entityDecl.type;
        if (this.fStandalone && entityDecl.declaredExternally && !this.externallyDeclaredEntityInAttValue(xMLString)) {
            return false;
        }
        if (n2 == 0) {
            int n3 = entityDecl.charValue;
            this.fScanner.attributeValueCharacter(n3, true);
            return true;
        }
        if (!this.fSupportDTD) {
            return this.undeclaredEntity(xMLString);
        }
        if (n2 == 1) {
            this.allocateInternalEntity(entityDecl.content);
            this.pushEntityState(2, string2, false);
            return true;
        }
        return this.externalEntityInAttValue(xMLString);
    }

    public boolean entityReferenceInDefaultAttValue(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.isRecursiveReference(string2)) {
            return this.recursiveReferenceInAttValue(xMLString, this.entityReferencePath(string2));
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupEntity(string2);
        if (entityDecl == null) {
            return this.undeclaredEntity(xMLString);
        }
        int n2 = entityDecl.type;
        if (this.fStandalone && entityDecl.declaredExternally && !this.externallyDeclaredEntityInAttValue(xMLString)) {
            return false;
        }
        if (n2 == 0) {
            int n3 = entityDecl.charValue;
            this.fSupport.defaultAttValueCharacter(n3, true);
            return true;
        }
        if (!this.fSupportDTD) {
            return this.undeclaredEntity(xMLString);
        }
        if (n2 == 1) {
            this.allocateInternalEntity(entityDecl.content);
            this.pushEntityState(2, string2, false);
            return true;
        }
        return this.externalEntityInAttValue(xMLString);
    }

    public boolean externalSubsetPEReference(XMLString xMLString) {
        return this.peReference(xMLString);
    }

    public boolean internalSubsetPEReference(XMLString xMLString) {
        return this.peReference(xMLString);
    }

    private boolean peReference(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.isRecursivePEReference(string2)) {
            return this.recursivePEReference(xMLString, this.peReferencePath(string2));
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupPE(string2);
        if (entityDecl == null || !this.fSupportDTD) {
            return this.fSupport.undeclaredParameterEntity(xMLString);
        }
        this.fHaveExternalSubsetOrPEReferences = true;
        int n2 = entityDecl.type;
        if (n2 == 3) {
            this.allocateInternalEntity(entityDecl.content);
            this.pushEntityState(4, string2, true);
            if (this.fInExternalEntity) {
                return this.fSupport.extSubsetPEReference(xMLString);
            }
            return this.fSupport.intSubsetPEReference(xMLString);
        }
        if (!this.fScanExternalParameterEntities) {
            return this.skippedParameterEntity(xMLString);
        }
        this.allocateExternalEntity(entityDecl.publicID, entityDecl.systemID, entityDecl.baseURI);
        this.pushEntityState(4, string2, true);
        this.fInExternalEntity = true;
        this.fHadExternalEntity = true;
        return this.fScanner.scanTextDecl() && this.fSupport.extSubsetPEReference(xMLString);
    }

    public boolean scanExternalSubset2(XMLString xMLString, XMLString xMLString2) {
        if (!this.fScanExternalParameterEntities || !this.fSupportDTD) {
            return this.fSupport.skippedExternalSubsetEntity();
        }
        this.allocateExternalEntity(xMLString, xMLString2, this.currentBaseURI());
        this.pushEntityState(3, null, true);
        this.fInExternalEntity = true;
        this.fHadExternalEntity = true;
        return this.fSupport.scanExternalSubset1();
    }

    public boolean peReferenceInEntityValue(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.isRecursivePEReference(string2)) {
            return this.recursivePEReference(xMLString, this.peReferencePath(string2));
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupPE(string2);
        if (entityDecl == null || !this.fSupportDTD) {
            return this.fSupport.undeclaredParameterEntity(xMLString);
        }
        this.fHaveExternalSubsetOrPEReferences = true;
        int n2 = entityDecl.type;
        if (n2 == 3) {
            this.allocateInternalEntity(entityDecl.content);
            this.pushEntityState(2, string2, true);
            return true;
        }
        if (!this.fScanExternalParameterEntities) {
            return this.skippedParameterEntity(xMLString);
        }
        this.allocateExternalEntity(entityDecl.publicID, entityDecl.systemID, entityDecl.baseURI);
        this.pushEntityState(2, string2, true);
        return this.fScanner.scanTextDecl();
    }

    public boolean startPEReferenceWithinMarkup(XMLString xMLString) {
        String string2 = this.fSymbolTable.addSymbol(xMLString);
        if (this.isRecursivePEReference(string2)) {
            return this.recursivePEReference(xMLString, this.peReferencePath(string2));
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupPE(string2);
        if (entityDecl == null) {
            return this.fSupport.undeclaredParameterEntity(xMLString);
        }
        this.fHaveExternalSubsetOrPEReferences = true;
        int n2 = entityDecl.type;
        if (n2 == 3) {
            this.allocateInternalEntity(entityDecl.content);
            this.pushEntityState(5, string2, true);
            return true;
        }
        if (!this.fScanExternalParameterEntities) {
            return this.skippedParameterEntity(xMLString);
        }
        this.allocateExternalEntity(entityDecl.publicID, entityDecl.systemID, entityDecl.baseURI);
        this.pushEntityState(5, string2, true);
        this.fInExternalEntity = true;
        this.fHadExternalEntity = true;
        return this.fScanner.scanTextDecl();
    }

    public String currentReferenceName() {
        return this.fActiveReferencesStack[this.fActiveReferences - 1];
    }

    public String currentPEReferenceName() {
        return this.fActivePEReferencesStack[this.fActivePEReferences - 1];
    }

    public void expandSystemID(XMLString xMLString) {
        String string2;
        String string3;
        if (this.fResolveDTDURIs && (string3 = this.fEntityFactory.expandSystemID(string2 = xMLString.toString(), this.currentBaseURI())) != string2) {
            if (this.fStringBuffer == null) {
                this.fStringBuffer = new XMLStringBuffer();
            }
            this.fStringBuffer.addString(string3, xMLString);
        }
    }

    private void allocateExternalEntity(XMLString xMLString, XMLString xMLString2, String string2) {
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntityFromExternalID(xMLString, xMLString2, string2, this.fCurrentEntity.isXML10);
        this.saveEntity(parsedEntity);
    }

    private void allocateInternalEntity(XMLString xMLString) {
        ParsedEntity parsedEntity = this.fEntityFactory.createParsedEntityFromXMLString(xMLString, this.currentBaseURI(), this.fCurrentEntity.isXML10);
        this.saveEntity(parsedEntity);
    }

    private void saveEntity(ParsedEntity parsedEntity) {
        parsedEntity.parent = this.fCurrentEntity;
        this.fCurrentEntity = parsedEntity;
        ++this.fEntityDepth;
        this.fSupport.setEntityContent(this.fCurrentEntity);
    }

    private boolean isRecursiveReference(String string2) {
        for (int i = 0; i < this.fActiveReferences; ++i) {
            if (this.fActiveReferencesStack[i] != string2) continue;
            return true;
        }
        return false;
    }

    private XMLString entityReferencePath(String string2) {
        if (this.fStringBuffer == null) {
            this.fStringBuffer = new XMLStringBuffer();
        }
        XMLStringBuffer xMLStringBuffer = this.fStringBuffer;
        int n2 = xMLStringBuffer.getOffset();
        xMLStringBuffer.appendChar(124);
        for (int i = 0; i < this.fActiveReferences; ++i) {
            if (this.fActiveReferencesStack[i] == null) continue;
            xMLStringBuffer.appendChar(45);
            xMLStringBuffer.appendChar(38);
            xMLStringBuffer.appendString(this.fActiveReferencesStack[i]);
            xMLStringBuffer.appendChar(59);
        }
        xMLStringBuffer.appendChar(45);
        xMLStringBuffer.appendChar(38);
        xMLStringBuffer.appendString(string2);
        xMLStringBuffer.appendChar(59);
        if (this.fReferencePath == null) {
            this.fReferencePath = new XMLString();
        }
        xMLStringBuffer.setStringValues(n2, xMLStringBuffer.getOffset(), this.fReferencePath);
        return this.fReferencePath;
    }

    private boolean isRecursivePEReference(String string2) {
        for (int i = 0; i < this.fActivePEReferences; ++i) {
            if (this.fActivePEReferencesStack[i] != string2) continue;
            return true;
        }
        return false;
    }

    private XMLString peReferencePath(String string2) {
        if (this.fStringBuffer == null) {
            this.fStringBuffer = new XMLStringBuffer();
        }
        XMLStringBuffer xMLStringBuffer = this.fStringBuffer;
        int n2 = xMLStringBuffer.getOffset();
        xMLStringBuffer.appendChar(124);
        for (int i = 0; i < this.fActivePEReferences; ++i) {
            if (this.fActivePEReferencesStack[i] == null) continue;
            xMLStringBuffer.appendChar(45);
            xMLStringBuffer.appendChar(37);
            xMLStringBuffer.appendString(this.fActivePEReferencesStack[i]);
            xMLStringBuffer.appendChar(59);
        }
        xMLStringBuffer.appendChar(45);
        xMLStringBuffer.appendChar(37);
        xMLStringBuffer.appendString(string2);
        xMLStringBuffer.appendChar(59);
        if (this.fReferencePath == null) {
            this.fReferencePath = new XMLString();
        }
        xMLStringBuffer.setStringValues(n2, xMLStringBuffer.getOffset(), this.fReferencePath);
        return this.fReferencePath;
    }

    private boolean reportFatalError(int n2) {
        return this.fScanner.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", n2);
    }

    public boolean inReferenceInContent() {
        return this.fEntityState == 1;
    }

    public boolean inPEReferenceWithinMarkup() {
        return this.fEntityState == 5;
    }

    public void setHaveExternalSubsetOrPEReferences() {
        this.fHaveExternalSubsetOrPEReferences = true;
    }

    public void setDefaultEntityDeclPool() {
        this.fEntityDeclPool = this.fDefaultEntityDeclPool;
    }

    public void setEntityDeclPool(EntityDeclPool entityDeclPool) {
        this.fEntityDeclPool = entityDeclPool;
    }

    public boolean addInternalEntityDecl(XMLString xMLString, XMLString xMLString2) {
        return this.fEntityDeclPool.addInternalEntityDecl(xMLString, xMLString2, this.inExternalEntity());
    }

    public boolean addExternalEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        this.expandSystemID(xMLString3);
        return this.fEntityDeclPool.addExternalEntityDecl(xMLString, xMLString2, xMLString3, this.currentBaseURI(), this.inExternalEntity());
    }

    public boolean addUnparsedEntityDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3, XMLString xMLString4) {
        this.expandSystemID(xMLString3);
        return this.fEntityDeclPool.addUnparsedEntityDecl(xMLString, this.inExternalEntity());
    }

    public boolean addInternalPEDecl(XMLString xMLString, XMLString xMLString2) {
        return this.fEntityDeclPool.addInternalPEDecl(xMLString, xMLString2, this.inExternalEntity());
    }

    public boolean addExternalPEDecl(XMLString xMLString, XMLString xMLString2, XMLString xMLString3) {
        this.expandSystemID(xMLString3);
        return this.fEntityDeclPool.addExternalPEDecl(xMLString, xMLString2, xMLString3, this.currentBaseURI(), this.inExternalEntity());
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static interface EntitySupport {
        public void setEntityContent(ParsedEntity var1);

        public boolean scanExternalSubset1();

        public boolean extSubsetPEReference(XMLString var1);

        public boolean intSubsetPEReference(XMLString var1);

        public void defaultAttValueCharacter(int var1, boolean var2);

        public boolean undeclaredParameterEntity(XMLString var1);

        public boolean skippedExternalSubsetEntity();
    }
}

