/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.runtime;

import com.ibm.xml.xlxp.internal.s1.converter.MergerContext;
import com.ibm.xml.xlxp.internal.s1.datatype.TypeValidator;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.datatype.XQName;
import com.ibm.xml.xlxp.internal.s1.grammar.Attribute;
import com.ibm.xml.xlxp.internal.s1.grammar.Element;
import com.ibm.xml.xlxp.internal.s1.grammar.ElementType;
import com.ibm.xml.xlxp.internal.s1.grammar.Grammar;
import com.ibm.xml.xlxp.internal.s1.grammar.NamedDeclaration;
import com.ibm.xml.xlxp.internal.s1.grammar.Wildcard;
import com.ibm.xml.xlxp.internal.s1.runtime.ContentScanner;
import com.ibm.xml.xlxp.internal.s1.runtime.DynamicSchemaResolver;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.DocumentScanner;
import com.ibm.xml.xlxp.internal.s1.scan.msg.MessageProviderRegistry;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.EntityDeclPool;
import com.ibm.xml.xlxp.internal.s1.scan.util.NullDataBufferFactory;
import com.ibm.xml.xlxp.internal.s1.scan.util.QName;
import com.ibm.xml.xlxp.internal.s1.scan.util.SymbolTable;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;
import com.ibm.xml.xlxp.internal.s1.util.BitSet;
import com.ibm.xml.xlxp.internal.s1.validation.idc.IDCContext;
import com.ibm.xml.xlxp.internal.s1.validation.idc.StartIDC;
import com.ibm.xml.xlxp.internal.s1.validation.msg.VMMessagesBundle;
import java.util.ArrayList;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class VMContext
extends DocumentScanner {
    public static final int FEATURE_INCREMENTAL = 1;
    public static final int FEATURE_KEEP_VALUE_POOL = 2;
    public static final int FEATURE_VALIDATION = 4;
    public static final int FEATURE_NO_ACTUAL_VALUE = 8;
    public static final int FEATURE_CUSTOM_DVCONTEXT = 16;
    public static final int FEATURE_DYNAMIC_SCHEMA_LOADING = 32;
    public static final int FEATURE_LAX_ASSESSMENT = 64;
    public static final int FEATURE_BO_BC_MODE = 128;
    public static final int STATE_STRICT = 0;
    public static final int STATE_LAX = 1;
    public static final int STATE_SKIP = 2;
    private int vmElementDepth;
    public int validationState;
    public int leafState;
    public Element eDecl;
    public int eDeclIndex;
    public Wildcard eWildcard;
    public ElementType eType;
    public boolean nilled;
    public boolean leafNilled;
    public final ValidatedInfo eValue = new ValidatedInfo();
    public Attribute[] aDecls = ArrayAllocator.newObjectArray(Attribute.class, 8);
    public int[] aIndex = ArrayAllocator.newIntArray(8);
    public ValidatedInfo[] aValues = ArrayAllocator.newObjectArray(ValidatedInfo.class, 8);
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XS_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String QNAME = "QName";
    private static final String ANYTYPE = "anyType";
    private static final String TYPE = "type";
    public final boolean validating;
    public ValidationContext dvContext;
    protected Grammar ir;
    private TypeValidator qnameDV;
    private int eWCIndex;
    private ValidatedInfo vcValue;
    private boolean vcFixed;
    protected ElementType.DFAInfo fDFAInfo;
    private int skipDepth;
    private int xsitypeIndex = -1;
    public final BitSet attsSpecified = new BitSet(1);
    public boolean isValidated = false;
    private int contentType;
    private State currentState;
    private final State rootState = new State();
    private final XMLStringBuffer elemBuffer = new XMLStringBuffer();
    private XMLString elementString;
    private final XMLString elementStringFirst = new XMLString();
    private int elemBufferOffset = -1;
    private ContentScanner fContentScanner;
    public final IDCContext idcContext;
    public int wildIDCDepth = -1;
    private EntityDeclPool fEntityDeclPool;
    private final boolean resetObjectPools;
    private final boolean supportsDynamicSchemaResolution;
    private DynamicSchemaResolver dynamicSchemaResolver;
    private final boolean produceActualValues;
    protected final boolean allowLaxAssessment;
    private final boolean boBCMode;
    protected int irVersion;

    public VMContext(long l) {
        this(null, null, l);
    }

    public VMContext(DataBufferFactory dataBufferFactory, SymbolTable symbolTable, long l) {
        super(dataBufferFactory, symbolTable, (l & 1L) != 0L);
        for (int i = 0; i < 8; ++i) {
            this.aValues[i] = new ValidatedInfo();
        }
        this.validating = (l & 4L) != 0L;
        this.allowLaxAssessment = (l & 0x40L) != 0L;
        boolean bl = this.boBCMode = (l & 0x80L) != 0L;
        if ((l & 0x10L) == 0L) {
            this.dvContext = new ValidationContext();
            this.dvContext.setSchemaProcessor(this);
        }
        this.resetObjectPools = (l & 2L) == 0L;
        this.produceActualValues = (l & 8L) == 0L;
        this.idcContext = this.validating ? new IDCContext(this) : null;
        this.supportsDynamicSchemaResolution = (l & 0x20L) != 0L && !this.validating;
        this.dynamicSchemaResolver = null;
    }

    public void setValidationContext(ValidationContext validationContext) {
        if (this.dvContext != null) {
            this.dvContext.setSchemaProcessor(null);
        }
        this.dvContext = validationContext;
        if (validationContext != null) {
            validationContext.setSchemaProcessor(this);
        }
    }

    public void setDynamicSchemaResolver(DynamicSchemaResolver dynamicSchemaResolver) {
        if (this.supportsDynamicSchemaResolution) {
            this.dynamicSchemaResolver = dynamicSchemaResolver;
        }
    }

    public final void setEntityDeclPool(EntityDeclPool entityDeclPool) {
        if (this.validating()) {
            this.fEntityDeclPool = entityDeclPool;
        }
    }

    public String toInternedString(XMLString xMLString) {
        return this.fSymbolTable.addSymbol(xMLString);
    }

    public boolean isUnparsedEntity(XMLString xMLString) {
        if (this.fEntityDeclPool == null) {
            return false;
        }
        EntityDeclPool.EntityDecl entityDecl = this.fEntityDeclPool.lookupEntity(this.toInternedString(xMLString));
        return entityDecl == null ? false : entityDecl.type == 5;
    }

    public void reset(boolean bl) {
        this.xsitypeIndex = -1;
        this.vmElementDepth = 0;
        this.eType = null;
        if (this.dvContext != null) {
            this.dvContext.reset(bl);
        }
        if (this.validating() && this.idcContext.idcCount > 0) {
            this.idcContext.reset();
        }
        this.leafState = 0;
        this.validationState = 0;
        super.reset(bl);
    }

    protected void growAttributes() {
        super.growAttributes();
        int n2 = this.aDecls.length;
        int n3 = n2 << 1;
        Attribute[] attributeArray = ArrayAllocator.newObjectArray(Attribute.class, n3);
        System.arraycopy(this.aDecls, 0, attributeArray, 0, n2);
        this.aDecls = attributeArray;
        ValidatedInfo[] validatedInfoArray = ArrayAllocator.newObjectArray(ValidatedInfo.class, n3);
        System.arraycopy(this.aValues, 0, validatedInfoArray, 0, n2);
        this.aValues = validatedInfoArray;
        for (int i = n3 - 1; i >= n2; --i) {
            this.aValues[i] = new ValidatedInfo();
        }
        int[] nArray = ArrayAllocator.newIntArray(n3);
        System.arraycopy(this.aIndex, 0, nArray, 0, n2);
        this.aIndex = nArray;
    }

    public boolean scanContent() {
        if (this.fContentScanner != null) {
            this.setStartCurrentEvent();
            boolean bl = this.fContentScanner.scanContent(this.fCurrentEntity, this.content, this);
            if (this.fCurrentState == 0) {
                this.setContentOrMarkupState();
            }
            return bl;
        }
        return super.scanContent();
    }

    public final void setContentScanner(ContentScanner contentScanner) {
        this.fContentScanner = contentScanner;
        this.inElementContent = false;
    }

    private final Wildcard matchWildcard(String string2) {
        Wildcard[] wildcardArray = this.fDFAInfo.wc;
        return this.matchWildcard(wildcardArray, string2);
    }

    private final Wildcard matchWildcard(Wildcard[] wildcardArray, String string2) {
        if (wildcardArray == null) {
            return null;
        }
        for (int i = 0; i < wildcardArray.length; ++i) {
            Wildcard wildcard = wildcardArray[i];
            if (!wildcard.allows(string2)) continue;
            this.eWCIndex = i;
            return wildcard;
        }
        return null;
    }

    public void setIR(Grammar grammar) {
        this.ir = grammar;
        this.qnameDV = null;
    }

    public Grammar getIR() {
        return this.ir;
    }

    public void startSchemaAssessment(Grammar grammar) {
        assert (this.ir == null && (this.fCurrentEvent == 2 || this.fCurrentEvent == 3));
        this.setIR(grammar);
        this.initializeGrammarState();
        if (this.fCurrentEvent == 2) {
            this.handleStartElementEvent();
        } else {
            this.handleLeafElementEvent();
        }
    }

    public void stopSchemaAssessment() {
        assert (this.ir != null && (this.fCurrentEvent == 4 || this.fCurrentEvent == 3) && this.vmElementDepth == 0);
        if (this.validating()) {
            this.finishValidation();
        }
        this.ir = null;
        this.qnameDV = null;
        this.setContentScanner(null);
    }

    private final void setAttrDecl(Attribute attribute2, int n2, int n3) {
        this.aDecls[n3] = attribute2;
        this.aIndex[n3] = n2;
    }

    public final int getElementDepth() {
        return this.vmElementDepth;
    }

    public final boolean currentElementHasSimpleContent() {
        return this.contentType == 1;
    }

    public final boolean currentElementHasMixedContent() {
        return this.contentType == 3;
    }

    public final boolean validating() {
        return this.validating;
    }

    public final ValidatedInfo currentElementActualValue() {
        return this.eValue;
    }

    public final ValidatedInfo currentAttributeActualValue() {
        return this.aValues[this.attrCount];
    }

    public final ValidatedInfo actualAttributeValue(int n2) {
        return this.aValues[n2];
    }

    public final boolean strictlyAssessing() {
        return this.validationState == 0;
    }

    public final boolean laxlyAssessing() {
        return this.validationState == 1;
    }

    public final boolean skipping() {
        return this.validationState == 2;
    }

    public final boolean strictlyAssessingLeaf() {
        return this.leafState == 0;
    }

    public final boolean laxlyAssessingLeaf() {
        return this.leafState == 1;
    }

    public final boolean skippingLeaf() {
        return this.leafState == 2;
    }

    public final void generateError(int n2) {
        this.reportRecoverableError(XS_NS, n2);
    }

    public final void generateError(int n2, String string2) {
        this.setParameter(0, string2);
        this.generateError(n2);
    }

    public final void generateError(int n2, String string2, String string3) {
        this.setParameter(0, string2);
        this.setParameter(1, string3);
        this.generateError(n2);
    }

    public final void generateError(int n2, String string2, String string3, String string4) {
        this.setParameter(0, string2);
        this.setParameter(1, string3);
        this.setParameter(2, string4);
        this.generateError(n2);
    }

    public final void generateError(int n2, XMLString xMLString) {
        this.setParameter(0, xMLString);
        this.generateError(n2);
    }

    private final void setupReadElement(int n2, ElementType.DFAInfo dFAInfo) {
        this.contentType = n2;
        this.setInElementContent(n2 == 2);
        if (n2 == 3) {
            this.clearCharValue();
        }
        this.fDFAInfo = dFAInfo;
    }

    private final void setupReadSimple(TypeValidator typeValidator) {
        this.setContentScanner(typeValidator.isContentScanner ? typeValidator : null);
        this.clearCharValue();
        this.contentType = 1;
        this.fDFAInfo = null;
    }

    private final void setupSkip() {
        this.skipDepth = this.vmElementDepth;
        this.setContentScanner(null);
        this.vcValue = null;
        this.setInElementContent(false);
        this.clearCharValue();
    }

    public final XMLString getElementString() {
        if (this.elementString == null) {
            if (this.elemBufferOffset == -1) {
                if (this.elementStringFirst.firstBuffer != null) {
                    this.elementString = this.elementStringFirst;
                    return this.elementString;
                }
                NullDataBufferFactory.setEmptyStringValues(this.elementStringFirst);
            } else {
                this.elemBuffer.setStringValues(this.elemBufferOffset, this.elemBuffer.getOffset(), this.elementStringFirst);
            }
            this.elementString = this.elementStringFirst;
        }
        return this.elementString;
    }

    private void appendCharsValue(XMLString xMLString) {
        if (this.elemBufferOffset == -1) {
            if (this.elementStringFirst.firstBuffer == null) {
                this.elementStringFirst.setValues(xMLString);
                return;
            }
            this.elemBufferOffset = this.elemBuffer.getOffset();
            this.elemBuffer.appendXMLString(this.elementStringFirst);
        }
        this.elemBuffer.appendXMLString(xMLString);
    }

    private void appendCharValue(int n2) {
        if (this.elemBufferOffset == -1) {
            this.elemBufferOffset = this.elemBuffer.getOffset();
            if (this.elementStringFirst.firstBuffer != null) {
                this.elemBuffer.appendXMLString(this.elementStringFirst);
            }
        }
        this.elemBuffer.appendChar(n2);
    }

    private void clearCharValue() {
        this.elementString = null;
        this.elementStringFirst.clear();
        this.elemBufferOffset = -1;
        this.elemBuffer.reset(true);
    }

    protected void push(ElementType elementType) {
        State state = this.currentState.free;
        if (state == null) {
            this.currentState.free = state = new State();
            state.parent = this.currentState;
        }
        state.element = this.eDecl;
        state.wildcard = this.eWildcard;
        state.type = elementType;
        this.currentState = state;
    }

    protected void pop() {
        this.currentState = this.currentState.parent;
    }

    public boolean produceStartDocumentEvent() {
        return this.produceStartDocumentEventVMDefault();
    }

    public final boolean produceStartDocumentEventVMDefault() {
        boolean bl = super.produceStartDocumentEvent();
        if (this.ir != null) {
            this.initializeGrammarState();
        }
        return bl;
    }

    public boolean produceEndDocumentEvent() {
        return this.produceEndDocumentEventVMDefault();
    }

    public final boolean produceEndDocumentEventVMDefault() {
        if (this.ir != null && this.validating()) {
            this.finishValidation();
        }
        return super.produceEndDocumentEvent();
    }

    public boolean produceLeafElementEvent() {
        return this.produceLeafElementEventVMDefault();
    }

    public final boolean produceLeafElementEventVMDefault() {
        boolean bl = super.produceLeafElementEvent();
        if (this.ir != null) {
            this.handleLeafElementEvent();
        }
        return bl;
    }

    public boolean produceStartElementEvent() {
        return this.produceStartElementEventVMDefault();
    }

    public final boolean produceStartElementEventVMDefault() {
        boolean bl = super.produceStartElementEvent();
        if (this.ir != null) {
            this.handleStartElementEvent();
        }
        return bl;
    }

    public boolean produceEndElementEvent() {
        return this.produceEndElementEventVMDefault();
    }

    public final boolean produceEndElementEventVMDefault() {
        if (this.ir == null) {
            return super.produceEndElementEvent();
        }
        boolean bl = super.produceEndElementEvent();
        this.handleEndElementEvent();
        return bl;
    }

    public boolean produceCharactersEvent() {
        return this.produceCharactersEventVMDefault();
    }

    public final boolean produceCharactersEventVMDefault() {
        boolean bl = super.produceCharactersEvent();
        if (this.ir != null) {
            this.handleCharactersEvent();
        }
        return bl;
    }

    public boolean produceCDATASectionEvent() {
        return this.produceCDATASectionEventVMDefault();
    }

    public final boolean produceCDATASectionEventVMDefault() {
        boolean bl = super.produceCDATASectionEvent();
        if (this.ir != null) {
            this.handleCharactersEvent();
        }
        return bl;
    }

    public boolean produceWhitespaceEvent() {
        return this.produceWhitespaceEventVMDefault();
    }

    public final boolean produceWhitespaceEventVMDefault() {
        boolean bl = super.produceWhitespaceEvent();
        if (this.ir != null) {
            this.handleWhitespaceEvent();
        }
        return bl;
    }

    public boolean produceCharacterEvent() {
        return this.produceCharacterEventVMDefault();
    }

    public final boolean produceCharacterEventVMDefault() {
        boolean bl = super.produceCharacterEvent();
        if (this.ir != null) {
            this.handleCharacterEvent();
        }
        return bl;
    }

    public boolean producePredefinedEntityEvent() {
        return this.producePredefinedEntityEventVMDefault();
    }

    public final boolean producePredefinedEntityEventVMDefault() {
        boolean bl = super.producePredefinedEntityEvent();
        if (this.ir != null) {
            this.handleCharacterEvent();
        }
        return bl;
    }

    protected void initializeGrammarState() {
        this.currentState = this.rootState;
        this.setupReadElement(2, (ElementType.DFAState)this.ir.root);
        if (this.validating()) {
            this.idcContext.initialize(this.ir.idcCount, this.ir);
        }
        this.setGrammarVersion(this.ir.getVersion());
    }

    private final void finishValidation() {
        String string2;
        if (this.validating() && (string2 = this.dvContext.checkIDRefID()) != null) {
            this.generateError(9, string2);
        }
    }

    private final void handleLeafElementEvent() {
        if (this.skipping()) {
            return;
        }
        ++this.vmElementDepth;
        this.eType = null;
        if (!this.validating()) {
            this.handleLeafElementNV();
        } else {
            this.handleLeafElementV();
        }
        --this.vmElementDepth;
        if (this.currentState.type != null && (this.currentState.type.useDFA || this.currentState.type.all == null)) {
            this.setupNextScanners();
        }
        this.leafState = this.eType != null ? 0 : 2;
        this.leafNilled = this.nilled;
        this.nilled = false;
    }

    private final void handleStartElementEvent() {
        ++this.vmElementDepth;
        if (this.skipping()) {
            return;
        }
        this.eType = null;
        if (!this.validating()) {
            this.handleStartElementNV();
        } else {
            this.handleStartElementV();
        }
        if (this.vcFixed) {
            this.fDFAInfo = null;
        }
        this.validationState = this.eType != null ? 0 : 2;
    }

    private final void handleEndElementEvent() {
        if (this.skipping()) {
            if (this.skipDepth == this.vmElementDepth) {
                this.setupNextScanners();
                this.validationState = 0;
            }
            --this.vmElementDepth;
            return;
        }
        if (!this.validating()) {
            this.handleEndElementNV();
        } else {
            this.handleEndElementV();
        }
        this.nilled = false;
        this.vcValue = null;
        --this.vmElementDepth;
        this.pop();
        this.setupNextScanners();
    }

    private final void handleCharactersEvent() {
        if (this.skipping()) {
            return;
        }
        if (this.content.length == 0) {
            return;
        }
        switch (this.contentType) {
            case 1: 
            case 3: {
                this.appendCharsValue(this.content);
                break;
            }
            case 2: {
                if (!this.validating() || this.content.isAllWhitespace()) break;
                this.generateError(8);
                break;
            }
            default: {
                if (!this.validating()) break;
                this.generateError(7);
            }
        }
    }

    private final void handleWhitespaceEvent() {
        assert (this.contentType == 2);
    }

    private final void handleCharacterEvent() {
        if (this.skipping()) {
            return;
        }
        switch (this.contentType) {
            case 1: 
            case 3: {
                this.appendCharValue(this.singleCh);
                break;
            }
            case 2: {
                if (!this.validating() || this.singleCh == 9 || this.singleCh == 10 || this.singleCh == 13 || this.singleCh == 32) break;
                this.generateError(8);
                break;
            }
            default: {
                if (!this.validating()) break;
                this.generateError(7);
            }
        }
    }

    private final void applyElementDefaultValue() {
        Element element2 = this.eDecl;
        ElementType elementType = this.eType;
        TypeValidator typeValidator = elementType.dv;
        if (this.validating() && elementType != element2.type && !element2.vcSafeTypes.getBit(elementType.index)) {
            this.generateError(17, element2.vcValue.actualValue.toString());
        }
        if (typeValidator != null) {
            if (this.validating() && typeValidator.idrefOrEntity && typeValidator.checkIdrefAndEntity(element2.vcValue.actualValue, this.dvContext) != 0) {
                this.generateError(17, element2.vcValue.actualValue.toString());
            }
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            validatedInfo.copyValues(element2.vcValue);
        }
    }

    protected void handleLeafElementNV() {
        ElementType elementType;
        this.clearCharValue();
        if (this.fDFAInfo == null) {
            this.eType = null;
            if (this.allowLaxAssessment) {
                this.processAttributes();
            }
            return;
        }
        this.eDecl = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
        if (n2 < 0) {
            this.eWildcard = this.matchWildcard(this.elementQName.nsURI);
            bl2 = this.isSkip(this.eWildcard);
            if (!bl2 && this.handleUnknownElement(this.elementQName)) {
                n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
            }
            if (n2 < 0 && this.eWildcard == null && (elementType = this.currentState.type) != null && elementType.useDFA) {
                n2 = elementType.all.findQNameInElements(this.elementQName);
                if (n2 >= 0) {
                    this.eDecl = elementType.all.elementInfo.elements[n2];
                } else {
                    this.eWildcard = this.matchWildcard(elementType.all.wc, this.elementQName.nsURI);
                }
                bl = true;
            }
            if (n2 < 0 && this.boBCMode) {
                n2 = this.fDFAInfo.findLocalNameInElements(this.elementQName.localName);
                if (n2 >= 0) {
                    bl = false;
                    this.eWildcard = null;
                } else if (bl) {
                    elementType = this.currentState.type;
                    n2 = elementType.all.findLocalNameInElements(this.elementQName.localName);
                    if (n2 >= 0) {
                        this.eDecl = elementType.all.elementInfo.elements[n2];
                        this.eWildcard = null;
                    }
                }
            }
        }
        if (n2 >= 0) {
            if (bl) {
                this.processAttributes();
                this.eDecl = null;
            } else {
                this.eDecl = this.fDFAInfo.elementInfo.elements[n2];
                this.eDeclIndex = n2;
                this.processAttributes();
                if (this.eDecl.vcValue != null) {
                    this.applyElementDefaultValue();
                }
                if ((elementType = this.currentState.type) != null && elementType.useDFA) {
                    this.dfaSubElement(true);
                }
            }
            return;
        }
        if (!bl2) {
            this.processAttributes();
        }
    }

    protected void handleLeafElementV() {
        this.clearCharValue();
        if (this.fDFAInfo == null) {
            this.eType = null;
            if (this.vcValue != null && this.vcFixed) {
                this.generateError(29);
            } else {
                this.generateError(7);
            }
            if (this.allowLaxAssessment) {
                this.processAttributes();
            }
            return;
        }
        this.eDecl = null;
        boolean bl = false;
        int n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
        if (n2 < 0) {
            this.eWildcard = this.matchWildcard(this.elementQName.nsURI);
            bl = this.isSkip(this.eWildcard);
            if (!bl && this.handleUnknownElement(this.elementQName)) {
                n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
            }
        }
        if (n2 >= 0) {
            this.eDecl = this.fDFAInfo.elementInfo.elements[n2];
            if (this.eDecl.isAbstract) {
                this.generateError(19);
            }
            this.eDeclIndex = n2;
            this.processAttributes();
            if (this.eDecl.vcValue != null) {
                this.applyElementDefaultValue();
            }
            this.handleIDCWildcards(true);
            if (!this.nilled && !this.eType.allowEmpty && this.eDecl.vcValue == null) {
                this.generateError(10);
            }
            this.finishLeafElement(this.eDecl, this.eType);
            return;
        }
        if (this.eWildcard == null) {
            this.generateError(12, this.elementQName.rawName);
            return;
        }
        if (!bl) {
            this.processAttributes();
        }
        this.finishLeafElementWithWc(this.eType);
    }

    protected void handleIDCWildcards(boolean bl) {
        if (this.wildIDCDepth >= 0) {
            this.idcContext.startIDCStateHistoryContext();
            this.idcContext.processActiveXPaths();
            if (bl) {
                this.idcContext.endIDCStateHistoryContext();
            }
        }
    }

    private void handleUnmatchedStartElementNV() {
        this.eType = null;
        if (this.allowLaxAssessment) {
            this.processAttributes();
            if (this.eType == null) {
                this.eType = this.lookupType(XS_NS, ANYTYPE);
            }
            this.push(this.eType);
            this.startElementNV(this.eType);
        } else {
            this.setupSkip();
        }
    }

    protected void handleStartElementNV() {
        ElementType elementType;
        if (this.fDFAInfo == null) {
            this.handleUnmatchedStartElementNV();
            return;
        }
        boolean bl = false;
        this.eDecl = null;
        boolean bl2 = false;
        int n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
        if (n2 < 0) {
            this.eWildcard = this.matchWildcard(this.elementQName.nsURI);
            bl2 = this.isSkip(this.eWildcard);
            if (!bl2 && this.handleUnknownElement(this.elementQName)) {
                n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
            }
            if (n2 < 0 && this.eWildcard == null && (elementType = this.currentState.type) != null && elementType.useDFA) {
                n2 = elementType.all.findQNameInElements(this.elementQName);
                if (n2 >= 0) {
                    this.eDecl = elementType.all.elementInfo.elements[n2];
                } else {
                    this.eWildcard = this.matchWildcard(elementType.all.wc, this.elementQName.nsURI);
                }
                bl = true;
            }
            if (n2 < 0 && this.boBCMode) {
                n2 = this.fDFAInfo.findLocalNameInElements(this.elementQName.localName);
                if (n2 >= 0) {
                    bl = false;
                    this.eWildcard = null;
                } else if (bl) {
                    elementType = this.currentState.type;
                    n2 = elementType.all.findLocalNameInElements(this.elementQName.localName);
                    if (n2 >= 0) {
                        this.eDecl = elementType.all.elementInfo.elements[n2];
                        this.eWildcard = null;
                    }
                }
            }
        }
        if (n2 >= 0) {
            if (bl) {
                this.processAttributes();
                this.eDecl = null;
            } else {
                this.eDecl = this.fDFAInfo.elementInfo.elements[n2];
                this.eDeclIndex = n2;
                this.processAttributes();
                elementType = this.currentState.type;
                if (elementType != null && elementType.dfa != null && elementType.dfa.length != 0 && elementType.useDFA) {
                    this.dfaSubElement(true);
                }
            }
            this.push(this.eType);
            if (this.nilled) {
                this.setupReadElement(0, null);
            } else {
                this.startElementNV(this.eType);
            }
            return;
        }
        if (this.eWildcard == null) {
            this.handleUnmatchedStartElementNV();
            return;
        }
        if (bl2) {
            this.eWildcard = null;
            this.setupSkip();
            return;
        }
        this.processAttributes();
        if (this.eType == null) {
            if (this.allowLaxAssessment) {
                this.eType = this.lookupType(XS_NS, ANYTYPE);
            } else {
                this.setupSkip();
                return;
            }
        }
        elementType = this.currentState.type;
        if (!bl && elementType != null && elementType.useDFA && elementType.dfa != null && elementType.dfa.length != 0) {
            this.dfaSubElement(false);
        }
        this.push(this.eType);
        this.startElementNV(this.eType);
    }

    private void handleUnmatchedStartElementV() {
        this.eType = null;
        if (this.allowLaxAssessment) {
            this.processAttributes();
            if (this.eType == null) {
                this.eType = this.lookupType(XS_NS, ANYTYPE);
            }
            this.handleIDCWildcards(false);
            this.push(this.eType);
            if (this.nilled) {
                this.setupReadElement(0, null);
            } else {
                this.startElementV(this.eType);
            }
        } else {
            this.setupSkip();
        }
    }

    protected void handleStartElementV() {
        if (this.fDFAInfo == null) {
            if (this.vcValue != null && this.vcFixed) {
                this.generateError(29);
            } else {
                this.generateError(7);
            }
            this.handleUnmatchedStartElementV();
            return;
        }
        this.eDecl = null;
        boolean bl = false;
        int n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
        if (n2 < 0) {
            this.eWildcard = this.matchWildcard(this.elementQName.nsURI);
            bl = this.isSkip(this.eWildcard);
            if (!bl && this.handleUnknownElement(this.elementQName)) {
                n2 = this.fDFAInfo.findQNameInElements(this.elementQName);
            }
        }
        if (n2 >= 0) {
            this.eDecl = this.fDFAInfo.elementInfo.elements[n2];
            if (this.eDecl.isAbstract) {
                this.generateError(19);
            }
            this.eDeclIndex = n2;
            this.processAttributes();
            this.vcValue = this.eDecl.vcValue;
            this.vcFixed = this.eDecl.fixed;
            this.handleIDCWildcards(false);
            this.finishStartElement(this.eDecl, this.eType);
            return;
        }
        if (this.eWildcard == null) {
            this.generateError(12, this.elementQName.rawName);
            this.handleUnmatchedStartElementV();
            return;
        }
        if (!bl) {
            this.processAttributes();
        }
        this.finishStartElementWithWc(this.eType);
    }

    protected final boolean isSkip(Wildcard wildcard) {
        return wildcard != null && wildcard.processContents == 2;
    }

    protected final boolean isLax(Wildcard wildcard) {
        return wildcard != null && wildcard.processContents == 3;
    }

    protected final boolean handleUnknownElement(QName qName) {
        return this.handleUnknownQName(qName, true);
    }

    protected final boolean handleUnknownAttribute(QName qName) {
        return this.handleUnknownQName(qName, false);
    }

    protected final boolean handleUnknownType(String string2, String string3) {
        if (this.dynamicSchemaResolver == null) {
            return false;
        }
        if (this.ir.isComponentUnresolved(string2, string3, (byte)4)) {
            return false;
        }
        boolean bl = this.dynamicSchemaResolver.handleUnknownType(this, string2, string3);
        this.checkIfComponentUnresolved(string2, string3, (byte)4);
        return bl;
    }

    private final boolean handleUnknownQName(QName qName, boolean bl) {
        byte by2;
        if (this.dynamicSchemaResolver == null) {
            return false;
        }
        byte by3 = by2 = bl ? (byte)1 : 2;
        if (this.ir.isComponentUnresolved(qName.nsURI, qName.localName, by2)) {
            return false;
        }
        if (this.dynamicSchemaResolver.handleUnknownQName(this, qName.nsURI, qName.localName, bl)) {
            boolean bl2 = false;
            if (bl2 && this.ir.idcCount != 0) {
                this.idcContext.initialize(this.ir.idcCount, this.ir);
            }
            this.checkIfComponentUnresolved(qName.nsURI, qName.localName, by2);
            return true;
        }
        this.checkIfComponentUnresolved(qName.nsURI, qName.localName, by2);
        return false;
    }

    private final void checkIfComponentUnresolved(String string2, String string3, byte by2) {
        String string4 = string2 != "" ? string2 : null;
        switch (by2) {
            case 1: {
                if (this.ir.xsModel.getElementDeclaration(string3, string4) == null) break;
                return;
            }
            case 2: {
                if (this.ir.xsModel.getAttributeDeclaration(string3, string4) == null) break;
                return;
            }
            case 4: {
                if (this.ir.xsModel.getTypeDefinition(string3, string4) == null) break;
                return;
            }
        }
        this.ir.addUnresolvedComponent(string2, string3, by2);
    }

    private void handleEndElementNV() {
        switch (this.contentType) {
            case 1: {
                this.handleSimpleEndElementNV(this.currentState.type.dv, this.getElementString());
                break;
            }
            default: {
                if (this.vcValue == null) break;
                XMLString xMLString = this.getElementString();
                if (xMLString.length != 0) break;
                this.applyElementDefaultValue();
            }
        }
    }

    private void handleEndElementV() {
        ElementType elementType = this.currentState.type;
        switch (this.contentType) {
            case 1: {
                if (elementType.all != null) {
                    this.endAllElement();
                }
                this.handleSimpleEndElementV(elementType.dv, this.getElementString());
                break;
            }
            default: {
                if (this.fDFAInfo != null && !this.fDFAInfo.isFinal) {
                    this.generateError(6);
                }
                if (elementType.all != null) {
                    this.endAllElement();
                }
                if (this.vcValue == null) break;
                XMLString xMLString = this.getElementString();
                if (xMLString.length == 0) {
                    this.applyElementDefaultValue();
                    break;
                }
                if (!this.vcFixed || xMLString.equals(this.vcValue.actualValue)) break;
                this.generateError(30, xMLString.toString(), String.valueOf(this.vcValue.actualValue));
            }
        }
        this.handleIDCOnEnd();
        if (this.wildIDCDepth >= 0) {
            if (this.vmElementDepth > this.wildIDCDepth) {
                this.idcContext.endIDCStateHistoryContext();
            } else {
                this.wildIDCDepth = -1;
            }
        }
    }

    private void handleIDCOnEnd() {
        ArrayList<StartIDC> arrayList;
        Element element2 = this.currentState.element;
        Wildcard wildcard = this.currentState.wildcard;
        if (element2 != null) {
            ArrayList<StartIDC> arrayList2;
            ArrayList<StartIDC> arrayList3 = arrayList2 = this.nilled ? element2.idcActionsNil : element2.idcActions;
            if (arrayList2 != null) {
                this.idcContext.endIDCStateHistoryContext(arrayList2.size());
            }
        } else if (wildcard != null && (arrayList = wildcard.idcActions) != null) {
            this.idcContext.endIDCStateHistoryContext(arrayList.size());
        }
    }

    private void finishLeafElement(Element element2, ElementType elementType) {
        ElementType elementType2;
        ArrayList<StartIDC> arrayList;
        ArrayList<StartIDC> arrayList2 = arrayList = this.nilled ? element2.idcActionsNil : element2.idcActions;
        if (arrayList != null) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                arrayList.get(i).execute(this);
            }
            this.idcContext.endIDCStateHistoryContext(n2);
        }
        if ((elementType2 = this.currentState.type) != null) {
            if (elementType2.dfa != null && elementType2.dfa.length != 0) {
                this.dfaSubElement(true);
            } else {
                this.allSubElement();
            }
        }
    }

    private void finishStartElement(Element element2, ElementType elementType) {
        ElementType elementType2;
        ArrayList<StartIDC> arrayList;
        ArrayList<StartIDC> arrayList2 = arrayList = this.nilled ? element2.idcActionsNil : element2.idcActions;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get(i).execute(this);
            }
        }
        if ((elementType2 = this.currentState.type) != null) {
            if (elementType2.dfa != null && elementType2.dfa.length != 0) {
                this.dfaSubElement(true);
            } else {
                this.allSubElement();
            }
        }
        this.push(elementType);
        if (this.nilled) {
            this.setupReadElement(0, null);
        } else {
            this.startElementV(elementType);
        }
    }

    private void finishLeafElementWithWc(ElementType elementType) {
        ElementType elementType2;
        ArrayList<StartIDC> arrayList;
        boolean bl;
        boolean bl2 = bl = this.eWildcard.processContents == 1 || this.eWildcard.processContents == 3 && this.eType != null;
        if (this.eWildcard.processContents == 1 && this.eType == null) {
            this.generateError(13);
            bl = false;
        }
        if (this.eWildcard.processContents != 2 && this.eType != null && !this.eType.allowEmpty) {
            this.generateError(10);
        }
        if (bl) {
            this.handleIDCWildcards(true);
        }
        if ((arrayList = this.eWildcard.idcActions) != null) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                arrayList.get(i).execute(this);
            }
            this.idcContext.endIDCStateHistoryContext(n2);
        }
        if ((elementType2 = this.currentState.type) != null) {
            if (elementType2.dfa != null && elementType2.dfa.length != 0) {
                this.dfaSubElement(false);
            } else {
                this.allSubElement();
            }
        }
    }

    private void finishStartElementWithWc(ElementType elementType) {
        ElementType elementType2;
        ArrayList<StartIDC> arrayList;
        boolean bl;
        boolean bl2 = bl = this.eWildcard.processContents == 1 || this.eWildcard.processContents == 3 && this.eType != null;
        if (this.eWildcard.processContents == 1 && this.eType == null) {
            this.generateError(13);
            bl = false;
        }
        if (bl) {
            this.handleIDCWildcards(false);
        }
        if ((arrayList = this.eWildcard.idcActions) != null) {
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                arrayList.get(i).execute(this);
            }
        }
        if ((elementType2 = this.currentState.type) != null) {
            if (elementType2.dfa != null && elementType2.dfa.length != 0) {
                this.dfaSubElement(false);
            } else {
                this.allSubElement();
            }
        }
        if (bl) {
            this.push(elementType);
            this.startElementV(elementType);
        } else {
            this.setupSkip();
        }
    }

    private void handleSimpleEndElementNV(TypeValidator typeValidator, XMLString xMLString) {
        if (xMLString.length == 0 && this.vcValue != null) {
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            validatedInfo.copyValues(this.vcValue);
        } else if (!this.isValidated && this.produceActualValues) {
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            ValidatedInfo validatedInfo2 = this.vcValue != null && this.vcFixed ? this.vcValue : null;
            typeValidator.validate(xMLString, validatedInfo2, this.dvContext, validatedInfo);
        }
        this.isValidated = false;
    }

    private void handleSimpleEndElementV(TypeValidator typeValidator, XMLString xMLString) {
        if (xMLString.length == 0 && this.vcValue != null) {
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            if (this.eType != this.eDecl.type && !this.eDecl.vcSafeTypes.getBit(this.eType.index)) {
                this.generateError(17, this.vcValue.actualValue.toString());
            } else if (typeValidator.idrefOrEntity && typeValidator.checkIdrefAndEntity(this.vcValue.actualValue, this.dvContext) != 0) {
                this.generateError(17, this.vcValue.actualValue.toString());
            }
            validatedInfo.copyValues(this.vcValue);
        } else if (!this.isValidated && this.produceActualValues) {
            ValidatedInfo validatedInfo = this.currentElementActualValue();
            ValidatedInfo validatedInfo2 = this.vcValue != null && this.vcFixed ? this.vcValue : null;
            typeValidator.validate(xMLString, validatedInfo2, this.dvContext, validatedInfo);
            if (validatedInfo.errorCode != 0) {
                this.generateError(16, xMLString);
            }
        }
        this.isValidated = false;
    }

    private void setupNextScanners() {
        ElementType elementType = this.currentState.type;
        if (elementType != null) {
            ElementType.DFAState[] dFAStateArray;
            if ((this.validating() || elementType.useDFA) && (dFAStateArray = elementType.dfa) != null && dFAStateArray.length != 0) {
                int n2 = this.currentState.curState;
                ElementType.DFAState dFAState = dFAStateArray[n2];
                this.setupReadElement(elementType.contentType, dFAState);
                return;
            }
            this.startElementNV(elementType);
        }
    }

    private void endAllElement() {
        BitSet bitSet = this.currentState.basicAll;
        ElementType.AllContent allContent = this.currentState.type.all;
        if (!(this.currentState.type.allowEmpty && bitSet.isZero() || bitSet.containsSet(allContent.required))) {
            int n2 = bitSet.getLength();
            for (int i = 0; i < n2; ++i) {
                String string2;
                if (!allContent.required.getBit(i) || bitSet.getBit(i) || (string2 = allContent.findIndex(i)) == null) continue;
                this.generateError(15, string2);
            }
        }
    }

    private void dfaSubElement(boolean bl) {
        int n2;
        ElementType.DFAState dFAState = (ElementType.DFAState)this.fDFAInfo;
        this.currentState.curState = n2 = bl ? dFAState.getEState(this.eDeclIndex) : dFAState.getWState(this.eWCIndex);
    }

    private void allSubElement() {
        ElementType elementType = this.currentState.type;
        int n2 = elementType.all.getIndex(this.eDeclIndex);
        if (this.currentState.basicAll.getAndSetBit(n2)) {
            this.generateError(14, elementType.all.elementInfo.elements[this.eDeclIndex].localName);
            return;
        }
    }

    private void startElementNV(ElementType elementType) {
        if (elementType.dv != null) {
            this.setupReadSimple(elementType.dv);
        } else {
            ElementType.DFAState[] dFAStateArray = elementType.dfa;
            if (elementType.useDFA && dFAStateArray != null && dFAStateArray.length != 0) {
                this.currentState.curState = 0;
                ElementType.DFAState dFAState = dFAStateArray[0];
                this.setupReadElement(elementType.contentType, dFAState);
            } else {
                this.setupReadElement(elementType.contentType, elementType.all);
            }
        }
    }

    private void startElementV(ElementType elementType) {
        ElementType.DFAState[] dFAStateArray = elementType.dfa;
        if (dFAStateArray != null && dFAStateArray.length != 0) {
            this.currentState.curState = 0;
            ElementType.DFAState dFAState = dFAStateArray[0];
            this.setupReadElement(elementType.contentType, dFAState);
        } else if (elementType.all != null) {
            ElementType.AllContent allContent = elementType.all;
            int n2 = allContent.numElements();
            if (this.currentState.basicAll == null) {
                this.currentState.basicAll = new BitSet(n2);
            } else {
                this.currentState.basicAll.setLength(n2);
            }
            this.setupReadElement(elementType.contentType, allContent);
        } else if (elementType.dv != null) {
            this.setupReadSimple(elementType.dv);
        } else {
            this.setupReadElement(elementType.contentType, null);
        }
    }

    private final Object validateAttribute(Attribute attribute2, XMLString xMLString, ValidatedInfo validatedInfo) {
        TypeValidator typeValidator = attribute2.type;
        ValidatedInfo validatedInfo2 = attribute2.fixed ? attribute2.vcValue : null;
        typeValidator.validate(xMLString, validatedInfo2, this.dvContext, validatedInfo);
        return this.validating() && validatedInfo.errorCode != 0 ? null : validatedInfo.actualValue;
    }

    private final void processAttributes() {
        int n2;
        if (this.resetObjectPools) {
            this.dvContext.resetObjectPools();
        }
        this.nilled = false;
        ElementType elementType = null;
        Element element2 = this.eDecl;
        boolean bl = this.validating();
        int n3 = this.attributeCount();
        if (n3 > 0 && (bl || this.dynamicSchemaResolver != null || element2 == null || element2.xsiTypes != null)) {
            elementType = this.resolveType();
        }
        if (elementType == null) {
            if (element2 != null) {
                elementType = element2.type;
            } else if (this.boBCMode && this.vmElementDepth == 1) {
                int n4 = -1;
                for (n2 = 0; n2 < this.attrCount; ++n2) {
                    QName qName = this.fAttributeNames[n2];
                    if (qName.nsURI != XSI_NS || qName.localName != TYPE) continue;
                    n4 = n2;
                    break;
                }
                if (n4 == -1 && (elementType = this.lookupType(this.elementQName.nsURI, this.elementQName.localName)) == null && this.handleUnknownType(this.elementQName.nsURI, this.elementQName.localName)) {
                    elementType = this.lookupType(this.elementQName.nsURI, this.elementQName.localName);
                }
            }
        }
        this.eType = elementType;
        if (elementType != null) {
            if (bl && elementType.isAbstract) {
                this.generateError(18);
            }
            this.attsSpecified.setLength(elementType.attributeInfo.ownedChoices.length);
            if (this.attributeCount() > 0) {
                this.validateAttributes(elementType);
            }
            if (bl) {
                if (elementType.required != null && !this.attsSpecified.containsSet(elementType.required)) {
                    String[] stringArray = elementType.missingAttributes(this.attsSpecified);
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        this.generateError(20, stringArray[n2]);
                    }
                }
                if (elementType.wildIDs != null) {
                    this.checkWildIDs(elementType);
                }
            }
            if (elementType.hasVC != null) {
                this.applyDefaultAttributes(elementType);
            }
        }
    }

    private boolean checkWildIDs(ElementType elementType) {
        if (this.attsSpecified.intersectsWith(elementType.wildIDs)) {
            if (elementType.idIndex != -1) {
                String string2 = elementType.getWildIDLocalName(this.attsSpecified);
                this.generateError(22, this.elementQName.localName, string2, elementType.attributeInfo.ownedChoices[elementType.idIndex].localName);
                return false;
            }
            int n2 = -1;
            for (int i = 0; i < elementType.numWildIDPositions(); ++i) {
                int n3 = elementType.getWildIDPosition(i);
                if (!this.attsSpecified.getBit(n3)) continue;
                if (n2 == -1) {
                    n2 = n3;
                    continue;
                }
                this.generateError(21, this.elementQName.localName, elementType.attributeInfo.ownedChoices[n3].localName, elementType.attributeInfo.ownedChoices[n2].localName);
                return false;
            }
        }
        return true;
    }

    private void applyDefaultAttributes(ElementType elementType) {
        if (elementType.hasVC != null && !this.attsSpecified.containsSet(elementType.hasVC)) {
            Attribute[] attributeArray = elementType.attributeInfo.ownedChoices;
            for (int i = 0; i < elementType.numVcPositions(); ++i) {
                int n2 = elementType.getVcPosition(i);
                if (this.attsSpecified.getBit(n2)) continue;
                Attribute attribute2 = attributeArray[n2];
                if (this.validating() && attribute2.type.idrefOrEntity && attribute2.type.checkIdrefAndEntity(attribute2.vcValue.actualValue, this.dvContext) != 0) {
                    this.generateError(17, attribute2.vcValue.actualValue.toString());
                    continue;
                }
                this.attsSpecified.setBit(n2);
                this.addDefaultSchemaAttribute(attribute2, n2);
            }
        }
    }

    private void addDefaultSchemaAttribute(Attribute attribute2, int n2) {
        this.fHasDefaultAttributes = true;
        QName qName = this.currentAttributeName();
        qName.clear();
        qName.nsURI = attribute2.nsURI;
        qName.localName = attribute2.localName;
        this.setupCurrentAttribute(qName, false);
        this.currentAttributeValue().clear();
        this.currentAttributeActualValue().copyValues(attribute2.vcValue);
        this.setAttrDecl(attribute2, n2, this.attrCount);
        ++this.attrCount;
    }

    private void validateAttributes(ElementType elementType) {
        int n2 = this.attributeCount();
        for (int i = 0; i < n2; ++i) {
            if (i == this.xsitypeIndex) {
                this.setAttrDecl(elementType.attributeInfo.ownedChoices[2], 2, i);
                this.xsitypeIndex = -1;
                continue;
            }
            boolean bl = false;
            QName qName = this.attributeName(i);
            int n3 = elementType.findQNameInOwnedChoices(qName);
            if (n3 < 0) {
                boolean bl2 = bl = elementType.ownedWC != null && elementType.ownedWC.allows(qName.nsURI);
                if (bl && !this.isSkip(elementType.ownedWC) && this.handleUnknownAttribute(qName)) {
                    n3 = elementType.findQNameInOwnedChoices(qName);
                }
                if (n3 < 0 && this.boBCMode) {
                    n3 = elementType.findLocalNameInOwnedChoices(qName.localName);
                }
            }
            if (n3 >= 0) {
                Attribute attribute2 = elementType.attributeInfo.ownedChoices[n3];
                this.handleAttribute(attribute2, i, n3);
                continue;
            }
            if (!this.validating()) {
                this.setAttrDecl(null, Integer.MIN_VALUE, i);
                continue;
            }
            if (bl && elementType.ownedWC.processContents != 1) continue;
            this.generateError(26, qName.localName);
            this.setAttrDecl(null, -1, i);
        }
    }

    private void handleAttribute(Attribute attribute2, int n2, int n3) {
        this.setAttrDecl(attribute2, n3, n2);
        if (3 == n3) {
            ValidatedInfo validatedInfo;
            XMLString xMLString = this.attributeValue(n2);
            Object object2 = this.validateAttribute(attribute2, xMLString, validatedInfo = this.actualAttributeValue(n2));
            if (object2 != null) {
                this.nilled = (Boolean)object2;
            }
            if (this.validating()) {
                if (validatedInfo.errorCode != 0) {
                    this.generateError(25, xMLString);
                }
                if (this.eDecl == null || !this.eDecl.nillable) {
                    this.generateError(23);
                }
                if (this.nilled && this.eDecl != null && this.eDecl.fixed) {
                    this.generateError(24);
                }
            }
        } else {
            this.attsSpecified.setBit(n3);
            if (this.produceActualValues) {
                XMLString xMLString = this.attributeValue(n2);
                ValidatedInfo validatedInfo = this.actualAttributeValue(n2);
                this.validateAttribute(attribute2, xMLString, validatedInfo);
                if (this.validating() && validatedInfo.errorCode != 0) {
                    this.generateError(25, xMLString);
                }
            }
        }
    }

    private ElementType resolveType() {
        String string2;
        int n2;
        int n3;
        Object object2;
        int n4 = -1;
        for (int i = 0; i < this.attrCount; ++i) {
            object2 = this.fAttributeNames[i];
            if (((QName)object2).nsURI != XSI_NS || ((QName)object2).localName != TYPE) continue;
            n4 = i;
            break;
        }
        this.xsitypeIndex = n4;
        if (n4 == -1) {
            return null;
        }
        XMLString xMLString = this.attributeValue(n4);
        object2 = this.actualAttributeValue(n4);
        if (this.qnameDV == null) {
            this.qnameDV = this.lookupType((String)XS_NS, (String)QNAME).dv;
        }
        this.qnameDV.validate(xMLString, null, this.dvContext, (ValidatedInfo)object2);
        if (((ValidatedInfo)object2).errorCode != 0) {
            if (this.validating()) {
                this.generateError(25, xMLString);
            }
            return null;
        }
        Object object3 = ((ValidatedInfo)object2).actualValue;
        XQName xQName = (XQName)object3;
        ElementType elementType = this.lookupType(xQName.nsURI, xQName.localName);
        if (elementType == null && this.handleUnknownType(xQName.nsURI, xQName.localName)) {
            elementType = this.lookupType(xQName.nsURI, xQName.localName);
        }
        if (elementType != null) {
            if (this.eDecl == null) {
                return elementType;
            }
            if (this.eDecl.xsiTypes != null ? this.xsiTypeOkay(this.eDecl.xsiTypes, elementType.index) : elementType == this.eDecl.type) {
                return elementType;
            }
            if (this.boBCMode) {
                return elementType;
            }
            if (this.validating()) {
                this.generateError(27);
            }
            return null;
        }
        if (this.boBCMode && this.vmElementDepth == 1 && (n3 = xQName.localName.indexOf("_._type")) > 0 && (n2 = NamedDeclaration.findQNameInChoices(this.ir.root.elementInfo.elements, this.ir.root.elementInfo.elementTable, xQName.nsURI, string2 = xQName.localName.substring(0, n3).intern())) >= 0) {
            return this.ir.root.elementInfo.elements[n2].type;
        }
        if (this.validating()) {
            this.generateError(28);
        }
        return null;
    }

    private final boolean xsiTypeOkay(BitSet bitSet, int n2) {
        if (n2 > bitSet.getLength()) {
            this.dynamicSchemaResolver.waitUntilUpdateComplete();
        }
        return bitSet.getBit(n2);
    }

    private ElementType lookupType(String string2, String string3) {
        int n2 = this.ir.findQNameInGlobalTypes(string2, string3);
        if (n2 != -1) {
            return this.ir.globalTypesInfo.globalTypes[n2];
        }
        return null;
    }

    public final void setGrammarVersion(int n2) {
        this.irVersion = n2;
        MergerContext.threadDebug("setVersion", n2);
    }

    public final int getGrammarVersion() {
        return this.irVersion;
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public Object saveFragment() {
        VMContextFragment vMContextFragment = new VMContextFragment();
        vMContextFragment.sDocumentScannerFragment = (DocumentScanner.DocumentScannerFragment)super.saveFragment();
        vMContextFragment.sIr = this.ir;
        vMContextFragment.sContentScanner = this.fContentScanner;
        vMContextFragment.sEntityDeclPool = this.fEntityDeclPool;
        vMContextFragment.sIsValidated = this.isValidated;
        vMContextFragment.sVmElementDepth = this.vmElementDepth;
        vMContextFragment.sWildIDCDepth = this.wildIDCDepth;
        vMContextFragment.sCurrentState = this.copyState(this.currentState);
        vMContextFragment.sEType = this.eType;
        vMContextFragment.sContentType = this.contentType;
        vMContextFragment.sDFAInfo = this.fDFAInfo;
        return vMContextFragment;
    }

    public State copyState(State state) {
        State state2 = new State();
        state2.element = state.element;
        state2.wildcard = state.wildcard;
        state2.type = state.type;
        state2.parent = state.parent;
        return state2;
    }

    public boolean loadFragment(Object object2) {
        VMContextFragment vMContextFragment = (VMContextFragment)object2;
        super.loadFragment(vMContextFragment.sDocumentScannerFragment);
        this.ir = vMContextFragment.sIr;
        this.fContentScanner = vMContextFragment.sContentScanner;
        this.fEntityDeclPool = vMContextFragment.sEntityDeclPool;
        this.isValidated = vMContextFragment.sIsValidated;
        this.vmElementDepth = vMContextFragment.sVmElementDepth;
        this.wildIDCDepth = vMContextFragment.sWildIDCDepth;
        this.currentState = vMContextFragment.sCurrentState;
        this.eType = vMContextFragment.sEType;
        this.contentType = vMContextFragment.sContentType;
        this.fDFAInfo = vMContextFragment.sDFAInfo;
        return true;
    }

    public boolean isBOBCMode() {
        return this.boBCMode;
    }

    static {
        MessageProviderRegistry.register(XS_NS, VMMessagesBundle.class.getName());
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class VMContextFragment {
        public Grammar sIr;
        public ContentScanner sContentScanner;
        public EntityDeclPool sEntityDeclPool;
        public boolean sIsValidated;
        public int sVmElementDepth;
        public int sWildIDCDepth;
        public State sCurrentState;
        public int sContentType;
        public ElementType sEType;
        public ElementType.DFAInfo sDFAInfo;
        public DocumentScanner.DocumentScannerFragment sDocumentScannerFragment;

        VMContextFragment() {
        }

        public void reset() {
            this.sDocumentScannerFragment.reset();
        }
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    public static final class State {
        public Element element;
        public Wildcard wildcard;
        public ElementType type;
        public State parent;
        public State free;
        public int curState;
        public BitSet basicAll;
        public int[] allAndDFA;
    }
}

