/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.ValidationContext;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLStringBuffer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2009. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public final class XSNormalizer {
    private final XMLStringBuffer fBuffer = new XMLStringBuffer();

    public XMLString replace(XMLString xMLString, ValidationContext validationContext) {
        if (xMLString.length == 0) {
            return xMLString;
        }
        if (xMLString.bytes != null) {
            return this.replaceUnbuffered(xMLString, validationContext);
        }
        return this.replaceBuffered(xMLString, validationContext);
    }

    public int replace(ParsedEntity parsedEntity, ValidationContext validationContext, ValidatedInfo validatedInfo, boolean[] blArray, int n2) {
        DataBuffer dataBuffer = parsedEntity.buffer;
        int n3 = parsedEntity.offset;
        int n4 = parsedEntity.endOffset;
        byte[] byArray = parsedEntity.bytes;
        byte by2 = 0;
        int n5 = n3;
        while (true) {
            if (n5 < n4) {
                by2 = byArray[n5];
                if (by2 == n2) {
                    return n5;
                }
                if (by2 == 10 || by2 == 9 || by2 == 13) {
                    blArray[0] = false;
                    validatedInfo.actualValue = validationContext.getXMLString();
                    return this.replace2(parsedEntity, (XMLString)validatedInfo.actualValue, dataBuffer, n3, n5, n2);
                }
                ++n5;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            byArray = parsedEntity.bytes;
            n5 = parsedEntity.offset;
            n4 = parsedEntity.endOffset;
        }
    }

    public XMLString collapse(XMLString xMLString, ValidationContext validationContext) {
        if (xMLString.length == 0) {
            return xMLString;
        }
        if (xMLString.bytes != null) {
            return this.collapseUnbuffered(xMLString, validationContext);
        }
        return this.collapseBuffered(xMLString, validationContext);
    }

    public int collapse(ParsedEntity parsedEntity, ValidationContext validationContext, ValidatedInfo validatedInfo, boolean[] blArray, int n2) {
        DataBuffer dataBuffer = parsedEntity.buffer;
        int n3 = parsedEntity.offset;
        int n4 = parsedEntity.endOffset;
        byte[] byArray = parsedEntity.bytes;
        byte by2 = 0;
        int n5 = n3;
        while (true) {
            if (n5 < n4) {
                by2 = byArray[n5];
                if (by2 == n2) {
                    return n5;
                }
                if (by2 == 10 || by2 == 9 || by2 == 13 || by2 == 32) {
                    blArray[0] = false;
                    validatedInfo.actualValue = validationContext.getXMLString();
                    return this.collapse2(parsedEntity, (XMLString)validatedInfo.actualValue, dataBuffer, n3, n5, n2);
                }
                ++n5;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            byArray = parsedEntity.bytes;
            n5 = parsedEntity.offset;
            n4 = parsedEntity.endOffset;
        }
    }

    public XMLString trim(XMLString xMLString, ValidationContext validationContext) {
        if (xMLString.length == 0) {
            return xMLString;
        }
        if (xMLString.bytes != null) {
            return this.trimUnbuffered(xMLString, validationContext);
        }
        return this.trimBuffered(xMLString, validationContext);
    }

    private XMLString replaceUnbuffered(XMLString xMLString, ValidationContext validationContext) {
        int n2 = xMLString.endOffset;
        byte by2 = 0;
        for (int i = xMLString.startOffset; i < n2; ++i) {
            by2 = xMLString.bytes[i];
            if (by2 != 10 && by2 != 9 && by2 != 13) continue;
            return this.replaceUnbuffered2(xMLString, validationContext, i, n2);
        }
        return xMLString;
    }

    private XMLString replaceUnbuffered2(XMLString xMLString, ValidationContext validationContext, int n2, int n3) {
        int n4 = xMLString.startOffset;
        byte by2 = 0;
        this.fBuffer.reset(true);
        int n5 = this.fBuffer.getOffset();
        if (n4 != n2) {
            if (n2 - n4 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n4]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n4, n2);
            }
        }
        this.fBuffer.appendChar(32);
        n4 = ++n2;
        while (n2 < n3) {
            by2 = xMLString.bytes[n2];
            if (by2 == 10 || by2 == 9 || by2 == 13) {
                if (n4 != n2) {
                    if (n2 - n4 == 1) {
                        this.fBuffer.appendChar(xMLString.bytes[n4]);
                    } else {
                        this.fBuffer.appendBytes(xMLString.bytes, n4, n2);
                    }
                }
                this.fBuffer.appendChar(32);
                n4 = n2 + 1;
            }
            ++n2;
        }
        if (n4 != n2) {
            if (n2 - n4 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n4]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n4, n2);
            }
        }
        XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        this.fBuffer.setStringValues(n5, this.fBuffer.getOffset(), xMLString2);
        return xMLString2;
    }

    private XMLString replaceBuffered(XMLString xMLString, ValidationContext validationContext) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = 0;
        while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                if (by2 == 10 || by2 == 9 || by2 == 13) {
                    return this.replaceBuffered2(xMLString, validationContext, dataBuffer, dataBuffer2, n2, n3);
                }
                ++n2;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return xMLString;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private XMLString replaceBuffered2(XMLString xMLString, ValidationContext validationContext, DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3) {
        DataBuffer dataBuffer3 = xMLString.firstBuffer;
        int n4 = xMLString.startOffset;
        this.fBuffer.reset(true);
        int n5 = this.fBuffer.getOffset();
        if (dataBuffer3 != dataBuffer) {
            this.fBuffer.appendBytes(dataBuffer3.bytes, n4, dataBuffer3.endOffset);
            DataBuffer dataBuffer4 = dataBuffer3.next;
            while (dataBuffer4 != dataBuffer) {
                this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                dataBuffer4 = dataBuffer4.next;
            }
            this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n2);
        } else if (n4 != n2) {
            if (n2 - n4 == 1) {
                this.fBuffer.appendChar(dataBuffer.bytes[n4]);
            } else {
                this.fBuffer.appendBytes(dataBuffer.bytes, n4, n2);
            }
        }
        this.fBuffer.appendChar(32);
        n4 = ++n2;
        dataBuffer3 = dataBuffer;
        byte by2 = 0;
        while (true) {
            Object object2;
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                if (by2 == 10 || by2 == 9 || by2 == 13) {
                    if (dataBuffer3 != dataBuffer) {
                        this.fBuffer.appendBytes(dataBuffer3.bytes, n4, dataBuffer3.endOffset);
                        object2 = dataBuffer3.next;
                        while (object2 != dataBuffer) {
                            this.fBuffer.appendBytes(((DataBuffer)object2).bytes, ((DataBuffer)object2).startOffset, ((DataBuffer)object2).endOffset);
                            object2 = ((DataBuffer)object2).next;
                        }
                        this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n2);
                    } else if (n4 != n2) {
                        if (n2 - n4 == 1) {
                            this.fBuffer.appendChar(dataBuffer.bytes[n4]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer.bytes, n4, n2);
                        }
                    }
                    this.fBuffer.appendChar(32);
                    n4 = n2 + 1;
                    dataBuffer3 = dataBuffer;
                }
                ++n2;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                if (dataBuffer3 != dataBuffer) {
                    this.fBuffer.appendBytes(dataBuffer3.bytes, n4, dataBuffer3.endOffset);
                    object2 = dataBuffer3.next;
                    while (object2 != dataBuffer) {
                        this.fBuffer.appendBytes(((DataBuffer)object2).bytes, ((DataBuffer)object2).startOffset, ((DataBuffer)object2).endOffset);
                        object2 = ((DataBuffer)object2).next;
                    }
                    this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n2);
                } else if (n4 != n2) {
                    if (n2 - n4 == 1) {
                        this.fBuffer.appendChar(dataBuffer.bytes[n4]);
                    } else {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n4, n2);
                    }
                }
                object2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
                this.fBuffer.setStringValues(n5, this.fBuffer.getOffset(), (XMLString)object2);
                return object2;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private int replace2(ParsedEntity parsedEntity, XMLString xMLString, DataBuffer dataBuffer, int n2, int n3, int n4) {
        DataBuffer dataBuffer2 = parsedEntity.buffer;
        int n5 = dataBuffer2.endOffset;
        this.fBuffer.reset(true);
        int n6 = this.fBuffer.getOffset();
        if (dataBuffer2 != dataBuffer) {
            this.fBuffer.appendBytes(dataBuffer.bytes, n2, dataBuffer.endOffset);
            DataBuffer dataBuffer3 = dataBuffer.next;
            while (dataBuffer3 != dataBuffer2) {
                this.fBuffer.appendBytes(dataBuffer3.bytes, dataBuffer3.startOffset, dataBuffer3.endOffset);
                dataBuffer3 = dataBuffer3.next;
            }
            this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n3);
        } else if (n2 != n3) {
            if (n3 - n2 == 1) {
                this.fBuffer.appendChar(dataBuffer2.bytes[n2]);
            } else {
                this.fBuffer.appendBytes(dataBuffer2.bytes, n2, n3);
            }
        }
        this.fBuffer.appendChar(32);
        n2 = ++n3;
        dataBuffer = dataBuffer2;
        byte by2 = 0;
        while (true) {
            if (n3 < n5) {
                DataBuffer dataBuffer4;
                by2 = dataBuffer2.bytes[n3];
                if (by2 == n4) {
                    if (dataBuffer != dataBuffer2) {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n2, dataBuffer.endOffset);
                        dataBuffer4 = dataBuffer.next;
                        while (dataBuffer4 != dataBuffer2) {
                            this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                            dataBuffer4 = dataBuffer4.next;
                        }
                        this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n3);
                    } else if (n2 != n3) {
                        if (n3 - n2 == 1) {
                            this.fBuffer.appendChar(dataBuffer2.bytes[n2]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer2.bytes, n2, n3);
                        }
                    }
                    this.fBuffer.setStringValues(n6, this.fBuffer.getOffset(), xMLString);
                    return n3;
                }
                if (by2 == 10 || by2 == 9 || by2 == 13) {
                    if (dataBuffer2 != dataBuffer) {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n2, dataBuffer.endOffset);
                        dataBuffer4 = dataBuffer.next;
                        while (dataBuffer4 != dataBuffer2) {
                            this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                            dataBuffer4 = dataBuffer4.next;
                        }
                        this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n3);
                    } else if (n2 != n3) {
                        if (n3 - n2 == 1) {
                            this.fBuffer.appendChar(dataBuffer2.bytes[n2]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer2.bytes, n2, n3);
                        }
                    }
                    this.fBuffer.appendChar(32);
                    n2 = n3 + 1;
                    dataBuffer = dataBuffer2;
                }
                ++n3;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            dataBuffer2 = parsedEntity.buffer;
            n3 = parsedEntity.offset;
            n5 = parsedEntity.endOffset;
        }
    }

    private XMLString collapseUnbuffered(XMLString xMLString, ValidationContext validationContext) {
        int n2 = xMLString.endOffset;
        byte by2 = 0;
        for (int i = xMLString.startOffset; i < n2; ++i) {
            by2 = xMLString.bytes[i];
            if (by2 != 10 && by2 != 9 && by2 != 13 && by2 != 32) continue;
            return this.collapseUnbuffered2(xMLString, validationContext, i, n2);
        }
        return xMLString;
    }

    private XMLString collapseUnbuffered2(XMLString xMLString, ValidationContext validationContext, int n2, int n3) {
        int n4 = xMLString.startOffset;
        byte by2 = xMLString.bytes[n2];
        boolean bl = true;
        this.fBuffer.reset(true);
        int n5 = this.fBuffer.getOffset();
        if (n4 != n2) {
            bl = false;
            if (n2 - n4 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n4]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n4, n2);
            }
        }
        boolean bl2 = by2 == 10 || by2 == 9 || by2 == 13 || by2 == 32;
        n4 = ++n2;
        while (n2 < n3) {
            by2 = xMLString.bytes[n2];
            if (by2 == 10 || by2 == 9 || by2 == 13 || by2 == 32) {
                if (n4 != n2) {
                    if (!bl && bl2) {
                        this.fBuffer.appendChar(32);
                        bl2 = false;
                    }
                    bl = false;
                    if (n2 - n4 == 1) {
                        this.fBuffer.appendChar(xMLString.bytes[n4]);
                    } else {
                        this.fBuffer.appendBytes(xMLString.bytes, n4, n2);
                    }
                }
                bl2 = true;
                n4 = n2 + 1;
            }
            ++n2;
        }
        if (n4 != n2) {
            if (!bl && bl2) {
                this.fBuffer.appendChar(32);
                bl2 = false;
            }
            if (n2 - n4 == 1) {
                this.fBuffer.appendChar(xMLString.bytes[n4]);
            } else {
                this.fBuffer.appendBytes(xMLString.bytes, n4, n2);
            }
        }
        XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
        this.fBuffer.setStringValues(n5, this.fBuffer.getOffset(), xMLString2);
        return xMLString2;
    }

    private XMLString collapseBuffered(XMLString xMLString, ValidationContext validationContext) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        byte by2 = 0;
        while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                if (by2 == 10 || by2 == 9 || by2 == 13 || by2 == 32) {
                    return this.collapseBuffered2(xMLString, validationContext, dataBuffer, dataBuffer2, n2, n3);
                }
                ++n2;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                return xMLString;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private XMLString collapseBuffered2(XMLString xMLString, ValidationContext validationContext, DataBuffer dataBuffer, DataBuffer dataBuffer2, int n2, int n3) {
        DataBuffer dataBuffer3 = xMLString.firstBuffer;
        int n4 = xMLString.startOffset;
        boolean bl = true;
        this.fBuffer.reset(true);
        int n5 = this.fBuffer.getOffset();
        if (dataBuffer3 != dataBuffer) {
            bl = false;
            this.fBuffer.appendBytes(dataBuffer3.bytes, n4, dataBuffer3.endOffset);
            DataBuffer dataBuffer4 = dataBuffer3.next;
            while (dataBuffer4 != dataBuffer) {
                this.fBuffer.appendBytes(dataBuffer4.bytes, dataBuffer4.startOffset, dataBuffer4.endOffset);
                dataBuffer4 = dataBuffer4.next;
            }
            this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n2);
        } else if (n4 != n2) {
            bl = false;
            if (n2 - n4 == 1) {
                this.fBuffer.appendChar(dataBuffer.bytes[n4]);
            } else {
                this.fBuffer.appendBytes(dataBuffer.bytes, n4, n2);
            }
        }
        byte by2 = dataBuffer.bytes[n2];
        boolean bl2 = by2 == 10 || by2 == 9 || by2 == 13 || by2 == 32;
        n4 = ++n2;
        dataBuffer3 = dataBuffer;
        while (true) {
            Object object2;
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                if (by2 == 10 || by2 == 9 || by2 == 13 || by2 == 32) {
                    if (dataBuffer3 != dataBuffer) {
                        if (!bl && bl2) {
                            this.fBuffer.appendChar(32);
                            bl2 = false;
                        }
                        bl = false;
                        this.fBuffer.appendBytes(dataBuffer3.bytes, n4, dataBuffer3.endOffset);
                        object2 = dataBuffer3.next;
                        while (object2 != dataBuffer) {
                            this.fBuffer.appendBytes(((DataBuffer)object2).bytes, ((DataBuffer)object2).startOffset, ((DataBuffer)object2).endOffset);
                            object2 = ((DataBuffer)object2).next;
                        }
                        this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n2);
                    } else if (n4 != n2) {
                        if (!bl && bl2) {
                            this.fBuffer.appendChar(32);
                            bl2 = false;
                        }
                        bl = false;
                        if (n2 - n4 == 1) {
                            this.fBuffer.appendChar(dataBuffer.bytes[n4]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer.bytes, n4, n2);
                        }
                    }
                    this.fBuffer.appendChar(32);
                    n4 = n2 + 1;
                    dataBuffer3 = dataBuffer;
                }
                ++n2;
                continue;
            }
            if (dataBuffer == dataBuffer2) {
                if (dataBuffer3 != dataBuffer) {
                    if (!bl && bl2) {
                        this.fBuffer.appendChar(32);
                        bl2 = false;
                    }
                    bl = false;
                    this.fBuffer.appendBytes(dataBuffer3.bytes, n4, dataBuffer3.endOffset);
                    object2 = dataBuffer3.next;
                    while (object2 != dataBuffer) {
                        this.fBuffer.appendBytes(((DataBuffer)object2).bytes, ((DataBuffer)object2).startOffset, ((DataBuffer)object2).endOffset);
                        object2 = ((DataBuffer)object2).next;
                    }
                    this.fBuffer.appendBytes(dataBuffer.bytes, dataBuffer.startOffset, n2);
                } else if (n4 != n2) {
                    if (!bl && bl2) {
                        this.fBuffer.appendChar(32);
                        bl2 = false;
                    }
                    bl = false;
                    if (n2 - n4 == 1) {
                        this.fBuffer.appendChar(dataBuffer.bytes[n4]);
                    } else {
                        this.fBuffer.appendBytes(dataBuffer.bytes, n4, n2);
                    }
                }
                object2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
                this.fBuffer.setStringValues(n5, this.fBuffer.getOffset(), (XMLString)object2);
                return object2;
            }
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
    }

    private int collapse2(ParsedEntity parsedEntity, XMLString xMLString, DataBuffer dataBuffer, int n2, int n3, int n4) {
        DataBuffer dataBuffer2 = parsedEntity.buffer;
        int n5 = dataBuffer2.endOffset;
        boolean bl = true;
        this.fBuffer.reset(true);
        int n6 = this.fBuffer.getOffset();
        while (true) {
            if (n3 < n5) {
                byte by2 = dataBuffer2.bytes[n3];
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13 || by2 == n4) {
                    if (dataBuffer != dataBuffer2) {
                        if (!bl) {
                            this.fBuffer.appendChar(32);
                        }
                        bl = false;
                        this.fBuffer.appendBytes(dataBuffer.bytes, n2, dataBuffer.endOffset);
                        DataBuffer dataBuffer3 = dataBuffer.next;
                        while (dataBuffer3 != dataBuffer2) {
                            this.fBuffer.appendBytes(dataBuffer3.bytes, dataBuffer3.startOffset, dataBuffer3.endOffset);
                            dataBuffer3 = dataBuffer3.next;
                        }
                        this.fBuffer.appendBytes(dataBuffer2.bytes, dataBuffer2.startOffset, n3);
                    } else if (n2 != n3) {
                        if (!bl) {
                            this.fBuffer.appendChar(32);
                        }
                        bl = false;
                        if (n3 - n2 == 1) {
                            this.fBuffer.appendChar(dataBuffer2.bytes[n2]);
                        } else {
                            this.fBuffer.appendBytes(dataBuffer2.bytes, n2, n3);
                        }
                    }
                    if (by2 == n4) {
                        this.fBuffer.setStringValues(n6, this.fBuffer.getOffset(), xMLString);
                        return n3;
                    }
                    n2 = n3 + 1;
                    dataBuffer = dataBuffer2;
                }
                ++n3;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            dataBuffer2 = parsedEntity.buffer;
            n3 = parsedEntity.offset;
            n5 = parsedEntity.endOffset;
        }
    }

    private XMLString trimUnbuffered(XMLString xMLString, ValidationContext validationContext) {
        int n2 = xMLString.endOffset;
        int n3 = xMLString.startOffset;
        byte by2 = 0;
        boolean bl = false;
        if (n3 < n2) {
            by2 = xMLString.bytes[n3];
            if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                bl = true;
            }
            while ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n3 <= n2) {
                by2 = xMLString.bytes[n3];
            }
        }
        if (n2 > n3) {
            if ((by2 = xMLString.bytes[--n2]) == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                bl = true;
            }
            while ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && --n2 > n3) {
                by2 = xMLString.bytes[n2];
            }
        }
        if (bl) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            xMLString2.setValues(xMLString.firstBuffer, n3, n2 + 1);
            xMLString2.flags = 1;
            return xMLString2;
        }
        return xMLString;
    }

    private XMLString trimBuffered(XMLString xMLString, ValidationContext validationContext) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.startOffset;
        int n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        boolean bl = false;
        byte by2 = dataBuffer.bytes[n2];
        if (by2 <= 32) {
            if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) {
                bl = true;
            }
            while (true) {
                if ((by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) && ++n2 <= n3) {
                    by2 = dataBuffer.bytes[n2];
                    continue;
                }
                if (n2 != n3 || dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n2 = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
                by2 = dataBuffer.bytes[n2];
            }
        }
        DataBuffer dataBuffer3 = dataBuffer;
        int n4 = n2;
        int n5 = n4 + 1;
        DataBuffer dataBuffer4 = dataBuffer;
        while (true) {
            if (n2 < n3) {
                by2 = dataBuffer.bytes[n2];
                ++n2;
                if (by2 == 32 || by2 == 10 || by2 == 9 || by2 == 13) continue;
                n5 = n2;
                dataBuffer4 = dataBuffer;
                continue;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n2 = dataBuffer.startOffset;
            n3 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (dataBuffer4 != dataBuffer2 || n5 != n3) {
            bl = true;
        }
        if (bl) {
            XMLString xMLString2 = validationContext != null ? validationContext.getXMLString() : new XMLString();
            xMLString2.setValues(dataBuffer3, dataBuffer4, n4, n5);
            xMLString2.flags = 1;
            return xMLString2;
        }
        return xMLString;
    }
}

