/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.internal.s1.datatype.validation;

import com.ibm.xml.xlxp.internal.s1.datatype.ValidatedInfo;
import com.ibm.xml.xlxp.internal.s1.datatype.XBinary;
import com.ibm.xml.xlxp.internal.s1.scan.Copyright;
import com.ibm.xml.xlxp.internal.s1.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp.internal.s1.scan.util.DataBuffer;
import com.ibm.xml.xlxp.internal.s1.scan.util.ParsedEntity;
import com.ibm.xml.xlxp.internal.s1.scan.util.XMLString;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class XSBase64BinaryUtil {
    private static final byte[] base64CharTo6BitGroupMap = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static XBinary parseBase64Binary(XMLString xMLString) {
        if (xMLString.length < 4) {
            return null;
        }
        if (xMLString.bytes != null) {
            return XSBase64BinaryUtil.parseBase64BinaryUnbuffered(xMLString);
        }
        return XSBase64BinaryUtil.parseBase64BinaryBuffered(xMLString);
    }

    private static XBinary parseBase64BinaryUnbuffered(XMLString xMLString) {
        int n2 = xMLString.startOffset;
        int n3 = xMLString.endOffset;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        n4 = xMLString.bytes[n3 - 1];
        if (n4 == 61) {
            ++n6;
            n4 = xMLString.bytes[n3 - 2];
            if (n4 == 61) {
                ++n6;
            }
        }
        byte[] byArray = ArrayAllocator.newByteArray(xMLString.length - (xMLString.length >> 2) - n6);
        int n7 = 0;
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        int n8 = 0;
        block0: while (true) {
            n8 = 0;
            while (n2 < n3) {
                n4 = xMLString.bytes[n2];
                if (n4 == 32 || n4 == 10 || n4 == 9 || n4 == 13) {
                    ++n2;
                    continue;
                }
                if (n4 == 61) break block0;
                n5 = n4;
                byArray2[n8] = base64CharTo6BitGroupMap[n4 & 0xFF];
                if (byArray2[n8] == -1) {
                    return null;
                }
                if (++n8 == 4) break;
                ++n2;
            }
            if (n2 == n3) break;
            ++n2;
            byArray[n7++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            byArray[n7++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            byArray[n7++] = (byte)(byArray2[2] << 6 | byArray2[3]);
        }
        while (n2 < n3) {
            n4 = xMLString.bytes[n2];
            if (n4 == 32 || n4 == 10 || n4 == 9 || n4 == 13) {
                ++n2;
                continue;
            }
            if (n4 == 61) {
                if (n8 < 2) {
                    return null;
                }
                if (n8 == 3) {
                    if (n5 != 61 && n5 != 65 && n5 != 69 && n5 != 73 && n5 != 77 && n5 != 81 && n5 != 85 && n5 != 89 && n5 != 99 && n5 != 103 && n5 != 107 && n5 != 111 && n5 != 115 && n5 != 119 && n5 != 48 && n5 != 52 && n5 != 56) {
                        return null;
                    }
                    if (n5 == 61) {
                        byArray[n7++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                    } else {
                        byArray[n7++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                        byArray[n7++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                    }
                    ++n8;
                    ++n2;
                    continue;
                }
                if (n8 != 2) continue;
                if (n5 != 65 && n5 != 81 && n5 != 103 && n5 != 119) {
                    return null;
                }
                n5 = 61;
                ++n2;
                ++n8;
                continue;
            }
            return null;
        }
        if (n8 > 0 && n8 < 4) {
            return null;
        }
        return new XBinary(byArray, n7);
    }

    private static XBinary parseBase64BinaryBuffered(XMLString xMLString) {
        DataBuffer dataBuffer = xMLString.firstBuffer;
        DataBuffer dataBuffer2 = xMLString.lastBuffer == null ? dataBuffer : xMLString.lastBuffer;
        int n2 = xMLString.endOffset;
        int n3 = xMLString.startOffset;
        int n4 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (n2 - dataBuffer2.startOffset >= 2 && (n6 = dataBuffer2.bytes[n2 - 1]) == 61) {
            ++n7;
            n6 = dataBuffer2.bytes[n2 - 2];
            if (n6 == 61) {
                ++n7;
            }
        }
        byte[] byArray = ArrayAllocator.newByteArray(xMLString.length - (xMLString.length >> 2) - n7);
        int n8 = 0;
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        int n9 = 0;
        block0: while (true) {
            n5 = 0;
            while (true) {
                if (n3 < n4) {
                    n6 = dataBuffer.bytes[n3];
                    if (n6 == 32 || n6 == 10 || n6 == 9 || n6 == 13) {
                        ++n3;
                        continue;
                    }
                    if (n6 == 61) break block0;
                    n8 = n6;
                    byArray2[n5] = base64CharTo6BitGroupMap[n6 & 0xFF];
                    if (byArray2[n5] == -1) {
                        return null;
                    }
                    if (++n5 == 4) break;
                    ++n3;
                    continue;
                }
                if (dataBuffer == dataBuffer2) break block0;
                dataBuffer = dataBuffer.next;
                n3 = dataBuffer.startOffset;
                n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
            }
            if (n3 == n4) break;
            ++n3;
            byArray[n9++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            byArray[n9++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            byArray[n9++] = (byte)(byArray2[2] << 6 | byArray2[3]);
        }
        while (true) {
            if (n3 < n4) {
                n6 = dataBuffer.bytes[n3];
                if (n6 == 32 || n6 == 10 || n6 == 9 || n6 == 13) {
                    ++n3;
                    continue;
                }
                if (n6 == 61) {
                    if (n5 < 2) {
                        return null;
                    }
                    if (n5 == 3) {
                        if (n8 != 61 && n8 != 65 && n8 != 69 && n8 != 73 && n8 != 77 && n8 != 81 && n8 != 85 && n8 != 89 && n8 != 99 && n8 != 103 && n8 != 107 && n8 != 111 && n8 != 115 && n8 != 119 && n8 != 48 && n8 != 52 && n8 != 56) {
                            return null;
                        }
                        if (n8 == 61) {
                            byArray[n9++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                        } else {
                            byArray[n9++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                            byArray[n9++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                        }
                        ++n5;
                        ++n3;
                        continue;
                    }
                    if (n5 == 2) {
                        if (n8 != 65 && n8 != 81 && n8 != 103 && n8 != 119) {
                            return null;
                        }
                        n8 = 61;
                        ++n3;
                        ++n5;
                        continue;
                    }
                    return null;
                }
                return null;
            }
            if (dataBuffer == dataBuffer2) break;
            dataBuffer = dataBuffer.next;
            n3 = dataBuffer.startOffset;
            n4 = dataBuffer == dataBuffer2 ? xMLString.endOffset : dataBuffer.endOffset;
        }
        if (n5 > 0 && n5 < 4) {
            return null;
        }
        return new XBinary(byArray, n9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseBase64BinaryBuffered(ParsedEntity parsedEntity, XBinary xBinary, ValidatedInfo validatedInfo) {
        int n2 = parsedEntity.offset;
        int n3 = parsedEntity.endOffset;
        byte[] byArray = parsedEntity.bytes;
        xBinary.length = 0;
        if (xBinary.value == null || xBinary.value.length >= 4096) {
            xBinary.value = ArrayAllocator.newByteArray(256);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = ArrayAllocator.newByteArray(4);
        block0: while (true) {
            n4 = 0;
            while (true) {
                if (n2 < n3) {
                    n5 = byArray[n2];
                    if (n5 != 32 && n5 != 10 && n5 != 9 && n5 != 13) {
                        if (n5 == 61) break block0;
                        n6 = n5;
                        byArray2[n4] = base64CharTo6BitGroupMap[n5 & 0xFF];
                        if (byArray2[n4] == -1) {
                            if (n4 != 0) return -1;
                            int n7 = n2;
                            return n7;
                        }
                        if (++n4 == 4) break;
                    }
                    ++n2;
                    continue;
                }
                if (parsedEntity.loadMore() == 0) {
                    return -1;
                }
                byArray = parsedEntity.bytes;
                n2 = parsedEntity.offset;
                n3 = parsedEntity.endOffset;
            }
            ++n2;
            if (xBinary.length + 3 >= xBinary.value.length) {
                xBinary.value = ArrayAllocator.resizeByteArray(xBinary.value, xBinary.value.length * 2);
            }
            xBinary.value[xBinary.length++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            xBinary.value[xBinary.length++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            xBinary.value[xBinary.length++] = (byte)(byArray2[2] << 6 | byArray2[3]);
        }
        while (true) {
            if (n2 < n3) {
                n5 = byArray[n2];
                if (n5 != 32 && n5 != 10 && n5 != 9 && n5 != 13) {
                    if (n5 != 61) return -1;
                    if (n4 == 3) {
                        if (n6 != 61 && n6 != 65 && n6 != 69 && n6 != 73 && n6 != 77 && n6 != 81 && n6 != 85 && n6 != 89 && n6 != 99 && n6 != 103 && n6 != 107 && n6 != 111 && n6 != 115 && n6 != 119 && n6 != 48 && n6 != 52 && n6 != 56) {
                            return -1;
                        }
                        if (xBinary.length + 2 >= xBinary.value.length) {
                            xBinary.value = ArrayAllocator.resizeByteArray(xBinary.value, xBinary.value.length * 2);
                        }
                        if (n6 == 61) {
                            xBinary.value[xBinary.length++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                            return n2;
                        } else {
                            xBinary.value[xBinary.length++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
                            xBinary.value[xBinary.length++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
                        }
                        return n2;
                    }
                    if (n4 != 2) return -1;
                    if (n6 != 65 && n6 != 81 && n6 != 103 && n6 != 119) {
                        return -1;
                    }
                    n6 = 61;
                    ++n4;
                }
                ++n2;
                continue;
            }
            if (parsedEntity.loadMore() == 0) {
                return -1;
            }
            byArray = parsedEntity.bytes;
            n2 = parsedEntity.offset;
            n3 = parsedEntity.endOffset;
        }
    }

    private XSBase64BinaryUtil() {
    }
}

